/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.kae.kpl.predicates;

import com.sun.eras.common.util.MessageKey;
import com.sun.eras.kae.engine.EngineTerminateException;
import com.sun.eras.kae.facts.Fact;
import com.sun.eras.kae.facts.patch.ObsoletePatch;
import com.sun.eras.kae.kpl.KPLEvaluator;
import com.sun.eras.kae.kpl.PredicateContext;
import com.sun.eras.kae.kpl.model.KPLBoolean;
import com.sun.eras.kae.kpl.model.KPLInteger;
import com.sun.eras.kae.kpl.model.KPLObject;
import com.sun.eras.kae.kpl.model.KPLString;
import com.sun.eras.kae.kpl.predicates.IKPLPredicate;
import com.sun.eras.kae.kpl.predicates.PredicateException;
import java.io.Serializable;
import java.util.Vector;

public final class P_patchCheck
implements IKPLPredicate {
    public int arity() {
        return -1;
    }

    public int arityMin() {
        return 1;
    }

    public int arityMax() {
        return 2;
    }

    public int argumentType(int n, int n2) {
        if (n == 2) {
            return 4;
        }
        return 7;
    }

    public KPLObject evaluate(PredicateContext predicateContext, KPLEvaluator kPLEvaluator, Vector vector) throws PredicateException {
        try {
            Serializable serializable;
            KPLString kPLString = (KPLString)kPLEvaluator.evaluateArgument(predicateContext, this, vector, 1);
            long l = 0L;
            if (vector.size() > 1) {
                serializable = (KPLInteger)kPLEvaluator.evaluateArgument(predicateContext, this, vector, 2);
                l = serializable.value();
            }
            serializable = null;
            try {
                serializable = predicateContext.getFactLocator().locateFact("MasterPatch", kPLString.value(), "patchRevision");
            }
            catch (Exception exception) {
                serializable = null;
            }
            if (serializable == null) {
                String string = "There is no MasterPatch Fact present for patch number " + kPLString.value();
                throw new EngineTerminateException(new MessageKey("executionTerminatingWithNotes"), string, new String[]{string}, null, null);
            }
            KPLInteger kPLInteger = (KPLInteger)((Fact)serializable).value("patchRevision");
            long l2 = kPLInteger.value();
            ObsoletePatch obsoletePatch = new ObsoletePatch();
            boolean bl = obsoletePatch.isObsoletePatch(predicateContext.getPatchFactContext(), kPLString.value(), l2);
            if (bl) {
                predicateContext.addCheckNote("This check is referencing an obsolete patch, " + kPLString.value() + ".");
            }
            String string = KPLInteger.padInteger(l2, 2, '0');
            kPLEvaluator.setVariable("PatchLatest", new KPLString(kPLString.value() + "-" + string));
            kPLEvaluator.setVariable("PatchLatestNum", kPLString);
            kPLEvaluator.setVariable("PatchLatestRev", kPLInteger);
            if (l > 0L) {
                string = KPLInteger.padInteger(l, 2, '0');
                kPLEvaluator.setVariable("PatchMin", new KPLString(kPLString.value() + "-" + string));
                kPLEvaluator.setVariable("PatchMinNum", kPLString);
                kPLEvaluator.setVariable("PatchMinRev", new KPLInteger(l));
            } else {
                kPLEvaluator.setVariable("PatchMin", new KPLString(kPLString.value() + "-" + string));
                kPLEvaluator.setVariable("PatchMinNum", kPLString);
                kPLEvaluator.setVariable("PatchMinRev", kPLInteger);
            }
            return new KPLBoolean(true);
        }
        catch (Exception exception) {
            throw new PredicateException((IKPLPredicate)this, (Throwable)exception);
        }
    }
}

