/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.kae.kpl.model;

import com.sun.eras.kae.kpl.model.ConversionException;
import com.sun.eras.kae.kpl.model.KPLBoolean;
import com.sun.eras.kae.kpl.model.KPLDate;
import com.sun.eras.kae.kpl.model.KPLDateTime;
import com.sun.eras.kae.kpl.model.KPLInteger;
import com.sun.eras.kae.kpl.model.KPLList;
import com.sun.eras.kae.kpl.model.KPLObject;
import com.sun.eras.kae.kpl.model.KPLReal;
import com.sun.eras.kae.kpl.model.KPLString;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class KPLTime
extends KPLObject
implements Serializable {
    private static final long serialVersionUID = -8614849822490568604L;
    protected Date m_value;

    public KPLTime(kpl.KPLTime kPLTime) {
        this.m_type = kPLTime.getType();
        this.m_value = kPLTime.getValue();
    }

    public KPLTime() {
        super(8);
        this.m_value = new Date(0L);
    }

    public KPLTime(Date date) {
        super(8);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(5, 1);
        this.m_value = calendar.getTime();
    }

    public KPLTime(long l) {
        super(8);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(l));
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        calendar.set(5, 1);
        this.m_value = calendar.getTime();
    }

    public KPLTime(String string) throws ConversionException {
        super(8);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(string, parsePosition);
        if (date != null) {
            this.m_value = date;
            return;
        }
        simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        parsePosition = new ParsePosition(0);
        date = simpleDateFormat.parse(string, parsePosition);
        if (date != null) {
            this.m_value = date;
            return;
        }
        throw new ConversionException(new KPLString(), 8);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new kpl.KPLTime(this);
    }

    public KPLBoolean convertToBoolean() throws ConversionException {
        throw new ConversionException(this, 1);
    }

    public KPLDate convertToDate() throws ConversionException {
        throw new ConversionException(this, 2);
    }

    public KPLDateTime convertToDateTime() throws ConversionException {
        throw new ConversionException(this, 3);
    }

    public KPLInteger convertToInteger() {
        return new KPLInteger(this.m_value.getTime());
    }

    public KPLList convertToList() {
        Vector<KPLTime> vector = new Vector<KPLTime>();
        vector.add(new KPLTime(this.m_value));
        return new KPLList(vector);
    }

    public KPLReal convertToReal() {
        return new KPLReal(this.m_value.getTime());
    }

    public KPLString convertToString() {
        return new KPLString(this.toString());
    }

    public KPLTime convertToTime() {
        return new KPLTime(this.m_value);
    }

    public String toString() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(this.m_value);
        SimpleDateFormat simpleDateFormat = calendar.get(14) != 0 ? new SimpleDateFormat("HH:mm:ss.SSS") : new SimpleDateFormat("HH:mm:ss");
        return simpleDateFormat.format(this.m_value);
    }

    public Date value() {
        return this.m_value;
    }

    public static KPLTime arithmetic(KPLTime kPLTime, String string, KPLTime kPLTime2) {
        try {
            return new KPLTime(KPLInteger.arithmetic(kPLTime.convertToInteger(), string, kPLTime2.convertToInteger()).value());
        }
        catch (Exception exception) {
            return new KPLTime(0L);
        }
    }

    public static boolean compare(KPLTime kPLTime, String string, KPLTime kPLTime2) {
        try {
            return KPLInteger.compare(kPLTime.convertToInteger(), string, kPLTime2.convertToInteger());
        }
        catch (Exception exception) {
            return false;
        }
    }
}

