/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.kae.kpl.model;

import com.sun.eras.common.util.MessageKey;
import com.sun.eras.kae.kpl.model.ConversionException;
import com.sun.eras.kae.kpl.model.KPLBoolean;
import com.sun.eras.kae.kpl.model.KPLConvertTable;
import com.sun.eras.kae.kpl.model.KPLDate;
import com.sun.eras.kae.kpl.model.KPLDateTime;
import com.sun.eras.kae.kpl.model.KPLInteger;
import com.sun.eras.kae.kpl.model.KPLList;
import com.sun.eras.kae.kpl.model.KPLReal;
import com.sun.eras.kae.kpl.model.KPLString;
import com.sun.eras.kae.kpl.model.KPLTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public abstract class KPLObject {
    private static final long serialVersionUID = 8843468939234487115L;
    protected int m_type;
    private static Hashtable m_arithmeticTable = new Hashtable();
    private static Hashtable m_bitopTable = new Hashtable();
    private static Hashtable m_compareTable = new Hashtable();
    private static Hashtable m_typeStrings = new Hashtable();
    public static final int NONE = 0;
    public static final int ANY = -1;
    public static final int BOOLEAN = 1;
    public static final int DATE = 2;
    public static final int DATETIME = 3;
    public static final int INTEGER = 4;
    public static final int LIST = 5;
    public static final int REAL = 6;
    public static final int STRING = 7;
    public static final int TIME = 8;
    public static final int VARIABLE = 100;
    public static int defaultYear;

    public KPLObject() {
        this.m_type = 0;
    }

    public KPLObject(int n) {
        this.m_type = n;
    }

    private static String convertKey(int n, int n2) {
        int n3 = n * 1000 + n2;
        return Integer.toString(n3);
    }

    public abstract KPLBoolean convertToBoolean() throws ConversionException;

    public abstract KPLDate convertToDate() throws ConversionException;

    public abstract KPLDateTime convertToDateTime() throws ConversionException;

    public abstract KPLInteger convertToInteger() throws ConversionException;

    public abstract KPLList convertToList() throws ConversionException;

    public abstract KPLReal convertToReal() throws ConversionException;

    public abstract KPLString convertToString() throws ConversionException;

    public abstract KPLTime convertToTime() throws ConversionException;

    public KPLObject convertToType(int n) throws ConversionException {
        switch (n) {
            case 1: {
                return this.convertToBoolean();
            }
            case 2: {
                return this.convertToDate();
            }
            case 3: {
                return this.convertToDateTime();
            }
            case 4: {
                return this.convertToInteger();
            }
            case 5: {
                return this.convertToList();
            }
            case 6: {
                return this.convertToReal();
            }
            case 7: {
                return this.convertToString();
            }
            case 8: {
                return this.convertToTime();
            }
        }
        throw new ConversionException(this, n);
    }

    public abstract String toString();

    public int type() {
        return this.m_type;
    }

    public String typeToString() {
        return KPLObject.typeToString(this.m_type);
    }

    public static KPLObject arithmetic(KPLObject kPLObject, String string, KPLObject kPLObject2) throws ConversionException {
        int n;
        int n2 = kPLObject.type();
        String string2 = KPLObject.convertKey(n2, n = kPLObject2.type());
        KPLConvertTable kPLConvertTable = (KPLConvertTable)m_arithmeticTable.get(string2);
        if (kPLConvertTable == null) {
            throw new ConversionException(new MessageKey("noArithmaTable"), kPLObject, kPLObject2);
        }
        if (kPLConvertTable.m_convertException != 0) {
            throw new ConversionException(kPLConvertTable.m_convertException);
        }
        KPLObject kPLObject3 = kPLObject;
        KPLObject kPLObject4 = kPLObject2;
        if (kPLConvertTable.m_type1Convert != 0) {
            kPLObject3 = kPLObject.convertToType(kPLConvertTable.m_type1Convert);
        }
        if (kPLConvertTable.m_type2Convert != 0) {
            kPLObject4 = kPLObject2.convertToType(kPLConvertTable.m_type2Convert);
        }
        switch (kPLConvertTable.m_objectFunction) {
            case 4: {
                return KPLInteger.arithmetic((KPLInteger)kPLObject3, string, (KPLInteger)kPLObject4);
            }
            case 6: {
                return KPLReal.arithmetic((KPLReal)kPLObject3, string, (KPLReal)kPLObject4);
            }
        }
        return new KPLInteger(0L);
    }

    public static KPLObject bitop(KPLObject kPLObject, String string, KPLObject kPLObject2) throws ConversionException {
        int n;
        int n2 = kPLObject.type();
        String string2 = KPLObject.convertKey(n2, n = kPLObject2.type());
        KPLConvertTable kPLConvertTable = (KPLConvertTable)m_bitopTable.get(string2);
        if (kPLConvertTable == null) {
            throw new ConversionException(new MessageKey("noBitopTable"), kPLObject, kPLObject2);
        }
        if (kPLConvertTable.m_convertException != 0) {
            throw new ConversionException(kPLConvertTable.m_convertException);
        }
        KPLObject kPLObject3 = kPLObject;
        KPLObject kPLObject4 = kPLObject2;
        if (kPLConvertTable.m_type1Convert != 0) {
            kPLObject3 = kPLObject.convertToType(kPLConvertTable.m_type1Convert);
        }
        if (kPLConvertTable.m_type2Convert != 0) {
            kPLObject4 = kPLObject2.convertToType(kPLConvertTable.m_type2Convert);
        }
        switch (kPLConvertTable.m_objectFunction) {
            case 4: {
                return KPLInteger.bitop((KPLInteger)kPLObject3, string, (KPLInteger)kPLObject4);
            }
        }
        return new KPLInteger(0L);
    }

    public static boolean compare(KPLObject kPLObject, String string, KPLObject kPLObject2) throws ConversionException {
        int n;
        int n2 = kPLObject.type();
        String string2 = KPLObject.convertKey(n2, n = kPLObject2.type());
        KPLConvertTable kPLConvertTable = (KPLConvertTable)m_compareTable.get(string2);
        if (kPLConvertTable == null) {
            throw new ConversionException(new MessageKey("noCompareTable"), kPLObject, kPLObject2);
        }
        if (kPLConvertTable.m_convertException != 0) {
            throw new ConversionException(kPLConvertTable.m_convertException);
        }
        KPLObject kPLObject3 = kPLObject;
        KPLObject kPLObject4 = kPLObject2;
        if (kPLConvertTable.m_type1Convert != 0) {
            kPLObject3 = kPLObject.convertToType(kPLConvertTable.m_type1Convert);
        }
        if (kPLConvertTable.m_type2Convert != 0) {
            kPLObject4 = kPLObject2.convertToType(kPLConvertTable.m_type2Convert);
        }
        switch (kPLConvertTable.m_objectFunction) {
            case 1: {
                return KPLBoolean.compare((KPLBoolean)kPLObject3, string, (KPLBoolean)kPLObject4);
            }
            case 2: {
                return KPLDate.compare((KPLDate)kPLObject3, string, (KPLDate)kPLObject4);
            }
            case 3: {
                return KPLDateTime.compare((KPLDateTime)kPLObject3, string, (KPLDateTime)kPLObject4);
            }
            case 4: {
                return KPLInteger.compare((KPLInteger)kPLObject3, string, (KPLInteger)kPLObject4);
            }
            case 5: {
                return KPLList.compare((KPLList)kPLObject3, string, (KPLList)kPLObject4);
            }
            case 6: {
                return KPLReal.compare((KPLReal)kPLObject3, string, (KPLReal)kPLObject4);
            }
            case 7: {
                return KPLString.compare((KPLString)kPLObject3, string, (KPLString)kPLObject4);
            }
            case 8: {
                return KPLTime.compare((KPLTime)kPLObject3, string, (KPLTime)kPLObject4);
            }
        }
        return false;
    }

    public static KPLObject objectFromString(String string, String string2) throws ConversionException {
        KPLObject kPLObject = null;
        if (string.equalsIgnoreCase("boolean")) {
            kPLObject = new KPLBoolean(string2);
        } else if (string.equalsIgnoreCase("date")) {
            kPLObject = new KPLDate(string2);
        } else if (string.equalsIgnoreCase("datetime")) {
            kPLObject = new KPLDateTime(string2);
        } else if (string.equalsIgnoreCase("integer")) {
            kPLObject = new KPLInteger(string2);
        } else if (string.equalsIgnoreCase("list")) {
            kPLObject = new KPLList(string2);
        } else if (string.equalsIgnoreCase("real")) {
            kPLObject = new KPLReal(string2);
        } else if (string.equalsIgnoreCase("string")) {
            kPLObject = new KPLString(string2);
        } else if (string.equalsIgnoreCase("time")) {
            kPLObject = new KPLTime(string2);
        }
        return kPLObject;
    }

    static KPLObject makeInstance(Object object) throws NullPointerException, IllegalArgumentException {
        KPLObject kPLObject;
        if (object instanceof KPLObject) {
            kPLObject = (KPLObject)object;
        } else if (object instanceof Long) {
            Long l = (Long)object;
            kPLObject = new KPLInteger(l);
        } else if (object instanceof Date) {
            Date date = (Date)object;
            kPLObject = new KPLDateTime(date);
        } else if (object instanceof String) {
            String string = (String)object;
            kPLObject = new KPLString(string);
        } else if (object instanceof Double) {
            Double d = (Double)object;
            kPLObject = new KPLReal(d);
        } else if (object instanceof List) {
            List list = (List)object;
            kPLObject = new KPLList(list);
        } else {
            throw new IllegalArgumentException(object.toString());
        }
        return kPLObject;
    }

    public static Object toJavaObject(KPLObject kPLObject) {
        if (kPLObject == null) {
            return null;
        }
        switch (kPLObject.type()) {
            case 1: {
                KPLBoolean kPLBoolean = (KPLBoolean)kPLObject;
                return new Boolean(kPLBoolean.value());
            }
            case 2: {
                KPLDate kPLDate = (KPLDate)kPLObject;
                return kPLDate.value();
            }
            case 3: {
                KPLDateTime kPLDateTime = (KPLDateTime)kPLObject;
                return kPLDateTime.value();
            }
            case 4: {
                KPLInteger kPLInteger = (KPLInteger)kPLObject;
                return new Long(kPLInteger.value());
            }
            case 5: {
                KPLList kPLList = (KPLList)kPLObject;
                Vector vector = kPLList.value();
                Vector<Object> vector2 = new Vector<Object>();
                int n = 0;
                while (n < vector.size()) {
                    KPLObject kPLObject2 = (KPLObject)vector.elementAt(n);
                    vector2.add(KPLObject.toJavaObject(kPLObject2));
                    ++n;
                }
                return vector2;
            }
            case 6: {
                KPLReal kPLReal = (KPLReal)kPLObject;
                return new Double(kPLReal.value());
            }
            case 7: {
                KPLString kPLString = (KPLString)kPLObject;
                return kPLString.value();
            }
            case 8: {
                KPLTime kPLTime = (KPLTime)kPLObject;
                return kPLTime.value();
            }
        }
        return null;
    }

    public static String typeToString(int n) {
        String string = (String)m_typeStrings.get(String.valueOf(n));
        if (string == null) {
            string = "Unknown object type '" + n + "'";
        }
        return string;
    }

    static {
        m_typeStrings.put(String.valueOf(0), "notype");
        m_typeStrings.put(String.valueOf(1), "boolean");
        m_typeStrings.put(String.valueOf(4), "integer");
        m_typeStrings.put(String.valueOf(6), "real");
        m_typeStrings.put(String.valueOf(7), "string");
        m_typeStrings.put(String.valueOf(5), "list");
        m_typeStrings.put(String.valueOf(2), "date");
        m_typeStrings.put(String.valueOf(8), "time");
        m_typeStrings.put(String.valueOf(3), "datetime");
        Date date = new Date();
        Calendar calendar = Calendar.getInstance();
        defaultYear = calendar.get(1);
        m_arithmeticTable.put(KPLObject.convertKey(1, 1), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(1, 2), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(1, 3), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(1, 4), new KPLConvertTable(4, 4, 0, 0));
        m_arithmeticTable.put(KPLObject.convertKey(1, 6), new KPLConvertTable(6, 6, 0, 0));
        m_arithmeticTable.put(KPLObject.convertKey(1, 7), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(1, 8), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(2, 1), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(2, 2), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(2, 3), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(2, 4), new KPLConvertTable(4, 4, 0, 0));
        m_arithmeticTable.put(KPLObject.convertKey(2, 6), new KPLConvertTable(6, 6, 0, 0));
        m_arithmeticTable.put(KPLObject.convertKey(2, 7), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(2, 8), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(3, 1), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(3, 2), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(3, 3), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(3, 4), new KPLConvertTable(4, 4, 0, 0));
        m_arithmeticTable.put(KPLObject.convertKey(3, 6), new KPLConvertTable(6, 6, 0, 0));
        m_arithmeticTable.put(KPLObject.convertKey(3, 7), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(3, 8), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(4, 1), new KPLConvertTable(4, 0, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(4, 2), new KPLConvertTable(4, 0, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(4, 3), new KPLConvertTable(4, 0, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(4, 4), new KPLConvertTable(4, 0, 0, 0));
        m_arithmeticTable.put(KPLObject.convertKey(4, 6), new KPLConvertTable(6, 6, 0, 0));
        m_arithmeticTable.put(KPLObject.convertKey(4, 7), new KPLConvertTable(4, 0, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(4, 8), new KPLConvertTable(4, 0, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(6, 1), new KPLConvertTable(6, 0, 6, 0));
        m_arithmeticTable.put(KPLObject.convertKey(6, 2), new KPLConvertTable(6, 0, 6, 0));
        m_arithmeticTable.put(KPLObject.convertKey(6, 3), new KPLConvertTable(6, 0, 6, 0));
        m_arithmeticTable.put(KPLObject.convertKey(6, 4), new KPLConvertTable(6, 0, 6, 0));
        m_arithmeticTable.put(KPLObject.convertKey(6, 6), new KPLConvertTable(6, 0, 0, 0));
        m_arithmeticTable.put(KPLObject.convertKey(6, 7), new KPLConvertTable(6, 0, 6, 0));
        m_arithmeticTable.put(KPLObject.convertKey(6, 8), new KPLConvertTable(6, 0, 6, 0));
        m_arithmeticTable.put(KPLObject.convertKey(7, 1), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(7, 2), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(7, 3), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(7, 4), new KPLConvertTable(4, 4, 0, 0));
        m_arithmeticTable.put(KPLObject.convertKey(7, 6), new KPLConvertTable(6, 6, 0, 0));
        m_arithmeticTable.put(KPLObject.convertKey(7, 7), new KPLConvertTable(6, 6, 6, 0));
        m_arithmeticTable.put(KPLObject.convertKey(7, 8), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(8, 1), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(8, 2), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(8, 3), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(8, 4), new KPLConvertTable(4, 4, 0, 0));
        m_arithmeticTable.put(KPLObject.convertKey(8, 6), new KPLConvertTable(6, 6, 0, 0));
        m_arithmeticTable.put(KPLObject.convertKey(8, 7), new KPLConvertTable(4, 4, 4, 0));
        m_arithmeticTable.put(KPLObject.convertKey(8, 8), new KPLConvertTable(4, 4, 4, 0));
        m_bitopTable.put(KPLObject.convertKey(1, 1), new KPLConvertTable(4, 4, 4, 0));
        m_bitopTable.put(KPLObject.convertKey(1, 4), new KPLConvertTable(4, 4, 0, 0));
        m_bitopTable.put(KPLObject.convertKey(1, 6), new KPLConvertTable(4, 4, 4, 0));
        m_bitopTable.put(KPLObject.convertKey(1, 7), new KPLConvertTable(4, 4, 4, 0));
        m_bitopTable.put(KPLObject.convertKey(4, 1), new KPLConvertTable(4, 0, 4, 0));
        m_bitopTable.put(KPLObject.convertKey(4, 4), new KPLConvertTable(4, 0, 0, 0));
        m_bitopTable.put(KPLObject.convertKey(4, 6), new KPLConvertTable(4, 0, 4, 0));
        m_bitopTable.put(KPLObject.convertKey(4, 7), new KPLConvertTable(4, 0, 4, 0));
        m_bitopTable.put(KPLObject.convertKey(6, 1), new KPLConvertTable(4, 4, 4, 0));
        m_bitopTable.put(KPLObject.convertKey(6, 4), new KPLConvertTable(4, 4, 4, 0));
        m_bitopTable.put(KPLObject.convertKey(6, 6), new KPLConvertTable(4, 4, 4, 0));
        m_bitopTable.put(KPLObject.convertKey(6, 7), new KPLConvertTable(4, 4, 4, 0));
        m_bitopTable.put(KPLObject.convertKey(7, 1), new KPLConvertTable(4, 4, 4, 0));
        m_bitopTable.put(KPLObject.convertKey(7, 4), new KPLConvertTable(4, 4, 4, 0));
        m_bitopTable.put(KPLObject.convertKey(7, 6), new KPLConvertTable(4, 4, 4, 0));
        m_bitopTable.put(KPLObject.convertKey(7, 7), new KPLConvertTable(4, 4, 4, 0));
        m_compareTable.put(KPLObject.convertKey(1, 1), new KPLConvertTable(1, 0, 0, 0));
        m_compareTable.put(KPLObject.convertKey(1, 2), new KPLConvertTable(0, 0, 0, 2));
        m_compareTable.put(KPLObject.convertKey(1, 3), new KPLConvertTable(0, 0, 0, 3));
        m_compareTable.put(KPLObject.convertKey(1, 4), new KPLConvertTable(4, 4, 0, 0));
        m_compareTable.put(KPLObject.convertKey(1, 5), new KPLConvertTable(0, 0, 0, 5));
        m_compareTable.put(KPLObject.convertKey(1, 6), new KPLConvertTable(6, 6, 0, 0));
        m_compareTable.put(KPLObject.convertKey(1, 7), new KPLConvertTable(1, 0, 1, 0));
        m_compareTable.put(KPLObject.convertKey(1, 8), new KPLConvertTable(0, 0, 0, 8));
        m_compareTable.put(KPLObject.convertKey(2, 1), new KPLConvertTable(0, 0, 0, 2));
        m_compareTable.put(KPLObject.convertKey(2, 2), new KPLConvertTable(2, 0, 0, 0));
        m_compareTable.put(KPLObject.convertKey(2, 3), new KPLConvertTable(2, 0, 2, 0));
        m_compareTable.put(KPLObject.convertKey(2, 4), new KPLConvertTable(2, 0, 2, 0));
        m_compareTable.put(KPLObject.convertKey(2, 5), new KPLConvertTable(0, 0, 0, 5));
        m_compareTable.put(KPLObject.convertKey(2, 6), new KPLConvertTable(6, 6, 0, 0));
        m_compareTable.put(KPLObject.convertKey(2, 7), new KPLConvertTable(2, 0, 2, 0));
        m_compareTable.put(KPLObject.convertKey(2, 8), new KPLConvertTable(0, 0, 0, 2));
        m_compareTable.put(KPLObject.convertKey(3, 1), new KPLConvertTable(0, 0, 0, 3));
        m_compareTable.put(KPLObject.convertKey(3, 2), new KPLConvertTable(2, 2, 0, 0));
        m_compareTable.put(KPLObject.convertKey(3, 3), new KPLConvertTable(3, 0, 0, 0));
        m_compareTable.put(KPLObject.convertKey(3, 4), new KPLConvertTable(3, 0, 3, 0));
        m_compareTable.put(KPLObject.convertKey(3, 5), new KPLConvertTable(0, 0, 0, 5));
        m_compareTable.put(KPLObject.convertKey(3, 6), new KPLConvertTable(6, 6, 0, 0));
        m_compareTable.put(KPLObject.convertKey(3, 7), new KPLConvertTable(3, 0, 3, 0));
        m_compareTable.put(KPLObject.convertKey(3, 8), new KPLConvertTable(8, 8, 0, 0));
        m_compareTable.put(KPLObject.convertKey(4, 1), new KPLConvertTable(4, 0, 4, 0));
        m_compareTable.put(KPLObject.convertKey(4, 2), new KPLConvertTable(2, 2, 0, 0));
        m_compareTable.put(KPLObject.convertKey(4, 3), new KPLConvertTable(3, 3, 0, 0));
        m_compareTable.put(KPLObject.convertKey(4, 4), new KPLConvertTable(4, 0, 0, 0));
        m_compareTable.put(KPLObject.convertKey(4, 5), new KPLConvertTable(0, 0, 0, 5));
        m_compareTable.put(KPLObject.convertKey(4, 6), new KPLConvertTable(6, 6, 0, 0));
        m_compareTable.put(KPLObject.convertKey(4, 7), new KPLConvertTable(4, 0, 4, 0));
        m_compareTable.put(KPLObject.convertKey(4, 8), new KPLConvertTable(8, 8, 0, 0));
        m_compareTable.put(KPLObject.convertKey(5, 1), new KPLConvertTable(0, 0, 0, 5));
        m_compareTable.put(KPLObject.convertKey(5, 2), new KPLConvertTable(0, 0, 0, 5));
        m_compareTable.put(KPLObject.convertKey(5, 3), new KPLConvertTable(0, 0, 0, 5));
        m_compareTable.put(KPLObject.convertKey(5, 4), new KPLConvertTable(0, 0, 0, 5));
        m_compareTable.put(KPLObject.convertKey(5, 5), new KPLConvertTable(0, 0, 0, 5));
        m_compareTable.put(KPLObject.convertKey(5, 6), new KPLConvertTable(0, 0, 0, 5));
        m_compareTable.put(KPLObject.convertKey(5, 7), new KPLConvertTable(0, 0, 0, 5));
        m_compareTable.put(KPLObject.convertKey(5, 8), new KPLConvertTable(0, 0, 0, 5));
        m_compareTable.put(KPLObject.convertKey(6, 1), new KPLConvertTable(6, 0, 6, 0));
        m_compareTable.put(KPLObject.convertKey(6, 2), new KPLConvertTable(6, 0, 6, 0));
        m_compareTable.put(KPLObject.convertKey(6, 3), new KPLConvertTable(6, 0, 6, 0));
        m_compareTable.put(KPLObject.convertKey(6, 4), new KPLConvertTable(6, 0, 6, 0));
        m_compareTable.put(KPLObject.convertKey(6, 5), new KPLConvertTable(0, 0, 0, 5));
        m_compareTable.put(KPLObject.convertKey(6, 6), new KPLConvertTable(6, 0, 0, 0));
        m_compareTable.put(KPLObject.convertKey(6, 7), new KPLConvertTable(6, 0, 6, 0));
        m_compareTable.put(KPLObject.convertKey(6, 8), new KPLConvertTable(6, 0, 6, 0));
        m_compareTable.put(KPLObject.convertKey(7, 1), new KPLConvertTable(1, 1, 0, 0));
        m_compareTable.put(KPLObject.convertKey(7, 2), new KPLConvertTable(2, 2, 0, 0));
        m_compareTable.put(KPLObject.convertKey(7, 3), new KPLConvertTable(3, 3, 0, 0));
        m_compareTable.put(KPLObject.convertKey(7, 4), new KPLConvertTable(4, 4, 0, 0));
        m_compareTable.put(KPLObject.convertKey(7, 5), new KPLConvertTable(0, 0, 0, 5));
        m_compareTable.put(KPLObject.convertKey(7, 6), new KPLConvertTable(6, 6, 0, 0));
        m_compareTable.put(KPLObject.convertKey(7, 7), new KPLConvertTable(7, 0, 0, 0));
        m_compareTable.put(KPLObject.convertKey(7, 8), new KPLConvertTable(8, 8, 0, 0));
        m_compareTable.put(KPLObject.convertKey(8, 1), new KPLConvertTable(0, 0, 0, 8));
        m_compareTable.put(KPLObject.convertKey(8, 2), new KPLConvertTable(0, 0, 0, 8));
        m_compareTable.put(KPLObject.convertKey(8, 3), new KPLConvertTable(8, 0, 8, 0));
        m_compareTable.put(KPLObject.convertKey(8, 4), new KPLConvertTable(8, 0, 8, 0));
        m_compareTable.put(KPLObject.convertKey(8, 5), new KPLConvertTable(0, 0, 0, 5));
        m_compareTable.put(KPLObject.convertKey(8, 6), new KPLConvertTable(6, 6, 0, 0));
        m_compareTable.put(KPLObject.convertKey(8, 7), new KPLConvertTable(8, 0, 8, 0));
        m_compareTable.put(KPLObject.convertKey(8, 8), new KPLConvertTable(8, 0, 0, 0));
    }
}

