/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.kae.kpl.model;

import com.sun.eras.kae.kpl.model.ConversionException;
import com.sun.eras.kae.kpl.model.KPLBoolean;
import com.sun.eras.kae.kpl.model.KPLDate;
import com.sun.eras.kae.kpl.model.KPLDateTime;
import com.sun.eras.kae.kpl.model.KPLList;
import com.sun.eras.kae.kpl.model.KPLObject;
import com.sun.eras.kae.kpl.model.KPLReal;
import com.sun.eras.kae.kpl.model.KPLString;
import com.sun.eras.kae.kpl.model.KPLTime;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Vector;

public class KPLInteger
extends KPLObject
implements Serializable {
    private static final long serialVersionUID = 7124911062557035143L;
    protected long m_value;

    public KPLInteger(kpl.KPLInteger kPLInteger) {
        this.m_type = kPLInteger.getType();
        this.m_value = kPLInteger.getValue();
    }

    public KPLInteger() {
        super(4);
        this.m_value = 0L;
    }

    public KPLInteger(long l) {
        super(4);
        this.m_value = l;
    }

    public KPLInteger(String string) throws ConversionException {
        super(4);
        try {
            String string2 = string;
            int n = 10;
            if (string2.length() >= 3 && string2.substring(0, 2).equalsIgnoreCase("0b")) {
                n = 2;
                string2 = string2.substring(2);
            } else if (string2.length() >= 3 && string2.substring(0, 2).equalsIgnoreCase("0o")) {
                n = 8;
                string2 = string2.substring(2);
            } else if (string2.length() >= 3 && string2.substring(0, 2).equalsIgnoreCase("0t")) {
                n = 10;
                string2 = string2.substring(2);
            } else if (string2.length() >= 3 && string2.substring(0, 2).equalsIgnoreCase("0x")) {
                n = 16;
                string2 = string2.substring(2);
            }
            this.m_value = Long.parseLong(string2, n);
        }
        catch (Exception exception) {
            throw new ConversionException(new KPLString(), 4);
        }
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new kpl.KPLInteger(this);
    }

    public KPLBoolean convertToBoolean() {
        return new KPLBoolean(this.m_value != 0L);
    }

    public KPLDate convertToDate() {
        return new KPLDate(this.m_value);
    }

    public KPLDateTime convertToDateTime() {
        return new KPLDateTime(this.m_value);
    }

    public KPLInteger convertToInteger() {
        return new KPLInteger(this.m_value);
    }

    public KPLList convertToList() {
        Vector<KPLInteger> vector = new Vector<KPLInteger>();
        vector.add(new KPLInteger(this.m_value));
        return new KPLList(vector);
    }

    public KPLReal convertToReal() {
        return new KPLReal(this.m_value);
    }

    public KPLString convertToString() {
        return new KPLString(Long.toString(this.m_value));
    }

    public KPLTime convertToTime() {
        return new KPLTime(this.m_value);
    }

    public String toString() {
        return Long.toString(this.m_value);
    }

    public long value() {
        return this.m_value;
    }

    public static KPLInteger arithmetic(KPLInteger kPLInteger, String string, KPLInteger kPLInteger2) {
        long l = kPLInteger.value();
        long l2 = kPLInteger2.value();
        if (string.equals("+")) {
            return new KPLInteger(l + l2);
        }
        if (string.equals("-")) {
            return new KPLInteger(l - l2);
        }
        if (string.equals("*")) {
            return new KPLInteger(l * l2);
        }
        if (string.equals("/")) {
            return new KPLInteger(l / l2);
        }
        if (string.equals("%")) {
            return new KPLInteger(l % l2);
        }
        return new KPLInteger(0L);
    }

    public static KPLInteger bitop(KPLInteger kPLInteger, String string, KPLInteger kPLInteger2) {
        long l = kPLInteger.value();
        long l2 = kPLInteger2.value();
        if (string.equals("&")) {
            return new KPLInteger(l & l2);
        }
        if (string.equals("|")) {
            return new KPLInteger(l | l2);
        }
        if (string.equals("^")) {
            return new KPLInteger(l ^ l2);
        }
        if (string.equals("~")) {
            return new KPLInteger(l ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (string.equals("<<")) {
            return new KPLInteger(l << (int)l2);
        }
        if (string.equals(">>")) {
            return new KPLInteger(l >> (int)l2);
        }
        return new KPLInteger(0L);
    }

    public static boolean compare(KPLInteger kPLInteger, String string, KPLInteger kPLInteger2) {
        long l = kPLInteger.value();
        long l2 = kPLInteger2.value();
        if (string.equals("==") || string.equals("=")) {
            return l == l2;
        }
        if (string.equals("!=") || string.equals("<>")) {
            return l != l2;
        }
        if (string.equals("<")) {
            return l < l2;
        }
        if (string.equals("<=")) {
            return l <= l2;
        }
        if (string.equals(">")) {
            return l > l2;
        }
        if (string.equals(">=")) {
            return l >= l2;
        }
        return false;
    }

    public static String padInteger(long l, int n, char c) {
        return KPLInteger.padInteger(Long.toString(l), n, c);
    }

    public static String padInteger(String string, int n, char c) {
        if (string == null) {
            return null;
        }
        if (n <= string.length()) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = n - string.length();
        int n3 = 0;
        while (n3 < n2) {
            stringBuffer.append(c);
            ++n3;
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }
}

