/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.kae.kpl.model;

import com.sun.eras.kae.kpl.model.ConversionException;
import com.sun.eras.kae.kpl.model.KPLBoolean;
import com.sun.eras.kae.kpl.model.KPLDateTime;
import com.sun.eras.kae.kpl.model.KPLInteger;
import com.sun.eras.kae.kpl.model.KPLList;
import com.sun.eras.kae.kpl.model.KPLObject;
import com.sun.eras.kae.kpl.model.KPLReal;
import com.sun.eras.kae.kpl.model.KPLString;
import com.sun.eras.kae.kpl.model.KPLTime;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class KPLDate
extends KPLObject
implements Serializable {
    private static final long serialVersionUID = 2393743125569609988L;
    protected Date m_value;

    public KPLDate(kpl.KPLDate kPLDate) {
        this.m_type = kPLDate.getType();
        this.m_value = kPLDate.getValue();
    }

    public KPLDate() {
        super(2);
        this.m_value = new Date(0L);
    }

    public KPLDate(Date date) {
        super(2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.m_value = calendar.getTime();
    }

    public KPLDate(long l) {
        super(2);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(l));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        this.m_value = calendar.getTime();
    }

    public KPLDate(String string) throws ConversionException {
        super(2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd");
        ParsePosition parsePosition = new ParsePosition(0);
        Date date = simpleDateFormat.parse(string, parsePosition);
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            calendar.set(1, KPLObject.defaultYear);
            this.m_value = calendar.getTime();
            return;
        }
        throw new ConversionException(new KPLString(), 2);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new kpl.KPLDate(this);
    }

    public KPLBoolean convertToBoolean() throws ConversionException {
        throw new ConversionException(this, 1);
    }

    public KPLDate convertToDate() {
        return new KPLDate(this.m_value);
    }

    public KPLDateTime convertToDateTime() throws ConversionException {
        throw new ConversionException(this, 3);
    }

    public KPLInteger convertToInteger() {
        return new KPLInteger(this.m_value.getTime());
    }

    public KPLList convertToList() {
        Vector<KPLDate> vector = new Vector<KPLDate>();
        vector.add(new KPLDate(this.m_value));
        return new KPLList(vector);
    }

    public KPLReal convertToReal() {
        return new KPLReal(this.m_value.getTime());
    }

    public KPLString convertToString() {
        return new KPLString(this.toString());
    }

    public KPLTime convertToTime() throws ConversionException {
        throw new ConversionException(this, 8);
    }

    public String toString() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd yyyy");
        return simpleDateFormat.format(this.m_value);
    }

    public Date value() {
        return this.m_value;
    }

    public static KPLDate arithmetic(KPLDate kPLDate, String string, KPLDate kPLDate2) {
        try {
            return new KPLDate(KPLInteger.arithmetic(kPLDate.convertToInteger(), string, kPLDate2.convertToInteger()).value());
        }
        catch (Exception exception) {
            return new KPLDate(0L);
        }
    }

    public static boolean compare(KPLDate kPLDate, String string, KPLDate kPLDate2) {
        try {
            return KPLInteger.compare(kPLDate.convertToInteger(), string, kPLDate2.convertToInteger());
        }
        catch (Exception exception) {
            return false;
        }
    }
}

