/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.kae.kpl.model;

import com.sun.eras.kae.kpl.model.ConversionException;
import com.sun.eras.kae.kpl.model.KPLDate;
import com.sun.eras.kae.kpl.model.KPLDateTime;
import com.sun.eras.kae.kpl.model.KPLInteger;
import com.sun.eras.kae.kpl.model.KPLList;
import com.sun.eras.kae.kpl.model.KPLObject;
import com.sun.eras.kae.kpl.model.KPLReal;
import com.sun.eras.kae.kpl.model.KPLString;
import com.sun.eras.kae.kpl.model.KPLTime;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Vector;

public class KPLBoolean
extends KPLObject
implements Serializable {
    private static final long serialVersionUID = 5993814761705951151L;
    protected boolean m_value;

    public KPLBoolean(kpl.KPLBoolean kPLBoolean) {
        this.m_type = kPLBoolean.getType();
        this.m_value = kPLBoolean.getValue();
    }

    public KPLBoolean() {
        super(1);
        this.m_value = false;
    }

    public KPLBoolean(boolean bl) {
        super(1);
        this.m_value = bl;
    }

    public KPLBoolean(String string) {
        super(1);
        this.m_value = string != null && (string.equalsIgnoreCase("true") || string.equalsIgnoreCase("t"));
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new kpl.KPLBoolean(this);
    }

    public KPLBoolean convertToBoolean() {
        return new KPLBoolean(this.m_value);
    }

    public KPLDate convertToDate() throws ConversionException {
        throw new ConversionException(this, 2);
    }

    public KPLDateTime convertToDateTime() throws ConversionException {
        throw new ConversionException(this, 3);
    }

    public KPLInteger convertToInteger() {
        return new KPLInteger(this.m_value ? 1L : 0L);
    }

    public KPLList convertToList() {
        Vector<KPLBoolean> vector = new Vector<KPLBoolean>();
        vector.add(new KPLBoolean(this.m_value));
        return new KPLList(vector);
    }

    public KPLReal convertToReal() {
        return new KPLReal(this.m_value ? 1.0 : 0.0);
    }

    public KPLString convertToString() {
        return new KPLString(this.toString());
    }

    public KPLTime convertToTime() throws ConversionException {
        throw new ConversionException(this, 8);
    }

    public String toString() {
        return this.m_value ? "true" : "false";
    }

    public boolean value() {
        return this.m_value;
    }

    public static boolean compare(KPLBoolean kPLBoolean, String string, KPLBoolean kPLBoolean2) {
        boolean bl = kPLBoolean.value();
        boolean bl2 = kPLBoolean2.value();
        if (string.equals("==") || string.equals("=")) {
            return bl == bl2;
        }
        if (string.equals("!=") || string.equals("<>")) {
            return bl != bl2;
        }
        if (string.equals("<")) {
            return !bl && bl2;
        }
        if (string.equals("<=")) {
            return true;
        }
        if (string.equals(">")) {
            return bl && !bl2;
        }
        return string.equals(">=");
    }
}

