/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.kae.facts.rfa;

import com.sun.eras.kae.facts.Fact;
import com.sun.eras.kae.facts.FactKeyUtil;
import com.sun.eras.kae.facts.rfa.FactAnalyzerContext;
import com.sun.eras.kae.facts.rfa.KCERFAHelperImpl;
import com.sun.eras.kae.facts.store.IFactStorage;
import com.sun.eras.kae.io.loaders.KCELoadObject;
import com.sun.eras.kae.kpl.model.KPLObject;
import com.sun.eras.kae.kpl.model.KPLString;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

public class KCERFA {
    private void a(FactAnalyzerContext factAnalyzerContext, String string, String string2, Fact fact, KPLObject kPLObject, Fact fact2, KPLObject kPLObject2) {
        if (kPLObject.type() == 1 && kPLObject2.type() == 1) {
            factAnalyzerContext.log(0x200000, "", "Check " + string + " is attempting to make a contradicting boolean recommendation for " + fact.className() + " Slot " + string2 + ".", false);
            return;
        }
        KCELoadObject kCELoadObject = new KCELoadObject();
        KCERFAHelperImpl kCERFAHelperImpl = (KCERFAHelperImpl)kCELoadObject.loadObject(factAnalyzerContext.getKCELoaderContext(), this.prefix() + fact.className());
        if (kCERFAHelperImpl == null) {
            factAnalyzerContext.log(0x200000, "", "CRITICAL: A value difference has been detected between two recommendation Facts and", false);
            factAnalyzerContext.log(0x200000, "", "          no RFA helper is available for the " + fact.className() + " Fact class.", false);
            return;
        }
        kCERFAHelperImpl.processSlotDiff(factAnalyzerContext, string, string2, fact, kPLObject, fact2, kPLObject2);
    }

    public void consolidate(FactAnalyzerContext factAnalyzerContext, Fact fact) {
        KPLString kPLString;
        if (factAnalyzerContext == null || fact == null) {
            return;
        }
        IFactStorage iFactStorage = factAnalyzerContext.recommendationFactStore();
        if (iFactStorage == null) {
            return;
        }
        String string = fact.className();
        String string2 = fact.instance();
        Fact fact2 = null;
        try {
            fact2 = iFactStorage.get(string, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (fact2 == null) {
            try {
                iFactStorage.put(fact);
            }
            catch (Exception exception) {
                // empty catch block
            }
            factAnalyzerContext.log(0x100000, "", "No consolidation needed for Fact " + FactKeyUtil.factKey(fact.className(), fact.instance()) + ".", false);
            return;
        }
        try {
            kPLString = (KPLString)fact.value("CreatedBy");
            KPLString kPLString2 = (KPLString)fact2.value("CreatedBy");
            String string3 = kPLString2.value() + "," + kPLString.value();
            fact2.set("CreatedBy", new KPLString(string3));
        }
        catch (Exception exception) {
            factAnalyzerContext.logException(2, "consolidate", exception);
            return;
        }
        TreeMap treeMap = fact.slots();
        if (treeMap == null || treeMap.size() <= 0) {
            factAnalyzerContext.log(0x100000, "", "No Slots in Fact " + FactKeyUtil.factKey(fact.className(), fact.instance()) + ".", false);
            return;
        }
        Set set = treeMap.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            KPLObject kPLObject;
            KPLObject kPLObject2;
            String string4 = (String)iterator.next();
            char c = string4.charAt(0);
            if (c >= 'A' && c <= 'Z') continue;
            try {
                kPLObject2 = fact.value(string4);
            }
            catch (Exception exception) {
                factAnalyzerContext.logException(1, "consolidate", exception);
                continue;
            }
            try {
                kPLObject = fact2.value(string4);
            }
            catch (Exception exception) {
                try {
                    fact2.set(string4, kPLObject2);
                }
                catch (Exception exception2) {
                    factAnalyzerContext.logException(2, "consolidate", exception2);
                }
                continue;
            }
            if (kPLObject2.type() != kPLObject.type()) {
                factAnalyzerContext.log(0x200000, "", "Check " + kPLString.value() + " is trying to change the " + fact.className() + " " + string4 + " Slot from " + kPLObject.typeToString() + " to " + kPLObject2.typeToString() + ".", false);
                continue;
            }
            try {
                boolean bl = KPLObject.compare(kPLObject2, "==", kPLObject);
                if (bl) continue;
                this.a(factAnalyzerContext, kPLString.value(), string4, fact, kPLObject2, fact2, kPLObject);
            }
            catch (Exception exception) {
                factAnalyzerContext.logException(1, "consolidate", exception);
            }
        }
        try {
            iFactStorage.put(fact2);
        }
        catch (Exception exception) {
            factAnalyzerContext.logException(2, "consolidate", exception);
        }
    }

    public String prefix() {
        return "com.sun.eras.kae.facts.rfa.KCERFA_";
    }
}

