/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.kae.facts;

import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import com.sun.eras.kae.facts.FactSlotException;
import com.sun.eras.kae.facts.Slot;
import com.sun.eras.kae.kpl.model.KPLBoolean;
import com.sun.eras.kae.kpl.model.KPLDateTime;
import com.sun.eras.kae.kpl.model.KPLInteger;
import com.sun.eras.kae.kpl.model.KPLList;
import com.sun.eras.kae.kpl.model.KPLObject;
import com.sun.eras.kae.kpl.model.KPLReal;
import com.sun.eras.kae.kpl.model.KPLString;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import kce.KCEFact;

public class Fact
implements Serializable {
    private static final long serialVersionUID = 7832640559911374625L;
    public static final String CLASS_SLOT_NAME = "Class";
    public static final String INSTANCE_SLOT_NAME = "Instance";
    private String m_className;
    private String m_instance;
    private String m_description;
    private String m_accessMethods;
    private TreeMap m_slots;

    public Fact(KCEFact kCEFact) {
        this.m_className = kCEFact.getClassName();
        this.m_instance = kCEFact.getInstance();
        this.m_description = kCEFact.getDescription();
        this.m_accessMethods = kCEFact.getAccessMethods();
        this.m_slots = kCEFact.getSlots();
    }

    public Fact(String string) {
        this.create(string, string);
    }

    public Fact(String string, String string2) {
        this.create(string, string2);
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new KCEFact(this);
    }

    protected void create(String string, String string2) {
        this.m_className = string;
        this.m_instance = string2;
        this.m_description = null;
        this.m_accessMethods = null;
        this.m_slots = new TreeMap();
        Slot slot = new Slot(CLASS_SLOT_NAME, 7, true, new KPLString(string));
        slot.setDescription("Class name.<BR>INTERNALLY CREATED.");
        this.m_slots.put(CLASS_SLOT_NAME, slot);
        slot = new Slot(INSTANCE_SLOT_NAME, 7, true, new KPLString(string2));
        slot.setDescription("Fact instance name.<BR>INTERNALLY CREATED.");
        this.m_slots.put(INSTANCE_SLOT_NAME, slot);
    }

    public String accessMethods() {
        return this.m_accessMethods;
    }

    public void addSlot(Slot slot) {
        this.m_slots.put(slot.name(), slot);
    }

    public String className() {
        return this.m_className;
    }

    public String description() {
        return this.m_description;
    }

    public Slot getSlot(String string) {
        return (Slot)this.m_slots.get(string);
    }

    public Object getValue(String string) {
        if (string == null || string.length() <= 0) {
            return null;
        }
        Slot slot = (Slot)this.m_slots.get(string);
        if (slot == null) {
            return null;
        }
        KPLObject kPLObject = slot.value();
        if (kPLObject == null) {
            return null;
        }
        return KPLObject.toJavaObject(kPLObject);
    }

    public String key() {
        return this.m_className + "^" + this.m_instance;
    }

    public String instance() {
        return this.m_instance;
    }

    public boolean isSlotPresent(String string) {
        Slot slot = (Slot)this.m_slots.get(string);
        return slot != null;
    }

    public boolean isDefault(String string) throws FactSlotException {
        Slot slot = (Slot)this.m_slots.get(string);
        if (slot == null) {
            throw new FactSlotException(this, string);
        }
        return slot.isDefault();
    }

    public boolean isReadOnly(String string) throws FactSlotException {
        Slot slot = (Slot)this.m_slots.get(string);
        if (slot == null) {
            throw new FactSlotException(this, string);
        }
        return slot.isReadOnly();
    }

    public void set(String string, KPLObject kPLObject) throws FactSlotException, NullPointerException {
        this.setSlotValue(string, kPLObject);
    }

    private void setSlotValue(String string, KPLObject kPLObject) throws NullPointerException {
        Slot slot = (Slot)this.m_slots.get(string);
        if (slot == null) {
            slot = new Slot(string, kPLObject.type(), false, null);
            this.m_slots.put(string, slot);
        }
        slot.set(kPLObject);
    }

    public void set(String string, String string2) {
        this.setSlotValue(string, new KPLString(string2));
    }

    public void set(String string, boolean bl) {
        String string2 = bl ? "true" : "false";
        this.setSlotValue(string, new KPLBoolean(string2));
    }

    public void set(String string, Date date) {
        this.setSlotValue(string, new KPLDateTime(date));
    }

    public void set(String string, long l) {
        this.setSlotValue(string, new KPLInteger(l));
    }

    public void set(String string, double d) {
        this.setSlotValue(string, new KPLReal(d));
    }

    public void set(String string, List list) throws NullPointerException, IllegalArgumentException {
        this.setSlotValue(string, new KPLList(list));
    }

    public void setAccessMethods(String string) {
        this.m_accessMethods = string;
    }

    public void setDescription(String string) {
        this.m_description = string;
    }

    public void setInstance(String string) {
        this.m_instance = string;
        try {
            this.setOverride(INSTANCE_SLOT_NAME, new KPLString(string));
        }
        catch (FactSlotException factSlotException) {
            String string2 = MessageLocalizer.makeLMS((Object)this, (MessageKey)new MessageKey("invalidException"), (String)("This exception should not have occurred " + factSlotException.getMessage()), null, null);
            throw new RuntimeException(string2);
        }
    }

    public void setOverride(String string, KPLObject kPLObject) throws FactSlotException {
        Slot slot = (Slot)this.m_slots.get(string);
        if (slot == null) {
            throw new FactSlotException(this, string);
        }
        slot.setOverride(kPLObject);
    }

    public TreeMap slots() {
        return this.m_slots;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(this.m_instance);
        stringBuffer.append(", instance of ");
        stringBuffer.append(this.m_className);
        stringBuffer.append(":\n");
        if (this.m_description != null && !this.m_description.equals("")) {
            stringBuffer.append(this.m_description);
            stringBuffer.append("\n");
        }
        if (this.m_accessMethods != null && !this.m_accessMethods.equals("")) {
            stringBuffer.append(this.m_accessMethods);
            stringBuffer.append("\n");
        }
        Set set = this.m_slots.keySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Slot slot = (Slot)this.m_slots.get(string);
            stringBuffer.append(slot.toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append("\n");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public int type(String string) throws FactSlotException {
        Slot slot = (Slot)this.m_slots.get(string);
        if (slot == null) {
            throw new FactSlotException(this, string);
        }
        return slot.type();
    }

    public KPLObject value(String string) throws FactSlotException {
        Slot slot = (Slot)this.m_slots.get(string);
        if (slot == null) {
            throw new FactSlotException(this, string);
        }
        return slot.value();
    }

    public static String instanceFull(Vector vector) {
        if (vector == null || vector.size() <= 0) {
            return "";
        }
        return Fact.instanceFull(vector.toArray(new String[vector.size()]));
    }

    public static String instanceFull(String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        String string = "";
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            if (n > 0) {
                string = string + "|";
            }
            string = string + string2;
            ++n;
        }
        return string;
    }

    public static String instanceFull(String string, String string2) {
        return Fact.instanceFull(new String[]{string, string2});
    }

    public static String instanceFull(String string, String string2, String string3) {
        return Fact.instanceFull(new String[]{string, string2, string3});
    }

    public static String instanceFull(String string, String string2, String string3, String string4) {
        return Fact.instanceFull(new String[]{string, string2, string3, string4});
    }

    public static String instancePart(String string, int n) {
        if (n <= 0) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        int n2 = 1;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (n2 == n) {
                return string2;
            }
            ++n2;
        }
        return "";
    }

    public static Vector instanceToParts(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken());
        }
        return vector;
    }

    public static String key(String string, String string2) {
        return string + "^" + string2;
    }

    public static String keyToClass(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        int n = string.indexOf(94);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String keyToInstance(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        int n = string.indexOf(94);
        if (n < 0) {
            return null;
        }
        return string.substring(n + 1);
    }
}

