/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.validator;

import com.sun.eras.common.logging4.Level;
import com.sun.eras.common.logging4.Logger;
import com.sun.eras.common.util.EntityResolverHelper;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import com.sun.eras.common.validator.ValidationException;
import com.sun.eras.common.validator.ValidationFailureException;
import com.sun.eras.common.validator.ValidatorConfig;
import com.sun.eras.common.validator.ValidatorInitializationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class Validator {
    static final int LINES_ADDED_BY_WRAP = 3;
    protected static final Logger logger = Logger.getLogger((class$com$sun$eras$common$validator$Validator == null ? (class$com$sun$eras$common$validator$Validator = Validator.class$("com.sun.eras.common.validator.Validator")) : class$com$sun$eras$common$validator$Validator).getName());
    protected static ValidatorConfig config = ValidatorConfig.getInstance();
    private String inputFormat = null;
    private String dtdUrlString = null;
    private String dtdFileName = null;
    private String dtdPublicId = null;
    static /* synthetic */ Class class$com$sun$eras$common$validator$Validator;

    public Validator(String string) {
        this.inputFormat = string;
    }

    public String getInputFormat() throws ValidationException {
        if (this.inputFormat == null) {
            throw new ValidatorInitializationException(new MessageKey("InputFormatStringNotInitialized"), "Input Form string has not been initialized", null, null, null);
        }
        return this.inputFormat;
    }

    public void setDtdPublicId(String string) {
        this.dtdPublicId = string;
    }

    public String getDtdPublicId() throws ValidationException {
        if (this.dtdPublicId != null) {
            return this.dtdPublicId;
        }
        return new EntityResolverHelper().publicIdForSystemId(this.getDtdUrlString());
    }

    public void setDtdUrlString(String string) {
        this.dtdUrlString = string;
    }

    public String getDtdUrlString() throws ValidationException {
        if (this.dtdUrlString == null) {
            String string = this.getDtdFileName();
            URL uRL = this.getClass().getResource(string);
            if (uRL == null) {
                throw new ValidatorInitializationException(new MessageKey("DTDFileNotFound"), "Cannot find resource on class path for dtdFileName: " + string, new Object[]{string}, null, null);
            }
            this.dtdUrlString = uRL.toString();
        }
        return this.dtdUrlString;
    }

    public void setDtdFileName(String string) {
        this.dtdFileName = string;
    }

    public String getDtdFileName() throws ValidationException {
        if (this.dtdFileName == null) {
            String string = this.getInputFormat();
            this.dtdFileName = config.getDtdFileName(string);
            if (this.dtdFileName == null) {
                throw new ValidatorInitializationException(new MessageKey("InputFormatStringNotInitialized"), "Input Format string not in Config File  " + string, new Object[]{string}, null, null);
            }
        }
        return this.dtdFileName;
    }

    public abstract void validate(String var1) throws ValidationFailureException, ValidationException;

    public void wrapAndValidate(String string) throws ValidationFailureException, ValidationException {
        try {
            this.toDocument(this.wrapCml(string));
        }
        catch (SAXParseException sAXParseException) {
            throw new ValidationFailureException(sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new ValidationFailureException(sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ValidatorInitializationException(parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new ValidationException(iOException);
        }
        catch (Throwable throwable) {
            throw new ValidationException(throwable);
        }
    }

    protected String wrapCml(String string) throws ValidationException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version='1.0' encoding='UTF-8'?>\n");
        this.addDoctype(stringBuffer);
        stringBuffer.append("<textbody>\n");
        stringBuffer.append(string);
        stringBuffer.append("\n</textbody>");
        return stringBuffer.toString();
    }

    protected void addDoctype(StringBuffer stringBuffer) throws ValidationException {
        String string = this.getDtdUrlString();
        String string2 = this.getDtdPublicId();
        if (string2 == null) {
            stringBuffer.append("<!DOCTYPE textbody SYSTEM \"");
            stringBuffer.append(string);
            stringBuffer.append("\">\n");
        } else {
            stringBuffer.append("<!DOCTYPE textbody PUBLIC \"");
            stringBuffer.append(string2);
            stringBuffer.append("\" \"");
            stringBuffer.append(string);
            stringBuffer.append("\">\n");
        }
    }

    protected Document toDocument(String string) throws SAXException, ParserConfigurationException, IOException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setErrorHandler(new ErrorHandler(){

            public void fatalError(SAXParseException sAXParseException) throws SAXException {
                String string = MessageLocalizer.makeLMS(this, new MessageKey("fatalSAXException"), "fatal SAXException", null, null);
                logger.log(Level.SEVERE, string, sAXParseException);
            }

            public void error(SAXParseException sAXParseException) throws SAXParseException {
                throw sAXParseException;
            }

            public void warning(SAXParseException sAXParseException) throws SAXParseException {
                String string = MessageLocalizer.makeLMS(this, new MessageKey("SAXParseExceptionlineuri"), "SAXParseException: , line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId(), new Object[]{new Integer(sAXParseException.getLineNumber()), sAXParseException.getSystemId()}, null);
                logger.log(Level.WARNING, string, sAXParseException);
            }
        });
        byte[] byArray = string.getBytes("UTF8");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        Document document = documentBuilder.parse(byteArrayInputStream);
        return document;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

