/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.validator;

import com.sun.eras.common.util.LocalizedString;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.validator.ValidationException;
import java.text.Format;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidationFailureException
extends ValidationException {
    private int columnNumber = 0;
    private int lineNumber = 0;

    public ValidationFailureException(MessageKey messageKey, String string, Object[] objectArray, Format[] formatArray, Throwable throwable) {
        super(messageKey, string, objectArray, formatArray, throwable);
    }

    public ValidationFailureException(LocalizedString localizedString) {
        super(localizedString, (Throwable)null);
    }

    public ValidationFailureException(LocalizedString localizedString, Throwable throwable) {
        super(localizedString, throwable);
    }

    public ValidationFailureException() {
    }

    public ValidationFailureException(SAXException sAXException) {
        super(new LocalizedString(ValidationFailureException.pruneExceptionMessage(sAXException.getMessage())), (Throwable)sAXException);
    }

    private static String pruneExceptionMessage(String string) {
        String string2;
        if (string == null) {
            string = "null message.";
        }
        if (string.startsWith(string2 = "org.xml.sax.SAXException: ")) {
            string = string.substring(string2.length());
        }
        if (string.startsWith(string2 = "org.xml.sax.SAXParseException: ")) {
            string = string.substring(string2.length());
        }
        if (string.startsWith(string2 = "Stopping after fatal error: ")) {
            string = string.substring(string2.length());
        }
        return string;
    }

    public ValidationFailureException(SAXParseException sAXParseException) {
        super(new LocalizedString(ValidationFailureException.pruneExceptionMessage(sAXParseException.getMessage())), (Throwable)sAXParseException);
        this.lineNumber = sAXParseException.getLineNumber() - 3;
        this.columnNumber = sAXParseException.getColumnNumber();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }
}

