/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;
import org.apache.oro.text.regex.Perl5Pattern;

public class FileRegExpr {
    private BufferedReader sourceReader = null;
    private Map regexpPatterns = new HashMap();
    private Perl5Compiler p5c = new Perl5Compiler();
    private Perl5Matcher p5m = new Perl5Matcher();

    public FileRegExpr(String string) throws FileNotFoundException {
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "US-ASCII");
            this.sourceReader = new BufferedReader(inputStreamReader);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.sourceReader = new BufferedReader(new FileReader(new File(string)));
        }
    }

    public BufferedReader reader() {
        return this.sourceReader;
    }

    public void close() {
        if (this.sourceReader != null) {
            try {
                this.sourceReader.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.sourceReader = null;
        }
    }

    public void defineRegexp(String string, String string2) throws MalformedPatternException {
        this.regexpPatterns.put(string, (Perl5Pattern)this.p5c.compile(string2));
    }

    public MatchResult matchRegexp(String string, String string2) {
        MatchResult matchResult = null;
        Perl5Pattern perl5Pattern = (Perl5Pattern)this.regexpPatterns.get(string);
        if (perl5Pattern != null && this.p5m.contains(string2, (Pattern)perl5Pattern)) {
            matchResult = this.p5m.getMatch();
        }
        return matchResult;
    }
}

