/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.util;

import com.sun.eras.common.logging4.Handler;
import com.sun.eras.common.logging4.Logger;
import com.sun.eras.common.util.ConfigNotFoundException;
import com.sun.eras.common.util.ConfigPropertyNotFoundException;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import com.sun.eras.common.util.StringUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.ListResourceBundle;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class Config
extends ResourceBundle {
    private static Logger logger = null;
    private static boolean loggerInitialized = false;
    private static boolean loggerMsgPrinted = false;
    private static final String MISSING_OBJECT = new String();
    public static final String USER_SUFFIX_PROPERTY = "configSuffix";
    public static final String USER_SUFFIX_PROPERTY_2 = "user.name";
    private static final String SEP = "_";
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final String DEFAULT_IP = "127.0.0.1";
    public static final String CONFIG_CONFIG_BASENAME = "config";
    public static final String CONFIG_CONFIG_PROPERTY_NAME = "config.name";
    private static String shortHostName;
    private static String hostIp;
    private static String fullHostName;
    private String baseName;
    private ResourceBundle baseBundle;
    private String baseBundleName;
    private boolean usingBaseConfig;
    private ResourceBundle localBundle;
    private String localBundleName;
    private boolean usingLocalConfig;
    private ResourceBundle userBundle;
    private String userBundleName;
    private boolean usingUserConfig;
    private ResourceBundle defaultsBundle = null;
    private static final String defaultsBundleName = "hard-coded class defaults";
    private boolean usingDefaultsConfig;
    static /* synthetic */ Class class$com$sun$eras$common$util$Config;

    public Config() throws ConfigNotFoundException {
        if (!this.init(null)) {
            Config.logInfo(MessageLocalizer.makeLMS(this, new MessageKey("ConfigFileNotFound"), "Could not find config file " + this.baseName, new Object[]{this.baseName}, null));
        }
    }

    public Config(String string) throws ConfigNotFoundException {
        if (!this.init(string, null)) {
            Config.logInfo(MessageLocalizer.makeLMS(this, new MessageKey("ConfigFileNotFound"), "Could not find config file " + string, new Object[]{string}, null));
        }
    }

    public Config(String string, String string2) throws ConfigNotFoundException {
        if (!this.init(string, string2, null)) {
            Config.logInfo(MessageLocalizer.makeLMS(this, new MessageKey("ConfigFileNotFound"), "Could not find config file " + string, new Object[]{string}, null));
        }
    }

    public Config(ResourceBundle resourceBundle) {
        this.init(resourceBundle);
    }

    public Config(String string, ResourceBundle resourceBundle) {
        this.init(string, resourceBundle);
    }

    public Config(String string, String string2, ResourceBundle resourceBundle) {
        this.init(string, string2, resourceBundle);
    }

    private boolean init(ResourceBundle resourceBundle) throws ConfigNotFoundException {
        Config config = new Config(CONFIG_CONFIG_BASENAME);
        String string = config.getString(CONFIG_CONFIG_PROPERTY_NAME, CONFIG_CONFIG_BASENAME);
        return this.init(string, resourceBundle);
    }

    private boolean init(String string, ResourceBundle resourceBundle) {
        return this.init(string, this.getDefaultLocalSuffix(), resourceBundle);
    }

    private boolean init(String string, String string2, ResourceBundle resourceBundle) {
        return this.init(string, string2, this.getDefaultUserSuffix(), resourceBundle);
    }

    private boolean init(String string, String string2, String string3, ResourceBundle resourceBundle) {
        this.baseName = string;
        this.usingDefaultsConfig = false;
        this.defaultsBundle = null;
        if (resourceBundle != null) {
            this.defaultsBundle = resourceBundle;
            this.usingDefaultsConfig = true;
        }
        this.usingLocalConfig = false;
        this.localBundle = null;
        if (string2 != null) {
            try {
                this.localBundleName = string + SEP + string2;
                this.localBundle = ResourceBundle.getBundle(this.localBundleName);
                this.usingLocalConfig = true;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        this.usingUserConfig = false;
        this.userBundle = null;
        if (string3 != null) {
            try {
                this.userBundleName = string + SEP + string3;
                this.userBundle = ResourceBundle.getBundle(this.userBundleName);
                this.usingUserConfig = true;
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        this.usingBaseConfig = false;
        this.baseBundle = null;
        try {
            this.baseBundleName = string;
            this.baseBundle = ResourceBundle.getBundle(string);
            this.usingBaseConfig = true;
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
        return true;
    }

    protected String getDefaultUserSuffix() {
        String string = System.getProperty(USER_SUFFIX_PROPERTY);
        if (string == null || "".equals(string)) {
            string = System.getProperty(USER_SUFFIX_PROPERTY_2);
        }
        if ("".equals(string)) {
            return null;
        }
        return string;
    }

    protected String getDefaultLocalSuffix() {
        return shortHostName;
    }

    protected ResourceBundle getDefaultsBundle() {
        return this.defaultsBundle;
    }

    public ResourceBundle getSystemResourceBundle() {
        return this.baseBundle;
    }

    public ResourceBundle getUserResourceBundle() {
        return this.userBundle;
    }

    public ResourceBundle getLocalResourceBundle() {
        return this.localBundle;
    }

    public String getSystemResourceBundleName() {
        return this.baseBundleName;
    }

    public String getUserResourceBundleName() {
        return this.userBundleName;
    }

    public String getLocalResourceBundleName() {
        return this.localBundleName;
    }

    public static ResourceBundle makeDefaultsBundle(final Object[][] objectArray) {
        ListResourceBundle listResourceBundle = new ListResourceBundle(){

            protected Object[][] getContents() {
                return objectArray;
            }
        };
        return listResourceBundle;
    }

    private String systemPropertyName(String string) {
        return this.baseName + "." + string;
    }

    protected Object handleGetObject(String string) throws ConfigPropertyNotFoundException {
        return this.handleGetObject(string, false, null);
    }

    protected Object handleGetObject(String string, boolean bl, Object object) throws ConfigPropertyNotFoundException {
        String string2 = System.getProperty(this.systemPropertyName(string));
        if (string2 != null) {
            String string3 = this.expandMacros(string2);
            Config.logTrace("loading value from system property: " + string + "=" + string3);
            return string3;
        }
        if (this.usingUserConfig && this.bundleContainsKey(this.userBundle, string)) {
            String string4 = this.expandMacros(this.userBundle.getString(string));
            Config.logTrace("loading value from " + this.userBundleName + ".properties: " + string + "=" + string4);
            return string4;
        }
        if (this.usingLocalConfig && this.bundleContainsKey(this.localBundle, string)) {
            String string5 = this.expandMacros(this.localBundle.getString(string));
            Config.logTrace("loading value from " + this.localBundleName + ".properties: " + string + "=" + string5);
            return string5;
        }
        if (this.usingBaseConfig && this.bundleContainsKey(this.baseBundle, string)) {
            String string6 = this.expandMacros(this.baseBundle.getString(string));
            Config.logTrace("loading value from " + this.baseName + ".properties: " + string + "=" + string6);
            return string6;
        }
        if (this.usingDefaultsConfig && this.bundleContainsKey(this.defaultsBundle, string)) {
            String string7 = this.expandMacros(this.defaultsBundle.getString(string));
            Config.logTrace("Property not in property file " + this.baseName + ". Loading value from hard-coded class defaults.");
            return string7;
        }
        if (bl) {
            return object;
        }
        this.logMissingKey(string);
        throw new ConfigPropertyNotFoundException(this.baseName, string);
    }

    private void logMissingKey(String string) {
        String string2 = null;
        if (this.usingUserConfig) {
            string2 = this.userBundleName;
        } else if (this.usingLocalConfig) {
            string2 = this.localBundleName;
        } else if (this.usingBaseConfig) {
            string2 = this.baseName;
        }
        if (!this.usingDefaultsConfig && string2 == null) {
            Config.logSevere(MessageLocalizer.makeLMS(this, new MessageKey("PropertyNotFound_NoDefaultBundle_NoFile"), "Property " + string + " not found, no defaults provided, " + this.baseName + ".properties is missing.", new Object[]{string, this.baseName}, null));
        } else if (this.usingDefaultsConfig && string2 == null) {
            Config.logSevere(MessageLocalizer.makeLMS(this, new MessageKey("PropertyNotFound_DefaultBundle_NoFile"), "Property " + string + " not found, not initialized in defaults, " + this.baseName + ".properties is missing.", new Object[]{string, this.baseName}, null));
        } else if (!this.usingDefaultsConfig && string2 != null) {
            Config.logSevere(MessageLocalizer.makeLMS(this, new MessageKey("PropertyNotFound_NoDefaultBundle_File"), "Property " + string + " not found in " + string2 + ".properties, no defaults provided", new Object[]{string, string2}, null));
        } else {
            Config.logSevere(MessageLocalizer.makeLMS(this, new MessageKey("PropertyNotFound_DefaultBundle_File"), "Property " + string + " not found in " + string2 + ".properties or defaults", new Object[]{string, string2}, null));
        }
    }

    protected boolean bundleContainsKey(ResourceBundle resourceBundle, String string) {
        try {
            resourceBundle.getString(string);
            return true;
        }
        catch (MissingResourceException missingResourceException) {
            return false;
        }
    }

    public String getString(String string, String string2) {
        Object object = this.handleGetObject(string, true, MISSING_OBJECT);
        if (object != MISSING_OBJECT) {
            return (String)object;
        }
        return this.expandMacros(string2);
    }

    public String[] getStrings(String string, String[] stringArray) {
        String string2 = this.getString(string, MISSING_OBJECT);
        if (string2 != MISSING_OBJECT) {
            return StringUtil.split(string2, ",");
        }
        return stringArray;
    }

    public int getInt(String string) throws ConfigPropertyNotFoundException, NumberFormatException {
        String string2 = this.getString(string);
        return Integer.parseInt(string2);
    }

    public int getInt(String string, int n) {
        String string2 = this.getString(string, MISSING_OBJECT);
        if (string2 != MISSING_OBJECT) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.logNumberFormatException("int", string, string2, "" + n, numberFormatException);
            }
        }
        return n;
    }

    private void logNumberFormatException(String string, String string2, String string3, String string4, NumberFormatException numberFormatException) {
        String string5 = MessageLocalizer.makeLMS(this, new MessageKey("ConfigNumberFormatException"), "Value provided for key " + string2 + ", \"" + string3 + "\", does not parse as a " + string + ". Default value \"" + string4 + "\" is used instead.", new Object[]{string2, string3, string, string4}, null);
        Config.logWarning(string5);
    }

    public long getLong(String string) throws ConfigPropertyNotFoundException, NumberFormatException {
        String string2 = this.getString(string);
        return Long.parseLong(string2);
    }

    public long getLong(String string, long l) {
        String string2 = this.getString(string, MISSING_OBJECT);
        if (string2 != MISSING_OBJECT) {
            try {
                return Long.parseLong(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.logNumberFormatException("long", string, string2, "" + l, numberFormatException);
            }
        }
        return l;
    }

    public double getDouble(String string) throws ConfigPropertyNotFoundException, NumberFormatException {
        String string2 = this.getString(string);
        return Double.parseDouble(string2);
    }

    public double getDouble(String string, double d) {
        String string2 = this.getString(string, MISSING_OBJECT);
        if (string2 != MISSING_OBJECT) {
            try {
                return Double.parseDouble(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.logNumberFormatException("double", string, string2, "" + d, numberFormatException);
            }
        }
        return d;
    }

    public float getFloat(String string) throws ConfigPropertyNotFoundException, NumberFormatException {
        String string2 = this.getString(string);
        return Float.parseFloat(string2);
    }

    public float getFloat(String string, float f) {
        String string2 = this.getString(string, MISSING_OBJECT);
        if (string2 != MISSING_OBJECT) {
            try {
                return Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.logNumberFormatException("float", string, string2, "" + f, numberFormatException);
            }
        }
        return f;
    }

    public boolean getBoolean(String string) throws ConfigPropertyNotFoundException {
        String string2 = this.getString(string);
        return this.parseBoolean(string2);
    }

    private boolean parseBoolean(String string) {
        return string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("on");
    }

    public boolean getBoolean(String string, boolean bl) {
        String string2 = this.getString(string, MISSING_OBJECT);
        if (string2 != MISSING_OBJECT) {
            return this.parseBoolean(string2);
        }
        return bl;
    }

    private String expandMacros(String string) {
        if (string == null) {
            return string;
        }
        string = StringUtil.findReplace(string, "$ip$", hostIp);
        string = StringUtil.findReplace(string, "$localhost$", fullHostName);
        string = StringUtil.findReplace(string, "$hostname$", shortHostName);
        return string;
    }

    public Set keySet() {
        String string;
        Enumeration<String> enumeration;
        HashSet<String> hashSet = new HashSet<String>();
        if (this.defaultsBundle != null) {
            enumeration = this.defaultsBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                if (null == string) continue;
                hashSet.add(string);
            }
        }
        if (this.baseBundle != null) {
            enumeration = this.baseBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                if (null == string) continue;
                hashSet.add(string);
            }
        }
        if (this.localBundle != null) {
            enumeration = this.localBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                if (null == string) continue;
                hashSet.add(string);
            }
        }
        if (this.userBundle != null) {
            enumeration = this.userBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                if (null == string) continue;
                hashSet.add(string);
            }
        }
        enumeration = System.getProperties().propertyNames();
        String string2 = this.baseName + ".";
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement();
            if (null == string || !string.startsWith(string2)) continue;
            string = string.substring(string2.length());
            hashSet.add(string);
        }
        return hashSet;
    }

    public Enumeration getKeys() {
        return this.propertyNames();
    }

    public Enumeration propertyNames() {
        Set set = this.keySet();
        final Iterator iterator = set.iterator();
        return new Enumeration(){

            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
    }

    public Set propertyNamesOld() {
        String string;
        Enumeration<String> enumeration;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        if (this.baseBundle != null) {
            enumeration = this.baseBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                if (null == string) continue;
                hashtable.put(string, "");
            }
        }
        if (this.localBundle != null) {
            enumeration = this.localBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                if (null == string) continue;
                hashtable.put(string, "");
            }
        }
        if (this.userBundle != null) {
            enumeration = this.userBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                if (null == string) continue;
                hashtable.put(string, "");
            }
        }
        enumeration = System.getProperties().propertyNames();
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement();
            String string2 = new String(this.baseName + ".");
            if (null == string || !string.startsWith(string2)) continue;
            string = string.substring(string2.length());
            hashtable.put(string, "");
        }
        return hashtable.keySet();
    }

    private static synchronized void makeLogger() {
        if (!loggerInitialized) {
            Logger logger;
            loggerInitialized = true;
            if (Config.logger == null && (loggerInitialized = Config.loggerReadyToLog(logger = Logger.getLogger((class$com$sun$eras$common$util$Config == null ? (class$com$sun$eras$common$util$Config = Config.class$("com.sun.eras.common.util.Config")) : class$com$sun$eras$common$util$Config).getName())))) {
                Config.logger = logger;
            }
        }
        if (logger == null && !loggerMsgPrinted) {
            System.err.println("INFO: from Config: The logger for class com.sun.eras.common.util.Config is");
            System.err.println("INFO: from Config: not ready to log. Config will write these");
            System.err.println("INFO: from Config: \"from Config\" messages to System.err until");
            System.err.println("INFO: from Config: the logging subsystem finishes initializing.");
            loggerMsgPrinted = true;
        }
    }

    private static boolean loggerReadyToLog(Logger logger) {
        while (logger != null) {
            Handler[] handlerArray = logger.getHandlers();
            if (handlerArray != null && handlerArray.length > 0) {
                return true;
            }
            if (!logger.getUseParentHandlers()) break;
            logger = logger.getParent();
        }
        return false;
    }

    private static void logWarning(String string) {
        if (logger == null) {
            Config.makeLogger();
        }
        if (logger != null) {
            logger.warning(string);
        } else {
            System.err.println("WARNING: from Config: " + string);
        }
    }

    private static void logSevere(String string) {
        if (logger == null) {
            Config.makeLogger();
        }
        if (logger != null) {
            logger.severe(string);
        } else {
            System.err.println("SEVERE: from Config: " + string);
        }
    }

    private static void logInfo(String string) {
        if (logger == null) {
            Config.makeLogger();
        }
        if (logger != null) {
            logger.info(string);
        } else {
            System.err.println("INFO: from Config: " + string);
        }
    }

    private static void logTrace(String string) {
        if (logger == null) {
            Config.makeLogger();
        }
        if (logger != null) {
            logger.fine(string);
        } else {
            System.err.println("FINE: from Config: " + string);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("{");
        stringBuffer.append(" baseName=").append(this.baseName).append(";");
        if (this.usingBaseConfig) {
            stringBuffer.append(" base=").append(this.baseBundleName).append(";");
        }
        if (this.usingLocalConfig) {
            stringBuffer.append(" local=").append(this.localBundleName).append(";");
        }
        if (this.usingUserConfig) {
            stringBuffer.append(" user=").append(this.userBundleName).append(";");
        }
        if (this.usingDefaultsConfig) {
            stringBuffer.append(" defaults=").append(defaultsBundleName).append(";");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        try {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                hostIp = inetAddress.getHostAddress();
                fullHostName = inetAddress.getHostName();
                if (fullHostName.indexOf(".") != -1) {
                    shortHostName = fullHostName.substring(0, fullHostName.indexOf(".")).toLowerCase();
                }
                shortHostName = fullHostName;
            }
            catch (UnknownHostException unknownHostException) {
                Config.logWarning(MessageLocalizer.makeLMS(class$com$sun$eras$common$util$Config == null ? (class$com$sun$eras$common$util$Config = Config.class$("com.sun.eras.common.util.Config")) : class$com$sun$eras$common$util$Config, new MessageKey("ConfigHostNameUnknown"), "Config could not determine hostname!", null, null));
                fullHostName = DEFAULT_HOSTNAME;
                shortHostName = DEFAULT_HOSTNAME;
                hostIp = DEFAULT_IP;
                Object var3_3 = null;
                Config.logTrace("Short hostname is " + shortHostName);
                Config.logTrace("Long hostname is " + fullHostName);
                Config.logTrace("Host IP is " + hostIp);
                return;
            }
            catch (NullPointerException nullPointerException) {
                Config.logWarning(MessageLocalizer.makeLMS(class$com$sun$eras$common$util$Config == null ? (class$com$sun$eras$common$util$Config = Config.class$("com.sun.eras.common.util.Config")) : class$com$sun$eras$common$util$Config, new MessageKey("ConfigHostNameUnknown"), "Config could not determine hostname!", null, null));
                fullHostName = DEFAULT_HOSTNAME;
                shortHostName = DEFAULT_HOSTNAME;
                hostIp = DEFAULT_IP;
                Object var3_4 = null;
                Config.logTrace("Short hostname is " + shortHostName);
                Config.logTrace("Long hostname is " + fullHostName);
                Config.logTrace("Host IP is " + hostIp);
                return;
            }
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            Config.logTrace("Short hostname is " + shortHostName);
            Config.logTrace("Long hostname is " + fullHostName);
            Config.logTrace("Host IP is " + hostIp);
            throw throwable;
        }
        Config.logTrace("Short hostname is " + shortHostName);
        Config.logTrace("Long hostname is " + fullHostName);
        Config.logTrace("Host IP is " + hostIp);
    }
}

