/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.translator.cml;

import com.sun.eras.common.logging4.Logger;
import com.sun.eras.common.translator.cml.CmlTextTranslatorSettings;
import com.sun.eras.common.translator.cml.CmlToTextTranslatorDispatcher;
import com.sun.eras.common.translator.cml.CmlTreeWalkingTranslator;
import com.sun.eras.common.translator.cml.TranslatorInitializationException;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import com.sun.eras.common.util.StringUtil;
import java.util.ResourceBundle;

public class CmlToTextTranslator
extends CmlTreeWalkingTranslator
implements CmlTextTranslatorSettings {
    private static final Logger logger = Logger.getLogger((class$com$sun$eras$common$translator$cml$CmlToTextTranslator == null ? (class$com$sun$eras$common$translator$cml$CmlToTextTranslator = CmlToTextTranslator.class$("com.sun.eras.common.translator.cml.CmlToTextTranslator")) : class$com$sun$eras$common$translator$cml$CmlToTextTranslator).getName());
    public static final double MIN_MEDIA_WIDTH = 1.0;
    private double mediaWidth = 0.0;
    private String mediaWidthUnit = null;
    private String tableLeft = "| ";
    private String tableRight = " |";
    private String tableColSep = " | ";
    private String tableTop = "________________________________";
    private String tableBottom = "_____________________________";
    private String tableRowSep = "--------------------------------";
    private String[] ulBullets = new String[]{" * ", " ++ ", " --- "};
    static /* synthetic */ Class class$com$sun$eras$common$translator$cml$CmlToTextTranslator;

    CmlToTextTranslator(String string) throws TranslatorInitializationException {
        super(string, new CmlToTextTranslatorDispatcher());
        ((CmlToTextTranslatorDispatcher)this.dispatcher).setSettings(this);
    }

    public void setMediaWidth(double d) {
        if (d <= 0.0) {
            String string = MessageLocalizer.makeLMS(this, new MessageKey("MediaWidthMustNotBeNegative"), "Media Width Must not be negative", null, null);
            throw new IllegalArgumentException(string);
        }
        this.mediaWidth = d;
    }

    public double getMediaWidth() {
        return this.mediaWidth;
    }

    public void setUlBullets(String[] stringArray) {
        this.ulBullets = stringArray;
    }

    public String[] getUlBullets() {
        return this.ulBullets;
    }

    public void setUlBullets(String string) {
        if (string != null) {
            this.ulBullets = StringUtil.split(string, ",");
            int n = 0;
            while (n < this.ulBullets.length) {
                this.ulBullets[n] = this.stripQuotes(this.ulBullets[n]);
                ++n;
            }
        }
    }

    public String getUlBulletsAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.ulBullets.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\"").append(this.ulBullets[n2]).append("\"");
            if (n2 < n - 1) {
                stringBuffer.append(",");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void setTableTop(String string) {
        if (string == null) {
            string = "";
        }
        this.tableTop = string;
    }

    public String getTableTop() {
        return this.tableTop;
    }

    public void setTableRowSep(String string) {
        if (string == null) {
            string = "";
        }
        this.tableRowSep = string;
    }

    public String getTableRowSep() {
        return this.tableRowSep;
    }

    public void setTableBottom(String string) {
        if (string == null) {
            string = "";
        }
        this.tableBottom = string;
    }

    public String getTableBottom() {
        return this.tableBottom;
    }

    public void setTableLeft(String string) {
        if (string == null) {
            string = "";
        }
        this.tableLeft = string;
    }

    public String getTableLeft() {
        return this.tableLeft;
    }

    public void setTableRight(String string) {
        if (string == null) {
            string = "";
        }
        this.tableRight = string;
    }

    public String getTableRight() {
        return this.tableRight;
    }

    public void setTableColSep(String string) {
        if (string == null) {
            string = "";
        }
        this.tableColSep = string;
    }

    public String getTableColSep() {
        return this.tableColSep;
    }

    public int tableRowSepLength(int n) {
        int n2 = 0;
        if (this.tableLeft != null) {
            n2 += this.tableLeft.length();
        }
        if (n > 0 && this.tableColSep != null) {
            n2 += (n - 1) * this.tableColSep.length();
        }
        if (this.tableRight != null) {
            n2 += this.tableRight.length();
        }
        return n2;
    }

    protected void validateTranslatorSettings() throws TranslatorInitializationException {
        if (this.getMediaWidth() < 1.0) {
            throw new TranslatorInitializationException(new MessageKey("WidthMustBeAtLeast"), "Width Must Be At Least 1.0", new Object[]{new Double(1.0)}, null, null);
        }
        if (this.getTableTop() == null || this.getTableRowSep() == null || this.getTableBottom() == null || this.getTableLeft() == null || this.getTableColSep() == null || this.getTableRight() == null) {
            throw new TranslatorInitializationException(new MessageKey("TextTranslatorRequiresTableSeparators"), "text translator requires all table separator strings to be set.", null, null, null);
        }
        String[] stringArray = this.getUlBullets();
        if (stringArray == null || stringArray.length == 0) {
            throw new TranslatorInitializationException(new MessageKey("TextTranslatorRequiresulBullets"), "text translator requires ulBullets to be set.", null, null, null);
        }
    }

    protected String encapsulateFragmentInDocument(String string) {
        if (this.isTextbodyDocument(string)) {
            return string;
        }
        return "<textbody>" + string + "</textbody>";
    }

    public void initializeFromConfig(ResourceBundle resourceBundle, String string) {
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8;
        super.initializeFromConfig(resourceBundle, string);
        if (string == null) {
            string = "";
        } else if (!string.endsWith(".")) {
            string = string + ".";
        }
        String string9 = this.getConfigString(resourceBundle, string + "mediaWidth", null);
        double d = 0.0;
        if (string9 != null) {
            d = Double.parseDouble(string9);
            this.setMediaWidth(d);
        }
        if ((string8 = this.getConfigString(resourceBundle, string + "mediaWidthUnit", null)) != null) {
            this.mediaWidthUnit = string8;
        }
        if ((string7 = this.stripQuotes(this.getConfigString(resourceBundle, string + "tableLeft", null))) != null) {
            this.tableLeft = string7;
        }
        if ((string6 = this.stripQuotes(this.getConfigString(resourceBundle, string + "tableRight", null))) != null) {
            this.tableRight = string6;
        }
        if ((string5 = this.stripQuotes(this.getConfigString(resourceBundle, string + "tableColSep", null))) != null) {
            this.tableColSep = string5;
        }
        if ((string4 = this.stripQuotes(this.getConfigString(resourceBundle, string + "tableTop", null))) != null) {
            this.tableTop = string4;
        }
        if ((string3 = this.stripQuotes(this.getConfigString(resourceBundle, string + "tableBottom", null))) != null) {
            this.tableBottom = string3;
        }
        if ((string2 = this.stripQuotes(this.getConfigString(resourceBundle, string + "tableRowSep", null))) != null) {
            this.tableRowSep = string2;
        }
        String string10 = this.getConfigString(resourceBundle, string + "ulBullets", null);
        this.setUlBullets(string10);
    }

    private String stripQuotes(String string) {
        if (string != null && string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

