/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.translator.cml;

import com.sun.eras.common.logging4.Logger;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;

public class CmlTextTranslatorContext
implements Cloneable {
    private static final Logger logger = Logger.getLogger((class$com$sun$eras$common$translator$cml$CmlTextTranslatorContext == null ? (class$com$sun$eras$common$translator$cml$CmlTextTranslatorContext = CmlTextTranslatorContext.class$("com.sun.eras.common.translator.cml.CmlTextTranslatorContext")) : class$com$sun$eras$common$translator$cml$CmlTextTranslatorContext).getName());
    private double mediaWidth = 0.0;
    private double currentMediaWidthPercentage = 100.0;
    private double currentMediaWidth = 0.0;
    private int ulNesting = 0;
    private int olNesting = 0;
    private String bullet = " * ";
    static /* synthetic */ Class class$com$sun$eras$common$translator$cml$CmlTextTranslatorContext;

    public CmlTextTranslatorContext(double d) {
        this.mediaWidth = d;
        this.currentMediaWidth = d;
    }

    public void setCurrentMediaWidthPercentage(double d) {
        if (d <= 0.0 || d > 100.0) {
            String string = MessageLocalizer.makeLMS(this, new MessageKey("WidthPercentageRange"), "width percentage must be between 0 and 100:  " + d, new Object[]{new Double(d)}, null);
            throw new IllegalArgumentException(string);
        }
        this.currentMediaWidthPercentage = d;
        this.computeCurrentMediaWidth();
    }

    public double getCurrentMediaWidthPercentage() {
        return this.currentMediaWidthPercentage;
    }

    private final void computeCurrentMediaWidth() {
        this.currentMediaWidth = this.mediaWidth * this.currentMediaWidthPercentage / 100.0;
    }

    public void setCurrentMediaWidth(double d) {
        if (d < 0.0) {
            String string = MessageLocalizer.makeLMS(this, new MessageKey("MustNotBeNegative"), "Must not be negative", null, null);
            throw new IllegalArgumentException(string);
        }
        this.currentMediaWidth = d;
        this.currentMediaWidthPercentage = 100.0 * this.currentMediaWidth / this.mediaWidth;
    }

    public double getCurrentMediaWidth() {
        return this.currentMediaWidth;
    }

    public void setUlNesting(int n) {
        this.ulNesting = n;
    }

    public void incUlNesting() {
        ++this.ulNesting;
    }

    public void decUlNesting() {
        --this.ulNesting;
    }

    public int getUlNesting() {
        return this.ulNesting;
    }

    public void setOlNesting(int n) {
        this.olNesting = n;
    }

    public void incOlNesting() {
        ++this.olNesting;
    }

    public void decOlNesting() {
        --this.olNesting;
    }

    public int getOlNesting() {
        return this.olNesting;
    }

    public void setBullet(String string) {
        if (string == null) {
            string = "";
        }
        this.bullet = string;
    }

    public String getBullet() {
        return this.bullet;
    }

    public CmlTextTranslatorContext cloneContext() {
        try {
            return (CmlTextTranslatorContext)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

