/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.translator.cml;

import com.sun.eras.common.logging4.Logger;
import com.sun.eras.common.translator.TranslationException;
import com.sun.eras.common.translator.cml.CmlTextTranslatorAccumulator;
import com.sun.eras.common.translator.cml.CmlTextTranslatorContext;
import com.sun.eras.common.translator.cml.CmlTextTranslatorSettings;
import com.sun.eras.common.translator.cml.IllFormedCmlException;
import com.sun.eras.common.translator.cml.LineWrapper;
import com.sun.eras.common.translator.cml.NodeTranslator;
import com.sun.eras.common.translator.cml.TranslatorAccumulator;
import com.sun.eras.common.translator.cml.TranslatorDispatcher;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class AbstractCmlTextNodeTranslator
implements NodeTranslator {
    private static final Logger logger = Logger.getLogger((class$com$sun$eras$common$translator$cml$AbstractCmlTextNodeTranslator == null ? (class$com$sun$eras$common$translator$cml$AbstractCmlTextNodeTranslator = AbstractCmlTextNodeTranslator.class$("com.sun.eras.common.translator.cml.AbstractCmlTextNodeTranslator")) : class$com$sun$eras$common$translator$cml$AbstractCmlTextNodeTranslator).getName());
    TranslatorDispatcher dispatcher;
    private static final String ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private NodeTranslator liTranslator = null;
    private NodeTranslator colTranslator = null;
    static String SPACES = "                                                                                    ";
    static /* synthetic */ Class class$com$sun$eras$common$translator$cml$AbstractCmlTextNodeTranslator;

    public AbstractCmlTextNodeTranslator(TranslatorDispatcher translatorDispatcher) {
        this.dispatcher = translatorDispatcher;
    }

    public abstract void translateNode(Node var1, TranslatorAccumulator var2) throws TranslationException;

    protected void translateCommentNode(Node node, TranslatorAccumulator translatorAccumulator) throws TranslationException {
    }

    protected void translateCDataNode(CDATASection cDATASection, TranslatorAccumulator translatorAccumulator) throws TranslationException {
        this.translateTextNode(cDATASection, translatorAccumulator);
    }

    protected void translateTextNode(Text text, TranslatorAccumulator translatorAccumulator) throws TranslationException {
        CmlTextTranslatorAccumulator cmlTextTranslatorAccumulator = (CmlTextTranslatorAccumulator)translatorAccumulator;
        LineWrapper lineWrapper = cmlTextTranslatorAccumulator.lw();
        CmlTextTranslatorContext cmlTextTranslatorContext = cmlTextTranslatorAccumulator.context();
        lineWrapper.lineWrap(text.getData(), (int)cmlTextTranslatorContext.getCurrentMediaWidth());
    }

    protected void translateTextbodyElement(Element element, TranslatorAccumulator translatorAccumulator) throws TranslationException {
        this.translateBlock(element, translatorAccumulator);
    }

    protected void translatePElement(Element element, TranslatorAccumulator translatorAccumulator) throws TranslationException {
        CmlTextTranslatorAccumulator cmlTextTranslatorAccumulator = (CmlTextTranslatorAccumulator)translatorAccumulator;
        LineWrapper lineWrapper = cmlTextTranslatorAccumulator.lw();
        lineWrapper.needNewline();
        lineWrapper.append("\n");
        this.translateBlock(element, translatorAccumulator);
        lineWrapper.needNewline();
        lineWrapper.append("\n");
    }

    protected void translateBlock(Element element, TranslatorAccumulator translatorAccumulator) throws TranslationException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Node node = nodeList.item(n);
            NodeTranslator nodeTranslator = this.dispatcher.getNodeTranslator(node);
            nodeTranslator.translateNode(node, translatorAccumulator);
            ++n;
        }
    }

    protected void translateBlockInPre(Element element, TranslatorAccumulator translatorAccumulator) throws TranslationException {
        NodeList nodeList = element.getChildNodes();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Object object;
            Node node = nodeList.item(n);
            if (node instanceof Text) {
                object = ((Text)node).getData();
                if (object == null) {
                    object = "";
                }
                CmlTextTranslatorAccumulator cmlTextTranslatorAccumulator = (CmlTextTranslatorAccumulator)translatorAccumulator;
                LineWrapper lineWrapper = cmlTextTranslatorAccumulator.lw();
                lineWrapper.append((String)object);
            } else {
                object = this.dispatcher.getNodeTranslator(node);
                object.translateNode(node, translatorAccumulator);
            }
            ++n;
        }
    }

    protected void translateBlockInCode(Element element, TranslatorAccumulator translatorAccumulator) throws TranslationException {
        this.translateBlockInPre(element, translatorAccumulator);
    }

    protected void translateAElement(Element element, TranslatorAccumulator translatorAccumulator) throws TranslationException {
        CmlTextTranslatorAccumulator cmlTextTranslatorAccumulator = (CmlTextTranslatorAccumulator)translatorAccumulator;
        LineWrapper lineWrapper = cmlTextTranslatorAccumulator.lw();
        CmlTextTranslatorContext cmlTextTranslatorContext = cmlTextTranslatorAccumulator.context();
        CmlTextTranslatorSettings cmlTextTranslatorSettings = cmlTextTranslatorAccumulator.settings();
        int n = (int)cmlTextTranslatorContext.getCurrentMediaWidth();
        String string = this.getFirstChildData(element);
        String string2 = cmlTextTranslatorSettings.getAnchorRootPath();
        String string3 = element.getAttribute("href");
        if (string3 != null && !string3.equals("")) {
            lineWrapper.lineWrap(string, n);
            lineWrapper.lineWrap(" (", n);
            lineWrapper.lineWrap(string3, n);
            lineWrapper.lineWrap(")", n);
        } else {
            if (string2 != null) {
                lineWrapper.lineWrap(string2, n);
                if (!string2.endsWith("/") && !string.startsWith("/")) {
                    lineWrapper.lineWrap("/", n);
                }
            }
            lineWrapper.lineWrap(string, n);
        }
    }

    protected void translatePreElement(Element element, TranslatorAccumulator translatorAccumulator) throws TranslationException {
        CmlTextTranslatorAccumulator cmlTextTranslatorAccumulator = (CmlTextTranslatorAccumulator)translatorAccumulator;
        LineWrapper lineWrapper = cmlTextTranslatorAccumulator.lw();
        lineWrapper.needNewline();
        lineWrapper.append("\n");
        this.translateBlockInPre(element, translatorAccumulator);
        lineWrapper.needNewline();
        lineWrapper.append("\n");
    }

    protected void translateCodeElement(Element element, TranslatorAccumulator translatorAccumulator) throws TranslationException {
        CmlTextTranslatorAccumulator cmlTextTranslatorAccumulator = (CmlTextTranslatorAccumulator)translatorAccumulator;
        LineWrapper lineWrapper = cmlTextTranslatorAccumulator.lw();
        this.translateBlockInCode(element, translatorAccumulator);
    }

    protected void translateBrElement(Element element, TranslatorAccumulator translatorAccumulator) throws TranslationException {
        CmlTextTranslatorAccumulator cmlTextTranslatorAccumulator = (CmlTextTranslatorAccumulator)translatorAccumulator;
        LineWrapper lineWrapper = cmlTextTranslatorAccumulator.lw();
        lineWrapper.append("\n");
    }

    public String makeOlBullet(CmlTextTranslatorSettings cmlTextTranslatorSettings, int n, int n2) {
        String string = "";
        switch (n2 % 3) {
            case 1: {
                char c = ALPHABET.charAt((n - 1) % ALPHABET.length());
                string = string + c;
                while (n > 26) {
                    string = string + c;
                    n -= 26;
                }
                string = " " + string + ". ";
                break;
            }
            case 2: {
                char c = ALPHABET.charAt((n - 1) % ALPHABET.length());
                string = string + c;
                while (n > 26) {
                    string = string + c;
                    n -= 26;
                }
                string = string.toLowerCase();
                string = " " + string + ". ";
                break;
            }
            default: {
                string = " " + n + ". ";
            }
        }
        return string;
    }

    protected void translateOlElement(Element element, TranslatorAccumulator translatorAccumulator) throws TranslationException {
        CmlTextTranslatorAccumulator cmlTextTranslatorAccumulator = (CmlTextTranslatorAccumulator)translatorAccumulator;
        CmlTextTranslatorContext cmlTextTranslatorContext = cmlTextTranslatorAccumulator.context();
        CmlTextTranslatorSettings cmlTextTranslatorSettings = cmlTextTranslatorAccumulator.settings();
        int n = cmlTextTranslatorContext.getOlNesting();
        String string = cmlTextTranslatorContext.getBullet();
        try {
            cmlTextTranslatorContext.incOlNesting();
            List list = this.getChildElements(element, "li");
            Iterator iterator = list.iterator();
            int n2 = 1;
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                String string2 = this.makeOlBullet(cmlTextTranslatorSettings, n2, n);
                cmlTextTranslatorContext.setBullet(string2);
                if (this.liTranslator == null) {
                    this.liTranslator = this.dispatcher.getNodeTranslator(element2);
                }
                this.liTranslator.translateNode(element2, translatorAccumulator);
                ++n2;
            }
            Object var14_13 = null;
            cmlTextTranslatorContext.setBullet(string);
            cmlTextTranslatorContext.setOlNesting(n);
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            cmlTextTranslatorContext.setBullet(string);
            cmlTextTranslatorContext.setOlNesting(n);
            throw throwable;
        }
    }

    public String makeUlBullet(CmlTextTranslatorSettings cmlTextTranslatorSettings, int n, int n2) {
        String[] stringArray = cmlTextTranslatorSettings.getUlBullets();
        return stringArray[n2 % stringArray.length];
    }

    protected void translateUlElement(Element element, TranslatorAccumulator translatorAccumulator) throws TranslationException {
        CmlTextTranslatorAccumulator cmlTextTranslatorAccumulator = (CmlTextTranslatorAccumulator)translatorAccumulator;
        LineWrapper lineWrapper = cmlTextTranslatorAccumulator.lw();
        CmlTextTranslatorContext cmlTextTranslatorContext = cmlTextTranslatorAccumulator.context();
        CmlTextTranslatorSettings cmlTextTranslatorSettings = cmlTextTranslatorAccumulator.settings();
        String string = cmlTextTranslatorContext.getBullet();
        int n = cmlTextTranslatorContext.getUlNesting();
        try {
            cmlTextTranslatorContext.incUlNesting();
            String string2 = this.makeUlBullet(cmlTextTranslatorSettings, 1, n);
            cmlTextTranslatorContext.setBullet(string2);
            List list = this.getChildElements(element, "li");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Element element2 = (Element)iterator.next();
                if (this.liTranslator == null) {
                    this.liTranslator = this.dispatcher.getNodeTranslator(element2);
                }
                this.liTranslator.translateNode(element2, translatorAccumulator);
            }
            Object var14_13 = null;
            cmlTextTranslatorContext.setBullet(string);
            cmlTextTranslatorContext.setUlNesting(n);
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            cmlTextTranslatorContext.setBullet(string);
            cmlTextTranslatorContext.setUlNesting(n);
            throw throwable;
        }
    }

    protected void translateLiElement(Element element, TranslatorAccumulator translatorAccumulator) throws TranslationException {
        CmlTextTranslatorAccumulator cmlTextTranslatorAccumulator = (CmlTextTranslatorAccumulator)translatorAccumulator;
        LineWrapper lineWrapper = cmlTextTranslatorAccumulator.lw();
        CmlTextTranslatorContext cmlTextTranslatorContext = cmlTextTranslatorAccumulator.context();
        CmlTextTranslatorSettings cmlTextTranslatorSettings = cmlTextTranslatorAccumulator.settings();
        String string = cmlTextTranslatorContext.getBullet();
        int n = string.length();
        CmlTextTranslatorContext cmlTextTranslatorContext2 = cmlTextTranslatorContext.cloneContext();
        double d = cmlTextTranslatorContext.getCurrentMediaWidth();
        cmlTextTranslatorContext2.setCurrentMediaWidth(d - (double)n);
        LineWrapper lineWrapper2 = new LineWrapper();
        CmlTextTranslatorAccumulator cmlTextTranslatorAccumulator2 = new CmlTextTranslatorAccumulator(lineWrapper2, cmlTextTranslatorSettings, cmlTextTranslatorContext2);
        this.translateBlock(element, cmlTextTranslatorAccumulator2);
        List list = lineWrapper2.getLines();
        String string2 = AbstractCmlTextNodeTranslator.getSpaces(n);
        lineWrapper.needNewline();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            lineWrapper.append(string);
            string = string2;
            lineWrapper.append((String)iterator.next());
            lineWrapper.needNewline();
        }
    }

    protected void translateTableElement(Element element, TranslatorAccumulator translatorAccumulator) throws TranslationException {
        CmlTextTranslatorAccumulator cmlTextTranslatorAccumulator = (CmlTextTranslatorAccumulator)translatorAccumulator;
        LineWrapper lineWrapper = cmlTextTranslatorAccumulator.lw();
        CmlTextTranslatorContext cmlTextTranslatorContext = cmlTextTranslatorAccumulator.context();
        CmlTextTranslatorSettings cmlTextTranslatorSettings = cmlTextTranslatorAccumulator.settings();
        int n = (int)cmlTextTranslatorContext.getCurrentMediaWidth();
        String string = cmlTextTranslatorSettings.getTableTop();
        String string2 = cmlTextTranslatorSettings.getTableRowSep();
        String string3 = cmlTextTranslatorSettings.getTableBottom();
        this.tableHoriz(lineWrapper, n, string);
        List list = this.getChildElements(element, "row");
        double[] dArray = this.computeColWidths(list, cmlTextTranslatorSettings, cmlTextTranslatorContext);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            this.translateRowElement(element2, translatorAccumulator, dArray);
            if (!iterator.hasNext()) continue;
            this.tableHoriz(lineWrapper, n, string2);
        }
        this.tableHoriz(lineWrapper, n, string3);
    }

    private void tableHoriz(LineWrapper lineWrapper, int n, String string) {
        lineWrapper.needNewline();
        if (string == null || string.length() == 0) {
            return;
        }
        int n2 = string.length();
        int n3 = 0;
        while (n3 + n2 <= n) {
            lineWrapper.append(string);
            n3 += n2;
        }
        if (n3 < n) {
            lineWrapper.append(string.substring(0, n - n3));
        }
        lineWrapper.append("\n");
    }

    protected List findWidthAttributes(List list) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            List list2 = this.getChildElements(element, "col");
            int n2 = -1;
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                String string;
                Element element2 = (Element)iterator2.next();
                if (n == ++n2) {
                    arrayList.add(null);
                    ++n;
                }
                if ((string = element2.getAttribute("width")) == null || string.trim().equals("")) continue;
                try {
                    Object object;
                    double d = Double.parseDouble(string);
                    if (d < 0.0 || d > 100.0) {
                        object = MessageLocalizer.makeLMS(this, new MessageKey("ColumnWidthOutOfRange"), "Column width out of range, ignored: \"" + string + "\"", new Object[]{string}, null);
                        logger.warning((String)object);
                        continue;
                    }
                    object = (Double)arrayList.get(n2);
                    if (object != null && !((Double)object < d)) continue;
                    arrayList.set(n2, new Double(d));
                }
                catch (NumberFormatException numberFormatException) {
                    String string2 = MessageLocalizer.makeLMS(this, new MessageKey("NumberFormatExceptionFromColumnWidth"), "NumberFormatException from column width \"" + string + "\" (ignored).", new Object[]{string}, null);
                    logger.warning(string2);
                }
            }
        }
        return arrayList;
    }

    protected double[] computeColWidths(List list, CmlTextTranslatorSettings cmlTextTranslatorSettings, CmlTextTranslatorContext cmlTextTranslatorContext) {
        List list2 = this.findWidthAttributes(list);
        int n = list2.size();
        double[] dArray = new double[n];
        if (n == 0) {
            return dArray;
        }
        double d = cmlTextTranslatorContext.getCurrentMediaWidth();
        double d2 = cmlTextTranslatorSettings.getTableLeft().length() + cmlTextTranslatorSettings.getTableRight().length() + (n - 1) * cmlTextTranslatorSettings.getTableColSep().length();
        double d3 = d - d2;
        int n2 = 0;
        int n3 = n - 1;
        int n4 = 0;
        while (n4 < n) {
            if (list2.get(n4) == null) {
                ++n2;
                n3 = n4;
            }
            ++n4;
        }
        double d4 = 0.0;
        double d5 = 0.0;
        int n5 = 0;
        while (n5 < n) {
            Double d6;
            if (n5 != n3 && (d6 = (Double)list2.get(n5)) != null) {
                if ((d4 += d6.doubleValue()) > 100.0) {
                    String string = MessageLocalizer.makeLMS(this, new MessageKey("TotalForColumnWidths"), "Total for column widths > 100%", null, null);
                    logger.warning(string);
                }
                dArray[n5] = Math.round(d3 * d6 / 100.0);
                d5 += dArray[n5];
            }
            ++n5;
        }
        double d7 = d3 - d5;
        int n6 = 0;
        while (n6 < n) {
            if (n6 != n3 && list2.get(n6) == null) {
                dArray[n6] = Math.round(d7 / (double)n2);
                d5 += dArray[n6];
            }
            ++n6;
        }
        dArray[n3] = d3 - d5;
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n7 = 0;
        while (n7 < dArray.length) {
            arrayList.add(new Double(dArray[n7]));
            ++n7;
        }
        return dArray;
    }

    protected void translateRowElement(Element element, TranslatorAccumulator translatorAccumulator) throws TranslationException {
        throw new IllFormedCmlException(new MessageKey("RowNotInsideTable"), "Row not immediately inside a table", null, null, null);
    }

    protected void translateRowElement(Element element, TranslatorAccumulator translatorAccumulator, double[] dArray) throws TranslationException {
        Object object;
        CmlTextTranslatorAccumulator cmlTextTranslatorAccumulator = (CmlTextTranslatorAccumulator)translatorAccumulator;
        LineWrapper lineWrapper = cmlTextTranslatorAccumulator.lw();
        CmlTextTranslatorContext cmlTextTranslatorContext = cmlTextTranslatorAccumulator.context();
        CmlTextTranslatorSettings cmlTextTranslatorSettings = cmlTextTranslatorAccumulator.settings();
        List list = this.getChildElements(element, "col");
        int n = dArray.length;
        String string = cmlTextTranslatorSettings.getTableLeft();
        String string2 = cmlTextTranslatorSettings.getTableRight();
        String string3 = cmlTextTranslatorSettings.getTableColSep();
        CmlTextTranslatorContext cmlTextTranslatorContext2 = cmlTextTranslatorContext.cloneContext();
        ArrayList arrayList = new ArrayList();
        int n2 = dArray.length;
        Iterator iterator = list.iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            object = new LineWrapper();
            CmlTextTranslatorAccumulator cmlTextTranslatorAccumulator2 = new CmlTextTranslatorAccumulator((LineWrapper)object, cmlTextTranslatorSettings, cmlTextTranslatorContext2);
            cmlTextTranslatorContext2.setCurrentMediaWidth(dArray[n3]);
            if (this.colTranslator == null) {
                this.colTranslator = this.dispatcher.getNodeTranslator(element2);
            }
            this.colTranslator.translateNode(element2, cmlTextTranslatorAccumulator2);
            arrayList.add(((LineWrapper)object).getLines().iterator());
            ++n3;
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            lineWrapper.append(string);
            object = arrayList.iterator();
            int n4 = 0;
            while (n4 < n) {
                int n5 = (int)dArray[n4];
                if (object.hasNext()) {
                    Iterator iterator2 = (Iterator)object.next();
                    int n6 = 0;
                    if (iterator2.hasNext()) {
                        String string4 = (String)iterator2.next();
                        boolean bl2 = bl = bl || iterator2.hasNext();
                        if (string4.endsWith("\n")) {
                            string4 = string4.substring(0, string4.length() - 1);
                        }
                        lineWrapper.append(string4);
                        n6 = string4.length();
                    }
                    this.appendSpaces(lineWrapper, n5 - n6);
                } else {
                    this.appendSpaces(lineWrapper, n5);
                }
                if (n4 < n - 1) {
                    lineWrapper.append(string3);
                }
                ++n4;
            }
            lineWrapper.append(string2).append("\n");
        }
    }

    protected void translateColElement(Element element, TranslatorAccumulator translatorAccumulator) throws TranslationException {
        this.translateBlock(element, translatorAccumulator);
    }

    private String getFirstChildData(Element element) throws TranslationException {
        Node node = element.getFirstChild();
        String string = null;
        RuntimeException runtimeException = null;
        try {
            string = node == null ? "" : ((CharacterData)node).getData();
        }
        catch (ClassCastException classCastException) {
            runtimeException = classCastException;
        }
        catch (DOMException dOMException) {
            runtimeException = dOMException;
        }
        if (runtimeException != null) {
            throw new TranslationException(new MessageKey("IllformedTagElement"), "Ill-formed <" + element.getTagName() + "> element: " + element + " " + runtimeException.getLocalizedMessage(), new Object[]{element.getTagName(), element, runtimeException.getLocalizedMessage()}, null, null);
        }
        return string;
    }

    private List getChildElements(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Element> arrayList = new ArrayList<Element>();
        int n = 0;
        int n2 = nodeList.getLength();
        while (n < n2) {
            Element element2;
            Node node = nodeList.item(n);
            if (node.getNodeType() == 1 && string.equals((element2 = (Element)node).getTagName())) {
                arrayList.add(element2);
            }
            ++n;
        }
        return arrayList;
    }

    private static String getSpaces(int n) {
        while (SPACES.length() < n) {
            SPACES = SPACES + SPACES;
        }
        return SPACES.substring(0, n);
    }

    private void appendSpaces(LineWrapper lineWrapper, int n) {
        if (n <= 0) {
            return;
        }
        lineWrapper.append(AbstractCmlTextNodeTranslator.getSpaces(n));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

