/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.logging4;

import com.sun.eras.common.logging4.Formatter;
import com.sun.eras.common.logging4.Frame;
import com.sun.eras.common.logging4.Handler;
import com.sun.eras.common.logging4.LogManager;
import com.sun.eras.common.logging4.LogRecord;
import com.sun.eras.common.logging4.Stack;
import java.util.Date;
import java.util.ResourceBundle;

public class XMLFormatter
extends Formatter {
    private LogManager manager = LogManager.getLogManager();

    private void a2(StringBuffer stringBuffer, int n) {
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
    }

    private void appendISO8601(StringBuffer stringBuffer, long l) {
        Date date = new Date(l);
        stringBuffer.append(date.getYear() + 1900);
        stringBuffer.append('-');
        this.a2(stringBuffer, date.getMonth() + 1);
        stringBuffer.append('-');
        this.a2(stringBuffer, date.getDate());
        stringBuffer.append('T');
        this.a2(stringBuffer, date.getHours());
        stringBuffer.append(':');
        this.a2(stringBuffer, date.getMinutes());
        stringBuffer.append(':');
        this.a2(stringBuffer, date.getSeconds());
    }

    private void escape(StringBuffer stringBuffer, String string) {
        if (string == null) {
            string = "<null>";
        }
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
    }

    public String format(LogRecord logRecord) {
        Object[] objectArray;
        StringBuffer stringBuffer;
        block12: {
            Object object;
            stringBuffer = new StringBuffer(500);
            stringBuffer.append("<record>\n");
            stringBuffer.append("  <date>");
            this.appendISO8601(stringBuffer, logRecord.getMillis());
            stringBuffer.append("</date>\n");
            stringBuffer.append("  <millis>");
            stringBuffer.append(logRecord.getMillis());
            stringBuffer.append("</millis>\n");
            stringBuffer.append("  <sequence>");
            stringBuffer.append(logRecord.getSequenceNumber());
            stringBuffer.append("</sequence>\n");
            String string = logRecord.getLoggerName();
            if (string != null) {
                stringBuffer.append("  <logger>");
                this.escape(stringBuffer, string);
                stringBuffer.append("</logger>\n");
            }
            stringBuffer.append("  <level>");
            this.escape(stringBuffer, logRecord.getLevel().toString());
            stringBuffer.append("</level>\n");
            if (logRecord.getSourceClassName() != null) {
                stringBuffer.append("  <class>");
                this.escape(stringBuffer, logRecord.getSourceClassName());
                stringBuffer.append("</class>\n");
            }
            if (logRecord.getSourceMethodName() != null) {
                stringBuffer.append("  <method>");
                this.escape(stringBuffer, logRecord.getSourceMethodName());
                stringBuffer.append("</method>\n");
            }
            stringBuffer.append("  <thread>");
            stringBuffer.append(logRecord.getThreadID());
            stringBuffer.append("</thread>\n");
            if (logRecord.getMessage() != null) {
                object = this.formatMessage(logRecord);
                stringBuffer.append("  <message>");
                this.escape(stringBuffer, (String)object);
                stringBuffer.append("</message>");
                stringBuffer.append("\n");
            }
            object = logRecord.getResourceBundle();
            try {
                if (object == null || ((ResourceBundle)object).getString(logRecord.getMessage()) == null) break block12;
                stringBuffer.append("  <key>");
                this.escape(stringBuffer, logRecord.getMessage());
                stringBuffer.append("</key>\n");
                stringBuffer.append("  <catalog>");
                this.escape(stringBuffer, logRecord.getResourceBundleName());
                stringBuffer.append("</catalog>\n");
                objectArray = logRecord.getParameters();
                int n = 0;
                while (n < objectArray.length) {
                    stringBuffer.append("  <param>");
                    try {
                        this.escape(stringBuffer, objectArray[n].toString());
                    }
                    catch (Exception exception) {
                        stringBuffer.append("???");
                    }
                    stringBuffer.append("</param>\n");
                    ++n;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (logRecord.getThrown() != null) {
            objectArray = logRecord.getThrown();
            stringBuffer.append("  <exception>\n");
            stringBuffer.append("    <message>");
            this.escape(stringBuffer, objectArray.toString());
            stringBuffer.append("</message>\n");
            Frame[] frameArray = new Stack((Throwable)objectArray).getFrames();
            int n = 0;
            while (n < frameArray.length) {
                Frame frame = frameArray[n];
                stringBuffer.append("    <frame>\n");
                stringBuffer.append("      <class>");
                this.escape(stringBuffer, frame.getClassName());
                stringBuffer.append("</class>\n");
                stringBuffer.append("      <method>");
                this.escape(stringBuffer, frame.getMethodName());
                stringBuffer.append("</method>\n");
                if (frame.getLineNumber() >= 0) {
                    stringBuffer.append("      <line>");
                    stringBuffer.append(frame.getLineNumber());
                    stringBuffer.append("</line>\n");
                }
                stringBuffer.append("    </frame>\n");
                ++n;
            }
            stringBuffer.append("  </exception>\n");
        }
        stringBuffer.append("</record>\n");
        return stringBuffer.toString();
    }

    public String getHead(Handler handler) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"");
        String string = handler.getEncoding();
        stringBuffer.append(" encoding=\"");
        stringBuffer.append(string);
        stringBuffer.append("\"");
        stringBuffer.append(" standalone=\"no\"?>\n");
        stringBuffer.append("<!DOCTYPE log SYSTEM \"logger.dtd\">\n");
        stringBuffer.append("<log>\n");
        return stringBuffer.toString();
    }

    public String getTail(Handler handler) {
        return "</log>\n";
    }
}

