/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.logging4;

import com.sun.eras.common.logging4.Formatter;
import com.sun.eras.common.logging4.Level;
import com.sun.eras.common.logging4.LogRecord;
import com.sun.eras.common.util.StringUtil;
import java.security.AccessController;
import java.text.SimpleDateFormat;
import java.util.Date;
import sun.security.action.GetPropertyAction;

public class SimpleOneLineFormatter
extends Formatter {
    private static final SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private String lineSeparator = AccessController.doPrivileged(new GetPropertyAction("line.separator"));

    protected String levelString(Level level) {
        String string = level.getLocalizedName();
        return string + ": ";
    }

    protected String sequenceString(String string) {
        int n = string.length();
        while (n < 4) {
            string = " " + string;
            ++n;
        }
        return string;
    }

    protected String locationString(LogRecord logRecord) {
        String string = null;
        String string2 = logRecord.getSourceClassName();
        String string3 = logRecord.getLoggerName();
        String string4 = logRecord.getSourceMethodName();
        StringBuffer stringBuffer = new StringBuffer();
        if (string2 == null && string3 != null) {
            string2 = string3 + " ";
        }
        if (string2 != null) {
            stringBuffer.append(string2.substring(string2.lastIndexOf(46) + 1));
        }
        if (string4 != null) {
            if (string2 != null) {
                stringBuffer.append(".");
            }
            stringBuffer.append(string4);
        }
        if (string != null) {
            int n = string.indexOf(58);
            if (n > 0) {
                string = string.substring(n + 1);
            }
            if (!string.equals("Compiled Code")) {
                stringBuffer.append(":").append(string);
            }
        }
        return stringBuffer.toString();
    }

    protected String formatLinePrefix(LogRecord logRecord) {
        String string = this.levelString(logRecord.getLevel());
        long l = logRecord.getSequenceNumber();
        String string2 = String.valueOf(l);
        String string3 = String.valueOf(logRecord.getThreadID());
        String string4 = df.format(new Date(logRecord.getMillis()));
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.lineSeparator);
        stringBuffer.append(string);
        stringBuffer.append(string4);
        stringBuffer.append(" ");
        stringBuffer.append(this.sequenceString(string2));
        stringBuffer.append(" ");
        stringBuffer.append(string3);
        stringBuffer.append(" ");
        stringBuffer.append(this.locationString(logRecord));
        stringBuffer.append(" ");
        return stringBuffer.toString();
    }

    public String format(LogRecord logRecord) {
        String string = this.formatLinePrefix(logRecord);
        String string2 = logRecord.getMessage();
        Throwable throwable = logRecord.getThrown();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\n');
        stringBuffer.append(string2);
        if (throwable != null) {
            if (!string2.endsWith("\n")) {
                stringBuffer.append('\n');
            }
            stringBuffer.append("Exception: ");
            stringBuffer.append(StringUtil.getStackTraceAsString(throwable));
        }
        String string3 = stringBuffer.toString();
        int n = string3.length();
        if (string3.endsWith("\n")) {
            stringBuffer.setLength(--n);
        }
        while ((n = string3.lastIndexOf(10, n - 1)) >= 0) {
            stringBuffer.replace(n, n + 1, string);
        }
        stringBuffer.append(this.lineSeparator);
        return stringBuffer.toString();
    }
}

