/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.logging4;

import com.sun.eras.common.logging4.Level;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class LogRecord
implements Serializable {
    private static long globalSequenceNumber;
    private static int nextThreadId;
    private static ThreadLocal threadIds;
    private Level level;
    private long sequenceNumber;
    private String sourceClassName;
    private String sourceMethodName;
    private String message;
    private int threadID;
    private long millis;
    private Throwable thrown;
    private String loggerName;
    private String resourceBundleName;
    private transient boolean needToInferCaller;
    private transient Object[] parameters;
    private transient ResourceBundle resourceBundle;
    static /* synthetic */ Class class$com$sun$eras$common$logging4$LogRecord;

    public LogRecord(Level level, String string) {
        level.getClass();
        this.level = level;
        this.message = string;
        Class clazz = class$com$sun$eras$common$logging4$LogRecord == null ? (class$com$sun$eras$common$logging4$LogRecord = LogRecord.class$("com.sun.eras.common.logging4.LogRecord")) : class$com$sun$eras$common$logging4$LogRecord;
        synchronized (clazz) {
            this.sequenceNumber = globalSequenceNumber++;
            Integer n = (Integer)threadIds.get();
            if (n == null) {
                n = new Integer(nextThreadId++);
                threadIds.set(n);
            }
            this.threadID = n;
        }
        this.millis = System.currentTimeMillis();
        this.needToInferCaller = true;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String string) {
        this.loggerName = string;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String string) {
        this.resourceBundleName = string;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level == null) {
            throw new NullPointerException();
        }
        this.level = level;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long l) {
        this.sequenceNumber = l;
    }

    public String getSourceClassName() {
        if (this.needToInferCaller) {
            this.inferCaller();
        }
        return this.sourceClassName;
    }

    public void setSourceClassName(String string) {
        this.sourceClassName = string;
        this.needToInferCaller = false;
    }

    public String getSourceMethodName() {
        if (this.needToInferCaller) {
            this.inferCaller();
        }
        return this.sourceMethodName;
    }

    public void setSourceMethodName(String string) {
        this.sourceMethodName = string;
        this.needToInferCaller = false;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] objectArray) {
        this.parameters = objectArray;
    }

    public int getThreadID() {
        return this.threadID;
    }

    public void setThreadID(int n) {
        this.threadID = n;
    }

    public long getMillis() {
        return this.millis;
    }

    public void setMillis(long l) {
        this.millis = l;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public void setThrown(Throwable throwable) {
        this.thrown = throwable;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeByte(1);
        objectOutputStream.writeByte(0);
        if (this.parameters == null) {
            objectOutputStream.writeInt(-1);
            return;
        }
        objectOutputStream.writeInt(this.parameters.length);
        int n = 0;
        while (n < this.parameters.length) {
            if (this.parameters[n] == null) {
                objectOutputStream.writeObject(null);
            } else {
                objectOutputStream.writeObject(this.parameters[n].toString());
            }
            ++n;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte by = objectInputStream.readByte();
        byte by2 = objectInputStream.readByte();
        if (by != 1) {
            String string = MessageLocalizer.makeLMS(this, new MessageKey("LogRecordbadversion"), "LogRecord: bad version: " + by + "." + by2, new Object[]{new Byte(by), new Byte(by2)}, null);
            throw new IOException(string);
        }
        int n = objectInputStream.readInt();
        if (n == -1) {
            this.parameters = null;
        } else {
            this.parameters = new Object[n];
            int n2 = 0;
            while (n2 < this.parameters.length) {
                this.parameters[n2] = objectInputStream.readObject();
                ++n2;
            }
        }
        if (this.resourceBundleName != null) {
            try {
                this.resourceBundle = ResourceBundle.getBundle(this.resourceBundleName);
            }
            catch (MissingResourceException missingResourceException) {
                this.resourceBundle = null;
            }
        }
        this.needToInferCaller = false;
    }

    private void inferCaller() {
        this.needToInferCaller = false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        nextThreadId = 10;
        threadIds = new ThreadLocal();
    }
}

