/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.kaeresult;

import com.sun.eras.common.checks.CheckSeverity;
import com.sun.eras.common.kaeresult.BeanToXml;
import com.sun.eras.common.kaeresult.CheckResults;
import com.sun.eras.common.kaeresult.KAEResultConversionException;
import com.sun.eras.common.kaeresult.RunSummary;
import com.sun.eras.common.logging4.Logger;
import com.sun.eras.common.util.LocalizedString;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class RunSummaryBean
implements RunSummary,
Cloneable,
Serializable,
BeanToXml {
    static final long serialVersionUID = 1184615466688213122L;
    private static Logger logger = Logger.getLogger((class$com$sun$eras$common$kaeresult$RunSummaryBean == null ? (class$com$sun$eras$common$kaeresult$RunSummaryBean = RunSummaryBean.class$("com.sun.eras.common.kaeresult.RunSummaryBean")) : class$com$sun$eras$common$kaeresult$RunSummaryBean).getName());
    private int totalCount = 0;
    private int errorCount = 0;
    private int notApplicableCount = 0;
    private int passedCount = 0;
    private int lowCount = 0;
    private int moderateCount = 0;
    private int highCount = 0;
    private int criticalCount = 0;
    private int erroneousSeverityCount = 0;
    static /* synthetic */ Class class$com$sun$eras$common$kaeresult$RunSummaryBean;
    static /* synthetic */ Class class$com$sun$eras$common$kaeresult$KAEResultConversionException;

    void setTotalCount(int n) {
        this.totalCount = n;
    }

    void setErrorCount(int n) {
        this.errorCount = n;
    }

    void setNotApplicableCount(int n) {
        this.notApplicableCount = n;
    }

    void setPassedCount(int n) {
        this.passedCount = n;
    }

    void setLowCount(int n) {
        this.lowCount = n;
    }

    void setModerateCount(int n) {
        this.moderateCount = n;
    }

    void setHighCount(int n) {
        this.highCount = n;
    }

    void setCriticalCount(int n) {
        this.criticalCount = n;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public int getNotApplicableCount() {
        return this.notApplicableCount;
    }

    public int getPassedCount() {
        return this.passedCount;
    }

    public int getLowCount() {
        return this.lowCount;
    }

    public int getModerateCount() {
        return this.moderateCount;
    }

    public int getHighCount() {
        return this.highCount;
    }

    public int getCriticalCount() {
        return this.criticalCount;
    }

    public int getErroneousSeverityCount() {
        return this.erroneousSeverityCount;
    }

    public void clear() {
        this.totalCount = 0;
        this.errorCount = 0;
        this.notApplicableCount = 0;
        this.passedCount = 0;
        this.lowCount = 0;
        this.moderateCount = 0;
        this.highCount = 0;
        this.criticalCount = 0;
        this.erroneousSeverityCount = 0;
    }

    public void updateCounts(CheckResults checkResults) {
        RunSummaryBean runSummaryBean = this;
        synchronized (runSummaryBean) {
            ++this.totalCount;
            if (checkResults.isErrored()) {
                ++this.errorCount;
            } else if (!checkResults.isApplicable()) {
                ++this.notApplicableCount;
            } else if (checkResults.isConditionPasses()) {
                ++this.passedCount;
            } else {
                CheckSeverity checkSeverity = checkResults.getSeverity();
                if (CheckSeverity.LOW.equals(checkSeverity)) {
                    ++this.lowCount;
                } else if (CheckSeverity.MODERATE.equals(checkSeverity)) {
                    ++this.moderateCount;
                } else if (CheckSeverity.HIGH.equals(checkSeverity)) {
                    ++this.highCount;
                } else if (CheckSeverity.CRITICAL.equals(checkSeverity)) {
                    ++this.criticalCount;
                } else {
                    String string = MessageLocalizer.makeLMS(this, new MessageKey("forCheckResultidunknownseverity"), "for CheckResult id=" + checkResults.getCheckId() + ", unknown severity " + checkSeverity, new Object[]{checkResults.getCheckId(), checkSeverity}, null);
                    logger.warning(string);
                    ++this.erroneousSeverityCount;
                }
            }
        }
    }

    public RunSummaryBean cloneSummary() {
        try {
            return (RunSummaryBean)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("RunSummaryBean[");
        stringBuffer.append("total=").append(this.totalCount).append(", ");
        stringBuffer.append("error=").append(this.errorCount).append(", ");
        stringBuffer.append("notApplicable=").append(this.notApplicableCount).append(", ");
        stringBuffer.append("passed=").append(this.passedCount).append(", ");
        stringBuffer.append("low=").append(this.lowCount).append(", ");
        stringBuffer.append("moderate=").append(this.moderateCount).append(", ");
        stringBuffer.append("high=").append(this.highCount).append(", ");
        stringBuffer.append("critical=").append(this.criticalCount);
        if (this.erroneousSeverityCount != 0) {
            stringBuffer.append(", ").append("erroneousSeverity=").append(this.erroneousSeverityCount);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String toXML() throws KAEResultConversionException {
        return this.toXML(new StringBuffer(128)).toString();
    }

    public StringBuffer toXML(StringBuffer stringBuffer) throws KAEResultConversionException {
        this.toXML("", stringBuffer);
        return stringBuffer;
    }

    public boolean toXML(OutputStream outputStream) throws KAEResultConversionException {
        try {
            outputStream.write(this.toXML().getBytes("UTF-8"));
            return true;
        }
        catch (IOException iOException) {
            logger.throwing(this.getClass().getName(), "toXML(OutputStream) failed", iOException);
            LocalizedString localizedString = MessageLocalizer.makeLS(class$com$sun$eras$common$kaeresult$KAEResultConversionException == null ? (class$com$sun$eras$common$kaeresult$KAEResultConversionException = RunSummaryBean.class$("com.sun.eras.common.kaeresult.KAEResultConversionException")) : class$com$sun$eras$common$kaeresult$KAEResultConversionException, KAEResultConversionException.TOXMLOUTPUTSTREAMFAILED, "toXML(OutputStream) failed", null, null);
            throw new KAEResultConversionException(localizedString, (Throwable)iOException);
        }
    }

    public StringBuffer toXML(String string, StringBuffer stringBuffer) throws KAEResultConversionException {
        if (stringBuffer == null) {
            LocalizedString localizedString = MessageLocalizer.makeLS(class$com$sun$eras$common$kaeresult$KAEResultConversionException == null ? (class$com$sun$eras$common$kaeresult$KAEResultConversionException = RunSummaryBean.class$("com.sun.eras.common.kaeresult.KAEResultConversionException")) : class$com$sun$eras$common$kaeresult$KAEResultConversionException, KAEResultConversionException.NULLSTRINGBUFFER, "null StringBuffer", null, null);
            KAEResultConversionException kAEResultConversionException = new KAEResultConversionException(localizedString);
            logger.throwing(this.getClass().getName(), "toXML(String, StringBuffer)", kAEResultConversionException);
            throw kAEResultConversionException;
        }
        stringBuffer.append(string + "<run_summary>\n");
        stringBuffer.append(string + "\t" + "<critical>" + this.criticalCount + "</critical>\n");
        stringBuffer.append(string + "\t" + "<high>" + this.highCount + "</high>\n");
        stringBuffer.append(string + "\t" + "<moderate>" + this.moderateCount + "</moderate>\n");
        stringBuffer.append(string + "\t" + "<low>" + this.lowCount + "</low>\n");
        stringBuffer.append(string + "\t" + "<passed>" + this.passedCount + "</passed>\n");
        stringBuffer.append(string + "\t" + "<notapplicable>" + this.notApplicableCount + "</notapplicable>\n");
        stringBuffer.append(string + "\t" + "<erroneous>" + this.errorCount + "</erroneous>\n");
        stringBuffer.append(string + "\t" + "<total>" + this.totalCount + "</total>\n");
        stringBuffer.append(string + "</run_summary>\n");
        return stringBuffer;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

