/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.kaeresult;

import com.sun.eras.common.checks.CheckSeverity;
import com.sun.eras.common.cml.CmlImpl;
import com.sun.eras.common.kae.DataCollectorDescriptorBean;
import com.sun.eras.common.kae.EngineVersionBean;
import com.sun.eras.common.kaeresult.AddressBean;
import com.sun.eras.common.kaeresult.CheckResultsBean;
import com.sun.eras.common.kaeresult.ContactBean;
import com.sun.eras.common.kaeresult.CustomerInfoBean;
import com.sun.eras.common.kaeresult.DateBean;
import com.sun.eras.common.kaeresult.FieldEngInfoBean;
import com.sun.eras.common.kaeresult.GeneralInfoBean;
import com.sun.eras.common.kaeresult.GeneratedByInfoBean;
import com.sun.eras.common.kaeresult.KAEResultBean;
import com.sun.eras.common.kaeresult.PartnerInfoBean;
import com.sun.eras.common.kaeresult.ProductInfoBean;
import com.sun.eras.common.kaeresult.RunInfoBean;
import com.sun.eras.common.kaeresult.RunResultBean;
import com.sun.eras.common.kaeresult.RunSummaryBean;
import com.sun.eras.common.kaeresult.RunSystemInfoBean;
import com.sun.eras.common.logging4.Logger;
import com.sun.eras.common.util.DateUtil;
import com.sun.eras.common.util.EntityResolverHelper;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class KAEXMLResultReader
extends DefaultHandler {
    private static Logger logger = Logger.getLogger((class$com$sun$eras$common$kaeresult$KAEXMLResultReader == null ? (class$com$sun$eras$common$kaeresult$KAEXMLResultReader = KAEXMLResultReader.class$("com.sun.eras.common.kaeresult.KAEXMLResultReader")) : class$com$sun$eras$common$kaeresult$KAEXMLResultReader).getName());
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    public boolean debug = false;
    public boolean validate = true;
    private ProductInfoBean prdib = null;
    private KAEResultBean kaerb = null;
    private GeneralInfoBean gib = null;
    private GeneratedByInfoBean gbib = null;
    private CustomerInfoBean cib = null;
    private FieldEngInfoBean feib = null;
    private PartnerInfoBean pib = null;
    private AddressBean ab = null;
    private ContactBean cb = null;
    private RunResultBean rrb = null;
    private RunInfoBean rib = null;
    private RunSystemInfoBean rsib = null;
    private RunSummaryBean rsb = null;
    private CheckResultsBean crb = null;
    private String checkId = null;
    private int checkRevisionNumber = -1;
    private String curElement = null;
    private String lastChars = null;
    private StringBuffer streetAddress = null;
    private EntityResolverHelper entityHelper = new EntityResolverHelper();
    static /* synthetic */ Class class$com$sun$eras$common$kaeresult$KAEXMLResultReader;

    private void log(String string) {
        if (this.debug) {
            logger.fine(string);
        }
    }

    private void log(String string, SAXParseException sAXParseException) {
        this.log(string + ": line=" + sAXParseException.getLineNumber() + ", col=" + sAXParseException.getColumnNumber() + ", pubId=" + sAXParseException.getPublicId() + ", uri=" + sAXParseException.getSystemId() + "\nmsg=" + sAXParseException.getMessage());
    }

    private void log(String string, Locator locator) {
        this.log(string + ": line=" + locator.getLineNumber() + ", col=" + locator.getColumnNumber() + ", pubId=" + locator.getPublicId() + ", uri=" + locator.getSystemId());
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        try {
            InputSource inputSource = this.entityHelper.resolveEntity(string, string2);
            return inputSource;
        }
        catch (IOException iOException) {
            String string3 = MessageLocalizer.makeLMS(this, new MessageKey("ioexception"), "io exception", null, null);
            throw new SAXException(string3, iOException);
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.log("warning", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.log("error", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.log("fatalError", sAXParseException);
        throw sAXParseException;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this.lastChars = this.lastChars == null ? string : this.lastChars + string;
        this.log("characters: |" + string + "|");
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        this.log("ignorableWhitespace: |" + string + "|");
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.lastChars = null;
        String string4 = "startElement :: uri=" + string + ", localName=" + string2 + ", qName=" + string3;
        int n = 0;
        int n2 = attributes.getLength();
        while (n < n2) {
            string4 = string4 + "\n" + n + ". LocalName=" + attributes.getLocalName(n) + ", Type=" + attributes.getType(n) + ", Value=" + attributes.getValue(n) + ", URI=" + attributes.getURI(n);
            ++n;
        }
        this.log(string4);
        String string5 = this.curElement = string3.trim();
        if (string5.equals("kaeresult")) {
            this.kaerb = new KAEResultBean();
        } else if (this.kaerb != null && string5.equals("general_info")) {
            this.gib = new GeneralInfoBean();
        } else if (this.kaerb != null && string5.equals("generatedBy")) {
            this.gbib = new GeneratedByInfoBean();
        } else if (this.kaerb != null && string5.equals("customer_info")) {
            this.cib = new CustomerInfoBean();
        } else if (this.kaerb != null && string5.equals("partner_info")) {
            this.pib = new PartnerInfoBean();
        } else if (this.kaerb != null && string5.equals("field_eng_info")) {
            this.feib = new FieldEngInfoBean();
            int n3 = 0;
            int n4 = attributes.getLength();
            while (n3 < n4) {
                String string6 = attributes.getLocalName(n3);
                String string7 = attributes.getValue(n3);
                if (string6.equals("employee_of")) {
                    this.feib.setEmployeeOf(string7);
                }
                ++n3;
            }
        } else if (this.kaerb != null && string5.equals("contact")) {
            this.cb = new ContactBean();
        } else if (this.kaerb != null && string5.equals("address")) {
            this.ab = new AddressBean();
            int n5 = 0;
            int n6 = attributes.getLength();
            while (n5 < n6) {
                String string8 = attributes.getLocalName(n5);
                String string9 = attributes.getValue(n5);
                if (string8.equals("type")) {
                    this.ab.setType(string9);
                } else if (string8.equals("name")) {
                    this.ab.setName(string9);
                }
                ++n5;
            }
        } else if (this.kaerb != null && string5.equals("runresult")) {
            this.rrb = new RunResultBean();
            int n7 = 0;
            int n8 = attributes.getLength();
            while (n7 < n8) {
                String string10 = attributes.getLocalName(n7);
                String string11 = attributes.getValue(n7);
                if (string10.equals("type")) {
                    this.rrb.setType(string11);
                }
                ++n7;
            }
        } else if (this.kaerb != null && this.rrb != null && string5.equals("run_info")) {
            this.rib = new RunInfoBean();
            int n9 = 0;
            int n10 = attributes.getLength();
            while (n9 < n10) {
                String string12 = attributes.getLocalName(n9);
                String string13 = attributes.getValue(n9);
                if (string12.equals("id")) {
                    this.rib.setRunInfoId(string13);
                }
                ++n9;
            }
        } else if (this.kaerb != null && this.rrb != null && this.rib != null && string5.equals("run_summary")) {
            this.rsb = new RunSummaryBean();
        } else if (this.kaerb != null && this.rrb != null && this.rib != null && string5.equals("run_system_info")) {
            this.rsib = new RunSystemInfoBean();
            int n11 = 0;
            int n12 = attributes.getLength();
            while (n11 < n12) {
                String string14 = attributes.getLocalName(n11);
                String string15 = attributes.getValue(n11);
                if (string14.equals("type")) {
                    this.rsib.setType(string15);
                }
                ++n11;
            }
        } else if (this.kaerb != null && this.rrb != null && this.rib != null && string5.equals("checkresult")) {
            this.crb = new CheckResultsBean();
            int n13 = 0;
            int n14 = attributes.getLength();
            while (n13 < n14) {
                String string16 = attributes.getLocalName(n13);
                String string17 = attributes.getValue(n13);
                if (string16.equals("status")) {
                    this.crb.setStatus(string17);
                } else if (string16.equals("severity")) {
                    this.crb.setSeverity(CheckSeverity.getInstance(string17));
                }
                ++n13;
            }
            this.crb.setProducts(new ArrayList());
            this.crb.setProductCategories(new ArrayList());
        } else if (this.kaerb != null && this.rrb != null && this.rib != null && this.crb != null && string5.equals("product")) {
            this.prdib = new ProductInfoBean();
            this.crb.getProducts().add(this.prdib);
        } else if (this.ab == null || string5.equals("street_address")) {
            // empty if block
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Object object;
        this.log("endElement :: uri=" + string + ", localName=" + string2 + ", qName=" + string3);
        String string4 = this.curElement = string3.trim();
        if (this.gbib != null) {
            if (string4.equals("generatedBy")) {
                object = this.lastChars;
                if (object != null && ((String)(object = ((String)object).trim())).length() > 0) {
                    int n = ((String)object).indexOf("-");
                    if (n < 0) {
                        n = ((String)object).length();
                    }
                    String string5 = ((String)object).substring(0, n).trim();
                    int n2 = n + 1;
                    if (string5.length() > 0 && this.gbib.getAppName() == null) {
                        this.gbib.setAppName(string5);
                    }
                    if (n2 < ((String)object).length()) {
                        String string6;
                        String string7;
                        n = ((String)object).indexOf("-", n2);
                        if (n < 0) {
                            n = ((String)object).length();
                        }
                        if ((string7 = ((String)object).substring(n2, n).trim()).length() > 0 && this.gbib.getAppVersion() == null) {
                            this.gbib.setAppVersion(string5);
                        }
                        if (n < ((String)object).length() && (string6 = ((String)object).substring(n + 1).trim()).length() > 0 && this.gbib.getAppDistributionChannel() == null) {
                            this.gbib.setAppDistributionChannel(string6);
                        }
                    }
                }
                this.kaerb.setGeneratedByInfo(this.gbib);
                this.gbib = null;
            } else {
                this.constructGeneratedBy(string4);
            }
        }
        if (this.gib != null) {
            if (string4.equals("general_info")) {
                this.kaerb.setGeneralInfo(this.gib);
                this.gib = null;
            } else {
                this.constructGeneralInfo(string4);
            }
        }
        if (this.cib != null) {
            if (string4.equals("customer_info")) {
                this.kaerb.setCustomerInfo(this.cib);
                this.cib = null;
            } else {
                this.constructCustomerInfo(string4);
            }
        }
        if (this.pib != null) {
            if (string4.equals("partner_info")) {
                this.kaerb.setPartnerInfo(this.pib);
                this.cib = null;
            } else {
                this.constructPartnerInfo(string4);
            }
        }
        if (this.feib != null) {
            if (string4.equals("field_eng_info")) {
                this.kaerb.setFieldEngInfo(this.feib);
                this.feib = null;
            } else {
                this.constructFieldEngInfo(string4);
            }
        }
        if (this.cb != null) {
            if (string4.equals("contact")) {
                if (this.feib != null) {
                    this.feib.setContact(this.cb);
                }
                this.cb = null;
            } else {
                this.constructContactInfo(string4);
            }
        }
        if (this.ab != null) {
            if (string4.equals("address")) {
                this.ab.setStreetAddress(this.streetAddress.toString());
                if (this.cb != null) {
                    this.cb.setAddress(this.ab);
                } else if (this.cib != null) {
                    this.cib.setAddress(this.ab);
                } else if (this.pib != null) {
                    this.pib.setAddress(this.ab);
                }
                this.streetAddress.setLength(0);
                this.ab = null;
            } else {
                this.constructAddress(string4);
            }
        }
        if (this.prdib != null) {
            if (string4.equals("product")) {
                this.prdib = null;
            } else {
                this.constructProductInfo(string4);
            }
        } else if (string4.equals("product_category")) {
            this.crb.getProductCategories().add(this.lastChars);
        }
        if (this.rrb != null && this.rib != null) {
            if (string4.equals("run_info")) {
                object = this.rrb.getRunInfo();
                object.add(this.rib);
                this.rib = null;
            } else {
                this.constructRunInfo(string4);
            }
        } else if (this.kaerb != null && this.rrb != null) {
            if (string4.equals("runresult")) {
                object = this.kaerb.getRunResults();
                object.add(this.rrb);
                this.rrb = null;
            } else {
                this.constructRunResult(string4);
            }
        }
    }

    private void constructGeneratedBy(String string) {
        GeneratedByInfoBean generatedByInfoBean = this.gbib;
        if (generatedByInfoBean == null) {
            return;
        }
        if (string.equals("app_name")) {
            generatedByInfoBean.setAppName(this.lastChars);
        } else if (string.equals("app_version")) {
            generatedByInfoBean.setAppVersion(this.lastChars);
        } else if (string.equals("app_distribution_channel")) {
            generatedByInfoBean.setAppDistributionChannel(this.lastChars);
        }
        this.lastChars = null;
    }

    private void constructGeneralInfo(String string) {
        GeneralInfoBean generalInfoBean = this.gib;
        if (generalInfoBean == null) {
            return;
        }
        if (string.equals("id")) {
            generalInfoBean.setReportId(this.lastChars);
        } else if (string.equals("date")) {
            Date date = DateUtil.getDateFromString(this.lastChars, "yyyy.MM.dd.kk.mm.ss");
            DateBean dateBean = new DateBean(date);
            generalInfoBean.setReportDate(dateBean);
        }
    }

    private void constructAddress(String string) {
        AddressBean addressBean = this.ab;
        if (addressBean == null) {
            return;
        }
        if (string.equals("street_address")) {
            if (this.streetAddress == null) {
                this.streetAddress = new StringBuffer();
            }
            if (this.streetAddress.length() == 0) {
                this.streetAddress.append(this.lastChars);
            } else {
                this.streetAddress.append("\n");
                this.streetAddress.append(this.lastChars);
            }
        } else if (string.equals("city")) {
            addressBean.setCity(this.lastChars);
        } else if (string.equals("state")) {
            addressBean.setState(this.lastChars);
        } else if (string.equals("zip")) {
            addressBean.setZip(this.lastChars);
        } else if (string.equals("country")) {
            addressBean.setCountry(this.lastChars);
        }
    }

    private void constructCustomerInfo(String string) {
        CustomerInfoBean customerInfoBean = this.cib;
        if (customerInfoBean == null) {
            return;
        }
        if (string.equals("company_name")) {
            customerInfoBean.setCompanyName(this.lastChars);
        }
    }

    private void constructContactInfo(String string) {
        ContactBean contactBean = this.cb;
        if (contactBean == null) {
            return;
        }
        if (string.equals("email")) {
            contactBean.setEmail(this.lastChars);
        } else if (string.equals("phone")) {
            contactBean.setPhone(this.lastChars);
        } else if (string.equals("fax")) {
            contactBean.setFax(this.lastChars);
        }
    }

    private void constructPartnerInfo(String string) {
        PartnerInfoBean partnerInfoBean = this.pib;
        if (partnerInfoBean == null) {
            return;
        }
        if (string.equals("company_name")) {
            partnerInfoBean.setCompanyName(this.lastChars);
        }
        if (string.equals("smi_contract_id")) {
            partnerInfoBean.setSMIContractId(this.lastChars);
        }
    }

    private void constructFieldEngInfo(String string) {
        FieldEngInfoBean fieldEngInfoBean = this.feib;
        if (fieldEngInfoBean == null) {
            return;
        }
        if (string.equals("first_name")) {
            fieldEngInfoBean.setFirstName(this.lastChars);
        }
        if (string.equals("last_name")) {
            fieldEngInfoBean.setLastName(this.lastChars);
        }
        if (string.equals("employee_id")) {
            fieldEngInfoBean.setEmployeeId(this.lastChars);
        }
    }

    private void constructProductInfo(String string) {
        ProductInfoBean productInfoBean = this.prdib;
        if (productInfoBean == null) {
            return;
        }
        if (string.equals("product_category")) {
            productInfoBean.setProductCategory(this.lastChars);
        } else if (string.equals("product_name")) {
            productInfoBean.setProductName(this.lastChars);
        } else if (string.equals("product_id")) {
            productInfoBean.setProductId(this.lastChars);
        } else if (string.equals("product_desc")) {
            productInfoBean.setProductDesc(this.lastChars);
        }
    }

    private void constructRunResult(String string) {
        RunResultBean runResultBean = this.rrb;
        if (runResultBean == null) {
            return;
        }
        if (string.equals("date")) {
            Date date = DateUtil.getDateFromString(this.lastChars, "yyyy.MM.dd.kk.mm.ss");
            DateBean dateBean = new DateBean(date);
            runResultBean.setResultDate(dateBean);
        } else if (string.equals("kae_version")) {
            EngineVersionBean engineVersionBean = new EngineVersionBean(this.lastChars);
            runResultBean.setKAEVersion(engineVersionBean);
        }
    }

    private void constructRunInfo(String string) {
        RunInfoBean runInfoBean = this.rib;
        if (runInfoBean == null) {
            return;
        }
        if (string.equals("explorerFile")) {
            DataCollectorDescriptorBean dataCollectorDescriptorBean = new DataCollectorDescriptorBean(this.lastChars);
            runInfoBean.setDataCollectorDescriptor(dataCollectorDescriptorBean);
        } else if (this.rsb != null) {
            if (string.equals("critical")) {
                this.rsb.setCriticalCount(Integer.parseInt(this.lastChars));
            } else if (string.equals("high")) {
                this.rsb.setHighCount(Integer.parseInt(this.lastChars));
            } else if (string.equals("moderate")) {
                this.rsb.setModerateCount(Integer.parseInt(this.lastChars));
            } else if (string.equals("low")) {
                this.rsb.setLowCount(Integer.parseInt(this.lastChars));
            } else if (string.equals("passed")) {
                this.rsb.setPassedCount(Integer.parseInt(this.lastChars));
            } else if (string.equals("notapplicable")) {
                this.rsb.setNotApplicableCount(Integer.parseInt(this.lastChars));
            } else if (string.equals("erroneous")) {
                this.rsb.setErrorCount(Integer.parseInt(this.lastChars));
            } else if (string.equals("total")) {
                this.rsb.setTotalCount(Integer.parseInt(this.lastChars));
            } else if (string.equals("run_summary")) {
                runInfoBean.setSummary(this.rsb);
                this.rsb = null;
            }
        } else if (this.rsib != null) {
            if (string.equals("hostid")) {
                this.rsib.setHostId(this.lastChars);
            } else if (string.equals("serial_number")) {
                this.rsib.setHostSerialNumber(this.lastChars);
            } else if (string.equals("product_type")) {
                this.rsib.setHostProductType(this.lastChars);
            } else if (string.equals("clusterid")) {
                this.rsib.setClusterId(this.lastChars);
            } else if (string.equals("cluster_name")) {
                this.rsib.setClusterName(this.lastChars);
            } else if (string.equals("cluster_nodes")) {
                ArrayList<String> arrayList = new ArrayList<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(this.lastChars);
                if (stringTokenizer.hasMoreTokens()) {
                    stringTokenizer.nextToken();
                }
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (!stringTokenizer.hasMoreTokens()) break;
                    if (string2.endsWith(",")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    arrayList.add(string2);
                }
                this.rsib.setNodeNames(arrayList);
            } else if (string.equals("run_system_info")) {
                runInfoBean.setRunSystemInfo(this.rsib);
                this.rsib = null;
            }
        } else if (this.crb != null) {
            if (string.equals("id")) {
                this.crb.setCheckId(this.lastChars);
            } else if (string.equals("check_revision")) {
                this.crb.setCheckRevisionNumber(Integer.parseInt(this.lastChars));
            } else if (string.equals("description")) {
                this.crb.setDescription(this.lastChars);
            } else if (string.equals("analysis")) {
                this.crb.setAnalysisCml(new CmlImpl(this.lastChars));
            } else if (string.equals("recommendations")) {
                this.crb.setRecommendationsCml(new CmlImpl(this.lastChars));
            } else if (string.equals("comment")) {
                this.crb.setComment(this.lastChars);
            } else if (string.equals("checkresult")) {
                List list = runInfoBean.getCheckResults();
                list.add(this.crb);
                this.crb = null;
                this.checkId = null;
                this.checkRevisionNumber = -1;
            }
        }
    }

    public KAEResultBean getKAEResultFromStream(InputStream inputStream) throws IOException, SAXParseException, SAXException {
        KAEResultBean kAEResultBean = null;
        XMLReader xMLReader = XMLReaderFactory.createXMLReader(DEFAULT_PARSER_NAME);
        xMLReader.setContentHandler(this);
        xMLReader.setEntityResolver(this);
        xMLReader.parse(new InputSource(inputStream));
        xMLReader.setFeature("http://xml.org/sax/features/validation", this.validate);
        kAEResultBean = this.kaerb;
        return kAEResultBean;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage: com.sun.eras.common.kaeresult.KAEXMLResultReader  KAEXMLResultFile");
            System.exit(1);
        }
        System.err.println("argv[0]=" + stringArray[0]);
        try {
            String string = stringArray[0];
            File file = new File(string);
            if (!file.exists()) {
                return;
            }
            FileInputStream fileInputStream = new FileInputStream(file);
            KAEXMLResultReader kAEXMLResultReader = new KAEXMLResultReader();
            kAEXMLResultReader.debug = true;
            kAEXMLResultReader.validate = true;
            KAEResultBean kAEResultBean = kAEXMLResultReader.getKAEResultFromStream(fileInputStream);
            System.out.println("kaerb.toXML()=" + kAEResultBean.toXML());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        logger.fine("Done...");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

