/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.checkstorage;

import com.sun.eras.common.checks.Check;
import com.sun.eras.common.checks.CheckKeyword;
import com.sun.eras.common.checks.CheckList;
import com.sun.eras.common.checks.CheckNote;
import com.sun.eras.common.checks.CheckParam;
import com.sun.eras.common.checks.CheckProduct;
import com.sun.eras.common.checks.CheckRefdoc;
import com.sun.eras.common.checks.CheckReportSection;
import com.sun.eras.common.checks.CheckSeverity;
import com.sun.eras.common.checks.CheckSwordfishProduct;
import com.sun.eras.common.checks.FriendlyCheckHelper;
import com.sun.eras.common.checkstorage.CheckStorageException;
import com.sun.eras.common.checkstorage.CheckStorageIOException;
import com.sun.eras.common.checkstorage.CheckStorageParseException;
import com.sun.eras.common.logging4.Logger;
import com.sun.eras.common.util.CRCFactory;
import com.sun.eras.common.util.EntityResolverHelper;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import com.sun.eras.common.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Date;
import java.util.Hashtable;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

final class ReadChecklistFromXml
extends DefaultHandler {
    private static final Logger logger = Logger.getLogger((class$com$sun$eras$common$checkstorage$ReadChecklistFromXml == null ? (class$com$sun$eras$common$checkstorage$ReadChecklistFromXml = ReadChecklistFromXml.class$("com.sun.eras.common.checkstorage.ReadChecklistFromXml")) : class$com$sun$eras$common$checkstorage$ReadChecklistFromXml).getName());
    private Writer debugOut = null;
    private boolean validate = false;
    private Locator locator = null;
    private boolean debug = false;
    private StringBuffer curChars = null;
    private Stack attrStack = new Stack();
    private Stack elementStack = new Stack();
    private boolean expectCDATA = false;
    private boolean withinCmlContainerTag = false;
    private static final String[] cmlContainerTags = new String[]{"analysis", "human_rule", "kce_analysis", "kce_execution", "kce_recommendations", "problem", "recommendations"};
    private CheckList checklist = new CheckList();
    private Date generationDate = null;
    private Date expirationDate = null;
    private String computedCRC = null;
    private String givenCRC = null;
    private EntityResolverHelper entityHelper = new EntityResolverHelper();
    private static Set startNotHandled = new TreeSet();
    private static Set endNotHandled = new TreeSet();
    private static final String nlLineEnd = System.getProperty("line.separator");
    private static final short TAG_CHECKLIST = 1;
    private static final short TAG_CHECK = 10;
    private static final short TAG_CRC = 11;
    private static final short TAG_GENERATION_DATE = 12;
    private static final short TAG_EXPIRATION_DATE = 13;
    private static final short TAG_ID = 100;
    private static final short TAG_TITLE = 101;
    private static final short TAG_AUTHOR = 102;
    private static final short TAG_AUTHOR_DATE = 103;
    private static final short TAG_UPDATED = 104;
    private static final short TAG_UPDATED_DATE = 105;
    private static final short TAG_APPLICATION = 106;
    private static final short TAG_PROBLEM = 107;
    private static final short TAG_HUMAN_RULE = 108;
    private static final short TAG_EXPLORER_PATH = 109;
    private static final short TAG_CHECK_APPLICABILITY = 110;
    private static final short TAG_SEVERITY = 111;
    private static final short TAG_RECOMMENDATIONS = 112;
    private static final short TAG_ANALYSIS = 113;
    private static final short TAG_AUTOMATION_STATE = 114;
    private static final short TAG_ENABLED = 115;
    private static final short TAG_CHECK_STATE = 116;
    private static final short TAG_DOMAIN = 117;
    private static final short TAG_RESTRICTED = 118;
    private static final short TAG_KCE_APPLICABILITY = 119;
    private static final short TAG_KCE_RULE_AUTHOR = 120;
    private static final short TAG_KCE_CONDITIONS = 121;
    private static final short TAG_KCE_SEVERITY = 122;
    private static final short TAG_KCE_ANALYSIS = 123;
    private static final short TAG_KCE_RECOMMENDATIONS = 124;
    private static final short TAG_KCE_RECOMMENDATION_FACTS = 125;
    private static final short TAG_KCE_EXECUTION = 126;
    private static final short TAG_NOTE = 127;
    private static final short TAG_PRODUCT = 128;
    private static final short TAG_REPORT_SECTION = 129;
    private static final short TAG_KEYWORD = 130;
    private static final short TAG_REFDOC = 131;
    private static final short TAG_CHECK_PARAM = 132;
    private static final short TAG_PRODUCT_CATEGORY = 133;
    private static final short TAG_MIN_REQUIRED_KAE_VERSION = 134;
    private static final short TAG_DBID = 135;
    private static final short TAG_METADBID = 136;
    private static final short TAG_SWORDFISH_PRODUCT = 137;
    private static final short TAG_AUDIENCE = 138;
    private static final short TAG_VALID_DATE = 139;
    private static final short TAG_REVISION_NUMBER = 140;
    private static final short TAG_CREATED_DATE = 200;
    private static final short TAG_NOTE_DATA = 201;
    private static final short TAG_CREATED_BY = 202;
    private static final short TAG_NOTE_SEQ = 203;
    private static final short TAG_REP_TYPE = 300;
    private static final short TAG_REP_SECTION = 301;
    private static final short TAG_REP_SUBSECTION = 302;
    private static final short TAG_REP_ID = 303;
    private static final short TAG_REP_SUBSECTION_ID = 304;
    private static final short TAG_REP_SECTION_ID = 305;
    private static final short TAG_REP_HEADER_ID = 306;
    private static final short TAG_KEYWORD_NAME = 400;
    private static final short TAG_KEYWORD_ID = 401;
    private static final short TAG_REFDOC_ID = 500;
    private static final short TAG_REFDOC_FILENAME = 501;
    private static final short TAG_REFDOC_DOCTYPE = 502;
    private static final short TAG_REFDOC_DOCURL = 503;
    private static final short TAG_REFDOC_DOCID = 504;
    private static final short TAG_REFDOC_DOCTITLE = 505;
    private static final short TAG_REFDOC_EXTERNAL = 506;
    private static final short TAG_PARAM_NAME = 600;
    private static final short TAG_PARAM_VALUE = 601;
    private static final short TAG_PARAM_DESC = 602;
    private static final short TAG_PARAM_ID = 603;
    private static final short TAG_PARAM_CREATED_BY = 604;
    private static final short TAG_PARAM_CREATED_DATE = 605;
    private static final short TAG_PARAM_UPDATED_BY = 606;
    private static final short TAG_PARAM_UPDATED_DATE = 607;
    private static final short TAG_PROD_DESCRIPTION = 700;
    private static final short TAG_PROD_PARENT_UUID = 701;
    private static final short TAG_PROD_CATEGORY = 800;
    private static final short TAG_PROD_NAME = 801;
    private static final short TAG_PROD_ID = 802;
    private static final short TAG_PROD_DESC = 803;
    private static final short TAG_CML_A = 1000;
    private static final short TAG_CML_PRE = 1001;
    private static final short TAG_CML_CODE = 1002;
    private static final short TAG_CML_BR = 1003;
    private static final short TAG_CML_P = 1004;
    private static final short TAG_CML_OL = 1005;
    private static final short TAG_CML_UL = 1006;
    private static final short TAG_CML_LI = 1007;
    private static final short TAG_CML_TABLE = 1008;
    private static final short TAG_CML_ROW = 1009;
    private static final short TAG_CML_COL = 1010;
    private static final short TAG_HISTORY = 900;
    private static final short TAG_VERSION = 901;
    private static Hashtable elements = new Hashtable();
    static /* synthetic */ Class class$com$sun$eras$common$checkstorage$ReadChecklistFromXml;

    ReadChecklistFromXml(InputStream inputStream, boolean bl, EntityResolverHelper entityResolverHelper, boolean bl2, Writer writer) throws CheckStorageException {
        this.validate = bl;
        this.debug = bl2;
        this.debugOut = writer;
        if (entityResolverHelper != null) {
            this.entityHelper = entityResolverHelper;
        }
        this.readCheckList(inputStream);
    }

    public CheckList getCheckList() {
        return this.checklist;
    }

    public Date getGenerationDate() {
        return this.generationDate;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public String getGivenCRC() {
        return this.givenCRC;
    }

    public String getComputedCRC() {
        return this.computedCRC;
    }

    public boolean getDebug() {
        return this.debug;
    }

    private byte[] readStreamBytes(InputStream inputStream) throws IOException {
        IOException iOException3;
        byte[] byArray;
        BufferedInputStream bufferedInputStream;
        block12: {
            bufferedInputStream = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            byArray = new byte[1024];
            try {
                int n;
                bufferedInputStream = new BufferedInputStream(inputStream);
                byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n = bufferedInputStream.read(byArray, 0, 1024)) > -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
                Object var8_6 = null;
                if (byteArrayOutputStream == null) break block12;
            }
            catch (Throwable throwable) {
                IOException iOException22;
                Object var8_7 = null;
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException3) {
                // empty catch block
            }
        }
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException3) {}
        }
        return byArray;
    }

    private void computeCRC(byte[] byArray) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer(new String(byArray, "UTF-8"));
        this.computedCRC = CRCFactory.computeCRC(stringBuffer);
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        if ("Entity-Resolver-Required:eras-common.jar!checklist.dtd".equals(string2)) {
            this.expectCDATA = true;
        } else if ("Entity-Resolver-Required:eras-common.jar!checklist1_1.dtd".equals(string2)) {
            this.expectCDATA = false;
        }
        try {
            return this.entityHelper.resolveEntity(string, string2);
        }
        catch (IOException iOException) {
            String string3 = MessageLocalizer.makeLMS(this, new MessageKey("ioexception"), "io exception", null, null);
            throw new SAXException(string3, iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void readCheckList(InputStream inputStream) throws CheckStorageException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        Exception exception = null;
        try {
            try {
                block16: {
                    sAXParserFactory.setValidating(this.validate);
                    SAXParser sAXParser = sAXParserFactory.newSAXParser();
                    byte[] byArray = this.readStreamBytes(inputStream);
                    this.computeCRC(byArray);
                    ByteArrayInputStream byteArrayInputStream = null;
                    try {
                        byteArrayInputStream = new ByteArrayInputStream(byArray);
                        try {
                            sAXParser.parse((InputStream)byteArrayInputStream, (DefaultHandler)this);
                        }
                        catch (ClassCastException classCastException) {
                            throw new CheckStorageParseException(CheckStorageParseException.TAGSAREIMPROPERLYNESTEDINSIDETHEXMLCHECKLIST, "Tags are improperly nested inside the XML checklist", null, null, classCastException);
                        }
                        logger.fine("This checklist has " + this.checklist.size() + " checks.");
                        logger.fine("File Buffer: " + byArray.length);
                        logger.fine("Memory used: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
                        logger.fine("Stacks: " + this.elementStack.size() + "/" + this.attrStack.size());
                        Object var9_12 = null;
                        if (byteArrayInputStream == null) break block16;
                    }
                    catch (Throwable throwable) {
                        Object var9_13 = null;
                        if (byteArrayInputStream == null) throw throwable;
                        try {
                            byteArrayInputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    byteArrayInputStream.close();
                }
                Object var12_17 = null;
                if (exception == null) return;
            }
            catch (SAXParseException sAXParseException) {
                exception = sAXParseException;
                if (sAXParseException.getException() != null) {
                    exception = sAXParseException.getException();
                }
                throw new CheckStorageParseException(CheckStorageParseException.PARSINGERRORINCHECKLIST, "Parsing error in checklist, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId(), new Object[]{new Integer(sAXParseException.getLineNumber()), sAXParseException.getSystemId()}, null, exception);
            }
            catch (SAXException sAXException) {
                exception = sAXException;
                if (sAXException.getException() != null) {
                    exception = sAXException.getException();
                }
                Object var12_18 = null;
                if (exception == null) return;
                if (!(exception instanceof IOException)) throw new CheckStorageParseException(CheckStorageParseException.ERRORREADINGCHECKLIST, "error reading checklist", null, null, exception);
                throw new CheckStorageIOException(CheckStorageIOException.ERRORREADINGCHECKLIST, "error reading checklist", null, null, (IOException)exception);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                exception = parserConfigurationException;
                Object var12_19 = null;
                if (exception == null) return;
                if (!(exception instanceof IOException)) throw new CheckStorageParseException(CheckStorageParseException.ERRORREADINGCHECKLIST, "error reading checklist", null, null, exception);
                throw new CheckStorageIOException(CheckStorageIOException.ERRORREADINGCHECKLIST, "error reading checklist", null, null, (IOException)exception);
            }
            catch (IOException iOException) {
                exception = iOException;
                Object var12_20 = null;
                if (exception == null) return;
                if (!(exception instanceof IOException)) throw new CheckStorageParseException(CheckStorageParseException.ERRORREADINGCHECKLIST, "error reading checklist", null, null, exception);
                throw new CheckStorageIOException(CheckStorageIOException.ERRORREADINGCHECKLIST, "error reading checklist", null, null, (IOException)exception);
            }
        }
        catch (Throwable throwable) {
            Object var12_21 = null;
            if (exception == null) throw throwable;
            if (!(exception instanceof IOException)) throw new CheckStorageParseException(CheckStorageParseException.ERRORREADINGCHECKLIST, "error reading checklist", null, null, exception);
            throw new CheckStorageIOException(CheckStorageIOException.ERRORREADINGCHECKLIST, "error reading checklist", null, null, (IOException)exception);
        }
        if (!(exception instanceof IOException)) throw new CheckStorageParseException(CheckStorageParseException.ERRORREADINGCHECKLIST, "error reading checklist", null, null, exception);
        throw new CheckStorageIOException(CheckStorageIOException.ERRORREADINGCHECKLIST, "error reading checklist", null, null, (IOException)exception);
    }

    public static boolean isCmlContainerTag(String string) {
        int n = cmlContainerTags.length;
        int n2 = 0;
        while (n2 < n) {
            if (cmlContainerTags[n2].equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        String string = MessageLocalizer.makeLMS(this, new MessageKey("Warninglineuri"), "** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId() + ": " + sAXParseException.getMessage(), new Object[]{new Integer(sAXParseException.getLineNumber()), sAXParseException.getSystemId(), sAXParseException.getMessage()}, null);
        logger.warning(string);
    }

    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.debugnl();
        this.debugemit("PROCESS: ");
        this.debugemit("<?");
        this.debugemit(string);
        this.debugemit(" ");
        this.debugemit(string2);
        this.debugemit("?>");
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        if (!this.debug) {
            return;
        }
        try {
            this.debugemit("LOCATOR");
            this.debugemit("\n SYS ID: " + locator.getSystemId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void startDocument() throws SAXException {
        this.debugnl();
        this.debugnl();
        this.debugemit("START DOCUMENT");
        this.debugnl();
    }

    public void endDocument() throws SAXException {
        this.debugnl();
        this.debugemit("END DOCUMENT");
        this.debugnl();
        this.debugflush();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        String string4 = null;
        if (string2 != null && !string2.equals("")) {
            string4 = string2.trim();
        }
        if ((string4 == null || string4.equals("")) && string3 != null && !string3.equals("")) {
            string4 = string3.trim();
        }
        if (ReadChecklistFromXml.isCmlContainerTag(string4)) {
            this.withinCmlContainerTag = true;
        }
        boolean bl = true;
        this.debugnl();
        this.debugemit("ELEMENT: ");
        this.debugemit("<");
        this.debugemit(string2);
        Short s = (Short)elements.get(string4);
        if (s == null) {
            object = MessageLocalizer.makeLMS(this, new MessageKey("Unknownelementinchecklist"), "Unknown element in checklist: " + string4, new Object[]{string4}, null);
            logger.warning((String)object);
        }
        if (null != s) {
            switch (s) {
                case 1: {
                    break;
                }
                case 10: {
                    break;
                }
                case 111: {
                    break;
                }
                case 127: {
                    this.elementStack.push(new CheckNote());
                    break;
                }
                case 128: {
                    this.elementStack.push(new CheckProduct());
                    break;
                }
                case 129: {
                    this.elementStack.push(new CheckReportSection());
                    break;
                }
                case 130: {
                    this.elementStack.push(new CheckKeyword());
                    break;
                }
                case 131: {
                    this.elementStack.push(new CheckRefdoc());
                    break;
                }
                case 132: {
                    this.elementStack.push(new CheckParam());
                    break;
                }
                case 137: {
                    object = new CheckSwordfishProduct();
                    String string5 = attributes.getValue("uuid");
                    String string6 = attributes.getValue("primary_link");
                    ((CheckSwordfishProduct)object).setProdUuid(string5);
                    if (string6 != null && string6.equals("true")) {
                        ((CheckSwordfishProduct)object).setPrimaryLink(true);
                    }
                    this.elementStack.push(object);
                    break;
                }
                case 701: {
                    Object object2 = (CheckSwordfishProduct)this.elementStack.peek();
                    String string7 = attributes.getValue("uuid");
                    ((CheckSwordfishProduct)object2).setProdParentUuid(string7);
                    break;
                }
                case 1000: 
                case 1001: 
                case 1002: 
                case 1003: 
                case 1004: 
                case 1005: 
                case 1006: 
                case 1007: 
                case 1008: 
                case 1009: 
                case 1010: {
                    bl = false;
                    if (this.curChars == null) {
                        this.curChars = new StringBuffer();
                    }
                    if ("br".equals(string4)) {
                        this.curChars.append("<br/>");
                        break;
                    }
                    this.curChars.append("<").append(string4);
                    int n = attributes.getLength();
                    int n2 = 0;
                    while (n2 < n) {
                        String string8 = attributes.getQName(n2);
                        String string9 = attributes.getValue(n2);
                        string9 = StringUtil.encodeXmlAttribute(string9);
                        this.curChars.append(" " + string8 + "=\"" + string9 + "\"");
                        ++n2;
                    }
                    this.curChars.append(">");
                    break;
                }
                case 11: 
                case 12: 
                case 13: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 116: 
                case 117: 
                case 118: 
                case 119: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 133: 
                case 134: 
                case 135: 
                case 136: 
                case 138: 
                case 139: 
                case 140: 
                case 200: 
                case 201: 
                case 202: 
                case 203: 
                case 300: 
                case 301: 
                case 302: 
                case 303: 
                case 304: 
                case 305: 
                case 306: 
                case 400: 
                case 401: 
                case 500: 
                case 501: 
                case 502: 
                case 503: 
                case 504: 
                case 505: 
                case 506: 
                case 600: 
                case 601: 
                case 602: 
                case 603: 
                case 604: 
                case 605: 
                case 606: 
                case 607: 
                case 700: 
                case 800: 
                case 801: 
                case 802: 
                case 803: 
                case 900: 
                case 901: {
                    break;
                }
                default: {
                    if (startNotHandled.contains(string4)) break;
                    Object object2 = MessageLocalizer.makeLMS(this, new MessageKey("Tagnothandled"), "Tag not handled: " + string4, new Object[]{string4}, null);
                    logger.warning((String)object2);
                    startNotHandled.add(string4);
                }
            }
            this.attrStack.push(attributes);
        }
        if (this.debug && attributes != null) {
            int n = 0;
            while (n < attributes.getLength()) {
                this.debugnl();
                this.debugemit("   ATTR: ");
                this.debugemit(attributes.getQName(n));
                this.debugemit("\t\"");
                this.debugemit(attributes.getValue(n));
                this.debugemit("\"");
                ++n;
            }
            if (attributes.getLength() > 0) {
                this.debugnl();
            }
        }
        this.debugemit(">");
        if (bl) {
            this.curChars = null;
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        Object object;
        String string4 = null;
        if (string2 != null && !string2.equals("")) {
            string4 = string2.trim();
        }
        if ((string4 == null || string4.equals("")) && string3 != null && !string3.equals("")) {
            string4 = string3.trim();
        }
        this.debugnl();
        this.debugemit("ELEMENT: ");
        this.debugemit("<");
        this.debugemit(string2);
        String string5 = this.curChars == null ? "" : this.curChars.toString();
        boolean bl = true;
        Short s = (Short)elements.get(string4);
        if (s == null) {
            object = MessageLocalizer.makeLMS(this, new MessageKey("Unknownelementinchecklist29"), "Unknown element in checklist: " + string4, new Object[]{string4}, null);
            logger.warning((String)object);
        }
        if (null != s) {
            object = (Attributes)this.attrStack.pop();
            switch (s) {
                case 1: {
                    break;
                }
                case 10: {
                    Check check = (Check)this.elementStack.pop();
                    this.checklist.add(check);
                    break;
                }
                case 11: {
                    this.givenCRC = string5.trim();
                    break;
                }
                case 12: {
                    String string6 = string5.trim();
                    if (string6.length() <= 0) break;
                    try {
                        Date date;
                        long l = Long.parseLong(string6);
                        this.generationDate = date = new Date(l);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string7 = MessageLocalizer.makeLMS(this, new MessageKey("Invalidgenerationdate"), "Invalid generation date.", null, null);
                        throw new SAXParseException(string7, this.locator, numberFormatException);
                    }
                }
                case 13: {
                    String string8 = string5.trim();
                    if (string8.length() <= 0) break;
                    try {
                        Date date;
                        long l = Long.parseLong(string8);
                        this.expirationDate = date = new Date(l);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string9 = MessageLocalizer.makeLMS(this, new MessageKey("Invalidexpirationdate"), "Invalid expiration date.", null, null);
                        throw new SAXParseException(string9, this.locator, numberFormatException);
                    }
                }
                case 100: {
                    this.elementStack.push(new Check(string5));
                    break;
                }
                case 101: {
                    Check check = (Check)this.elementStack.peek();
                    check.setTitle(string5);
                    break;
                }
                case 102: {
                    Check check = (Check)this.elementStack.peek();
                    check.setAuthor(string5);
                    break;
                }
                case 103: {
                    String string10 = string5.trim();
                    if (string10.length() <= 0) break;
                    try {
                        long l = Long.parseLong(string10);
                        Date date = new Date(l);
                        Check check = (Check)this.elementStack.peek();
                        check.setAuthorDate(date);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string11 = MessageLocalizer.makeLMS(this, new MessageKey("Invalidauthordate"), "Invalid author date.", null, null);
                        throw new SAXParseException(string11, this.locator, numberFormatException);
                    }
                }
                case 104: {
                    Check check = (Check)this.elementStack.peek();
                    check.setUpdated(string5);
                    break;
                }
                case 105: {
                    String string12 = string5.trim();
                    if (string12.length() <= 0) break;
                    try {
                        long l = Long.parseLong(string12);
                        Date date = new Date(l);
                        Check check = (Check)this.elementStack.peek();
                        check.setUpdatedDate(date);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string13 = MessageLocalizer.makeLMS(this, new MessageKey("Invalidupdateddate"), "Invalid updated date.", null, null);
                        throw new SAXParseException(string13, this.locator, numberFormatException);
                    }
                }
                case 106: {
                    Check check = (Check)this.elementStack.peek();
                    check.setApplication(string5);
                    break;
                }
                case 107: {
                    Check check = (Check)this.elementStack.peek();
                    check.setProblem(string5);
                    break;
                }
                case 108: {
                    Check check = (Check)this.elementStack.peek();
                    check.setHumanRule(string5);
                    break;
                }
                case 109: {
                    Check check = (Check)this.elementStack.peek();
                    check.addToExplorerPathList(string5);
                    break;
                }
                case 110: {
                    Check check = (Check)this.elementStack.peek();
                    check.setCheckApplicability(string5);
                    break;
                }
                case 111: {
                    Check check = (Check)this.elementStack.peek();
                    String string14 = string5;
                    check.setSeverity(CheckSeverity.getInstance(string14));
                    break;
                }
                case 112: {
                    Check check = (Check)this.elementStack.peek();
                    check.setRecommendations(string5);
                    break;
                }
                case 113: {
                    Check check = (Check)this.elementStack.peek();
                    check.setAnalysis(string5);
                    break;
                }
                case 114: {
                    Check check = (Check)this.elementStack.peek();
                    check.setAutomationState(string5);
                    break;
                }
                case 115: {
                    Check check = (Check)this.elementStack.peek();
                    check.setEnabled(!string5.equalsIgnoreCase("DISABLED"));
                    break;
                }
                case 116: {
                    Check check = (Check)this.elementStack.peek();
                    check.setCheckState(string5);
                    break;
                }
                case 117: {
                    Check check = (Check)this.elementStack.peek();
                    check.setDomain(string5);
                    break;
                }
                case 118: {
                    Check check = (Check)this.elementStack.peek();
                    check.setRestricted(!string5.equalsIgnoreCase("N"));
                    break;
                }
                case 119: {
                    Check check = (Check)this.elementStack.peek();
                    check.setKceApplicability(string5);
                    break;
                }
                case 120: {
                    Check check = (Check)this.elementStack.peek();
                    check.setKceRuleAuthor(string5);
                    break;
                }
                case 121: {
                    Check check = (Check)this.elementStack.peek();
                    check.setKceConditions(string5);
                    break;
                }
                case 122: {
                    Check check = (Check)this.elementStack.peek();
                    check.setKceSeverity(string5);
                    break;
                }
                case 123: {
                    Check check = (Check)this.elementStack.peek();
                    check.setKceAnalysis(string5);
                    break;
                }
                case 124: {
                    Check check = (Check)this.elementStack.peek();
                    check.setKceRecommendations(string5);
                    break;
                }
                case 125: {
                    Check check = (Check)this.elementStack.peek();
                    check.setKceRecommendationFacts(string5);
                    break;
                }
                case 126: {
                    Check check = (Check)this.elementStack.peek();
                    check.setKceExecution(string5);
                    break;
                }
                case 127: {
                    CheckNote checkNote = (CheckNote)this.elementStack.pop();
                    Check check = (Check)this.elementStack.peek();
                    check.addToNoteList(checkNote);
                    break;
                }
                case 128: {
                    CheckProduct checkProduct = (CheckProduct)this.elementStack.pop();
                    Check check = (Check)this.elementStack.peek();
                    check.addToProductList(checkProduct);
                    break;
                }
                case 800: {
                    CheckProduct checkProduct = (CheckProduct)this.elementStack.peek();
                    checkProduct.setProdCategory(string5);
                    break;
                }
                case 133: {
                    Check check = (Check)this.elementStack.peek();
                    FriendlyCheckHelper friendlyCheckHelper = new FriendlyCheckHelper(check);
                    friendlyCheckHelper.addToExplicitProductCategoryList(string5);
                    break;
                }
                case 801: {
                    if (this.elementStack.peek() instanceof CheckProduct) {
                        CheckProduct checkProduct = (CheckProduct)this.elementStack.peek();
                        checkProduct.setProdName(string5);
                        break;
                    }
                    if (!(this.elementStack.peek() instanceof CheckSwordfishProduct)) break;
                    CheckSwordfishProduct checkSwordfishProduct = (CheckSwordfishProduct)this.elementStack.peek();
                    checkSwordfishProduct.setProdName(string5);
                    break;
                }
                case 802: {
                    CheckProduct checkProduct = (CheckProduct)this.elementStack.peek();
                    checkProduct.setProdId(string5);
                    break;
                }
                case 803: {
                    CheckProduct checkProduct = (CheckProduct)this.elementStack.peek();
                    checkProduct.setProdDesc(string5);
                    break;
                }
                case 701: {
                    break;
                }
                case 129: {
                    CheckReportSection checkReportSection = (CheckReportSection)this.elementStack.pop();
                    Check check = (Check)this.elementStack.peek();
                    check.addToReportSectionList(checkReportSection);
                    break;
                }
                case 130: {
                    CheckKeyword checkKeyword = (CheckKeyword)this.elementStack.pop();
                    Check check = (Check)this.elementStack.peek();
                    check.addToKeywordList(checkKeyword);
                    break;
                }
                case 131: {
                    CheckRefdoc checkRefdoc = (CheckRefdoc)this.elementStack.pop();
                    Check check = (Check)this.elementStack.peek();
                    check.addToRefdocList(checkRefdoc);
                    break;
                }
                case 132: {
                    CheckParam checkParam = (CheckParam)this.elementStack.pop();
                    Check check = (Check)this.elementStack.peek();
                    check.addToCheckParamList(checkParam);
                    break;
                }
                case 134: {
                    Check check = (Check)this.elementStack.peek();
                    check.setMinRequiredKaeVersion(string5);
                    break;
                }
                case 135: {
                    Check check = (Check)this.elementStack.peek();
                    check.setDbid(string5);
                    break;
                }
                case 136: {
                    Check check = (Check)this.elementStack.peek();
                    check.setMetadbid(string5);
                    break;
                }
                case 137: {
                    CheckSwordfishProduct checkSwordfishProduct = (CheckSwordfishProduct)this.elementStack.pop();
                    if (this.elementStack.peek() instanceof Check) {
                        Check check = (Check)this.elementStack.peek();
                        check.addToSwordfishProductList(checkSwordfishProduct);
                        break;
                    }
                    String string15 = MessageLocalizer.makeLMS(this, new MessageKey("Handlingofnestedswordfishproducttagsisnotimplemented"), "** Handling of nested swordfish_product tags is not implemented: " + checkSwordfishProduct, new Object[]{checkSwordfishProduct}, null);
                    logger.warning(string15);
                    break;
                }
                case 138: {
                    Check check = (Check)this.elementStack.peek();
                    check.setAudience(string5);
                    break;
                }
                case 139: {
                    String string16 = string5.trim();
                    if (string16.length() <= 0) break;
                    try {
                        long l = Long.parseLong(string16);
                        Date date = new Date(l);
                        Check check = (Check)this.elementStack.peek();
                        check.setValidDate(date);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string17 = MessageLocalizer.makeLMS(this, new MessageKey("Invalidvaliddate"), "Invalid valid date.", null, null);
                        throw new SAXParseException(string17, this.locator, numberFormatException);
                    }
                }
                case 140: {
                    String string18 = string5.trim();
                    if (string18.length() <= 0) break;
                    try {
                        int n = Integer.parseInt(string18);
                        Check check = (Check)this.elementStack.peek();
                        check.setRevisionNumber(n);
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        String string19 = MessageLocalizer.makeLMS(this, new MessageKey("Invalidrevisionnumber"), "Invalid revision number.", null, null);
                        throw new SAXParseException(string19, this.locator, numberFormatException);
                    }
                }
                case 200: {
                    CheckNote checkNote = (CheckNote)this.elementStack.peek();
                    checkNote.setCreatedDate(string5);
                    break;
                }
                case 201: {
                    CheckNote checkNote = (CheckNote)this.elementStack.peek();
                    checkNote.setNoteData(string5);
                    break;
                }
                case 202: {
                    CheckNote checkNote = (CheckNote)this.elementStack.peek();
                    checkNote.setCreatedBy(string5);
                    break;
                }
                case 203: {
                    CheckNote checkNote = (CheckNote)this.elementStack.peek();
                    checkNote.setNoteSeq(string5);
                    break;
                }
                case 300: {
                    CheckReportSection checkReportSection = (CheckReportSection)this.elementStack.peek();
                    checkReportSection.setRepType(string5);
                    break;
                }
                case 301: {
                    CheckReportSection checkReportSection = (CheckReportSection)this.elementStack.peek();
                    checkReportSection.setRepSection(string5);
                    break;
                }
                case 302: {
                    CheckReportSection checkReportSection = (CheckReportSection)this.elementStack.peek();
                    checkReportSection.setRepSubsection(string5);
                    break;
                }
                case 303: {
                    CheckReportSection checkReportSection = (CheckReportSection)this.elementStack.peek();
                    checkReportSection.setRepId(string5);
                    break;
                }
                case 304: {
                    CheckReportSection checkReportSection = (CheckReportSection)this.elementStack.peek();
                    checkReportSection.setRepSubsectionId(string5);
                    break;
                }
                case 305: {
                    CheckReportSection checkReportSection = (CheckReportSection)this.elementStack.peek();
                    checkReportSection.setRepSectionId(string5);
                    break;
                }
                case 306: {
                    CheckReportSection checkReportSection = (CheckReportSection)this.elementStack.peek();
                    checkReportSection.setRepHeaderId(string5);
                    break;
                }
                case 400: {
                    CheckKeyword checkKeyword = (CheckKeyword)this.elementStack.peek();
                    checkKeyword.setKeywordName(string5);
                    break;
                }
                case 401: {
                    CheckKeyword checkKeyword = (CheckKeyword)this.elementStack.peek();
                    checkKeyword.setKeywordId(string5);
                    break;
                }
                case 500: {
                    CheckRefdoc checkRefdoc = (CheckRefdoc)this.elementStack.peek();
                    checkRefdoc.setRefdocId(string5);
                    break;
                }
                case 501: {
                    CheckRefdoc checkRefdoc = (CheckRefdoc)this.elementStack.peek();
                    checkRefdoc.setRefdocFilename(string5);
                    break;
                }
                case 502: {
                    CheckRefdoc checkRefdoc = (CheckRefdoc)this.elementStack.peek();
                    checkRefdoc.setRefdocDoctype(string5);
                    break;
                }
                case 503: {
                    CheckRefdoc checkRefdoc = (CheckRefdoc)this.elementStack.peek();
                    checkRefdoc.setRefdocDocurl(string5);
                    break;
                }
                case 504: {
                    CheckRefdoc checkRefdoc = (CheckRefdoc)this.elementStack.peek();
                    checkRefdoc.setRefdocDocid(string5);
                    break;
                }
                case 505: {
                    CheckRefdoc checkRefdoc = (CheckRefdoc)this.elementStack.peek();
                    checkRefdoc.setRefdocDoctitle(string5);
                    break;
                }
                case 506: {
                    CheckRefdoc checkRefdoc = (CheckRefdoc)this.elementStack.peek();
                    checkRefdoc.setRefdocExternal(string5);
                    break;
                }
                case 600: {
                    CheckParam checkParam = (CheckParam)this.elementStack.peek();
                    checkParam.setParamName(string5);
                    break;
                }
                case 601: {
                    CheckParam checkParam = (CheckParam)this.elementStack.peek();
                    checkParam.setParamValue(string5);
                    break;
                }
                case 602: {
                    CheckParam checkParam = (CheckParam)this.elementStack.peek();
                    checkParam.setParamDesc(string5);
                    break;
                }
                case 603: {
                    CheckParam checkParam = (CheckParam)this.elementStack.peek();
                    checkParam.setParamId(string5);
                    break;
                }
                case 604: {
                    CheckParam checkParam = (CheckParam)this.elementStack.peek();
                    checkParam.setParamCreatedBy(string5);
                    break;
                }
                case 605: {
                    CheckParam checkParam = (CheckParam)this.elementStack.peek();
                    checkParam.setParamCreatedDate(string5);
                    break;
                }
                case 606: {
                    CheckParam checkParam = (CheckParam)this.elementStack.peek();
                    checkParam.setParamUpdatedBy(string5);
                    break;
                }
                case 607: {
                    CheckParam checkParam = (CheckParam)this.elementStack.peek();
                    checkParam.setParamUpdatedDate(string5);
                    break;
                }
                case 700: {
                    CheckSwordfishProduct checkSwordfishProduct = (CheckSwordfishProduct)this.elementStack.peek();
                    checkSwordfishProduct.setProdDescription(string5);
                    break;
                }
                case 1000: 
                case 1001: 
                case 1002: 
                case 1003: 
                case 1004: 
                case 1005: 
                case 1006: 
                case 1007: 
                case 1008: 
                case 1009: 
                case 1010: {
                    bl = false;
                    if ("br".equals(string4)) break;
                    this.curChars.append("</").append(string4).append(">");
                    break;
                }
                case 900: 
                case 901: {
                    break;
                }
                default: {
                    if (endNotHandled.contains(string4)) break;
                    String string20 = MessageLocalizer.makeLMS(this, new MessageKey("Tagnothandled30"), "Tag not handled: " + string4, new Object[]{string4}, null);
                    logger.warning(string20);
                    endNotHandled.add(string4);
                }
            }
        }
        if (bl) {
            this.curChars = null;
        }
        if (ReadChecklistFromXml.isCmlContainerTag(string4)) {
            this.withinCmlContainerTag = false;
        }
        this.debugnl();
        this.debugemit("END_ELM: ");
        this.debugemit("</");
        this.debugemit(string2);
        this.debugemit(">");
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.debugnl();
        this.debugemit("CHARS: |");
        if (this.curChars == null) {
            this.curChars = new StringBuffer(n2);
        }
        this.curChars.append(cArray, n, n2);
        if (this.withinCmlContainerTag && !this.expectCDATA) {
            StringUtil.encodeXmlStringBuffer(this.curChars, this.curChars.length() - n2, n2);
        }
        this.debugemit(cArray, n, n2);
        this.debugemit("|");
    }

    private void debugemit(String string) throws SAXException {
        if (null == this.debugOut || !this.debug) {
            return;
        }
        try {
            this.debugOut.write(string);
            this.debugOut.flush();
        }
        catch (IOException iOException) {
            String string2 = MessageLocalizer.makeLMS(this, new MessageKey("IOerror"), "I/O error", null, null);
            throw new SAXException(string2, iOException);
        }
    }

    private void debugemit(char[] cArray, int n, int n2) throws SAXException {
        if (null == this.debugOut || !this.debug) {
            return;
        }
        try {
            this.debugOut.write(cArray, n, n2);
            this.debugOut.flush();
        }
        catch (IOException iOException) {
            String string = MessageLocalizer.makeLMS(this, new MessageKey("IOerror"), "I/O error", null, null);
            throw new SAXException(string, iOException);
        }
    }

    private void debugnl() throws SAXException {
        if (null == this.debugOut || !this.debug) {
            return;
        }
        try {
            this.debugOut.write(nlLineEnd);
            this.debugOut.flush();
        }
        catch (IOException iOException) {
            String string = MessageLocalizer.makeLMS(this, new MessageKey("IOerror"), "I/O error", null, null);
            throw new SAXException(string, iOException);
        }
    }

    private void debugflush() throws SAXException {
        if (null == this.debugOut || !this.debug) {
            return;
        }
        try {
            this.debugOut.flush();
        }
        catch (IOException iOException) {
            String string = MessageLocalizer.makeLMS(this, new MessageKey("IOerror"), "I/O error", null, null);
            throw new SAXException(string, iOException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        elements.put("checklist", new Short(1));
        elements.put("check", new Short(10));
        elements.put("CRC", new Short(11));
        elements.put("generation_date", new Short(12));
        elements.put("expiration_date", new Short(13));
        elements.put("id", new Short(100));
        elements.put("title", new Short(101));
        elements.put("author", new Short(102));
        elements.put("author_date", new Short(103));
        elements.put("updated", new Short(104));
        elements.put("updated_date", new Short(105));
        elements.put("application", new Short(106));
        elements.put("problem", new Short(107));
        elements.put("human_rule", new Short(108));
        elements.put("explorer_path", new Short(109));
        elements.put("check_applicability", new Short(110));
        elements.put("severity", new Short(111));
        elements.put("recommendations", new Short(112));
        elements.put("analysis", new Short(113));
        elements.put("automation_state", new Short(114));
        elements.put("enabled", new Short(115));
        elements.put("check_state", new Short(116));
        elements.put("domain", new Short(117));
        elements.put("restricted", new Short(118));
        elements.put("kce_applicability", new Short(119));
        elements.put("kce_rule_author", new Short(120));
        elements.put("kce_conditions", new Short(121));
        elements.put("kce_severity", new Short(122));
        elements.put("kce_analysis", new Short(123));
        elements.put("kce_recommendations", new Short(124));
        elements.put("kce_recommendation_facts", new Short(125));
        elements.put("kce_execution", new Short(126));
        elements.put("note", new Short(127));
        elements.put("product", new Short(128));
        elements.put("prod_category", new Short(800));
        elements.put("prod_name", new Short(801));
        elements.put("prod_id", new Short(802));
        elements.put("prod_desc", new Short(803));
        elements.put("report_section", new Short(129));
        elements.put("keyword", new Short(130));
        elements.put("refdoc", new Short(131));
        elements.put("check_param", new Short(132));
        elements.put("product_category", new Short(133));
        elements.put("min_required_kae_version", new Short(134));
        elements.put("dbid", new Short(135));
        elements.put("metadbid", new Short(136));
        elements.put("swordfish_product", new Short(137));
        elements.put("audience", new Short(138));
        elements.put("valid_date", new Short(139));
        elements.put("revision_number", new Short(140));
        elements.put("created_date", new Short(200));
        elements.put("note_data", new Short(201));
        elements.put("created_by", new Short(202));
        elements.put("note_seq", new Short(203));
        elements.put("rep_type", new Short(300));
        elements.put("rep_section", new Short(301));
        elements.put("rep_subsection", new Short(302));
        elements.put("rep_id", new Short(303));
        elements.put("rep_subsection_id", new Short(304));
        elements.put("rep_section_id", new Short(305));
        elements.put("rep_header_id", new Short(306));
        elements.put("keyword_name", new Short(400));
        elements.put("keyword_id", new Short(401));
        elements.put("refdoc_id", new Short(500));
        elements.put("refdoc_filename", new Short(501));
        elements.put("refdoc_doctype", new Short(502));
        elements.put("refdoc_docurl", new Short(503));
        elements.put("refdoc_docid", new Short(504));
        elements.put("refdoc_doctitle", new Short(505));
        elements.put("refdoc_external", new Short(506));
        elements.put("param_name", new Short(600));
        elements.put("param_value", new Short(601));
        elements.put("param_desc", new Short(602));
        elements.put("param_id", new Short(603));
        elements.put("param_created_by", new Short(604));
        elements.put("param_created_date", new Short(605));
        elements.put("param_updated_by", new Short(606));
        elements.put("param_updated_date", new Short(607));
        elements.put("prod_description", new Short(700));
        elements.put("prod_parent_id", new Short(701));
        elements.put("a", new Short(1000));
        elements.put("pre", new Short(1001));
        elements.put("code", new Short(1002));
        elements.put("br", new Short(1003));
        elements.put("p", new Short(1004));
        elements.put("ol", new Short(1005));
        elements.put("ul", new Short(1006));
        elements.put("li", new Short(1007));
        elements.put("table", new Short(1008));
        elements.put("row", new Short(1009));
        elements.put("col", new Short(1010));
        elements.put("history", new Short(900));
        elements.put("version", new Short(901));
    }
}

