/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.checks.filters;

import com.sun.eras.common.checks.filters.CheckFilter;
import com.sun.eras.common.checks.filters.FilterOperators;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;

public abstract class IntCheckFilter
extends CheckFilter {
    protected int operator;
    protected int i;

    protected IntCheckFilter(int n, int n2) {
        if (!this.isLegalOperator(n)) {
            String string = MessageLocalizer.makeLMS(this, new MessageKey("illegaloperator"), "illegal operator", null, null);
            throw new IllegalArgumentException(string);
        }
        this.operator = n;
        this.i = n2;
    }

    public int getOperator() {
        return this.operator;
    }

    public int getInt() {
        return this.i;
    }

    public boolean isLegalOperator(int n) {
        return n >= 0 && n <= 5;
    }

    protected boolean matchInt(int n) {
        switch (this.operator) {
            case 0: {
                return n == this.i;
            }
            case 1: {
                return n >= this.i;
            }
            case 2: {
                return n > this.i;
            }
            case 3: {
                return n <= this.i;
            }
            case 4: {
                return n < this.i;
            }
            case 5: {
                return n != this.i;
            }
        }
        return false;
    }

    protected void toStringBody(StringBuffer stringBuffer) {
        stringBuffer.append("op=").append(FilterOperators.toString(this.operator)).append(",");
        stringBuffer.append("operand=").append(this.i);
    }
}

