/*
 * Decompiled with CFR 0.152.
 */
package com.sun.eras.common.checks;

import com.sun.eras.common.checks.CheckExternalProperties;
import com.sun.eras.common.checks.CheckKeyword;
import com.sun.eras.common.checks.CheckNote;
import com.sun.eras.common.checks.CheckParam;
import com.sun.eras.common.checks.CheckProduct;
import com.sun.eras.common.checks.CheckRefdoc;
import com.sun.eras.common.checks.CheckReportSection;
import com.sun.eras.common.checks.CheckSeverity;
import com.sun.eras.common.checks.CheckSwordfishProduct;
import com.sun.eras.common.logging4.Logger;
import com.sun.eras.common.util.MessageKey;
import com.sun.eras.common.util.MessageLocalizer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class Check
implements CheckExternalProperties,
Serializable {
    private static final Logger logger = Logger.getLogger((class$com$sun$eras$common$checks$Check == null ? (class$com$sun$eras$common$checks$Check = Check.class$("com.sun.eras.common.checks.Check")) : class$com$sun$eras$common$checks$Check).getName());
    static final long serialVersionUID = -8031164379567366898L;
    static final String EMPTY_STRING = "";
    public static final String ENABLED_STRING = "ENABLED";
    public static final String DISABLED_STRING = "DISABLED";
    public static final String RESTRICTED_STRING = "Y";
    public static final String NOT_RESTRICTED_STRING = "N";
    public static final String GOOD_CHECK_STATE = "cs01";
    public static final String REWORK_CHECK_STATE = "cs02";
    public static final String NEW_CHECK_STATE = "cs03";
    public static final String STDS_REVIEW_CHECK_STATE = "cs04";
    public static final String ARCHIVE_CHECK_STATE = "cs05";
    public static final String RECYCLE_CHECK_STATE = "cs06";
    public static final String ACQ_REVIEW_CHECK_STATE = "cs07";
    public static final String TECH_REVIEW_CHECK_STATE = "cs08";
    public static final String AUTO_REVIEW_CHECK_STATE = "cs09";
    public static final String AUTO_WAIT_CHECK_STATE = "cs10";
    public static final String AUTO_DEV_CHECK_STATE = "cs11";
    public static final String AUTO_TEST_CHECK_STATE = "cs12";
    private String id = null;
    private String title = null;
    private String author = null;
    private Date authorDate = null;
    private String updated = null;
    private Date updatedDate = null;
    private String application = null;
    private String problem = null;
    private String humanRule = null;
    private List explorerPathList = null;
    private String checkApplicability = null;
    private CheckSeverity severity = CheckSeverity.UNKNOWN;
    private String recommendations = null;
    private String analysis = null;
    private String automationState = null;
    private boolean enabled = true;
    private String checkState = null;
    private String domain = null;
    private boolean restricted = true;
    private List noteList = null;
    private List checkParamList = null;
    private String kceApplicability = null;
    private String kceRuleAuthor = null;
    private String kceConditions = null;
    private String kceSeverity = null;
    private String kceAnalysis = null;
    private String kceRecommendations = null;
    private String kceRecommendationFacts = null;
    private String kceExecution = null;
    private List keywordList = null;
    private List reportSectionList = null;
    private List productList = null;
    private List explicitProductCategoryList = null;
    private List productCategoryList = null;
    private TreeMap productCategoryMap = null;
    private List refdocList = null;
    private String minRequiredKaeVersion = null;
    private String dbid = null;
    private String metadbid = null;
    private List swordfishProductList = null;
    private String audience = null;
    private Date validDate = null;
    private int revisionNumber = 0;
    static /* synthetic */ Class class$com$sun$eras$common$checks$Check;

    public Check(String string) throws IllegalArgumentException {
        if (string == null || EMPTY_STRING.equals(string.trim())) {
            String string2 = MessageLocalizer.makeLMS(this, new MessageKey("idcantbenullorempty"), "id can't be null or empty", null, null);
            throw new IllegalArgumentException(string2);
        }
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setAuthor(String string) {
        this.author = string;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthorDate(Date date) {
        this.authorDate = date;
    }

    public Date getAuthorDate() {
        return this.authorDate;
    }

    public void setUpdated(String string) {
        this.updated = string;
    }

    public String getUpdated() {
        return this.updated;
    }

    public void setUpdatedDate(Date date) {
        this.updatedDate = date;
    }

    public Date getUpdatedDate() {
        return this.updatedDate;
    }

    public void setApplication(String string) {
        this.application = string;
    }

    public String getApplication() {
        return this.application;
    }

    public void setProblem(String string) {
        this.problem = string;
    }

    public String getProblem() {
        return this.problem;
    }

    public void setHumanRule(String string) {
        this.humanRule = string;
    }

    public String getHumanRule() {
        return this.humanRule;
    }

    public void setExplorerPathList(List list) {
        this.explorerPathList = list;
    }

    public void addToExplorerPathList(String string) {
        if (this.explorerPathList == null) {
            this.explorerPathList = new ArrayList();
        }
        this.explorerPathList.add(string);
    }

    public List getExplorerPathList() {
        return this.explorerPathList;
    }

    public void setCheckApplicability(String string) {
        this.checkApplicability = string;
    }

    public String getCheckApplicability() {
        return this.checkApplicability;
    }

    public void setSeverity(CheckSeverity checkSeverity) {
        this.severity = checkSeverity;
    }

    public CheckSeverity getSeverity() {
        return this.severity;
    }

    public void setRecommendations(String string) {
        this.recommendations = string;
    }

    public String getRecommendations() {
        return this.recommendations;
    }

    public void setAnalysis(String string) {
        this.analysis = string;
    }

    public String getAnalysis() {
        return this.analysis;
    }

    public void setAutomationState(String string) {
        this.automationState = string;
    }

    public String getAutomationState() {
        return this.automationState;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setCheckState(String string) {
        this.checkState = string;
    }

    public String getCheckState() {
        return this.checkState;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setRestricted(boolean bl) {
        this.restricted = bl;
    }

    public boolean isRestricted() {
        return this.restricted;
    }

    public void setNoteList(List list) {
        this.noteList = list;
    }

    public void addToNoteList(CheckNote checkNote) {
        if (this.noteList == null) {
            this.noteList = new ArrayList();
        }
        this.noteList.add(checkNote);
    }

    public List getNoteList() {
        return this.noteList;
    }

    public void setCheckParamList(List list) {
        this.checkParamList = list;
    }

    public void addToCheckParamList(CheckParam checkParam) {
        if (this.checkParamList == null) {
            this.checkParamList = new ArrayList();
        }
        this.checkParamList.add(checkParam);
    }

    public List getCheckParamList() {
        return this.checkParamList;
    }

    public void setKceApplicability(String string) {
        this.kceApplicability = string;
    }

    public String getKceApplicability() {
        return this.kceApplicability;
    }

    public void setKceRuleAuthor(String string) {
        this.kceRuleAuthor = string;
    }

    public String getKceRuleAuthor() {
        return this.kceRuleAuthor;
    }

    public void setKceConditions(String string) {
        this.kceConditions = string;
    }

    public String getKceConditions() {
        return this.kceConditions;
    }

    public void setKceSeverity(String string) {
        this.kceSeverity = string;
    }

    public String getKceSeverity() {
        return this.kceSeverity;
    }

    public void setKceAnalysis(String string) {
        this.kceAnalysis = string;
    }

    public String getKceAnalysis() {
        return this.kceAnalysis;
    }

    public void setKceRecommendations(String string) {
        this.kceRecommendations = string;
    }

    public String getKceRecommendations() {
        return this.kceRecommendations;
    }

    public void setKceRecommendationFacts(String string) {
        this.kceRecommendationFacts = string;
    }

    public String getKceRecommendationFacts() {
        return this.kceRecommendationFacts;
    }

    public void setKceExecution(String string) {
        this.kceExecution = string;
    }

    public String getKceExecution() {
        return this.kceExecution;
    }

    public void setKeywordList(List list) {
        this.keywordList = list;
    }

    public void addToKeywordList(CheckKeyword checkKeyword) {
        if (this.keywordList == null) {
            this.keywordList = new ArrayList();
        }
        this.keywordList.add(checkKeyword);
    }

    public List getKeywordList() {
        return this.keywordList;
    }

    public void setReportSectionList(List list) {
        this.reportSectionList = list;
    }

    public void addToReportSectionList(CheckReportSection checkReportSection) {
        if (this.reportSectionList == null) {
            this.reportSectionList = new ArrayList();
        }
        this.reportSectionList.add(checkReportSection);
    }

    public List getReportSectionList() {
        return this.reportSectionList;
    }

    public void setProductList(List list) {
        this.productList = list;
        this.productCategoryList = null;
        this.productCategoryMap = null;
    }

    public void addToProductList(CheckProduct checkProduct) {
        if (this.productList == null) {
            this.productList = new ArrayList();
        }
        this.productList.add(checkProduct);
        this.productCategoryList = null;
        this.productCategoryMap = null;
    }

    public List getProductList() {
        return this.productList;
    }

    void addToExplicitProductCategoryList(String string) {
        if (this.explicitProductCategoryList == null) {
            this.explicitProductCategoryList = new ArrayList();
        }
        this.explicitProductCategoryList.add(string);
        this.productCategoryList = null;
    }

    void setExplicitProductCategoryList(List list) {
        this.explicitProductCategoryList = list;
        this.productCategoryList = null;
    }

    List getExplicitProductCategoryList() {
        return this.explicitProductCategoryList;
    }

    public List getProductCategoryList() {
        if (this.productCategoryList == null) {
            TreeSet<String> treeSet = new TreeSet<String>();
            if (this.productList != null) {
                Iterator iterator = this.productList.iterator();
                while (iterator.hasNext()) {
                    CheckProduct checkProduct = (CheckProduct)iterator.next();
                    String string = checkProduct.getProdCategory();
                    treeSet.add(string);
                }
            }
            if (this.explicitProductCategoryList != null) {
                treeSet.addAll(this.explicitProductCategoryList);
            }
            this.productCategoryList = new ArrayList(treeSet);
        }
        if (this.productCategoryList.isEmpty()) {
            return null;
        }
        return this.productCategoryList;
    }

    public Map getProductCategoryMap() {
        if (this.productList == null) {
            return null;
        }
        if (this.productCategoryMap != null) {
            return this.productCategoryMap;
        }
        this.productCategoryMap = new TreeMap();
        Iterator iterator = this.productList.iterator();
        while (iterator.hasNext()) {
            CheckProduct checkProduct = (CheckProduct)iterator.next();
            String string = checkProduct.getProdCategory();
            if (this.productCategoryMap != null && this.productCategoryMap.get(string) != null && this.productCategoryMap.get(string).equals(checkProduct)) continue;
            this.productCategoryMap.put(string, checkProduct);
        }
        return this.productCategoryMap;
    }

    public void setRefdocList(List list) {
        this.refdocList = list;
    }

    public void addToRefdocList(CheckRefdoc checkRefdoc) {
        if (this.refdocList == null) {
            this.refdocList = new ArrayList();
        }
        this.refdocList.add(checkRefdoc);
    }

    public List getRefdocList() {
        return this.refdocList;
    }

    public void setMinRequiredKaeVersion(String string) {
        this.minRequiredKaeVersion = string;
    }

    public String getMinRequiredKaeVersion() {
        return this.minRequiredKaeVersion;
    }

    public void setDbid(String string) {
        this.dbid = string;
    }

    public String getDbid() {
        return this.dbid;
    }

    public void setMetadbid(String string) {
        this.metadbid = string;
    }

    public String getMetadbid() {
        return this.metadbid;
    }

    public void setSwordfishProductList(List list) {
        this.swordfishProductList = list;
    }

    public void addToSwordfishProductList(CheckSwordfishProduct checkSwordfishProduct) {
        if (this.swordfishProductList == null) {
            this.swordfishProductList = new ArrayList();
        }
        this.swordfishProductList.add(checkSwordfishProduct);
    }

    public List getSwordfishProductList() {
        return this.swordfishProductList;
    }

    public void setAudience(String string) {
        this.audience = string;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setValidDate(Date date) {
        this.validDate = date;
    }

    public Date getValidDate() {
        return this.validDate;
    }

    public void setRevisionNumber(int n) {
        this.revisionNumber = n;
    }

    public int getRevisionNumber() {
        return this.revisionNumber;
    }

    public void setSeverityString(String string) {
        this.severity = CheckSeverity.getInstance(string);
    }

    public void setEnabledString(String string) {
        if (ENABLED_STRING.equalsIgnoreCase(string)) {
            this.enabled = true;
        } else if (DISABLED_STRING.equalsIgnoreCase(string)) {
            this.enabled = false;
        } else {
            if (string != null && !string.trim().equals(EMPTY_STRING)) {
                String string2 = MessageLocalizer.makeLMS(this, new MessageKey("checkenabledstringdoesnotparseasabooleanSettingtofalse"), "check enabled string \"" + string + "\" does not parse as a boolean. " + "Setting to false.", new Object[]{string}, null);
                logger.warning(string2);
            }
            this.enabled = false;
        }
    }

    public String getEnabledString() {
        return this.enabled ? ENABLED_STRING : DISABLED_STRING;
    }

    public void setRestrictedString(String string) {
        if (RESTRICTED_STRING.equalsIgnoreCase(string)) {
            this.restricted = true;
        } else if (NOT_RESTRICTED_STRING.equalsIgnoreCase(string)) {
            this.restricted = false;
        } else {
            if (string != null && !string.trim().equals(EMPTY_STRING)) {
                String string2 = MessageLocalizer.makeLMS(this, new MessageKey("checkrestrictedstringdoesnotparseasabooleanSettingtofalse"), "check restricted string \"" + string + "\" does not parse as a boolean. " + "Setting to false.", new Object[]{string}, null);
                logger.warning(string2);
            }
            this.restricted = false;
        }
    }

    public String getRestrictedString() {
        return this.restricted ? RESTRICTED_STRING : NOT_RESTRICTED_STRING;
    }

    public void setRevisionNumberString(String string) {
        try {
            this.revisionNumber = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (string != null && !string.trim().equals(EMPTY_STRING)) {
                String string2 = MessageLocalizer.makeLMS(this, new MessageKey("checkrevisionnumberstringdoesnotparseasanintSettingto"), "check revision number string \"" + string + "\" does not parse as an int. " + "Setting to 0.", new Object[]{string}, null);
                logger.warning(string2);
            }
            this.revisionNumber = 0;
        }
    }

    public String getRevisionNumberString() {
        return String.valueOf(this.revisionNumber);
    }

    public void fillRequiredProperties() {
        Serializable serializable;
        Iterator iterator;
        if (this.author == null) {
            this.author = EMPTY_STRING;
        }
        if (this.authorDate == null) {
            this.authorDate = new Date();
        }
        if (this.updated == null) {
            this.updated = EMPTY_STRING;
        }
        if (this.updatedDate == null) {
            this.updatedDate = new Date();
        }
        if (this.problem == null) {
            this.problem = EMPTY_STRING;
        }
        if (this.checkApplicability == null) {
            this.checkApplicability = EMPTY_STRING;
        }
        if (this.recommendations == null) {
            this.recommendations = EMPTY_STRING;
        }
        if (this.analysis == null) {
            this.analysis = EMPTY_STRING;
        }
        if (this.noteList != null) {
            iterator = this.noteList.iterator();
            while (iterator.hasNext()) {
                serializable = (CheckNote)iterator.next();
                ((CheckNote)serializable).fillRequiredProperties();
            }
        }
        if (this.checkParamList != null) {
            iterator = this.checkParamList.iterator();
            while (iterator.hasNext()) {
                serializable = (CheckParam)iterator.next();
                ((CheckParam)serializable).fillRequiredProperties();
            }
        }
        if (this.keywordList != null) {
            iterator = this.keywordList.iterator();
            while (iterator.hasNext()) {
                serializable = (CheckKeyword)iterator.next();
                ((CheckKeyword)serializable).fillRequiredProperties();
            }
        }
        if (this.reportSectionList != null) {
            iterator = this.reportSectionList.iterator();
            while (iterator.hasNext()) {
                serializable = (CheckReportSection)iterator.next();
                ((CheckReportSection)serializable).fillRequiredProperties();
            }
        }
        if (this.productList != null) {
            iterator = this.productList.iterator();
            while (iterator.hasNext()) {
                serializable = (CheckProduct)iterator.next();
                ((CheckProduct)serializable).fillRequiredProperties();
            }
        }
        if (this.refdocList != null) {
            iterator = this.refdocList.iterator();
            while (iterator.hasNext()) {
                serializable = (CheckRefdoc)iterator.next();
                ((CheckRefdoc)serializable).fillRequiredProperties();
            }
        }
        if (this.swordfishProductList != null) {
            iterator = this.swordfishProductList.iterator();
            while (iterator.hasNext()) {
                serializable = (CheckSwordfishProduct)iterator.next();
                ((CheckSwordfishProduct)serializable).fillRequiredProperties();
            }
        }
    }

    public void fillDefaults() {
        if (this.getUpdated() == null) {
            this.setUpdated(this.getAuthor());
        }
        if (this.getUpdatedDate() == null) {
            this.setUpdatedDate(this.getAuthorDate());
        }
        this.fillRequiredProperties();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        boolean bl6;
        boolean bl7;
        boolean bl8;
        boolean bl9;
        boolean bl10;
        boolean bl11;
        boolean bl12;
        boolean bl13;
        boolean bl14;
        boolean bl15;
        boolean bl16;
        boolean bl17;
        boolean bl18;
        boolean bl19;
        boolean bl20;
        boolean bl21;
        boolean bl22;
        boolean bl23;
        boolean bl24;
        boolean bl25;
        boolean bl26;
        boolean bl27;
        boolean bl28;
        boolean bl29;
        boolean bl30;
        boolean bl31;
        boolean bl32;
        boolean bl33;
        boolean bl34;
        boolean bl35;
        boolean bl36;
        if (this == object) {
            return true;
        }
        if (!(object instanceof Check)) {
            return false;
        }
        Check check = (Check)object;
        if (!this.id.equals(check.id)) return false;
        if (this.title == null) {
            if (check.title != null) return false;
            bl36 = true;
        } else {
            bl36 = this.title.equals(check.title);
        }
        if (!bl36) return false;
        if (this.author == null) {
            if (check.author != null) return false;
            bl35 = true;
        } else {
            bl35 = this.author.equals(check.author);
        }
        if (!bl35) return false;
        if (this.authorDate == null) {
            if (check.authorDate != null) return false;
            bl34 = true;
        } else {
            bl34 = this.authorDate.equals(check.authorDate);
        }
        if (!bl34) return false;
        if (this.updated == null) {
            if (check.updated != null) return false;
            bl33 = true;
        } else {
            bl33 = this.updated.equals(check.updated);
        }
        if (!bl33) return false;
        if (this.updatedDate == null) {
            if (check.updatedDate != null) return false;
            bl32 = true;
        } else {
            bl32 = this.updatedDate.equals(check.updatedDate);
        }
        if (!bl32) return false;
        if (this.application == null) {
            if (check.application != null) return false;
            bl31 = true;
        } else {
            bl31 = this.application.equals(check.application);
        }
        if (!bl31) return false;
        if (this.problem == null) {
            if (check.problem != null) return false;
            bl30 = true;
        } else {
            bl30 = this.problem.equals(check.problem);
        }
        if (!bl30) return false;
        if (this.humanRule == null) {
            if (check.humanRule != null) return false;
            bl29 = true;
        } else {
            bl29 = this.humanRule.equals(check.humanRule);
        }
        if (!bl29) return false;
        if (this.explorerPathList == null) {
            if (check.explorerPathList != null) return false;
            bl28 = true;
        } else {
            bl28 = this.explorerPathList.equals(check.explorerPathList);
        }
        if (!bl28) return false;
        if (this.checkApplicability == null) {
            if (check.checkApplicability != null) return false;
            bl27 = true;
        } else {
            bl27 = this.checkApplicability.equals(check.checkApplicability);
        }
        if (!bl27) return false;
        if (this.severity != check.severity) return false;
        if (this.recommendations == null) {
            if (check.recommendations != null) return false;
            bl26 = true;
        } else {
            bl26 = this.recommendations.equals(check.recommendations);
        }
        if (!bl26) return false;
        if (this.analysis == null) {
            if (check.analysis != null) return false;
            bl25 = true;
        } else {
            bl25 = this.analysis.equals(check.analysis);
        }
        if (!bl25) return false;
        if (this.automationState == null) {
            if (check.automationState != null) return false;
            bl24 = true;
        } else {
            bl24 = this.automationState.equals(check.automationState);
        }
        if (!bl24) return false;
        if (this.enabled != check.enabled) return false;
        if (this.checkState == null) {
            if (check.checkState != null) return false;
            bl23 = true;
        } else {
            bl23 = this.checkState.equals(check.checkState);
        }
        if (!bl23) return false;
        if (this.domain == null) {
            if (check.domain != null) return false;
            bl22 = true;
        } else {
            bl22 = this.domain.equals(check.domain);
        }
        if (!bl22) return false;
        if (this.restricted != check.restricted) return false;
        if (this.kceApplicability == null) {
            if (check.kceApplicability != null) return false;
            bl21 = true;
        } else {
            bl21 = this.kceApplicability.equals(check.kceApplicability);
        }
        if (!bl21) return false;
        if (this.kceRuleAuthor == null) {
            if (check.kceRuleAuthor != null) return false;
            bl20 = true;
        } else {
            bl20 = this.kceRuleAuthor.equals(check.kceRuleAuthor);
        }
        if (!bl20) return false;
        if (this.kceConditions == null) {
            if (check.kceConditions != null) return false;
            bl19 = true;
        } else {
            bl19 = this.kceConditions.equals(check.kceConditions);
        }
        if (!bl19) return false;
        if (this.kceSeverity == null) {
            if (check.kceSeverity != null) return false;
            bl18 = true;
        } else {
            bl18 = this.kceSeverity.equals(check.kceSeverity);
        }
        if (!bl18) return false;
        if (this.kceAnalysis == null) {
            if (check.kceAnalysis != null) return false;
            bl17 = true;
        } else {
            bl17 = this.kceAnalysis.equals(check.kceAnalysis);
        }
        if (!bl17) return false;
        if (this.kceRecommendations == null) {
            if (check.kceRecommendations != null) return false;
            bl16 = true;
        } else {
            bl16 = this.kceRecommendations.equals(check.kceRecommendations);
        }
        if (!bl16) return false;
        if (this.kceRecommendationFacts == null) {
            if (check.kceRecommendationFacts != null) return false;
            bl15 = true;
        } else {
            bl15 = this.kceRecommendationFacts.equals(check.kceRecommendationFacts);
        }
        if (!bl15) return false;
        if (this.kceExecution == null) {
            if (check.kceExecution != null) return false;
            bl14 = true;
        } else {
            bl14 = this.kceExecution.equals(check.kceExecution);
        }
        if (!bl14) return false;
        if (this.noteList == null) {
            if (check.noteList != null) return false;
            bl13 = true;
        } else {
            bl13 = this.noteList.equals(check.noteList);
        }
        if (!bl13) return false;
        if (this.checkParamList == null) {
            if (check.checkParamList != null) return false;
            bl12 = true;
        } else {
            bl12 = this.checkParamList.equals(check.checkParamList);
        }
        if (!bl12) return false;
        if (this.keywordList == null) {
            if (check.keywordList != null) return false;
            bl11 = true;
        } else {
            bl11 = this.keywordList.equals(check.keywordList);
        }
        if (!bl11) return false;
        if (this.reportSectionList == null) {
            if (check.reportSectionList != null) return false;
            bl10 = true;
        } else {
            bl10 = this.reportSectionList.equals(check.reportSectionList);
        }
        if (!bl10) return false;
        if (this.productList == null) {
            if (check.productList != null) return false;
            bl9 = true;
        } else {
            bl9 = this.productList.equals(check.productList);
        }
        if (!bl9) return false;
        if (this.getProductCategoryList() == null) {
            if (check.getProductCategoryList() != null) return false;
            bl8 = true;
        } else {
            bl8 = this.getProductCategoryList().equals(check.getProductCategoryList());
        }
        if (!bl8) return false;
        if (this.refdocList == null) {
            if (check.refdocList != null) return false;
            bl7 = true;
        } else {
            bl7 = this.refdocList.equals(check.refdocList);
        }
        if (!bl7) return false;
        if (this.minRequiredKaeVersion == null) {
            if (check.minRequiredKaeVersion != null) return false;
            bl6 = true;
        } else {
            bl6 = this.minRequiredKaeVersion.equals(check.minRequiredKaeVersion);
        }
        if (!bl6) return false;
        if (this.dbid == null) {
            if (check.dbid != null) return false;
            bl5 = true;
        } else {
            bl5 = this.dbid.equals(check.dbid);
        }
        if (!bl5) return false;
        if (this.metadbid == null) {
            if (check.metadbid != null) return false;
            bl4 = true;
        } else {
            bl4 = this.metadbid.equals(check.metadbid);
        }
        if (!bl4) return false;
        if (this.swordfishProductList == null) {
            if (check.swordfishProductList != null) return false;
            bl3 = true;
        } else {
            bl3 = this.swordfishProductList.equals(check.swordfishProductList);
        }
        if (!bl3) return false;
        if (this.audience == null) {
            if (check.audience != null) return false;
            bl2 = true;
        } else {
            bl2 = this.audience.equals(check.audience);
        }
        if (!bl2) return false;
        if (this.validDate == null) {
            if (check.validDate != null) return false;
            bl = true;
        } else {
            bl = this.validDate.equals(check.validDate);
        }
        if (!bl) return false;
        if (this.revisionNumber != check.revisionNumber) return false;
        return true;
    }

    public int hashCode() {
        int n = this.id.hashCode();
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Check[");
        stringBuffer.append("    id=").append(this.getId()).append(";\n");
        stringBuffer.append("    title=").append(this.getTitle()).append(";\n");
        stringBuffer.append("    author=").append(this.getAuthor()).append(";\n");
        stringBuffer.append("    authorDate=").append(this.getAuthorDate()).append(";\n");
        stringBuffer.append("    updated=").append(this.getUpdated()).append(";\n");
        stringBuffer.append("    updatedDate=").append(this.getUpdatedDate()).append(";\n");
        stringBuffer.append("    application=").append(this.getApplication()).append(";\n");
        stringBuffer.append("    problem=").append(this.getProblem()).append(";\n");
        stringBuffer.append("    humanRule=").append(this.getHumanRule()).append(";\n");
        stringBuffer.append("    explorerPathList=").append(this.getExplorerPathList()).append(";\n");
        stringBuffer.append("    checkApplicability=").append(this.getCheckApplicability()).append(";\n");
        stringBuffer.append("    severity=").append(this.getSeverity()).append(";\n");
        stringBuffer.append("    recommendations=").append(this.getRecommendations()).append(";\n");
        stringBuffer.append("    analysis=").append(this.getAnalysis()).append(";\n");
        stringBuffer.append("    automationState=").append(this.getAutomationState()).append(";\n");
        stringBuffer.append("    enabled=").append(this.isEnabled()).append(";\n");
        stringBuffer.append("    checkState=").append(this.getCheckState()).append(";\n");
        stringBuffer.append("    domain=").append(this.getDomain()).append(";\n");
        stringBuffer.append("    restricted=").append(this.isRestricted()).append(";\n");
        stringBuffer.append("    kceApplicability=").append(this.getKceApplicability()).append(";\n");
        stringBuffer.append("    kceRuleAuthor=").append(this.getKceRuleAuthor()).append(";\n");
        stringBuffer.append("    kceConditions=").append(this.getKceConditions()).append(";\n");
        stringBuffer.append("    kceSeverity=").append(this.getKceSeverity()).append(";\n");
        stringBuffer.append("    kceAnalysis=").append(this.getKceAnalysis()).append(";\n");
        stringBuffer.append("    kceRecommendations=").append(this.getKceRecommendations()).append(";\n");
        stringBuffer.append("    kceRecommendationFacts=").append(this.getKceRecommendationFacts()).append(";\n");
        stringBuffer.append("    kceExecution=").append(this.getKceExecution()).append(";\n");
        stringBuffer.append("    noteList=").append(this.getNoteList()).append(";\n");
        stringBuffer.append("    productList=").append(this.getProductList()).append(";\n");
        stringBuffer.append("    explicitProductCategoryList=").append(this.getExplicitProductCategoryList()).append(";\n");
        stringBuffer.append("    reportSectionList=").append(this.getReportSectionList()).append(";\n");
        stringBuffer.append("    keywordList=").append(this.getKeywordList()).append(";\n");
        stringBuffer.append("    refdocList=").append(this.getRefdocList()).append(";\n");
        stringBuffer.append("    checkParamList=").append(this.getCheckParamList()).append(";\n");
        stringBuffer.append("    minRequiredKaeVersion=").append(this.getMinRequiredKaeVersion()).append(";\n");
        stringBuffer.append("    dbid=").append(this.getDbid()).append(";\n");
        stringBuffer.append("    metadbid=").append(this.getMetadbid()).append(";\n");
        stringBuffer.append("    swordfishProductList=").append(this.getSwordfishProductList()).append(";\n");
        stringBuffer.append("    audience=").append(this.getAudience()).append(";\n");
        stringBuffer.append("    validDate=").append(this.getValidDate()).append(";\n");
        stringBuffer.append("    revisionNumber=").append(this.getRevisionNumber()).append(";\n");
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

