/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.ssl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.ObjectNotFoundException;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.ssl.SSLCertificateApprovalCallback;
import org.mozilla.jss.ssl.SSLClientCertificateSelectionCallback;
import org.mozilla.jss.ssl.SocketProxy;
import org.mozilla.jss.util.Assert;

class SocketBase {
    private SocketProxy sockProxy;
    private int timeout;
    static final int SSL_ENABLE_SSL2 = 0;
    static final int SSL_ENABLE_SSL3 = 1;
    static final int TCP_NODELAY = 2;
    static final int SO_KEEPALIVE = 3;
    static final int PR_SHUTDOWN_RCV = 4;
    static final int PR_SHUTDOWN_SEND = 5;
    static final int SSL_REQUIRE_CERTIFICATE = 6;
    static final int SSL_REQUEST_CERTIFICATE = 7;
    static final int SSL_NO_CACHE = 8;
    static final int SSL_POLICY_DOMESTIC = 9;
    static final int SSL_POLICY_EXPORT = 10;
    static final int SSL_POLICY_FRANCE = 11;
    private boolean requestingClientAuth = false;
    static /* synthetic */ Class class$java$lang$String;

    SocketBase() {
    }

    int getTimeout() {
        return this.timeout;
    }

    void setTimeout(int n) {
        this.timeout = n;
    }

    void setProxy(SocketProxy socketProxy) {
        this.sockProxy = socketProxy;
    }

    native byte[] socketCreate(Object var1, SSLCertificateApprovalCallback var2, SSLClientCertificateSelectionCallback var3, Socket var4, String var5) throws SocketException;

    byte[] socketCreate(Object object, SSLCertificateApprovalCallback sSLCertificateApprovalCallback, SSLClientCertificateSelectionCallback sSLClientCertificateSelectionCallback) throws SocketException {
        return this.socketCreate(object, sSLCertificateApprovalCallback, sSLClientCertificateSelectionCallback, null, null);
    }

    native void socketBind(byte[] var1, int var2) throws SocketException;

    void close() throws IOException {
        this.socketClose();
    }

    synchronized native void socketClose() throws IOException;

    void requestClientAuth(boolean bl) throws SocketException {
        this.requestingClientAuth = bl;
        this.setSSLOption(7, bl);
    }

    public void requestClientAuthNoExpiryCheck(boolean bl) throws SocketException {
        this.requestingClientAuth = bl;
        this.requestClientAuthNoExpiryCheckNative(bl);
    }

    private native void requestClientAuthNoExpiryCheckNative(boolean var1) throws SocketException;

    void enableSSL2(boolean bl) throws SocketException {
        this.setSSLOption(0, bl);
    }

    void enableSSL3(boolean bl) throws SocketException {
        this.setSSLOption(1, bl);
    }

    void setSSLOption(int n, boolean bl) throws SocketException {
        this.setSSLOption(n, bl ? 1 : 0);
    }

    native void setSSLOption(int var1, int var2) throws SocketException;

    private static InetAddress convertIntToInetAddress(int n) {
        InetAddress inetAddress;
        int[] nArray = new int[]{n >>> 24 & 0xFF, n >>> 16 & 0xFF, n >>> 8 & 0xFF, n & 0xFF};
        try {
            inetAddress = InetAddress.getByName(nArray[0] + "." + nArray[1] + "." + nArray[2] + "." + nArray[3]);
        }
        catch (UnknownHostException unknownHostException) {
            inetAddress = null;
        }
        return inetAddress;
    }

    InetAddress getInetAddress() {
        try {
            return SocketBase.convertIntToInetAddress(this.getPeerAddressNative());
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    private native int getPeerAddressNative() throws SocketException;

    InetAddress getLocalAddress() {
        try {
            return SocketBase.convertIntToInetAddress(this.getLocalAddressNative());
        }
        catch (SocketException socketException) {
            return null;
        }
    }

    private native int getLocalAddressNative() throws SocketException;

    public int getLocalPort() {
        try {
            return this.getLocalPortNative();
        }
        catch (SocketException socketException) {
            return 0;
        }
    }

    private native int getLocalPortNative() throws SocketException;

    void requireClientAuth(boolean bl, boolean bl2) throws SocketException {
        if (bl && !this.requestingClientAuth) {
            this.requestClientAuth(true);
        }
        this.setSSLOption(6, bl ? (bl2 ? 1 : 2) : 0);
    }

    public void setClientCertNickname(String string) throws SocketException {
        try {
            this.setClientCert(CryptoManager.getInstance().findCertByNickname(string));
        }
        catch (CryptoManager.NotInitializedException notInitializedException) {
            throw new SocketException("CryptoManager not initialized");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new SocketException("Object not found: " + objectNotFoundException);
        }
        catch (TokenException tokenException) {
            throw new SocketException("Token Exception: " + tokenException);
        }
    }

    native void setClientCert(X509Certificate var1) throws SocketException;

    void useCache(boolean bl) throws SocketException {
        this.setSSLOption(8, !bl);
    }

    static Throwable processExceptions(Throwable throwable, Throwable throwable2) {
        try {
            StringBuffer stringBuffer = new StringBuffer(throwable.toString());
            if (throwable2 != null) {
                stringBuffer.append(" --> ");
                stringBuffer.append(throwable2.toString());
            }
            Class<?> clazz = throwable.getClass();
            Class clazz2 = class$java$lang$String == null ? (class$java$lang$String = SocketBase.class$("java.lang.String")) : class$java$lang$String;
            Constructor<?> constructor = clazz.getConstructor(clazz2);
            return (Throwable)constructor.newInstance(stringBuffer.toString());
        }
        catch (Exception exception) {
            Assert.notReached("Problem constructing exception container");
            return throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

