/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkix.primitive;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkix.primitive.AVA;
import org.mozilla.jss.pkix.primitive.TooFewElementsException;

public class RDN
implements ASN1Value {
    private SET avas;
    public static final Tag TAG = SET.TAG;

    private RDN() {
    }

    public RDN(AVA aVA) {
        this.avas = new SET();
        this.avas.addElement(aVA);
    }

    RDN(SET sET) {
        this.avas = sET;
    }

    public void add(AVA aVA) {
        this.avas.addElement(aVA);
    }

    public AVA at(int n) {
        return (AVA)this.avas.elementAt(n);
    }

    public void removeAt(int n) throws TooFewElementsException {
        if (this.avas.size() <= 1) {
            throw new TooFewElementsException();
        }
        this.avas.removeElementAt(n);
    }

    public int size() {
        return this.avas.size();
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.avas.encode(outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.avas.encode(tag, outputStream);
    }

    public static class Template
    implements ASN1Template {
        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            AVA.Template template = new AVA.Template();
            SET.OF_Template oF_Template = new SET.OF_Template(template);
            SET sET = (SET)oF_Template.decode(tag, inputStream);
            if (sET.size() < 1) {
                throw new InvalidBERException("RDN with zero elements; an RDN must have at least one element");
            }
            return new RDN(sET);
        }
    }
}

