/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs12;

import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.crypto.BadPaddingException;
import org.mozilla.jss.crypto.IllegalBlockSizeException;
import org.mozilla.jss.crypto.PBEAlgorithm;
import org.mozilla.jss.crypto.TokenException;
import org.mozilla.jss.pkcs12.PasswordConverter;
import org.mozilla.jss.pkcs12.SafeBag;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkcs7.EncryptedContentInfo;
import org.mozilla.jss.pkcs7.EncryptedData;
import org.mozilla.jss.util.Assert;
import org.mozilla.jss.util.Password;

public class AuthenticatedSafes
implements ASN1Value {
    private SEQUENCE sequence;
    public static final int DEFAULT_ITERATIONS = 1;
    private static final int SALT_LENGTH = 20;
    public static final PBEAlgorithm DEFAULT_KEY_GEN_ALG = PBEAlgorithm.PBE_SHA1_RC2_40_CBC;
    private static final boolean ACCEPT_SECURITY_DYNAMICS = false;
    private static final Tag TAG = SEQUENCE.TAG;
    private static final Template templateInstance = new Template();

    public AuthenticatedSafes() {
        this.sequence = new SEQUENCE();
    }

    public AuthenticatedSafes(SEQUENCE sEQUENCE) {
        if (sEQUENCE == null) {
            throw new IllegalArgumentException("parameter is null");
        }
        this.sequence = sEQUENCE;
    }

    public SEQUENCE getSequence() {
        return this.sequence;
    }

    public int getSize() {
        return this.sequence.size();
    }

    public boolean safeContentsIsEncrypted(int n) {
        ContentInfo contentInfo = (ContentInfo)this.sequence.elementAt(n);
        return contentInfo.getContentType().equals(ContentInfo.ENCRYPTED_DATA);
    }

    public SEQUENCE getSafeContentsAt(Password password, int n) throws IllegalStateException, CryptoManager.NotInitializedException, NoSuchAlgorithmException, InvalidBERException, IOException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, IllegalBlockSizeException, BadPaddingException {
        ContentInfo contentInfo = (ContentInfo)this.sequence.elementAt(n);
        if (contentInfo.getContentType().equals(ContentInfo.ENCRYPTED_DATA)) {
            if (password == null) {
                throw new IllegalStateException("No password to decode encrypted SafeContents");
            }
            EncryptedContentInfo encryptedContentInfo = ((EncryptedData)contentInfo.getInterpretedContent()).getEncryptedContentInfo();
            byte[] byArray = encryptedContentInfo.decrypt(password, new PasswordConverter());
            SEQUENCE.OF_Template oF_Template = new SEQUENCE.OF_Template(SafeBag.getTemplate());
            return (SEQUENCE)ASN1Util.decode(oF_Template, byArray);
        }
        if (contentInfo.getContentType().equals(ContentInfo.DATA)) {
            SEQUENCE.OF_Template oF_Template = new SEQUENCE.OF_Template(SafeBag.getTemplate());
            return (SEQUENCE)ASN1Util.decode(oF_Template, ((OCTET_STRING)contentInfo.getInterpretedContent()).toByteArray());
        }
        throw new InvalidBERException("AuthenticatedSafes element is neither a Data or an EncryptedData");
    }

    static void print_byte_array(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            if (n > 25) {
                System.out.println("");
                n = 0;
            }
            System.out.print(Integer.toHexString(byArray[n2] & 0xFF) + " ");
            ++n2;
            ++n;
        }
        System.out.println("");
    }

    public void addSafeContents(SEQUENCE sEQUENCE) {
        AuthenticatedSafes.checkSafeContents(sEQUENCE);
        ContentInfo contentInfo = new ContentInfo(ASN1Util.encode(sEQUENCE));
        this.sequence.addElement(contentInfo);
    }

    private static void checkSafeContents(SEQUENCE sEQUENCE) {
        int n = sEQUENCE.size();
        int n2 = 0;
        while (n2 < n) {
            if (!(sEQUENCE.elementAt(n2) instanceof SafeBag)) {
                throw new IllegalArgumentException("Element " + n2 + " of SafeContents is not a SafeBag");
            }
            ++n2;
        }
    }

    public void addEncryptedSafeContents(PBEAlgorithm pBEAlgorithm, Password password, byte[] byArray, int n, SEQUENCE sEQUENCE) throws CryptoManager.NotInitializedException, InvalidKeyException, InvalidAlgorithmParameterException, TokenException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException {
        try {
            Object object;
            if (byArray == null) {
                object = CryptoManager.getInstance().createPseudoRandomNumberGenerator();
                byArray = new byte[20];
                object.nextBytes(byArray);
            }
            object = EncryptedContentInfo.createPBE(pBEAlgorithm, password, byArray, n, new PasswordConverter(), ASN1Util.encode(sEQUENCE));
            EncryptedData encryptedData = new EncryptedData((EncryptedContentInfo)object);
            ContentInfo contentInfo = new ContentInfo(encryptedData);
            this.sequence.addElement(contentInfo);
        }
        catch (CharConversionException charConversionException) {
            Assert.notReached("CharConversionException while converting password");
        }
    }

    public Tag getTag() {
        return TAG;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(TAG, outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.OF_Template seqt = new SEQUENCE.OF_Template(ContentInfo.getTemplate());

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        public ASN1Value decode(InputStream inputStream) throws InvalidBERException, IOException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws InvalidBERException, IOException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            return new AuthenticatedSafes(sEQUENCE);
        }
    }
}

