/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.hds.service;

import com.sun.jade.apps.discovery.Probe;
import com.sun.jade.device.protocol.snmp.SNMP;
import com.sun.jade.device.protocol.snmp.SNMPWalk;
import com.sun.jade.util.log.Report;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class HDSProbe
implements Probe {
    private boolean verbose;
    private static String probeType = "hdss";
    private static String[] propertyNames = new String[]{"ip", "serialNumber", "model"};
    private static String SERIAL_NUMBER = "1.3.6.1.4.1.116.5.11.4.1.1.5.1.1";
    private static String PROCESSOR = "1.3.6.1.4.1.116.5.11.4.1.1.5.1.2";
    public static final String sccs_id = "@(#)HDSProbe.java\t1.7 10/10/02 SMI";

    public Iterator probe(String string) {
        Report.trace.log((Object)string);
        ArrayList<Properties> arrayList = new ArrayList<Properties>();
        SNMP sNMP = new SNMP(5000);
        Iterator iterator = sNMP.probe(string);
        while (iterator != null && iterator.hasNext()) {
            InetAddress inetAddress;
            Properties properties = (Properties)iterator.next();
            String string2 = properties.getProperty("sysDescr");
            if (string2 == null) {
                string2 = "-";
            }
            if (!string2.startsWith("RAID400") && !string2.startsWith("RAID450")) continue;
            Properties properties2 = new Properties();
            String string3 = properties.getProperty("ip");
            String string4 = properties.getProperty("ipno");
            if (string3 != null) {
                properties2.setProperty("ip", string3);
            }
            if (string4 != null) {
                properties2.setProperty("ipno", string4);
            } else {
                try {
                    inetAddress = InetAddress.getByName(string3);
                    properties2.setProperty("ipno", inetAddress.getHostAddress());
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
            inetAddress = new SNMPWalk(string4 != null ? string4 : string3);
            String string5 = null;
            HashMap hashMap = null;
            hashMap = inetAddress.getProperties(SERIAL_NUMBER, PROCESSOR);
            Iterator iterator2 = hashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                String string6 = (String)iterator2.next();
                if (!string6.startsWith(SERIAL_NUMBER)) continue;
                string5 = (String)hashMap.get(string6);
                break;
            }
            if (string5 == null) continue;
            properties2.setProperty("name", string3);
            properties2.setProperty("logicalName", string3);
            properties2.setProperty("serialNumber", string5);
            properties2.setProperty("type", "hds");
            if (string2.startsWith("RAID400")) {
                properties2.setProperty("model", "9960");
            } else if (string2.startsWith("RAID450")) {
                properties2.setProperty("model", "9980");
            } else if (string2.startsWith("RAID450")) {
                properties2.setProperty("model", "9980");
            }
            arrayList.add(properties2);
        }
        return arrayList.iterator();
    }

    public String getProbeType() {
        return probeType;
    }

    public String[] getProbeProperties() {
        return propertyNames;
    }

    public static void main(String[] stringArray) {
        HDSProbe hDSProbe = new HDSProbe();
        hDSProbe.verbose = true;
        Iterator iterator = hDSProbe.probe(stringArray[0]);
        while (iterator.hasNext()) {
            Properties properties = (Properties)iterator.next();
            properties.list(System.out);
        }
        System.exit(0);
    }
}

