/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.hds.service;

import com.sun.jade.device.array.hds.service.HDSMF;
import com.sun.jade.device.array.hds.service.HDSReportGenerator;
import com.sun.jade.logic.mf.AbstractMF;
import com.sun.jade.util.locale.LocalizedMessage;
import com.sun.jade.util.locale.LocalizedString;
import java.net.InetAddress;
import java.util.Properties;

public class HDSMFImpl
extends AbstractMF
implements HDSMF {
    private String wwn;
    private String ip;
    private String ipno;
    private InetAddress iaddr;
    private String type;
    private String model;

    public HDSMFImpl(Properties properties) {
        super(properties);
        this.type = properties.getProperty("type");
        if (!"hds".equals(this.type)) {
            throw new IllegalArgumentException("Unknown type " + this.type);
        }
        this.ip = this.resolveIP(properties);
        this.ipno = properties.getProperty("ipno");
        this.model = properties.getProperty("MODEL");
        this.setDeviceReport(new HDSReportGenerator(properties));
    }

    public String getClassName() {
        return "StorEdge9900_System";
    }

    public String getName() {
        return this.getProperties().getProperty("name");
    }

    public String getIPAddr() {
        return this.ip;
    }

    public String getIPNum() {
        return this.ipno;
    }

    public String getType() {
        return this.type;
    }

    public LocalizedMessage getCaption() {
        return new LocalizedString(this.getProperties().getProperty("logicalName"));
    }

    public LocalizedMessage getDescription() {
        String string = "Sun ";
        if (this.model == null) {
            this.model = "StorEdge 9900";
        }
        return new LocalizedString(string + this.model);
    }

    protected void shutdown() {
    }
}

