/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.device.array.t3;

import com.sun.jade.logic.mf.MF;
import com.sun.netstorage.mgmt.esm.logic.device.component.instrumentation.InstrumentationComponent;
import java.rmi.RemoteException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Properties;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class SMISInstrumentation
implements InstrumentationComponent {
    private MF device;
    private String nameSpace;
    private String host;
    private String user;
    private String pass;
    public static final String sccs_id = "@(#)SMISInstrumentation.java\t1.4 04/07/03 SMI";

    public static SMISInstrumentation createComponent(MF mF, Properties properties) {
        return new SMISInstrumentation(mF, properties);
    }

    public SMISInstrumentation(MF mF, Properties properties) {
        this.nameSpace = properties.getProperty("CIM_NAMESPACE");
        this.device = mF;
        try {
            Properties properties2 = mF.getProperties();
            this.host = properties2.getProperty("wbem.ip");
            this.user = properties2.getProperty("wbem.user");
            this.pass = properties2.getProperty("wbem.password");
        }
        catch (RemoteException remoteException) {}
    }

    public String doBaseline() {
        CIMNameSpace cIMNameSpace = new CIMNameSpace(this.host, this.nameSpace);
        UserPrincipal userPrincipal = new UserPrincipal(this.user);
        PasswordCredential passwordCredential = new PasswordCredential(this.pass);
        try {
            CIMClient cIMClient = new CIMClient(cIMNameSpace, (Principal)userPrincipal, (Object)passwordCredential, "cim-xml");
            return this.poolBaseline(cIMClient);
        }
        catch (CIMException cIMException) {
            return "";
        }
    }

    private String poolBaseline(CIMClient cIMClient) throws CIMException {
        StringBuffer stringBuffer = new StringBuffer();
        CIMObjectPath cIMObjectPath = new CIMObjectPath("SunStorEdge_T3StoragePool");
        try {
            String string = this.device.getClassName();
            String string2 = this.device.getName();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        Enumeration enumeration = cIMClient.enumerateInstances(cIMObjectPath, true, false, true, true, null);
        while (enumeration.hasMoreElements()) {
            CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
            this.addPool(cIMInstance, stringBuffer);
        }
        return stringBuffer.toString();
    }

    private String getPropString(CIMInstance cIMInstance, String string) {
        CIMProperty cIMProperty = cIMInstance.getProperty(string);
        if (cIMProperty == null) {
            return null;
        }
        CIMValue cIMValue = cIMProperty.getValue();
        if (cIMValue == null) {
            return null;
        }
        return cIMValue.toString();
    }

    private String itemString(CIMInstance cIMInstance, String string) {
        return "\t<item name='" + string + "' value='" + this.getPropString(cIMInstance, string) + "'/>\n";
    }

    private void addPool(CIMInstance cIMInstance, StringBuffer stringBuffer) {
        stringBuffer.append("<MSE classname='SunStorEdge_T3StoragePool' ");
        stringBuffer.append("keyname='DeviceID' ");
        stringBuffer.append("keyvalue='" + this.getPropString(cIMInstance, "InstanceID") + "'>/n");
        stringBuffer.append("<view type='Asset'>\n");
        stringBuffer.append(this.itemString(cIMInstance, "Caption"));
        stringBuffer.append(this.itemString(cIMInstance, "Description"));
        stringBuffer.append(this.itemString(cIMInstance, "VolumeCount"));
        stringBuffer.append(this.itemString(cIMInstance, "Name"));
        stringBuffer.append(this.itemString(cIMInstance, "PoolID"));
        stringBuffer.append(this.itemString(cIMInstance, "InstanceID"));
        stringBuffer.append(this.itemString(cIMInstance, "TotalAvailableSpace"));
        stringBuffer.append("</view>\n");
        stringBuffer.append("<view type='Health'>\n");
        stringBuffer.append(this.itemString(cIMInstance, "OperationStatus"));
        stringBuffer.append(this.itemString(cIMInstance, "PoolStatus"));
        stringBuffer.append(this.itemString(cIMInstance, "OnLinePool"));
        stringBuffer.append("</view>\n");
        stringBuffer.append("</MSE>");
    }
}

