/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.array.t3.diags;

import com.sun.jade.apps.diags.lib.DiagUtil;
import com.sun.jade.cim.diag.DiagnosticException;
import com.sun.jade.cim.diag.DiagnosticResult;
import com.sun.jade.cim.diag.DiagnosticSetting;
import com.sun.jade.cim.diag.TestExecutableImpl;
import com.sun.jade.cim.diag.TestParameter;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.cim.util.TestState;
import com.sun.jade.device.array.t3.diags.Messages;
import com.sun.jade.device.array.t3.io.T3Exception;
import com.sun.jade.device.array.t3.io.T3FtpConnection;
import com.sun.jade.device.array.t3.io.T3HttpConnection;
import com.sun.jade.device.array.t3.io.T3System;
import com.sun.jade.device.array.t3.io.T3Token;
import com.sun.jade.device.array.t3.io.T3TokenList;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.locale.Localizer;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.io.PrintWriter;
import java.io.StringWriter;

public class BackEndLoopExecutable
extends TestExecutableImpl {
    private static final int HEALTH_CHECK_TIMEOUT = 20;
    private static final int FAST_FIND_TIMEOUT = 20;
    private static final int FIND_TIMEOUT = 120;
    private static final int HEALTH_CHECK_RUNTIME = 5;
    private static final int FAST_FIND_RUNTIME = 5;
    private static final int FIND_RUNTIME = 60;
    private static final long MILLIS_IN_MINUTE = 60000L;
    private long currentTestStartTime;
    private long currentTestEstimatedCompletionTime;
    private static final Localizer msgs = Messages.getLocalizer();
    private static final int POLL_INTERVAL = 30;
    private static final String LOG_TAG = "T3";
    private T3HttpConnection t3 = null;
    private T3System t3Sys;
    private DiagnosticResult result;
    private boolean abort = false;
    private boolean isRunning = false;
    private boolean testing = false;
    private boolean debug = true;
    private String diagName = "fastFind";
    private String userName;
    private String password;
    private String ip;
    private int numUnits;
    private int unit = 0;
    private int loop = 0;
    private T3TokenList firstOfdgOper;
    private T3TokenList ofdgoper;
    public static final String sccs_id = "@(#)BackEndLoopExecutable.java\t1.3 12/02/02 SMI";

    BackEndLoopExecutable(ReferenceForMSE referenceForMSE, DiagnosticSetting diagnosticSetting) {
        super(referenceForMSE, diagnosticSetting);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void runTest(DiagnosticResult diagnosticResult) throws DiagnosticException {
        block37: {
            block35: {
                block34: {
                    block33: {
                        block32: {
                            block31: {
                                this.isRunning = true;
                                this.result = diagnosticResult;
                                this.parseSettings();
                                if (null == this.ip || "".equals(this.ip)) {
                                    diagnosticResult.setFinalResults(TestState.FAILED, msgs.getString("oob.noipaddr"));
                                    return;
                                }
                                try {
                                    try {
                                        block36: {
                                            String string;
                                            boolean bl;
                                            block38: {
                                                String string2;
                                                boolean bl2;
                                                block40: {
                                                    String string3;
                                                    block39: {
                                                        if (this.reportStatus) {
                                                            diagnosticResult.addTestResults(msgs.getString("ofdg.msg.starting"));
                                                            diagnosticResult.update();
                                                        }
                                                        this.t3 = new T3HttpConnection(this.ip);
                                                        this.t3.setAuthentication(this.userName, this.password);
                                                        this.firstOfdgOper = this.t3.getTokenList("/ofdgoper.htm");
                                                        String string4 = this.checkForOFDGOperation(this.firstOfdgOper);
                                                        if (string4 != null) {
                                                            diagnosticResult.addTestResults(msgs.getFormattedString("ofdg.diag.conflict", (Object)string4));
                                                            diagnosticResult.setFinalResults(TestState.FAILED);
                                                            Object var15_4 = null;
                                                            this.isRunning = false;
                                                            this.abort = false;
                                                            return;
                                                        }
                                                        if (this.reportStatus) {
                                                            diagnosticResult.addTestResults(msgs.getString("ofdg.msg.noConflictOp"));
                                                            diagnosticResult.update();
                                                        }
                                                        this.setPercentComplete(1);
                                                        this.checkAbort();
                                                        if (this.reportStatus) {
                                                            diagnosticResult.addTestResults(msgs.getString("ofdg.msg.arrayState"));
                                                            diagnosticResult.update();
                                                        }
                                                        this.t3Sys = new T3System(this.ip);
                                                        if (!this.checkSystem()) {
                                                            break block31;
                                                        }
                                                        this.setPercentComplete(2);
                                                        this.checkAbort();
                                                        this.startHealthTest();
                                                        String string5 = this.waitForResult(5, 25, 20);
                                                        String string6 = this.getLastOFDGLog();
                                                        diagnosticResult.addTestResults(msgs.getFormattedString("ofdg.healthCheck.output", (Object)string6));
                                                        int n = BackEndLoopExecutable.parseHealthCheck(string5);
                                                        if (n == 0) {
                                                            diagnosticResult.addTestResults(msgs.getString("ofdg.passed"));
                                                            diagnosticResult.setFinalResults(TestState.PASSED);
                                                            break block32;
                                                        }
                                                        if (n == 1) {
                                                            this.loop = 1;
                                                            if (this.haltOnError) {
                                                                diagnosticResult.addTestResults(msgs.getString("ofdg.healthCheck.errorFoundHalt"));
                                                                diagnosticResult.setFinalResults(TestState.FAILED);
                                                                break block33;
                                                            }
                                                        } else if (n == 2) {
                                                            this.loop = 2;
                                                            if (this.haltOnError) {
                                                                diagnosticResult.addTestResults(msgs.getString("ofdg.healthCheck.errorFoundHalt"));
                                                                diagnosticResult.setFinalResults(TestState.FAILED);
                                                                break block34;
                                                            }
                                                        } else if (n > 2) {
                                                            diagnosticResult.addTestResults(msgs.getString("ofdg.healthCheck.failBothPaths"));
                                                            diagnosticResult.setFinalResults(TestState.FAILED);
                                                            break block35;
                                                        }
                                                        String string7 = "";
                                                        string7 = this.startDiag(1, this.loop, 25, 60);
                                                        string3 = this.getLastOFDGLog();
                                                        diagnosticResult.addTestResults(msgs.getFormattedString("ofdg." + this.diagName + ".output", (Object)string3));
                                                        bl = this.isStatusPassed(this.getStatus(string3));
                                                        string = this.getBadFruList(string3);
                                                        if (this.numUnits <= 1) break block38;
                                                        if (!this.unitFailure(1, string3)) break block39;
                                                        if (string != null) {
                                                            diagnosticResult.addTestResults(msgs.getFormattedString("ofdg.diag.failNearFrus", (Object)string));
                                                            break block36;
                                                        } else {
                                                            diagnosticResult.addTestResults(msgs.getString("ofdg.diag.failNear"));
                                                        }
                                                        break block36;
                                                    }
                                                    String string8 = this.startDiag(1, this.loop, 60, 95);
                                                    String string9 = this.getLastOFDGLog();
                                                    diagnosticResult.addTestResults(msgs.getFormattedString("ofdg." + this.diagName + ".output", (Object)string3));
                                                    bl2 = this.isStatusPassed(this.getStatus(string9));
                                                    string2 = this.getBadFruList(string9);
                                                    if (bl || bl2) break block40;
                                                    diagnosticResult.addTestResults(msgs.getFormattedString("ofdg.fail.multi", (Object)string3, (Object)string9));
                                                    break block36;
                                                }
                                                if (!bl) {
                                                    this.reportError(bl, string);
                                                    break block36;
                                                } else if (!bl2) {
                                                    this.reportError(bl, string2);
                                                    break block36;
                                                } else {
                                                    diagnosticResult.addTestResults(msgs.getString("ofdg." + this.diagName + ".go"));
                                                }
                                                break block36;
                                            }
                                            this.reportError(bl, string);
                                        }
                                        diagnosticResult.setFinalResults(TestState.FAILED);
                                        break block37;
                                    }
                                    catch (T3Exception t3Exception) {
                                        String string = t3Exception.getError();
                                        if (!"t3.exception.aborted".equals(string)) {
                                            LocalizedString localizedString = new LocalizedString((Exception)t3Exception);
                                            diagnosticResult.addTestResults(localizedString.toString());
                                            diagnosticResult.setFinalResults(TestState.FAILED);
                                            Object var15_12 = null;
                                            this.isRunning = false;
                                            this.abort = false;
                                            return;
                                        }
                                        if (!diagnosticResult.isTestCompleted()) {
                                            if (this.reportStatus) {
                                                diagnosticResult.addTestResults(msgs.getString("ofdg.aborted"));
                                            }
                                            diagnosticResult.setFinalResults(TestState.STOPPED);
                                        }
                                        Object var15_11 = null;
                                        this.isRunning = false;
                                        this.abort = false;
                                        return;
                                    }
                                    catch (DiagnosticException diagnosticException) {
                                        LocalizedString localizedString = new LocalizedString((Exception)((Object)diagnosticException));
                                        diagnosticResult.addTestResults(localizedString.toString());
                                        diagnosticResult.setFinalResults(diagnosticException.getTestState());
                                        Object var15_13 = null;
                                        this.isRunning = false;
                                        this.abort = false;
                                        return;
                                    }
                                    catch (Exception exception) {
                                        StringWriter stringWriter;
                                        if (this.debug) {
                                            stringWriter = new StringWriter();
                                            PrintWriter printWriter = new PrintWriter(stringWriter);
                                            exception.printStackTrace(printWriter);
                                            diagnosticResult.addTestResults(stringWriter.toString());
                                        }
                                        stringWriter = new LocalizedString(exception);
                                        diagnosticResult.addTestResults(stringWriter.toString());
                                        stringWriter = new DiagnosticException().getLocalizedString();
                                        diagnosticResult.addTestResults(stringWriter.toString());
                                        diagnosticResult.setFinalResults(TestState.FAILED);
                                        Object var15_14 = null;
                                        this.isRunning = false;
                                        this.abort = false;
                                        return;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var15_15 = null;
                                    this.isRunning = false;
                                    this.abort = false;
                                    throw throwable;
                                }
                            }
                            Object var15_5 = null;
                            this.isRunning = false;
                            this.abort = false;
                            return;
                        }
                        Object var15_6 = null;
                        this.isRunning = false;
                        this.abort = false;
                        return;
                    }
                    Object var15_7 = null;
                    this.isRunning = false;
                    this.abort = false;
                    return;
                }
                Object var15_8 = null;
                this.isRunning = false;
                this.abort = false;
                return;
            }
            Object var15_9 = null;
            this.isRunning = false;
            this.abort = false;
            return;
        }
        Object var15_10 = null;
        this.isRunning = false;
        this.abort = false;
    }

    public synchronized boolean abortTest() throws DiagnosticException {
        if (this.debug) {
            this.result.addTestResults("DEBUG: abortTest called");
        }
        if (!this.isRunning || this.abort) {
            return false;
        }
        if (this.reportStatus) {
            if (this.currentTestEstimatedCompletionTime == 0L) {
                this.result.addTestResults(msgs.getString("ofdg.msg.aborting"));
            } else {
                long l = this.currentTestEstimatedCompletionTime - System.currentTimeMillis();
                if (l < 0L) {
                    this.result.addTestResults(msgs.getString("ofdg.msg.aborting"));
                } else {
                    int n = (int)(l / 60000L);
                    this.result.addTestResults(msgs.getFormattedString("ofdg.msg.abortingTime", (Object)new Integer(++n)));
                }
            }
            this.result.update();
        }
        this.abort = true;
        return true;
    }

    private synchronized void checkAbort() throws DiagnosticException {
        if (this.abort) {
            DiagnosticException diagnosticException = new DiagnosticException(msgs.getLocalizedString("ofdg.aborted"));
            diagnosticException.setTestState(TestState.STOPPED);
            throw diagnosticException;
        }
    }

    private boolean checkSystem() throws T3Exception, DiagnosticException {
        int n;
        this.t3Sys.updateSystem();
        T3TokenList t3TokenList = this.t3Sys.getSystemProperties();
        T3TokenList[] t3TokenListArray = this.t3Sys.getUnitProperties();
        this.numUnits = t3TokenListArray.length;
        if (this.numUnits > 1) {
            n = 1;
            while (n <= 9) {
                if (!this.checkDiskAssignedToVolume(t3TokenListArray[1], "u2d" + n)) {
                    this.result.addTestResults(msgs.getString("ofdg.u1disk.notAssigned"));
                    this.result.setFinalResults(TestState.FAILED);
                    return false;
                }
                ++n;
            }
        }
        if (!this.checkVolumeOperation(1, 1)) {
            return false;
        }
        if (!this.checkVolumeOperation(1, 2)) {
            return false;
        }
        if (this.numUnits > 1) {
            if (!this.checkVolumeOperation(2, 1)) {
                return false;
            }
            if (!this.checkVolumeOperation(2, 2)) {
                return false;
            }
        }
        n = 0;
        while (n < t3TokenListArray.length) {
            this.checkLoops(t3TokenListArray[n], "u" + (n + 1) + "l1");
            this.checkLoops(t3TokenListArray[n], "u" + (n + 1) + "l2");
            ++n;
        }
        return true;
    }

    private boolean checkLoops(T3TokenList t3TokenList, String string) throws T3Exception, DiagnosticException {
        boolean bl = true;
        if (this.warnLevel == 1) {
            return bl;
        }
        if (!t3TokenList.assertCondition(string, "fruStatus", "ready")) {
            this.result.addTestResults(msgs.getFormattedString("ofdg.loopNotReady", new Object[]{string}));
            bl = false;
        }
        if (!t3TokenList.assertCondition(string, "fruState", "enabled")) {
            this.result.addTestResults(msgs.getFormattedString("ofdg.loopNotReady", new Object[]{string}));
            bl = false;
        }
        return bl;
    }

    private boolean checkDiskAssignedToVolume(T3TokenList t3TokenList, String string) {
        String string2 = t3TokenList.getStringValue(string, "fruDiskVolIndex");
        String string3 = t3TokenList.getStringValue(string, "fruDiskVolId");
        String string4 = t3TokenList.getStringValue(string, "fruDiskVolName");
        if (string2 == null) {
            return false;
        }
        if (string3 == null) {
            return false;
        }
        return string4 != null;
    }

    private boolean checkVolumeOperation(int n, int n2) throws T3Exception {
        T3TokenList t3TokenList = this.t3Sys.getCurrentVolumeOperation(n - 1, n2 - 1);
        String string = t3TokenList.getStringValue("u" + n + "vol" + n2);
        if (string != null) {
            this.result.addTestResults(msgs.getFormattedString("ofdg.volop.conflict", (Object)string, (Object)new Integer(n), (Object)new Integer(n2)));
            this.result.setFinalResults(TestState.FAILED);
            return false;
        }
        return true;
    }

    private void setPercentComplete(int n) {
        this.result.setPercentComplete((short)n);
    }

    private void setPercentComplete(int n, int n2, int n3) {
        int n4 = n3 - n2;
        int n5 = n * n4 / 100;
        this.result.setPercentComplete((short)(n5 + n2));
    }

    private void startHealthTest() throws T3Exception, DiagnosticException {
        this.checkAbort();
        if (this.reportStatus) {
            this.result.addTestResults(msgs.getString("ofdg.healthCheck.start"));
            this.result.update();
        }
        this.currentTestStartTime = System.currentTimeMillis();
        this.currentTestEstimatedCompletionTime = this.currentTestStartTime + 300000L;
        this.t3.post("/update?sysOndgMode=on", "sysApplySettings=Apply");
        this.t3.post("/update", "ondgHealthCheck=HealthCheck");
        this.confirmStart("healthCheck");
        if (this.reportStatus) {
            this.result.addTestResults(msgs.getString("ofdg.healthCheck.run"));
            this.result.update();
        }
    }

    private String startDiag(int n, int n2, int n3, int n4) throws T3Exception, DiagnosticException {
        if (this.isQuick) {
            this.startFastFind(n, n2);
            return this.waitForResult(n3, n4, 20);
        }
        this.startFind(n, n2);
        return this.waitForResult(n3, n4, 120);
    }

    private void startFastFind(int n, int n2) throws T3Exception, DiagnosticException {
        this.checkAbort();
        if (this.reportStatus) {
            this.result.addTestResults(msgs.getFormattedString("ofdg.fastFind.start", (Object)new Integer(n + 1), (Object)new Integer(n2 + 1)));
            this.result.update();
        }
        this.currentTestStartTime = System.currentTimeMillis();
        this.currentTestEstimatedCompletionTime = this.currentTestStartTime + 300000L;
        this.t3.setPath("/update?unitIndex=" + n + "&loopIndex=" + n2);
        this.t3.post("ondgFastFind=FastFind");
        this.confirmStart("fastFind");
        if (this.reportStatus) {
            this.result.addTestResults(msgs.getString("ofdg.fastFind.run"));
            this.result.update();
        }
    }

    private void startFind(int n, int n2) throws T3Exception, DiagnosticException {
        this.checkAbort();
        if (this.reportStatus) {
            this.result.addTestResults(msgs.getFormattedString("ofdg.loopFind.start", (Object)new Integer(n + 1), (Object)new Integer(n2 + 1)));
            this.result.update();
        }
        this.currentTestStartTime = System.currentTimeMillis();
        this.currentTestEstimatedCompletionTime = this.currentTestStartTime + 3600000L;
        this.t3.setPath("/update?unitIndex=" + n + "&loopIndex=" + n2);
        this.t3.post("ondgFind=Find");
        this.confirmStart("find");
        if (this.reportStatus) {
            this.result.addTestResults(msgs.getString("ofdg.loopFind.run"));
            this.result.update();
        }
    }

    private boolean confirmStart(String string) throws DiagnosticException, T3Exception {
        this.ofdgoper = this.t3.getTokenList("/ofdgoper.htm");
        T3Token t3Token = this.ofdgoper.findToken("ondgOper");
        T3Token t3Token2 = this.ofdgoper.findToken("ondgOperPending");
        if (t3Token2 != null && "yes".equals(t3Token2.getPropertyValue()) && t3Token != null && string.equals(t3Token.getPropertyValue())) {
            return true;
        }
        throw new DiagnosticException(msgs.getString("ofdg.msg.notStarted"));
    }

    private String checkForOFDGOperation(T3TokenList t3TokenList) throws DiagnosticException, T3Exception {
        T3Token t3Token = t3TokenList.findToken("ondgOperPending");
        if (t3Token == null) {
            return null;
        }
        String string = t3Token.getPropertyValue();
        if (string.equals("yes")) {
            T3Token t3Token2 = t3TokenList.findToken("ondgOper");
            if (t3Token2 == null) {
                return "?";
            }
            return t3Token2.getPropertyValue();
        }
        return null;
    }

    private synchronized String waitForResult(int n, int n2, int n3) throws DiagnosticException {
        int n4 = 0;
        long l = System.currentTimeMillis();
        long l2 = l + 60000L * (long)n3;
        Report.trace.log((Object)"waitForResult");
        do {
            block7: {
                try {
                    this.t3Sys.updateLoopOperation();
                    n4 = 0;
                }
                catch (T3Exception t3Exception) {
                    Report.debug.log((Throwable)t3Exception, (Object)"Update error");
                    if (++n4 <= 5) break block7;
                    throw new DiagnosticException(msgs.getString("ofdg.msg.oob.lost"));
                }
            }
            if (n4 == 0) {
                int n5 = this.t3Sys.getLoopOperationProgress();
                this.setPercentComplete(n5, n, n2);
            }
            if (System.currentTimeMillis() > l2) {
                throw new DiagnosticException(msgs.getString("ofdg.msg.oob.lost"));
            }
            try {
                ((Object)((Object)this)).wait(30000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (this.t3Sys.getLoopOperationPending());
        String string = this.t3Sys.getLoopError();
        return string;
    }

    private void checkError(String string) throws DiagnosticException {
        int n;
        if (string != null && (n = string.indexOf("fail")) > 0) {
            throw new DiagnosticException(msgs.getFormattedString("ofdg.msg.failure", (Object)string));
        }
    }

    private void reportError(boolean bl, String string) {
        if (!bl) {
            if (string != null) {
                this.result.addTestResults(msgs.getFormattedString("ofdg.diag.failFrus", (Object)string));
            } else {
                this.result.addTestResults(msgs.getString("ofdg." + this.diagName + ".fail"));
            }
        } else {
            this.result.addTestResults(msgs.getString("ofdg." + this.diagName + "go"));
        }
    }

    private boolean isInError(String string) {
        int n;
        return string != null && (n = string.indexOf("fail")) > 0;
    }

    private String getLastOFDGLog() {
        T3FtpConnection t3FtpConnection = new T3FtpConnection(this.ip, this.userName, this.password);
        String string = t3FtpConnection.grep("/syslog", "ONDG[", "ONDG Initiated");
        return string;
    }

    private String getBadFruList(String string) {
        try {
            int n = string.indexOf("BAD_FRU_LIST");
            int n2 = string.indexOf("{", n);
            int n3 = string.indexOf("}", n);
            return string.substring(n2 + 1, n3);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getStatus(String string) {
        try {
            int n = string.indexOf("STATUS");
            int n2 = string.indexOf("\n", n);
            return string.substring(n + 4, n2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isStatusPassed(String string) {
        if (string == null) {
            return false;
        }
        int n = string.indexOf("PASS");
        return n > 0;
    }

    private boolean unitFailure(int n, String string) {
        int n2 = string.indexOf("u" + n + " FAIL");
        return n2 < 0;
    }

    private static int parseHealthCheck(String string) {
        int n = string.indexOf("fail");
        if (n < 0) {
            return 0;
        }
        boolean bl = false;
        n = string.indexOf("fail u1l1");
        if (n > 0) {
            bl = true;
        }
        if ((n = string.indexOf("fail u2l1")) > 0) {
            bl = true;
        }
        boolean bl2 = false;
        n = string.indexOf("fail u1l2");
        if (n > 0) {
            bl2 = true;
        }
        if ((n = string.indexOf("fail u2l2")) > 0) {
            bl2 = true;
        }
        int n2 = 0;
        if (bl) {
            n2 = 1;
        }
        if (bl2) {
            n2 += 2;
        }
        return n2;
    }

    protected void parseSettings() {
        TestParameter testParameter;
        super.parseSettings();
        if (!this.isQuick) {
            this.diagName = "find";
        }
        if ((testParameter = this.setting.getTestParameter("user")) != null) {
            this.userName = (String)testParameter.getCurrentValue();
        }
        if ((testParameter = this.setting.getTestParameter("password")) != null) {
            this.password = (String)testParameter.getCurrentValue();
        }
        if ((testParameter = this.setting.getTestParameter("ip")) != null) {
            this.ip = (String)testParameter.getCurrentValue();
            Report.debug.log(LOG_TAG, (Object)("ip=" + this.ip));
        }
        if (this.ip == null || "".equals(this.ip)) {
            this.ip = DiagUtil.getIP((ReferenceForMSE)this.mse);
        }
    }

    public static class Test
    extends UnitTest {
        public static void main(String[] stringArray) {
            T3FtpConnection t3FtpConnection = new T3FtpConnection(stringArray[0], stringArray[1], stringArray[2]);
            String string = t3FtpConnection.grep("/syslog", "ONDG[", "ONDG Initiated");
            System.out.println(string);
        }

        public void test() {
            this.assertCondition(0 == BackEndLoopExecutable.parseHealthCheck("healthCheck         18 pass"));
            this.assertCondition(1 == BackEndLoopExecutable.parseHealthCheck("healthCheck         17 fail    fastTest      17 fail u1l1"));
            this.assertCondition(2 == BackEndLoopExecutable.parseHealthCheck("healthCheck         17 fail    fastTest      17 fail u1l2"));
            this.assertCondition(2 == BackEndLoopExecutable.parseHealthCheck("healthCheck          1 fail fastTest          1 fail u2l2"));
            this.assertCondition(3 == BackEndLoopExecutable.parseHealthCheck("healthCheck         17 fail fastTest      17 fail u1l1 fastTest         17 fail u1l2 fastTest      17 fail u2l1 fastTest         17 fail u2l2"));
        }
    }
}

