/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.rmi;

import com.sun.netstorage.mgmt.esm.util.rmi.RMISSLConstants;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Properties;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public final class RMISSLClientSocketFactory
implements RMIClientSocketFactory,
RMISSLConstants,
Serializable {
    static final long serialVersionUID = 8863107404685095386L;
    private static SSLContext sslContext;
    private static final Integer stateLock;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$util$rmi$RMISSLClientSocketFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket createSocket(String string, int n) throws IOException {
        try {
            Integer n2 = stateLock;
            synchronized (n2) {
                if (sslContext == null) {
                    RMISSLClientSocketFactory.initializeSSLContext();
                }
            }
            return sslContext.getSocketFactory().createSocket(string, n);
        }
        catch (Exception exception) {
            throw new RemoteException("Failure creating socket", exception);
        }
    }

    public boolean equals(Object object) {
        return object instanceof RMISSLClientSocketFactory;
    }

    public int hashCode() {
        return (class$com$sun$netstorage$mgmt$esm$util$rmi$RMISSLClientSocketFactory == null ? (class$com$sun$netstorage$mgmt$esm$util$rmi$RMISSLClientSocketFactory = RMISSLClientSocketFactory.class$("com.sun.netstorage.mgmt.esm.util.rmi.RMISSLClientSocketFactory")) : class$com$sun$netstorage$mgmt$esm$util$rmi$RMISSLClientSocketFactory).hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeSSLContext() throws IOException, GeneralSecurityException {
        RMISSLClientSocketFactory.initializeKeystorePasswords();
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        try {
            char[] cArray = System.getProperty("esm.util.rmi.keystore_pwd").toCharArray();
            fileInputStream = new FileInputStream(System.getProperty("esm.util.rmi.keystore"));
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(fileInputStream, cArray);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, cArray);
            char[] cArray2 = System.getProperty("esm.util.rmi.truststore_pwd").toCharArray();
            fileInputStream2 = new FileInputStream(System.getProperty("esm.util.rmi.truststore"));
            KeyStore keyStore2 = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore2.load(fileInputStream2, cArray2);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init(keyStore2);
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                fileInputStream2.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fileInputStream2.close();
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void initializeKeystorePasswords() {
        block9: {
            if (System.getProperty("esm.util.rmi.pwd_filename") == null) {
                return;
            }
            FileInputStream fileInputStream = null;
            Properties properties = new Properties();
            fileInputStream = new FileInputStream(System.getProperty("esm.util.rmi.pwd_filename"));
            properties.load(fileInputStream);
            System.setProperty("esm.util.rmi.keystore_pwd", properties.getProperty("keystore_pwd", System.getProperty("esm.util.rmi.keystore_pwd")));
            System.setProperty("esm.util.rmi.truststore_pwd", properties.getProperty("truststore_pwd", System.getProperty("esm.util.rmi.truststore_pwd")));
            Object var3_3 = null;
            try {
                fileInputStream.close();
            }
            catch (Exception exception) {}
            break block9;
            {
                catch (Exception exception) {
                    Object var3_4 = null;
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        stateLock = new Integer(0);
    }
}

