/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.numbers;

import com.sun.netstorage.mgmt.esm.util.l10n.properties.Name;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.numbers.NumberRangeException;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.numbers.NumberValueConstraint;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.numbers.NumberValueException;

public abstract class NumberRange
extends NumberValueConstraint {
    private static final String SCCS_ID = "@(#)NumberRange.java 1.2   03/04/07 SMI";
    private final Number myMinimum;
    private final Number myMaximum;

    public NumberRange(Name name, Number number, Number number2) {
        super(name);
        this.myMinimum = number;
        this.myMaximum = number2;
    }

    public final boolean hasMinimum() {
        return this.myMinimum != null;
    }

    protected final Number getMinimum() {
        return this.myMinimum;
    }

    public final boolean hasMaximum() {
        return this.myMaximum != null;
    }

    protected final Number getMaximum() {
        return this.myMaximum;
    }

    protected final boolean isValueValid(Number number) {
        boolean bl = true;
        Comparable comparable = (Comparable)((Object)this.myMinimum);
        Comparable comparable2 = (Comparable)((Object)this.myMaximum);
        if (comparable != null && comparable.compareTo(number) > 0) {
            bl = false;
        }
        if (comparable2 != null && comparable2.compareTo(number) < 0) {
            bl = false;
        }
        return bl;
    }

    protected final void validateValue(Number number) throws NumberValueException {
        if (!this.isValueValid(number)) {
            if (this.myMinimum != null && this.myMaximum != null) {
                throw new NumberRangeException.OutOfRange(this, number);
            }
            if (this.myMinimum != null) {
                throw new NumberRangeException.LessThanMin(this, number);
            }
            if (this.myMaximum != null) {
                throw new NumberRangeException.GreaterThanMax(this, number);
            }
        }
    }
}

