/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.numbers;

import com.sun.netstorage.mgmt.esm.util.l10n.properties.Name;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.PropertyException;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.numbers.FloatValidator;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.numbers.NumberEnum;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.numbers.NumberUtil;
import com.sun.netstorage.mgmt.esm.util.l10n.properties.metadata.numbers.NumberValueException;

public class FloatEnum
extends NumberEnum
implements FloatValidator {
    private static final String SCCS_ID = "@(#)FloatEnum.java 1.2   03/04/07 SMI";

    public static Float[] toObjectArray(float[] fArray) {
        int n = fArray != null ? fArray.length : 0;
        Float[] floatArray = new Float[n];
        int n2 = 0;
        while (n2 < n) {
            floatArray[n2] = new Float(fArray[n2]);
            ++n2;
        }
        return floatArray;
    }

    public static float[] toPrimitiveArray(Number[] numberArray) {
        int n = numberArray != null ? numberArray.length : 0;
        float[] fArray = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray[n2] = numberArray[n2].floatValue();
            ++n2;
        }
        return fArray;
    }

    public FloatEnum(Name name) {
        super(name);
    }

    public FloatEnum(Name name, Float[] floatArray) {
        super(name, floatArray);
    }

    public FloatEnum(Name name, float[] fArray) {
        super(name, FloatEnum.toObjectArray(fArray));
    }

    public void add(float f) {
        super.add(new Float(f));
    }

    public void addAll(float[] fArray) {
        super.addAll(FloatEnum.toObjectArray(fArray));
    }

    public float[] floatValues() {
        return FloatEnum.toPrimitiveArray(super.toArray());
    }

    public boolean isValueValid(float f) {
        return super.isValueValid(new Float(f));
    }

    public void validateValue(float f) throws NumberValueException {
        super.validateValue(new Float(f));
    }

    public Object parseValue(String string) throws PropertyException {
        return NumberUtil.parseValue(string, this);
    }
}

