/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.l10n.exceptions;

import com.sun.netstorage.mgmt.esm.util.l10n.Formatter;
import com.sun.netstorage.mgmt.esm.util.l10n.FormatterException;
import com.sun.netstorage.mgmt.esm.util.l10n.Resource;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.Contract;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableThrowable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public final class LocalizableThrowableSupport
implements LocalizableThrowable,
Serializable {
    private static final String SCCS_ID = "@(#)LocalizableThrowableSupport.java 1.7   03/05/02 SMI";
    private final Class myConcreteClass;
    private Resource myResource = null;
    private transient Formatter myFormatter = null;
    private List myMessageArgList = null;
    private String myMessage = null;

    public static final String toString(Serializable serializable) {
        return serializable instanceof String ? (String)((Object)serializable) : (serializable != null ? serializable.toString() : null);
    }

    public LocalizableThrowableSupport(Class clazz) {
        Contract.requires(clazz != null, "theConcreteClass != null");
        this.myConcreteClass = clazz;
    }

    public Class getConcreteClass() {
        return this.myConcreteClass;
    }

    private String getBundleNameDefault() {
        String string = this.myConcreteClass.getPackage().getName();
        return string + '.' + "Localization";
    }

    private String getMessageKeyDefault() {
        String string = this.myConcreteClass.getName();
        int n = string.lastIndexOf(46);
        String string2 = string.substring(n + 1);
        return string2;
    }

    public void setResource(Resource resource) {
        Contract.requires(resource != null, "theResource != null");
        if (this.myResource == null) {
            this.myResource = resource;
        }
    }

    private String getMessage(Locale locale) {
        return this.myResource.getLocalizedText(locale);
    }

    private Formatter getFormatter() {
        if (this.myFormatter == null && this.myResource != null) {
            this.myFormatter = new Formatter(this.myResource);
        }
        return this.myFormatter;
    }

    public void setFormatter(Formatter formatter) {
        Contract.requires(formatter != null, "theFormatter != null");
        if (this.myFormatter == null) {
            this.myFormatter = formatter;
            this.setResource(this.myFormatter.getResource());
        }
    }

    private String formatMessage(Locale locale) {
        String string = null;
        String[] stringArray = this.getMessageArgLiterals();
        try {
            string = this.getFormatter().getFormattedText(stringArray, locale);
        }
        catch (FormatterException formatterException) {
            string = this.getMessage(locale);
        }
        return string;
    }

    private String formatMessage() {
        String string = null;
        String[] stringArray = this.getMessageArgLiterals();
        try {
            string = this.getFormatter().getLiteralFormattedText(stringArray);
        }
        catch (FormatterException formatterException) {
            string = this.getMessage();
        }
        return string;
    }

    private boolean hasMessageArgList() {
        return this.myMessageArgList != null;
    }

    private List getMessageArgList() {
        if (this.myMessageArgList == null) {
            this.myMessageArgList = new ArrayList();
        }
        return this.myMessageArgList;
    }

    public final void addMessageArg(Serializable serializable) {
        if (serializable != null) {
            Class<?> clazz = serializable.getClass();
            if (clazz.isArray()) {
                if (serializable instanceof Serializable[]) {
                    this.addMessageArgs((Serializable[])serializable);
                } else {
                    Object[] objectArray = (Object[])serializable;
                    int n = 0;
                    while (n < objectArray.length) {
                        if (!(objectArray[n] instanceof Serializable)) {
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append("argument (");
                            stringBuffer.append(objectArray[n]);
                            stringBuffer.append(") is required to be Serializable");
                            throw new IllegalArgumentException(stringBuffer.toString());
                        }
                        this.addMessageArg((Serializable)objectArray[n]);
                        ++n;
                    }
                }
            } else {
                this.getMessageArgList().add(serializable);
            }
        }
    }

    public final void addMessageArgs(Serializable[] serializableArray) {
        if (serializableArray != null && serializableArray.length > 0) {
            int n = 0;
            while (n < serializableArray.length) {
                if (serializableArray[n] != null) {
                    this.addMessageArg(serializableArray[n]);
                }
                ++n;
            }
        }
    }

    public String[] getMessageArgLiterals() {
        Serializable[] serializableArray = this.getMessageArgs();
        int n = serializableArray != null ? serializableArray.length : 0;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = LocalizableThrowableSupport.toString(serializableArray[n2]);
            ++n2;
        }
        return stringArray;
    }

    public void initMessage() {
        block3: {
            Contract.guarantees(this.myResource != null, "myResource != null");
            try {
                if (this.myMessage != null) break block3;
                this.myMessage = this.formatMessage(Locale.getDefault());
                if (this.myMessage == null) {
                    this.myMessage = this.formatMessage();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void initMessage(Resource resource) {
        this.setResource(resource);
        this.initMessage();
    }

    public void initMessage(Formatter formatter) {
        this.setFormatter(formatter);
        this.initMessage();
    }

    public void initMessage(String string, String string2, String string3) {
        Contract.requires(string != null, "theResourceBundleName != null");
        Contract.requires(string2 != null, "theMessageKey != null");
        Contract.requires(string3 != null, "theMessage != null");
        Resource resource = new Resource(string, string2, string3);
        this.initMessage(resource);
    }

    public Throwable getCause() {
        String string = "Support for getCause() is provided directly by Throwable.";
        throw new UnsupportedOperationException(string);
    }

    public String getMessage() {
        if (this.myMessage == null) {
            this.myMessage = this.formatMessage();
        }
        return this.myMessage;
    }

    public Serializable[] getMessageArgs() {
        Serializable[] serializableArray = null;
        if (this.hasMessageArgList()) {
            int n = this.getMessageArgList().size();
            serializableArray = new Serializable[n];
            serializableArray = this.getMessageArgList().toArray(serializableArray);
        } else {
            serializableArray = new Serializable[]{};
        }
        return serializableArray;
    }

    public String[] getMessageArgStrings() {
        return this.getMessageArgStrings(Locale.getDefault());
    }

    public String[] getMessageArgStrings(Locale locale) {
        String[] stringArray = this.getMessageArgLiterals();
        int n = stringArray != null ? stringArray.length : 0;
        String[] stringArray2 = this.getFormatter().getLocalizedArgs(stringArray, locale);
        return stringArray2;
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    public String getLocalizedMessage(Locale locale) {
        String string = null;
        string = this.hasMessageArgList() ? this.formatMessage(locale) : this.getMessage(locale);
        if (string == null) {
            string = this.getMessage();
        }
        return string;
    }

    public String toString() {
        return this.getMessage();
    }
}

