/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.util.l10n.doclet;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;

public abstract class ResourceWriter {
    public static final String DASHES = "-----------------------------------";
    private final String myPackageName;
    private final String myBundleName;
    private final String myBundleSuffix;
    private final String myFileSuffix;
    private String myBasename = null;
    private String myFilename = null;
    private File myFile = null;
    private final String myCommentBegin;
    private final String myCommentContinue;
    private final String myCommentEnd;
    private final String myIndent;
    private int myResourceCount = 0;
    private String mySection = null;
    private final StringWriter myContent = new StringWriter();
    private final PrintWriter myOutput = new PrintWriter((Writer)this.myContent, true);
    private File mySource = null;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$ResourceDoclet;

    protected ResourceWriter(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        this.myPackageName = string;
        this.myBundleName = string2;
        this.myBundleSuffix = string3;
        this.myFileSuffix = string4;
        this.myCommentBegin = string5;
        this.myCommentContinue = string6;
        this.myCommentEnd = string7;
        this.myIndent = string8;
    }

    protected final String getPackageName() {
        return this.myPackageName;
    }

    protected final String getBundleName() {
        return this.myBundleName;
    }

    protected final String getBundleSuffix() {
        return this.myBundleSuffix;
    }

    protected final String getFileSuffix() {
        return this.myFileSuffix;
    }

    public final String getBasename() {
        if (this.myBasename == null) {
            StringBuffer stringBuffer = new StringBuffer(this.myBundleName);
            if (this.myBundleSuffix != null) {
                stringBuffer.append(this.myBundleSuffix);
            }
            stringBuffer.append(this.myFileSuffix);
            this.myBasename = stringBuffer.toString();
        }
        return this.myBasename;
    }

    public final String getFilename() {
        if (this.myFilename == null) {
            String string = this.getBasename();
            if (this.mySource != null) {
                File file = this.mySource.getParentFile();
                File file2 = new File(file, string);
                try {
                    string = file2.getCanonicalPath();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.myFilename = string;
        }
        return this.myFilename;
    }

    public final File getFile() {
        if (this.myFile == null) {
            this.myFile = new File(this.getFilename());
        }
        return this.myFile;
    }

    protected final void printlnCommentBegin() {
        this.getOutput().println(this.myCommentBegin);
    }

    protected final void printCommentBegin() {
        this.getOutput().print(this.myCommentBegin);
    }

    protected final void printlnCommentContinue() {
        this.getOutput().println(this.myCommentContinue);
    }

    protected final void printCommentContinue() {
        this.getOutput().print(this.myCommentContinue);
    }

    protected final void printlnCommentEnd() {
        this.getOutput().println(this.myCommentEnd);
    }

    protected final void printIndent(int n) {
        int n2 = 0;
        while (this.myIndent != null && n2 < n) {
            this.getOutput().print(this.myIndent);
            ++n2;
        }
    }

    public boolean hasResources() {
        return this.myResourceCount > 0;
    }

    protected final void incrementResourceCount() {
        ++this.myResourceCount;
    }

    protected final void setSection(String string) {
        this.mySection = string;
    }

    protected final boolean hasSection() {
        return this.mySection != null;
    }

    protected final boolean matchesSection(String string) {
        return this.mySection.equals(string);
    }

    public String getContent() {
        String string = null;
        if (this.hasResources()) {
            this.footer();
            string = this.myContent.toString();
        }
        return string;
    }

    protected final PrintWriter getOutput() {
        return this.myOutput;
    }

    public boolean hasSource() {
        return this.mySource != null;
    }

    public void setSource(File file) {
        this.mySource = file;
    }

    protected abstract void entry(String var1, String var2, String var3, String var4, String[] var5);

    protected void header() {
        Date date = new Date();
        this.printlnCommentBegin();
        this.printCommentContinue();
        this.getOutput().print(" %");
        this.getOutput().print("W% %E");
        this.getOutput().println("%");
        this.printlnCommentContinue();
        this.printCommentContinue();
        this.getOutput().println(" Copyright (c) 2003 Sun Microsystems, Inc.");
        this.printlnCommentContinue();
        this.printGeneratedBy();
        this.printlnCommentEnd();
    }

    protected void section(String string) {
        this.setSection(string);
        this.getOutput().println();
        this.printIndent(1);
        this.printlnCommentBegin();
        this.printIndent(1);
        this.printCommentContinue();
        this.getOutput().print(" Resources from ");
        this.getOutput().print(string);
        this.getOutput().println(':');
        this.printIndent(1);
        this.printCommentContinue();
        this.getOutput().print(' ');
        this.getOutput().print(DASHES);
        this.getOutput().print(DASHES);
        this.getOutput().println();
        this.printIndent(1);
        this.printlnCommentEnd();
        this.getOutput().println();
    }

    protected void footer() {
    }

    protected final void printEntry(String string, String string2, String string3, String string4, String[] stringArray) {
        this.incrementResourceCount();
        if (!this.hasSection()) {
            this.header();
            this.section(string);
        } else if (!this.matchesSection(string)) {
            this.section(string);
        }
        this.entry(string, string2, string3, string4, stringArray);
    }

    protected final void printGeneratedBy() {
        Date date = new Date();
        this.printCommentContinue();
        this.getOutput().print(" Generated by: ");
        this.getOutput().println((class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$ResourceDoclet == null ? (class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$ResourceDoclet = ResourceWriter.class$("com.sun.netstorage.mgmt.esm.util.l10n.doclet.ResourceDoclet")) : class$com$sun$netstorage$mgmt$esm$util$l10n$doclet$ResourceDoclet).getName());
        this.printCommentContinue();
        this.getOutput().print(" Generated on: ");
        this.getOutput().println(date);
    }

    public void writeFile(boolean bl) throws IOException {
        String string = this.getContent();
        if (string != null) {
            File file = this.getFile();
            if (!bl || file.exists()) {
                // empty if block
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            PrintWriter printWriter = new PrintWriter(fileOutputStream);
            printWriter.println(string);
            printWriter.flush();
            printWriter.close();
        }
    }

    public void writeFile() throws IOException {
        this.writeFile(false);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ResourceWriter: ");
        if (this.hasResources()) {
            stringBuffer.append(this.getFilename());
            stringBuffer.append('\n');
            stringBuffer.append(this.getContent());
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

