/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.component.model.domain.datatypes;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;

public final class NetworkObjectPath {
    private static final CIMProperty[] CIM_PROPERTIES = new CIMProperty[0];
    private static final char DELIMITER = ':';
    static final String sccs_id = "@(#)NetworkObjectPath.java 1.2   01/11/20 SMI";

    public static String getObjectName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("objectPath == null");
        }
        int n = string.indexOf(58);
        if (n == -1) {
            throw new IllegalArgumentException(string + ".indexOf(" + ':' + ") == -1");
        }
        return string.substring(0, n);
    }

    public static String normalizedObjectPath(CIMObjectPath cIMObjectPath) {
        if (cIMObjectPath == null) {
            throw new IllegalArgumentException("objectPath == null");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(cIMObjectPath.getObjectName());
        stringBuffer.append(':');
        CIMProperty[] cIMPropertyArray = cIMObjectPath.getKeys().toArray(CIM_PROPERTIES);
        Arrays.sort(cIMPropertyArray, new Comparator(){

            public int compare(Object object, Object object2) {
                CIMProperty cIMProperty = (CIMProperty)object;
                CIMProperty cIMProperty2 = (CIMProperty)object2;
                return cIMProperty.getName().compareTo(cIMProperty2.getName());
            }
        });
        int n = 0;
        while (n < cIMPropertyArray.length) {
            CIMProperty cIMProperty = cIMPropertyArray[n];
            Object object = cIMProperty.getValue().getValue();
            stringBuffer.append(cIMProperty.getName());
            stringBuffer.append('=');
            stringBuffer.append(NetworkObjectPath.valueToString(object));
            stringBuffer.append(':');
            ++n;
        }
        return stringBuffer.toString();
    }

    private static String valueToString(Object object) {
        if (object == null) {
            return "<null>";
        }
        if (object instanceof CIMObjectPath) {
            return NetworkObjectPath.normalizedObjectPath((CIMObjectPath)object);
        }
        if (object instanceof Vector) {
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = ((Vector)object).iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(NetworkObjectPath.valueToString(iterator.next()));
                stringBuffer.append(',');
            }
            return stringBuffer.toString();
        }
        return object.toString();
    }
}

