/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.util.log;

import com.sun.jade.util.log.LogFormatter;
import com.sun.jade.util.unittest.UnitTest;
import java.util.GregorianCalendar;

public class LogFormatterImpl
implements LogFormatter {
    private String header;
    private String service;
    private String operation;
    public final int DATE = 1;
    public final int TIME = 2;
    public final int MEMORY = 3;
    public final int CLASS = 4;
    public final int METHOD = 5;
    public final int LINE = 6;
    public final int OPERATION = 7;
    public final int SERVICE = 8;

    public LogFormatterImpl(String string) {
        this.header = string;
    }

    public String format(String string) {
        if (this.header == null) {
            return string;
        }
        return LogFormatterImpl.getTime() + this.header + string;
    }

    static String getTime() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        gregorianCalendar.get(11);
        int n = gregorianCalendar.get(11);
        if (n <= 9) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n);
        stringBuffer.append(":");
        n = gregorianCalendar.get(12);
        if (n <= 9) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n);
        stringBuffer.append(":");
        n = gregorianCalendar.get(13);
        if (n <= 9) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public void setCaption(String string) {
        this.header = string;
    }

    public static class Test
    extends UnitTest {
        public void test() {
            String string = "test";
            String string2 = "msg";
            LogFormatterImpl logFormatterImpl = new LogFormatterImpl(string);
            this.assertEquals(logFormatterImpl.format(string2).substring(10), string + string2);
            logFormatterImpl.setCaption(null);
            this.assertEquals(logFormatterImpl.format(string2), string2);
            this.assertNull(logFormatterImpl.format(null));
        }
    }
}

