/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.util.locale;

import com.sun.jade.util.locale.LocalizedMessage;
import com.sun.jade.util.unittest.UnitTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalizedString
implements LocalizedMessage,
Serializable {
    private static final String sccs_id = "@(#)LocalizedString.java\t1.16 07/12/03 SMI";
    private final transient String CLASS_NAME = this.getClass().getName();
    private final transient String PKG_NAME = this.getClass().getPackage().getName();
    private final transient String RES_NAME = "com/sun/jade/util/locale/Localization";
    private final transient String COMP_NAME = "LocalizedString";
    private final transient Logger logger = Logger.getLogger(this.PKG_NAME);
    private static String tag = "L10N:";
    private String resource;
    private String property;
    private String defaultValue;
    private Object[] args;

    public String getResource() {
        return this.resource;
    }

    public String getProperty() {
        return this.property;
    }

    public Object[] getArgs() {
        return this.args;
    }

    public LocalizedString(String string, String string2, String string3) {
        this.resource = string;
        this.property = string2;
        this.defaultValue = string3 != null ? string3 : string2;
    }

    public LocalizedString(String string, String string2) {
        this(string, string2, string2);
    }

    public LocalizedString(Class clazz, String string, String string2) {
        String string3 = clazz.getName();
        String string4 = "";
        int n = string3.lastIndexOf(".");
        if (n > 0) {
            string4 = string3.substring(0, n);
            string3 = string3.substring(n + 1);
        }
        this.resource = string4 + ".resource." + string3;
        this.property = string;
        this.defaultValue = string2 != null ? string2 : string;
    }

    public LocalizedString(String string, String string2, String string3, Object[] objectArray) {
        this.resource = string;
        this.property = string2;
        this.defaultValue = string3 != null ? string3 : string2;
        this.args = objectArray;
    }

    public LocalizedString(String string) {
        String string2 = this.decode(string);
        try {
            int n = string2.indexOf(0);
            if (n < 0) {
                this.defaultValue = string2;
            } else {
                int n2 = string2.indexOf(58, n + 1);
                int n3 = string2.indexOf(58, n2 + 1);
                int n4 = string2.indexOf(58, n3 + 1);
                this.resource = string2.substring(n2 + 1, n3);
                this.property = string2.substring(n3 + 1, n4);
                this.defaultValue = string2.substring(0, n);
                ArrayList arrayList = new ArrayList();
                while (n4 > 0) {
                    n4 = this.DeserializeObject(string2, n4, arrayList);
                }
                if (arrayList.size() > 0) {
                    this.args = arrayList.toArray();
                }
            }
        }
        catch (Exception exception) {
            this.resource = null;
            this.property = null;
            this.defaultValue = string2;
        }
    }

    public LocalizedString(Exception exception) {
        this.resource = null;
        this.property = null;
        if (exception != null) {
            this.defaultValue = exception.getLocalizedMessage();
        }
    }

    private String encode(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\\') {
                stringBuffer.append("\\\\");
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private String decode(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (c == '\\') {
                char c2;
                if ((c2 = string.charAt(++n2)) == '0') {
                    stringBuffer.append('\u0000');
                } else if (c2 == '\\') {
                    stringBuffer.append('\\');
                } else {
                    stringBuffer.append(c2);
                }
            } else {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String toString() {
        if (this.resource == null || this.property == null) {
            return this.defaultValue;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.encode(this.defaultValue));
        stringBuffer.append("\\0");
        if (this.resource != null) {
            stringBuffer.append(tag);
            stringBuffer.append(this.resource);
            stringBuffer.append(":");
        }
        if (this.property != null) {
            stringBuffer.append(this.property);
        }
        stringBuffer.append(":");
        if (this.args != null) {
            int n = 0;
            while (n < this.args.length) {
                Object object = this.args[n];
                if (object instanceof Double) {
                    stringBuffer.append("D");
                    stringBuffer.append(object.toString());
                    stringBuffer.append(":");
                } else if (object instanceof Float) {
                    stringBuffer.append("F");
                    stringBuffer.append(object.toString());
                    stringBuffer.append(":");
                } else if (object instanceof Long) {
                    stringBuffer.append("L");
                    stringBuffer.append(object.toString());
                    stringBuffer.append(":");
                } else if (object instanceof Number) {
                    stringBuffer.append("#");
                    stringBuffer.append(object.toString());
                    stringBuffer.append(":");
                } else if (object instanceof String) {
                    stringBuffer.append("S");
                    stringBuffer.append(((String)object).length());
                    stringBuffer.append(":");
                    stringBuffer.append(object.toString());
                    stringBuffer.append(":");
                } else {
                    String string = this.SerializeObject(object);
                    stringBuffer.append("O");
                    stringBuffer.append(string.length());
                    stringBuffer.append(":");
                    stringBuffer.append(string);
                    stringBuffer.append(":");
                }
                ++n;
            }
        }
        return stringBuffer.toString();
    }

    public int hashCode() {
        int n = 0;
        if (this.resource != null) {
            n += this.resource.hashCode();
        }
        if (this.property != null) {
            n += this.property.hashCode();
        }
        if (this.defaultValue != null) {
            n += this.defaultValue.hashCode();
        }
        if (this.args != null) {
            int n2 = 0;
            while (n2 < this.args.length) {
                if (this.args[n2] != null) {
                    n += this.args[n2].hashCode();
                }
                ++n2;
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (!(object instanceof LocalizedString)) {
            return false;
        }
        LocalizedString localizedString = (LocalizedString)object;
        return this.toString().equals(localizedString.toString());
    }

    public Object clone() {
        if (this.args != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(this.args);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                return new LocalizedString(new String(this.resource), new String(this.property), new String(this.defaultValue), (Object[])objectInputStream.readObject());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new LocalizedString(new String(this.resource), new String(this.property), new String(this.defaultValue));
    }

    public static String localize(String string) {
        LocalizedString localizedString = new LocalizedString(string);
        return localizedString.getString();
    }

    public static String localize(String string, Locale locale) {
        LocalizedString localizedString = new LocalizedString(string);
        return localizedString.getString(locale);
    }

    public String getLocalizedMessage() {
        return this.getString();
    }

    public String getLocalizedMessage(Locale locale) {
        return this.getString(locale);
    }

    public String getString() {
        String string = this.getValueFromResource(null);
        if (string == null) {
            string = this.defaultValue;
        }
        if (this.args != null && this.args.length > 0) {
            return MessageFormat.format(string, this.localizeArgs(null));
        }
        return string;
    }

    public String getString(Locale locale) {
        String string = this.getValueFromResource(locale);
        if (string == null) {
            string = this.defaultValue;
        }
        if (this.args != null && this.args.length > 0) {
            return MessageFormat.format(string, this.localizeArgs(locale));
        }
        return string;
    }

    public void setDefaultValue() {
        this.setDefaultValue(this.getString());
    }

    public void setDefaultValue(Locale locale) {
        this.setDefaultValue(this.getString(locale));
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    private int DeserializeObject(String string, int n, ArrayList arrayList) {
        if (string.length() <= n + 1) {
            return -1;
        }
        int n2 = string.indexOf(":", n + 2);
        String string2 = string.substring(n + 2, n2);
        switch (string.charAt(n + 1)) {
            case 'D': {
                arrayList.add(Double.valueOf(string2));
                break;
            }
            case 'F': {
                arrayList.add(Float.valueOf(string2));
                break;
            }
            case 'L': {
                arrayList.add(Double.valueOf(string2));
                break;
            }
            case '#': {
                arrayList.add(Integer.valueOf(string2));
                break;
            }
            case 'S': {
                Integer n3 = Integer.valueOf(string2);
                int n4 = n3;
                arrayList.add(string.substring(n2 + 1, n2 + 1 + n4));
                n2 += n4 + 1;
                break;
            }
            case 'O': {
                Integer n5 = Integer.valueOf(string2);
                int n6 = n5;
                String string3 = string.substring(n2 + 1, n2 + 1 + n6);
                byte[] byArray = new byte[n6];
                int n7 = 0;
                while (n7 < n6) {
                    byArray[n7] = (byte)string3.charAt(n7);
                    ++n7;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                try {
                    ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                    Object object = objectInputStream.readObject();
                    arrayList.add(object);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return -1;
                }
                n2 += n6 + 1;
            }
        }
        return n2;
    }

    private String SerializeObject(Object object) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            int n = byteArrayOutputStream.size();
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append((char)byArray[n2]);
                ++n2;
            }
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String getValueFromResource(Locale locale) {
        if (this.resource == null || this.property == null) {
            return null;
        }
        try {
            ResourceBundle resourceBundle = locale == null ? ResourceBundle.getBundle(this.resource) : ResourceBundle.getBundle(this.resource, locale);
            return resourceBundle.getString(this.property);
        }
        catch (MissingResourceException missingResourceException) {
            this.logger.logrb(Level.WARNING, this.CLASS_NAME, "getValueFromResource(Locale inLocale)", "com/sun/jade/util/locale/Localization", "error", new Object[]{this.property, this.resource, locale});
            return null;
        }
    }

    private Object[] localizeArgs(Locale locale) {
        Object[] objectArray = new Object[this.args.length];
        int n = 0;
        while (n < this.args.length) {
            if (this.args[n] instanceof String) {
                LocalizedString localizedString = new LocalizedString((String)this.args[n]);
                objectArray[n] = localizedString.getString(locale);
            } else {
                objectArray[n] = this.args[n];
            }
            ++n;
        }
        return objectArray;
    }

    public static class Test
    extends UnitTest {
        String value = "testDefault";
        Date date = new Date();

        public void testNoResource() {
            LocalizedString localizedString = new LocalizedString("com.sun.xxx", "xxx", this.value);
            this.assertEquals(this.value, localizedString.getString());
        }

        public void testNoProperty() {
            LocalizedString localizedString = new LocalizedString("com.sun.jade.util.locale.TestResource", "propertyX", this.value);
            this.assertEquals(this.value, localizedString.getString());
        }

        public void testValue() {
            LocalizedString localizedString = new LocalizedString("com.sun.jade.util.locale.TestResource", "propertyA", this.value);
            this.assertEquals("A", localizedString.getString());
            String string = localizedString.toString();
            localizedString = new LocalizedString(string);
            this.assertEquals("A", localizedString.getString());
            this.assertEquals(string, localizedString.toString());
            Object object = localizedString.clone();
            this.assertEquals(localizedString, object);
            this.assertCondition(localizedString.hashCode() == object.hashCode());
        }

        public void testArg() {
            Object[] objectArray = new Object[]{new Integer(529)};
            LocalizedString localizedString = new LocalizedString("com.sun.jade.util.locale.TestResource", "value", "Reporting Value = {0}.", objectArray);
            String string = localizedString.toString();
            localizedString = new LocalizedString(string);
            this.assertEquals("The value is 529.", localizedString.getString());
            objectArray[0] = "abc";
            localizedString = new LocalizedString("com.sun.jade.util.locale.TestResource", "value", "def value", objectArray);
            this.assertEquals("The value is abc.", localizedString.getString());
        }

        public void testArgs() {
            Object[] objectArray = new Object[]{"A string.", new Double(3.14), new Float(123.45), new Long(123456789L)};
            LocalizedString localizedString = new LocalizedString("com.sun.jade.util.locale.TestResource", "none", "{0}:{1}:{2}:{3}", objectArray);
            String string = localizedString.toString();
            String string2 = localizedString.getString();
            localizedString = new LocalizedString(string);
            this.assertEquals(string2, localizedString.getString());
        }

        public void testStringCreator() {
            LocalizedString localizedString = new LocalizedString((String)null);
            this.assertNull(localizedString.toString());
            localizedString = new LocalizedString((Exception)null);
            this.assertNull(localizedString.toString());
            localizedString = new LocalizedString("");
            this.assertEquals("", localizedString.toString());
            localizedString = new LocalizedString("\u0000L10N:x");
            localizedString = new LocalizedString("\\0L10N:x");
            localizedString = new LocalizedString("abc");
            this.assertEquals("abc", localizedString.toString());
        }
    }

    private class ByteStream
    extends ByteArrayOutputStream {
        ByteStream() {
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < this.count) {
                stringBuffer.append((char)this.buf[n]);
                ++n;
            }
            return stringBuffer.toString();
        }
    }
}

