/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.netstorage.mgmt.esm.logic.discovery.api.Probe;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.ProbeResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.ProbeRootImpl;
import java.security.Principal;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;

public class WBEMClassProbe
implements Probe {
    String className;
    String nameSpace = "root\\cimv27";
    String wbemProtocol;
    Properties probeProps;
    public static final String sccs_id = "@(#)WBEMClassProbe.java\t1.4 04/08/03 SMI";

    public String getName() {
        return "WBEM:" + this.className;
    }

    public WBEMClassProbe(Properties properties) {
        this.probeProps = properties;
        this.className = properties.getProperty("CIM_CLASS");
        String string = properties.getProperty("CIM_NAMESPACE");
        if (string != null) {
            this.nameSpace = string;
        }
        this.wbemProtocol = properties.getProperty("WBEM_PROTOCOL");
    }

    public ProbeResult probe(Properties properties) {
        try {
            LinkedList<Properties> linkedList = new LinkedList<Properties>();
            String string = properties.getProperty("wbem.ip");
            String string2 = properties.getProperty("wbem.user");
            String string3 = properties.getProperty("wbem.password");
            CIMNameSpace cIMNameSpace = new CIMNameSpace(string, this.nameSpace);
            UserPrincipal userPrincipal = new UserPrincipal(string2);
            PasswordCredential passwordCredential = new PasswordCredential(string3);
            String string4 = properties.getProperty("wbem.protocol");
            String string5 = "cim-xml";
            if ("rmi".equals(string4)) {
                string5 = "cim-rmi";
            }
            CIMClient cIMClient = new CIMClient(cIMNameSpace, (Principal)userPrincipal, (Object)passwordCredential, string5);
            CIMObjectPath cIMObjectPath = new CIMObjectPath(this.className);
            Enumeration enumeration = cIMClient.enumerateInstances(cIMObjectPath, true, false, true, true, null);
            while (enumeration.hasMoreElements()) {
                Properties properties2 = new Properties();
                CIMInstance cIMInstance = (CIMInstance)enumeration.nextElement();
                Vector vector = cIMInstance.getProperties();
                int n = 0;
                while (n < vector.size()) {
                    CIMValue cIMValue;
                    CIMProperty cIMProperty = (CIMProperty)vector.get(n);
                    CIMQualifier cIMQualifier = cIMProperty.getQualifier("Key");
                    if (cIMQualifier != null && (cIMValue = cIMProperty.getValue()) != null) {
                        properties2.setProperty(this.className + "." + cIMProperty.getName(), cIMValue.toString());
                    }
                    ++n;
                }
                linkedList.add(ProbeRootImpl.mergeProperties(properties2, properties));
            }
            return new ProbeResult(this.probeProps, linkedList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        Properties properties2 = new Properties();
        if (stringArray.length < 4) {
            System.out.println("Usage: WBEMClassProbe host user passwd classname [rmi|http]");
            System.exit(1);
        }
        properties.setProperty("CIM_CLASS", stringArray[3]);
        properties2.setProperty("wbem.ip", stringArray[0]);
        properties2.setProperty("wbem.user", stringArray[1]);
        properties2.setProperty("wbem.password", stringArray[2]);
        if (stringArray.length == 5) {
            properties2.setProperty("wbem.protocol", stringArray[4]);
        }
        WBEMClassProbe wBEMClassProbe = new WBEMClassProbe(properties);
        ProbeResult probeResult = wBEMClassProbe.probe(properties2);
        System.out.println(probeResult);
    }
}

