/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.jade.apps.command.ThreadPool;
import com.sun.jade.apps.discovery.InstallerServiceFinder;
import com.sun.jade.device.util.DeviceConfig;
import com.sun.jade.util.StoradeEnvironment;
import com.sun.netstorage.mgmt.esm.logic.device.factory.FacadeFactory;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.DeviceDetail;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.DiscoveryService;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.FabricSearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.Search;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.SearchResult;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.DeviceDetailImpl;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.DiscoveryScheduler;
import com.sun.netstorage.mgmt.esm.logic.discovery.impl.PACKAGE;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;

public class DiscoveryServiceImpl
implements DiscoveryService {
    private DiscoveryScheduler scheduler;
    private Properties discoProps;
    private LinkedList configs = new LinkedList();
    private LinkedList searches = new LinkedList();
    public static final String sccs_id = "@(#)DiscoveryServiceImpl.java\t1.18 08/28/03 SMI";
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory;

    public DiscoveryServiceImpl(Properties properties) {
        this.discoProps = properties;
        FabricSearchConfig fabricSearchConfig = new FabricSearchConfig();
        this.configs.add(fabricSearchConfig);
        ThreadPool threadPool = ThreadPool.getThreadPool();
        threadPool.runJob((Runnable)new BootStarter(this));
    }

    public synchronized SearchResult runSearch(SearchConfig searchConfig) {
        Search search = searchConfig.newSearch();
        SearchResult searchResult = search.runSearch();
        this.searches.add(search);
        return searchResult;
    }

    public synchronized void stopSearch(String string) {
        Iterator iterator = this.searches.iterator();
        while (iterator.hasNext()) {
            Search search = (Search)iterator.next();
            SearchResult searchResult = search.getSearchResult();
            if (!string.equals(searchResult.getId())) continue;
            search.stopSearch();
            this.searches.remove(search);
            return;
        }
        throw new IllegalArgumentException();
    }

    public synchronized SearchResult[] getRunningSearches() {
        Object object;
        this.purgeSearches();
        LinkedList<SearchResult> linkedList = new LinkedList<SearchResult>();
        Iterator iterator = this.searches.iterator();
        while (iterator.hasNext()) {
            object = (Search)iterator.next();
            SearchResult searchResult = object.getSearchResult();
            linkedList.add(searchResult);
        }
        object = new SearchResult[linkedList.size()];
        linkedList.toArray((T[])object);
        return object;
    }

    public synchronized SearchConfig[] getConfiguredSearches() {
        SearchConfig[] searchConfigArray = new SearchConfig[this.configs.size()];
        this.configs.toArray(searchConfigArray);
        return searchConfigArray;
    }

    public synchronized void addSearch(SearchConfig searchConfig) {
        this.configs.add(searchConfig);
        if (StoradeEnvironment.getState() == 1) {
            this.runSearch(searchConfig);
        }
    }

    public synchronized void removeSearch(SearchConfig searchConfig) {
        Iterator iterator = this.configs.iterator();
        while (iterator.hasNext()) {
            SearchConfig searchConfig2 = (SearchConfig)iterator.next();
            if (!searchConfig.equals(searchConfig2)) continue;
            this.configs.remove(searchConfig2);
            return;
        }
    }

    public DeviceDetail[] getDiscoveredDevices(int n) throws RemoteException {
        Object object;
        DeviceConfig deviceConfig = DeviceConfig.getSystemConfig();
        Collection collection = deviceConfig.getConfigProperties();
        Iterator iterator = collection.iterator();
        LinkedList<DeviceDetailImpl> linkedList = new LinkedList<DeviceDetailImpl>();
        block7: while (iterator.hasNext()) {
            object = (Properties)iterator.next();
            String string = ((Properties)object).getProperty("search.oob");
            String string2 = ((Properties)object).getProperty("search.ib");
            switch (n) {
                case 2: {
                    if (string == null) continue block7;
                    linkedList.add(new DeviceDetailImpl((Properties)object));
                    break;
                }
                case 3: {
                    if (string == null || string2 != null) continue block7;
                    linkedList.add(new DeviceDetailImpl((Properties)object));
                    break;
                }
                case 4: {
                    if (string2 == null) continue block7;
                    linkedList.add(new DeviceDetailImpl((Properties)object));
                    break;
                }
                case 5: {
                    if (string2 == null || string != null) continue block7;
                    linkedList.add(new DeviceDetailImpl((Properties)object));
                    break;
                }
                case 6: {
                    if (string2 == null || string == null) continue block7;
                    linkedList.add(new DeviceDetailImpl((Properties)object));
                    break;
                }
                default: {
                    linkedList.add(new DeviceDetailImpl((Properties)object));
                }
            }
        }
        object = new DeviceDetail[linkedList.size()];
        linkedList.toArray((T[])object);
        return object;
    }

    public void setDeviceMonitoring(String string, boolean bl) {
        DeviceConfig deviceConfig = DeviceConfig.getSystemConfig();
        Collection collection = deviceConfig.getConfigProperties();
        Iterator iterator = collection.iterator();
        LinkedList linkedList = new LinkedList();
        while (iterator.hasNext()) {
            Properties properties = (Properties)iterator.next();
            String string2 = properties.getProperty("OID");
            if (!string.equals(string2)) continue;
            properties.setProperty("active", bl ? "Y" : "N");
            deviceConfig.store();
            try {
                FacadeFactory facadeFactory = (FacadeFactory)InstallerServiceFinder.findLocalService((Class)(class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory == null ? (class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory = DiscoveryServiceImpl.class$("com.sun.netstorage.mgmt.esm.logic.device.factory.FacadeFactory")) : class$com$sun$netstorage$mgmt$esm$logic$device$factory$FacadeFactory));
                if (facadeFactory == null) {
                    PACKAGE.ERROR("Error finding MF factory.");
                    return;
                }
                if (bl) {
                    facadeFactory.installDevice(properties);
                } else {
                    facadeFactory.removeDevice(properties);
                }
            }
            catch (Exception exception) {
                PACKAGE.ERROR("Error setting device active flag.");
                return;
            }
            return;
        }
    }

    public void removeUnmonitoredDevices() throws RemoteException {
        DeviceConfig deviceConfig = DeviceConfig.getSystemConfig();
        Collection collection = deviceConfig.getConfigProperties();
        Iterator iterator = collection.iterator();
        LinkedList linkedList = new LinkedList();
        while (iterator.hasNext()) {
            Properties properties = (Properties)iterator.next();
            String string = properties.getProperty("active");
            if ("Y".equals(string)) continue;
            deviceConfig.removeDevice(properties);
        }
    }

    private synchronized void purgeSearches() {
        LinkedList<Search> linkedList = new LinkedList<Search>();
        Iterator iterator = this.searches.iterator();
        while (iterator.hasNext()) {
            Search search = (Search)iterator.next();
            SearchResult searchResult = search.getSearchResult();
            if (searchResult.getStatus() != 1) continue;
            linkedList.add(search);
        }
        this.searches = linkedList;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BootStarter
    implements Runnable {
        DiscoveryServiceImpl ds;

        BootStarter(DiscoveryServiceImpl discoveryServiceImpl2) {
            this.ds = discoveryServiceImpl2;
        }

        public void run() {
            StoradeEnvironment.waitState((int)1);
            DiscoveryServiceImpl.this.scheduler = new DiscoveryScheduler(this.ds);
        }
    }
}

