/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.discovery.impl;

import com.sun.jade.util.unittest.ClassTest;
import com.sun.netstorage.mgmt.esm.logic.device.api.ConfigItem;
import com.sun.netstorage.mgmt.esm.logic.device.api.DeviceConfig;
import com.sun.netstorage.mgmt.esm.logic.discovery.api.DeviceDetail;
import com.sun.netstorage.mgmt.esm.logic.identity.api.DeviceFlavor;
import com.sun.netstorage.mgmt.esm.logic.identity.api.DeviceType;
import com.sun.netstorage.mgmt.esm.logic.identity.api.ElementModel;
import com.sun.netstorage.mgmt.esm.logic.identity.api.ElementVendor;
import java.util.Date;
import java.util.Properties;

public class DeviceDetailImpl
implements DeviceDetail {
    private String key;
    private DeviceType deviceType;
    private String displayName;
    private boolean isMonitored;
    private Date discovered;
    private int type;
    public static final String sccs_id = "@(#)DeviceDetailImpl.java\t1.7 05/12/03 SMI";

    public DeviceDetailImpl(Properties properties) {
        String string;
        String string2 = properties.getProperty("type");
        DeviceConfig deviceConfig = new DeviceConfig(string2);
        ConfigItem configItem = deviceConfig.getDevice();
        this.key = properties.getProperty("OID");
        if (this.key == null) {
            this.key = string2 + ":" + properties.getProperty("name");
        }
        if ("Y".equalsIgnoreCase(string = properties.getProperty("active"))) {
            this.isMonitored = true;
        }
        this.displayName = properties.getProperty("logicalName");
        String string3 = properties.getProperty("CATEGORY");
        String string4 = properties.getProperty("VENDOR");
        String string5 = properties.getProperty("MODEL");
        Properties properties2 = configItem.getProps();
        if (string3 == null && properties2 != null) {
            string3 = properties2.getProperty("CATEGORY");
        }
        if (string4 == null && properties2 != null) {
            string4 = properties2.getProperty("VENDOR");
        }
        if (string5 == null && properties2 != null) {
            string5 = properties2.getProperty("MODEL");
        }
        DeviceFlavor deviceFlavor = null;
        if ("hosts".equals(string3)) {
            deviceFlavor = DeviceFlavor.HOST;
        } else if ("hbas".equals(string3)) {
            deviceFlavor = DeviceFlavor.HBA;
        } else if ("switches".equals(string3)) {
            deviceFlavor = DeviceFlavor.SWITCH;
        } else if ("storage".equals(string3)) {
            deviceFlavor = DeviceFlavor.ARRAY;
        }
        if (string4 == null) {
            string4 = "?";
        }
        if (string5 == null) {
            string5 = string2 != null ? string2 : "?";
        }
        ElementVendor elementVendor = ElementVendor.getInstance((String)string4);
        ElementModel elementModel = ElementModel.getInstance((String)string5);
        this.deviceType = DeviceType.getInstance((DeviceFlavor)deviceFlavor, (ElementVendor)elementVendor, (ElementModel)elementModel);
        String string6 = properties.getProperty("search.oob");
        String string7 = properties.getProperty("search.ib");
        long l = 0L;
        if (string6 != null && string7 != null) {
            this.type = 3;
            l = Long.parseLong(string6);
        } else if (string6 != null) {
            this.type = 1;
            l = Long.parseLong(string6);
        } else if (string7 != null) {
            this.type = 2;
            l = Long.parseLong(string7);
        }
        if (l != 0L) {
            this.discovered = new Date(l);
        }
    }

    public String getDeviceKey() {
        return this.key;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean getMonitorState() {
        return this.isMonitored;
    }

    public Date getLastDiscovery() {
        return this.discovered;
    }

    public int getSearchType() {
        return this.type;
    }

    public static class Test
    extends ClassTest {
        public void test() throws Exception {
            Properties properties = new Properties();
            properties.setProperty("type", "fake");
            properties.setProperty("OID", "mykey");
            properties.setProperty("active", "Y");
            properties.setProperty("logicalName", "myname");
            properties.setProperty("ip", "myaddress");
            properties.setProperty("search.oob", "12345");
            DeviceDetailImpl deviceDetailImpl = new DeviceDetailImpl(properties);
            this.verifySerialization(deviceDetailImpl);
            this.assertEquals(deviceDetailImpl.getDeviceKey(), "mykey");
            this.assertNotNull(deviceDetailImpl.getDeviceType());
            this.assertEquals("myname", deviceDetailImpl.getDisplayName());
            this.assertCondition(deviceDetailImpl.getMonitorState());
            this.assertCondition(1 == deviceDetailImpl.getSearchType());
        }
    }
}

