/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.services.topology;

import com.sun.netstorage.mgmt.services.topology.ModelNodeAdapterSim;
import com.sun.netstorage.mgmt.services.topology.stubs.ModelNode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

public class TopoDebugger
extends ModelNodeAdapterSim {
    private BufferedReader bufReader_ = null;
    private static final String RETRIEVED = "Retrieved";
    private static final String NODE = "ModelNode";
    private static final String OID = "oid:";
    private static final String PARENT = "parentOid:";
    private static final String TYPE = "type:";
    private static final String STATUS = "status:";
    private static final String NAME = "name:";
    private static final String WWN = "WWN:";
    private static final String CHILDREN = "childOid[]:";
    private static final String ATTACHED = "attachedOid[]:";
    private static int attemptedNodeCount_ = 0;
    private static int actualNodeCount_ = 0;
    private Map nodes_ = null;
    static final String sccs_id = "@(#)TopoDebugger.java 1.5   02/11/14 SMI";

    public TopoDebugger(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        this.bufReader_ = new BufferedReader(inputStreamReader);
        this.nodes_ = new HashMap();
    }

    protected Map beginReverseEngineer() throws IOException {
        String string = this.bufReader_.readLine();
        int n = 1;
        while (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2.equals(RETRIEVED)) {
                    string2 = stringTokenizer.nextToken();
                    attemptedNodeCount_ = Integer.parseInt(string2);
                    continue;
                }
                if (!string2.equals(NODE)) continue;
                this.parseNode(stringTokenizer, string);
            }
            string = this.bufReader_.readLine();
            ++n;
        }
        super.reverseEngineer(this.nodes_, null);
        return this.nodes_;
    }

    protected void dump(Map map) {
        int n = 0;
        System.out.println();
        System.out.println("***** TopoDebugger.dumpModelNodes(), REVERSE_ENGINEER GJG_DEBUG, BEGIN_DUMP: *****");
        System.out.println("NOTE: ModelNode order not guaranteed the same order as from file! ");
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            ModelNode modelNode = (ModelNode)iterator.next();
            System.out.println();
            System.out.println("ModelNode " + n++ + ": ");
            System.out.println("\toid: " + modelNode.getOid());
            System.out.println("\tparentOid: " + modelNode.getParentOid());
            System.out.println("\ttype: " + modelNode.getType());
            System.out.println("\tstatus: " + modelNode.getStatus());
            System.out.println("\tname: " + modelNode.getName());
            System.out.println("\tWWN: " + modelNode.getWWN());
            String[] stringArray = modelNode.getChildOids();
            System.out.println("\tchildOid[]:");
            int n2 = 0;
            while (n2 < stringArray.length) {
                System.out.println("\t\t" + stringArray[n2]);
                ++n2;
            }
            System.out.println();
            String[] stringArray2 = modelNode.getAttachedNodeOids();
            System.out.println("\tattachedOid[]:");
            int n3 = 0;
            while (n3 < stringArray2.length) {
                System.out.println("\t\t" + stringArray2[n3]);
                ++n3;
            }
            System.out.println();
        }
        System.out.println();
        System.out.println("***** REVERSE_ENGINEER GJG_DEBUG, END_DUMP: *****");
    }

    protected int getActualNodeCount() {
        return actualNodeCount_;
    }

    protected int getAttemptedNodeCount() {
        return attemptedNodeCount_;
    }

    private void parseNode(StringTokenizer stringTokenizer, String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string2 = this.bufReader_.readLine();
        int n = string2.indexOf("oid: ") + 5;
        String string3 = string2.substring(n);
        String string4 = this.bufReader_.readLine();
        n = string4.indexOf("parentOid: ") + 11;
        String string5 = string4.substring(n);
        String string6 = this.bufReader_.readLine();
        stringTokenizer = new StringTokenizer(string6);
        stringTokenizer.nextToken();
        String string7 = stringTokenizer.nextToken();
        this.bufReader_.readLine();
        String string8 = this.bufReader_.readLine();
        stringTokenizer = new StringTokenizer(string8);
        stringTokenizer.nextToken();
        String string9 = stringTokenizer.nextToken();
        this.bufReader_.readLine();
        String[] stringArray = null;
        string = this.bufReader_.readLine();
        string = this.bufReader_.readLine();
        while (!string.endsWith(ATTACHED) && string.length() > 0) {
            arrayList.add(string.trim());
            string = this.bufReader_.readLine();
        }
        string = this.bufReader_.readLine();
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        String[] stringArray2 = null;
        if (string.endsWith(ATTACHED)) {
            string = this.bufReader_.readLine();
            while (!string.startsWith(NODE) && string.length() > 0) {
                arrayList2.add(string.trim());
                string = this.bufReader_.readLine();
            }
        }
        stringArray2 = arrayList2.toArray(new String[arrayList2.size()]);
        ModelNode modelNode = new ModelNode(string3, string5, string7, stringArray, stringArray2, string9, null, null, null, null, null, null);
        this.nodes_.put(string3, modelNode);
        ++actualNodeCount_;
    }
}

