/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.services.topology;

import com.sun.jade.apps.topology.EdgeUserObject;
import com.sun.jade.apps.topology.EndPointUserObject;
import com.sun.jade.apps.topology.IdResolver;
import com.sun.jade.apps.topology.TopologyService;
import com.sun.jade.apps.topology.ZoneSummary;
import com.sun.jade.apps.topology.graph.model.BasicEdge;
import com.sun.jade.apps.topology.graph.model.BasicEdgeSet;
import com.sun.jade.apps.topology.graph.model.BasicNode;
import com.sun.jade.apps.topology.graph.model.Graph;
import com.sun.jade.cim.util.ReferenceForMSE;
import com.sun.jade.logic.mf.MF;
import com.sun.jade.ui.topology.TopologyNode;
import com.sun.jade.ui.topology.tree.DefaultTreeNode;
import com.sun.netstorage.mgmt.esm.logic.alarmservice.api.AlarmService;
import com.sun.netstorage.mgmt.esm.logic.alarmservice.api.AlarmSummary;
import com.sun.netstorage.mgmt.esm.logic.identity.api.DeviceFlavor;
import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityException;
import com.sun.netstorage.mgmt.services.topology.Configuration;
import com.sun.netstorage.mgmt.services.topology.FabricId;
import com.sun.netstorage.mgmt.services.topology.FabricTopology;
import com.sun.netstorage.mgmt.services.topology.RootRealm;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.TSTopologyEdge;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyDuplicateElementException;
import com.sun.netstorage.mgmt.services.topology.TopologyEdgeAdapter;
import com.sun.netstorage.mgmt.services.topology.TopologyElementNotFoundException;
import com.sun.netstorage.mgmt.services.topology.TopologyGraph;
import com.sun.netstorage.mgmt.services.topology.TopologyMalformedNodeException;
import com.sun.netstorage.mgmt.services.topology.TopologyNodeAdapter;
import com.sun.netstorage.mgmt.services.topology.TopologyServiceImpl;
import com.sun.netstorage.mgmt.services.topology.ZoneImpl;
import java.io.PrintWriter;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class StoradeAdapter {
    static final String sccs_id = "@(#)StoradeAdapter.java 1.62  03/10/02 SMI";
    private TopologyServiceImpl topoEngine_ = null;
    private EndPointUserObject[] endPointsForZones_ = null;
    private TopologyService sadeTopoService_ = null;
    private Map topoEngineNodes_ = null;
    private List allSwitches_ = null;
    private Map jadeNodes_ = null;
    private Map composites_ = null;
    private List nodeIds_ = null;
    private Map fabricIds_ = null;
    private List allJadeEdges_ = null;
    private static final String RESERVED = "Reserved For Future Use! ";
    private static final String EDGE_SEMANTIC = "EDGE semantic reserved! ";
    private static final String CONTACT = "contact";
    private static final String LOCATION = "location";
    private static final String CHILD_IDS_KEY = "TEMP Child OIDS";
    private static final String ZONE_NAMES_KEY = "TEMP Zone Names";
    private static final String PARENT_OID_KEY = "TEMP Parent OID";
    private static final String OUT_EDGE_USER_OBJECTS_LIST_KEY = "TEMP JADE Edge User Objects List";
    private PrintWriter out_ = null;
    private int jadeNodeCount_ = 0;
    private long debuggerOutputTime_ = 0L;
    private int edgeUserObjectCount_ = 0;
    private int zoneCount_ = 0;
    private long jadePullTotalTime_ = 0L;
    private int fruCount_ = 0;
    private long alarmServicePullTime_ = 0L;
    private long zoneIdentityPullTime_ = 0L;
    private long topoEngineTranslationTime_ = 0L;
    private static final String ALARM_SERVICE_PKG_NAME = "com.sun.netstorage.mgmt.esm.logic.alarmservice.api";

    public StoradeAdapter(TopologyService topologyService) {
        this.sadeTopoService_ = topologyService;
        this.topoEngine_ = TopologyServiceImpl.getInstance();
        this.topoEngineNodes_ = new HashMap();
        this.jadeNodes_ = new HashMap();
        this.allSwitches_ = new ArrayList();
        this.composites_ = new HashMap();
        this.nodeIds_ = new ArrayList();
        this.fabricIds_ = new HashMap();
        this.allJadeEdges_ = new ArrayList();
    }

    private void addZoneIdentities() {
        block6: {
            SanTopology sanTopology = this.topoEngine_.getSanTopologyCached();
            try {
                Iterator iterator = this.fabricIds_.keySet().iterator();
                while (iterator.hasNext()) {
                    Identity identity = (Identity)iterator.next();
                    FabricId fabricId = (FabricId)this.fabricIds_.get(identity);
                    long l = System.currentTimeMillis();
                    ZoneSummary[] zoneSummaryArray = this.sadeTopoService_.getZones(identity);
                    if (this.out_ != null) {
                        this.zoneIdentityPullTime_ += System.currentTimeMillis() - l;
                    }
                    int n = 0;
                    while (n < zoneSummaryArray.length) {
                        String string = zoneSummaryArray[n].getName();
                        Identity identity2 = zoneSummaryArray[n].getIdentity();
                        String string2 = zoneSummaryArray[n].getType().toString();
                        FabricTopology fabricTopology = sanTopology.getFabric(fabricId.getFabricName());
                        ZoneImpl zoneImpl = (ZoneImpl)fabricTopology.getZone(string);
                        if (zoneImpl != null) {
                            zoneImpl.setIdentity(identity2);
                            zoneImpl.setType(string2);
                        }
                        ++n;
                    }
                }
            }
            catch (RemoteException remoteException) {
                if (this.out_ == null) break block6;
                this.out_.println("RemoteException thrown in StoradeAdapter.addZoneIdentities()! " + remoteException.getMessage());
                this.out_.println(remoteException.getMessage());
            }
        }
    }

    private Map assembleProps(Properties properties) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string7 = properties.getProperty("logicalName");
        String string8 = properties.getProperty("name");
        if (string7 == null) {
            string7 = string8;
        }
        if (string7 != null) {
            hashMap.put("Logical Name", string7);
        }
        if (this.out_ != null) {
            long l = System.currentTimeMillis();
            this.out_.println("\t LogicalName PROPERTY = " + string8);
            this.out_.println("\t Name PROPERTY = " + string8);
            this.debuggerOutputTime_ += System.currentTimeMillis() - l;
        }
        if ((string6 = properties.getProperty("VENDOR")) != null) {
            hashMap.put("Vendor", string6);
            if (this.out_ != null) {
                long l = System.currentTimeMillis();
                this.out_.println("\t vendor PROPERTY = " + string6);
                this.debuggerOutputTime_ += System.currentTimeMillis() - l;
            }
        }
        if ((string5 = properties.getProperty("MODEL")) != null) {
            hashMap.put("Model Number", string5);
            if (this.out_ != null) {
                long l = System.currentTimeMillis();
                this.out_.println("\t model PROPERTY = " + string5);
                this.debuggerOutputTime_ += System.currentTimeMillis() - l;
            }
        }
        if ((string4 = properties.getProperty("wwn")) != null) {
            hashMap.put("WWN", string4);
            if (this.out_ != null) {
                long l = System.currentTimeMillis();
                this.out_.println("\t WWN PROPERTY = " + string4);
                this.debuggerOutputTime_ += System.currentTimeMillis() - l;
            }
        }
        if ((string3 = properties.getProperty("ipno")) != null) {
            hashMap.put("IP Address", string3);
            if (this.out_ != null) {
                long l = System.currentTimeMillis();
                this.out_.println("\t IP Address PROPERTY = " + string3);
                this.debuggerOutputTime_ += System.currentTimeMillis() - l;
            }
        }
        if ((string2 = properties.getProperty(CONTACT)) != null) {
            hashMap.put("Contact", string2);
            if (this.out_ != null) {
                long l = System.currentTimeMillis();
                this.out_.println("\t contact PROPERTY = " + string2);
                this.debuggerOutputTime_ += System.currentTimeMillis() - l;
            }
        }
        if ((string = properties.getProperty(LOCATION)) != null) {
            hashMap.put("Location", string);
            if (this.out_ != null) {
                long l = System.currentTimeMillis();
                this.out_.println("\t location PROPERTY = " + string);
                this.debuggerOutputTime_ += System.currentTimeMillis() - l;
            }
        }
        return hashMap;
    }

    private void assembleTempEdgeProp(BasicNode basicNode, TopologyNodeAdapter topologyNodeAdapter) {
        ArrayList<EdgeUserObject> arrayList = new ArrayList<EdgeUserObject>();
        BasicEdgeSet basicEdgeSet = basicNode.getOutEdgeSet();
        Iterator iterator = basicEdgeSet.edges();
        while (iterator.hasNext()) {
            BasicEdge basicEdge = (BasicEdge)iterator.next();
            EdgeUserObject edgeUserObject = (EdgeUserObject)basicEdge.getUserObject();
            arrayList.add(edgeUserObject);
            this.allJadeEdges_.add(edgeUserObject);
        }
        if (arrayList.size() > 0) {
            topologyNodeAdapter.setProperty(OUT_EDGE_USER_OBJECTS_LIST_KEY, arrayList);
        }
    }

    private TSTopologyNode attemptInlinePortNodeCreation(TSTopologyNode tSTopologyNode, String string) {
        TSTopologyNode tSTopologyNode2 = null;
        try {
            String string2 = "com.sun.netstorage.mgmt.component.model.domain.NxPort";
            String string3 = tSTopologyNode.getType();
            if (string3.equals("com.sun.netstorage.mgmt.component.model.domain.Switch")) {
                string2 = "com.sun.netstorage.mgmt.component.model.domain.SwitchPort";
            }
            tSTopologyNode2 = this.topoEngine_.addNode(string, RESERVED, string2, null, null, null, tSTopologyNode);
            this.topoEngine_.addChildren(tSTopologyNode, new TSTopologyNode[]{tSTopologyNode2});
            if (this.out_ != null) {
                long l = System.currentTimeMillis();
                this.out_.println();
                this.out_.println("*** INLINE FRU PORT NODE CREATION ***");
                this.out_.println("*** NEW DYNAMIC NODE CREATED ***:");
                this.out_.println("OID = " + string + ", type = " + tSTopologyNode2.getType());
                this.out_.println();
                this.debuggerOutputTime_ += System.currentTimeMillis() - l;
            }
        }
        catch (TopologyDuplicateElementException topologyDuplicateElementException) {
        }
        catch (TopologyMalformedNodeException topologyMalformedNodeException) {
        }
        catch (TopologyElementNotFoundException topologyElementNotFoundException) {}
        return tSTopologyNode2;
    }

    protected TSTopologyNode[] beginStoradePull(PrintWriter printWriter) {
        try {
            this.out_ = printWriter;
            long l = System.currentTimeMillis();
            Graph graph = this.sadeTopoService_.getGraph();
            this.endPointsForZones_ = this.sadeTopoService_.getEndPoints();
            if (this.out_ != null) {
                this.jadePullTotalTime_ += System.currentTimeMillis() - l;
                long l2 = System.currentTimeMillis();
                this.out_.println("StoradeAdapter.beginStoradePull() GJG_DEBUG:");
                this.out_.println("Retrieved *** " + graph.getNodeCount() + " *** raw MF nodes from JADE.");
                this.out_.println();
                this.debuggerOutputTime_ += System.currentTimeMillis() - l2;
            }
            if (graph != null && graph.getNodeCount() > 0) {
                this.translateAllNodes(graph);
                this.translateComposites();
                this.translateEdges();
                this.translateZones();
                this.resolveFloatingHBAs();
                this.moveAllOrphans();
                this.getAlarms();
                this.removeTempProps();
                if (this.out_ != null) {
                    this.topoEngineTranslationTime_ += System.currentTimeMillis() - l;
                    this.debugOutputStats();
                }
            }
        }
        catch (RemoteException remoteException) {
            if (this.out_ != null) {
                this.out_.println("RemoteException thrown in StoradeAdapter.beginStoradePull()! " + remoteException.getMessage());
            }
            return null;
        }
        return this.topoEngineNodes_.values().toArray(new TSTopologyNode[this.topoEngineNodes_.size()]);
    }

    private void createEdges(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, String string) throws TopologyElementNotFoundException {
        boolean bl = false;
        if (tSTopologyNode.getType().equals("com.sun.netstorage.mgmt.component.model.domain.NxPort") && tSTopologyNode2.getType().equals("com.sun.netstorage.mgmt.component.model.domain.NxPort")) {
            bl = true;
        }
        this.topoEngine_.addEdge(tSTopologyNode, tSTopologyNode2, string, bl, null);
        String string2 = tSTopologyNode.getImmediateParent().getOid();
        TSTopologyNode tSTopologyNode3 = (TSTopologyNode)this.topoEngineNodes_.get(string2);
        String string3 = tSTopologyNode2.getImmediateParent().getOid();
        TSTopologyNode tSTopologyNode4 = (TSTopologyNode)this.topoEngineNodes_.get(string3);
        try {
            this.topoEngine_.addEdge(tSTopologyNode3, tSTopologyNode4, string, bl, null);
        }
        catch (TopologyElementNotFoundException topologyElementNotFoundException) {
            FabricId fabricId = this.determineFabric(tSTopologyNode3, tSTopologyNode);
            try {
                this.topoEngine_.addNode(tSTopologyNode3.getOid(), tSTopologyNode3.getId(), tSTopologyNode3.getType(), tSTopologyNode3.getProperties(), tSTopologyNode3.getChildren(), fabricId, tSTopologyNode3.getImmediateParent());
            }
            catch (TopologyMalformedNodeException topologyMalformedNodeException) {
            }
            catch (TopologyDuplicateElementException topologyDuplicateElementException) {
                // empty catch block
            }
            try {
                this.topoEngine_.addNode(tSTopologyNode4.getOid(), tSTopologyNode4.getId(), tSTopologyNode4.getType(), tSTopologyNode4.getProperties(), tSTopologyNode4.getChildren(), fabricId, tSTopologyNode4.getImmediateParent());
            }
            catch (TopologyMalformedNodeException topologyMalformedNodeException) {
            }
            catch (TopologyDuplicateElementException topologyDuplicateElementException) {
                // empty catch block
            }
            this.topoEngine_.addEdge(tSTopologyNode3, tSTopologyNode4, string, bl, null);
        }
        if (tSTopologyNode3.getType().equals("com.sun.netstorage.mgmt.component.model.domain.HBA")) {
            this.moveHost(tSTopologyNode3);
        } else if (tSTopologyNode4.getType().equals("com.sun.netstorage.mgmt.component.model.domain.HBA")) {
            this.moveHost(tSTopologyNode4);
        }
    }

    private void debugOutputStats() {
        Object object;
        long l = System.currentTimeMillis();
        this.out_.println("Alarm Service pull time: *** " + this.alarmServicePullTime_ + "ms ***");
        this.out_.println();
        this.out_.println("JADE RMI total pull time: *** " + this.jadePullTotalTime_ + "ms ***");
        this.out_.println();
        this.out_.println("Applicable JADE FRUs successfully translated: *** " + this.fruCount_ + " ***");
        this.out_.println();
        SanTopology sanTopology = this.topoEngine_.getSanTopologyCached();
        int n = sanTopology.getFabricCount();
        this.out_.println("Total fabric count: *** " + n + " fabrics ***");
        this.out_.println();
        this.out_.println("Orphan oids: ");
        TSTopologyNode[] tSTopologyNodeArray = this.topoEngine_.getOrphanNodes();
        int n2 = 0;
        while (n2 < tSTopologyNodeArray.length) {
            this.out_.println("\t Orphan[" + n2 + "] OID = " + tSTopologyNodeArray[n2].getOid() + " type = " + tSTopologyNodeArray[n2].getType());
            ++n2;
        }
        this.out_.println();
        this.out_.println("Default Fabric Node OIDS: ");
        FabricTopology fabricTopology = sanTopology.getFabric("DEFAULT_FABRIC");
        if (fabricTopology != null) {
            object = fabricTopology.getPhysicalTopology().getNodes();
            int n3 = 0;
            while (n3 < ((TSTopologyNode[])object).length) {
                this.out_.println("\t Default Fabric Node[" + n3 + "] OID = " + object[n3].getOid() + " type = " + object[n3].getType());
                ++n3;
            }
        }
        this.out_.println();
        this.out_.println("DAS Node OIDS: ");
        object = sanTopology.getDasTopology();
        if (object != null) {
            TSTopologyNode[] tSTopologyNodeArray2 = object.getNodes();
            int n4 = 0;
            while (n4 < tSTopologyNodeArray2.length) {
                this.out_.println("\t DAS Node[" + n4 + "] OID = " + tSTopologyNodeArray2[n4].getOid() + " type = " + tSTopologyNodeArray2[n4].getType());
                ++n4;
            }
        }
        this.debuggerOutputTime_ += System.currentTimeMillis() - l;
        this.out_.println("Topology engine debug outputter time: *** " + this.debuggerOutputTime_ + "ms *** ");
        this.out_.println();
    }

    private TSTopologyNode deduceHeadNode(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2) {
        TSTopologyNode tSTopologyNode3 = tSTopologyNode;
        TSTopologyNode tSTopologyNode4 = tSTopologyNode.getImmediateParent();
        TSTopologyNode tSTopologyNode5 = tSTopologyNode2.getImmediateParent();
        String string = tSTopologyNode4.getType();
        String string2 = tSTopologyNode5.getType();
        if (string.equals("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem")) {
            tSTopologyNode3 = tSTopologyNode2;
        } else if (string.equals("com.sun.netstorage.mgmt.component.model.domain.Switch") && string2.equals("com.sun.netstorage.mgmt.component.model.domain.HBA")) {
            tSTopologyNode3 = tSTopologyNode2;
        }
        return tSTopologyNode3;
    }

    private TSTopologyNode deduceTailNode(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2) {
        TSTopologyNode tSTopologyNode3 = tSTopologyNode2;
        TSTopologyNode tSTopologyNode4 = tSTopologyNode.getImmediateParent();
        TSTopologyNode tSTopologyNode5 = tSTopologyNode2.getImmediateParent();
        String string = tSTopologyNode4.getType();
        String string2 = tSTopologyNode5.getType();
        if (string.equals("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem")) {
            tSTopologyNode3 = tSTopologyNode;
        } else if (string.equals("com.sun.netstorage.mgmt.component.model.domain.Switch") && string2.equals("com.sun.netstorage.mgmt.component.model.domain.HBA")) {
            tSTopologyNode3 = tSTopologyNode;
        }
        return tSTopologyNode3;
    }

    private FabricId determineFabric(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2) {
        FabricId fabricId = null;
        SanTopology sanTopology = null;
        sanTopology = this.topoEngine_.getSanTopologyCached();
        FabricTopology[] fabricTopologyArray = sanTopology.getFabrics();
        int n = 0;
        while (n < fabricTopologyArray.length) {
            if (tSTopologyNode.getType().equals("com.sun.netstorage.mgmt.component.model.domain.Switch") && fabricTopologyArray[n].contains(tSTopologyNode) || !fabricTopologyArray[n].contains(tSTopologyNode) && fabricTopologyArray[n].contains(tSTopologyNode2)) {
                fabricId = fabricTopologyArray[n].getFabricId();
                return fabricId;
            }
            ++n;
        }
        return fabricId;
    }

    private void getAlarms() {
        block7: {
            try {
                int n = -1;
                String string = Configuration.getProperty("TR_REGISTRY_HOST");
                String string2 = Configuration.getProperty("TR_RMI_REGISTRY_PORT");
                if (string2 != null) {
                    n = Integer.parseInt(string2);
                }
                Registry registry = LocateRegistry.getRegistry(string, n);
                long l = System.currentTimeMillis();
                AlarmService alarmService = (AlarmService)registry.lookup(ALARM_SERVICE_PKG_NAME);
                this.alarmServicePullTime_ += System.currentTimeMillis() - l;
                Identity[] identityArray = this.reconstituteIds();
                l = System.currentTimeMillis();
                Map map = alarmService.retrieveMostXAlarmSummaries(identityArray, AlarmService.ALL_SEVERITIES, new int[]{0}, new int[]{9}, this.topoEngine_.getLocale(), true);
                this.alarmServicePullTime_ += System.currentTimeMillis() - l;
                this.translateAlarmSummaries(map);
                this.translateEdgeAlarms(alarmService);
            }
            catch (RemoteException remoteException) {
                if (this.out_ != null) {
                    this.out_.println("RemoteException thrown in StoradeAdapter.translateAlarms()! " + remoteException.getMessage());
                }
            }
            catch (NotBoundException notBoundException) {
                if (this.out_ != null) {
                    this.out_.println("NotBoundException thrown in StoradeAdapter.translateAlarms()! " + notBoundException.getMessage());
                }
            }
            catch (IdentityException identityException) {
                if (this.out_ == null) break block7;
                this.out_.println("IdentityException thrown in StoradeAdapter.translateAlarms()! " + identityException.getMessage());
            }
        }
    }

    private String mapType(DeviceFlavor deviceFlavor) {
        if (this.out_ != null) {
            long l = System.currentTimeMillis();
            this.out_.println("\t DeviceFlavor (aka TYPE) = " + deviceFlavor.toString());
            this.debuggerOutputTime_ += System.currentTimeMillis() - l;
        }
        if (deviceFlavor.equals((Object)DeviceFlavor.HOST)) {
            return "com.sun.netstorage.mgmt.component.model.domain.StorageHost";
        }
        if (deviceFlavor.equals((Object)DeviceFlavor.SWITCH)) {
            return "com.sun.netstorage.mgmt.component.model.domain.Switch";
        }
        if (deviceFlavor.equals((Object)DeviceFlavor.ARRAY)) {
            return "com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem";
        }
        if (deviceFlavor.equals((Object)DeviceFlavor.HBA)) {
            return "com.sun.netstorage.mgmt.component.model.domain.HBA";
        }
        return deviceFlavor.toString();
    }

    private void moveAllOrphans() {
        this.topoEngine_.moveAllOrphans();
    }

    private void moveHost(TSTopologyNode tSTopologyNode) {
        block8: {
            FabricId fabricId = null;
            TSTopologyNode tSTopologyNode2 = null;
            FabricTopology[] fabricTopologyArray = this.topoEngine_.getSanTopologyCached().getFabrics();
            int n = 0;
            while (n < fabricTopologyArray.length) {
                if (fabricTopologyArray[n].contains(tSTopologyNode)) {
                    fabricId = fabricTopologyArray[n].getFabricId();
                    tSTopologyNode2 = tSTopologyNode.getImmediateParent();
                    try {
                        this.topoEngine_.addNode(tSTopologyNode2.getOid(), tSTopologyNode2.getId(), tSTopologyNode2.getType(), tSTopologyNode2.getProperties(), tSTopologyNode2.getChildren(), fabricId, null);
                    }
                    catch (TopologyDuplicateElementException topologyDuplicateElementException) {
                    }
                    catch (TopologyMalformedNodeException topologyMalformedNodeException) {
                        // empty catch block
                    }
                }
                ++n;
            }
            TopologyGraph topologyGraph = this.topoEngine_.getSanTopologyCached().getDasTopology();
            if (!topologyGraph.contains(tSTopologyNode)) break block8;
            fabricId = new FabricId("DAS Topology", "Default Root SAN");
            tSTopologyNode2 = tSTopologyNode.getImmediateParent();
            try {
                this.topoEngine_.addNode(tSTopologyNode2.getOid(), tSTopologyNode2.getId(), tSTopologyNode2.getType(), tSTopologyNode2.getProperties(), tSTopologyNode2.getChildren(), fabricId, null);
            }
            catch (TopologyDuplicateElementException topologyDuplicateElementException) {
            }
            catch (TopologyMalformedNodeException topologyMalformedNodeException) {}
        }
    }

    private Identity[] reconstituteIds() {
        Identity[] identityArray = new Identity[this.jadeNodes_.size()];
        int n = 0;
        Iterator iterator = this.jadeNodes_.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Identity identity = Identity.reconstitute((String)string);
            identityArray[n++] = identity;
        }
        return identityArray;
    }

    private void removeTempProps() {
        Iterator iterator = this.topoEngineNodes_.values().iterator();
        while (iterator.hasNext()) {
            TopologyNodeAdapter topologyNodeAdapter = (TopologyNodeAdapter)iterator.next();
            topologyNodeAdapter.removeProperty(CHILD_IDS_KEY);
            topologyNodeAdapter.removeProperty(ZONE_NAMES_KEY);
            topologyNodeAdapter.removeProperty(PARENT_OID_KEY);
            topologyNodeAdapter.removeProperty(OUT_EDGE_USER_OBJECTS_LIST_KEY);
        }
    }

    private void resolveFloatingHBAs() {
        TSTopologyNode[] tSTopologyNodeArray;
        TSTopologyNode[] tSTopologyNodeArray2;
        SanTopology sanTopology = this.topoEngine_.getSanTopologyCached();
        FabricTopology[] fabricTopologyArray = sanTopology.getFabrics();
        int n = 0;
        while (n < fabricTopologyArray.length) {
            tSTopologyNodeArray2 = fabricTopologyArray[n].getPhysicalTopology().getNodesByType("com.sun.netstorage.mgmt.component.model.domain.StorageHost");
            if (tSTopologyNodeArray2.length > 0) {
                tSTopologyNodeArray = fabricTopologyArray[n].getFabricId();
                this.resolveFloatingHBAs((FabricId)tSTopologyNodeArray, tSTopologyNodeArray2);
            }
            ++n;
        }
        tSTopologyNodeArray2 = sanTopology.getDasTopology();
        tSTopologyNodeArray = tSTopologyNodeArray2.getNodesByType("com.sun.netstorage.mgmt.component.model.domain.StorageHost");
        if (tSTopologyNodeArray.length > 0) {
            FabricId fabricId = new FabricId("DAS Topology", "Default Root SAN");
            this.resolveFloatingHBAs(fabricId, tSTopologyNodeArray);
        }
    }

    private void resolveFloatingHBAs(FabricId fabricId, TSTopologyNode[] tSTopologyNodeArray) {
        int n = 0;
        while (n < tSTopologyNodeArray.length) {
            TSTopologyNode[] tSTopologyNodeArray2 = tSTopologyNodeArray[n].getChildren();
            int n2 = 0;
            while (n2 < tSTopologyNodeArray2.length) {
                TSTopologyEdge[] tSTopologyEdgeArray = tSTopologyNodeArray2[n2].getInEdges();
                TSTopologyEdge[] tSTopologyEdgeArray2 = tSTopologyNodeArray2[n2].getOutEdges();
                if (tSTopologyEdgeArray.length == 0 && tSTopologyEdgeArray2.length == 0) {
                    try {
                        this.topoEngine_.addNode(tSTopologyNodeArray2[n2].getOid(), tSTopologyNodeArray2[n2].getId(), tSTopologyNodeArray2[n2].getType(), tSTopologyNodeArray2[n2].getProperties(), tSTopologyNodeArray2[n2].getChildren(), fabricId, null);
                    }
                    catch (TopologyDuplicateElementException topologyDuplicateElementException) {
                    }
                    catch (TopologyMalformedNodeException topologyMalformedNodeException) {
                        // empty catch block
                    }
                    this.resolveFloatingPorts(tSTopologyNodeArray2[n2], fabricId);
                }
                ++n2;
            }
            ++n;
        }
    }

    private void resolveFloatingPorts(TSTopologyNode tSTopologyNode, FabricId fabricId) {
        TSTopologyNode[] tSTopologyNodeArray = tSTopologyNode.getChildren();
        int n = 0;
        while (n < tSTopologyNodeArray.length) {
            try {
                this.topoEngine_.addNode(tSTopologyNodeArray[n].getOid(), tSTopologyNodeArray[n].getId(), tSTopologyNodeArray[n].getType(), tSTopologyNodeArray[n].getProperties(), tSTopologyNodeArray[n].getChildren(), fabricId, null);
            }
            catch (TopologyDuplicateElementException topologyDuplicateElementException) {
            }
            catch (TopologyMalformedNodeException topologyMalformedNodeException) {
                // empty catch block
            }
            ++n;
        }
    }

    private void rollup() {
        Iterator iterator = this.topoEngineNodes_.values().iterator();
        while (iterator.hasNext()) {
            Integer n;
            TSTopologyNode tSTopologyNode = (TSTopologyNode)iterator.next();
            String string = (String)tSTopologyNode.getProperty("Alarm Identity");
            if (string == null) continue;
            Integer n2 = (Integer)tSTopologyNode.getProperty("Alarm Severity");
            TSTopologyNode tSTopologyNode2 = tSTopologyNode.getImmediateParent();
            if (tSTopologyNode2 == null) continue;
            String string2 = tSTopologyNode2.getType();
            if (string2.equals("com.sun.netstorage.mgmt.component.model.domain.HBA")) {
                tSTopologyNode2 = tSTopologyNode2.getImmediateParent();
                string2 = tSTopologyNode2.getType();
            }
            if (!string2.equals("com.sun.netstorage.mgmt.component.model.domain.StorageHost") && !string2.equals("com.sun.netstorage.mgmt.component.model.domain.Switch") && !string2.equals("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem") || (n = (Integer)tSTopologyNode2.getProperty("Alarm Severity")) != null && n >= n2) continue;
            String string3 = (String)tSTopologyNode.getProperty("Alarm Type");
            TopologyNodeAdapter topologyNodeAdapter = (TopologyNodeAdapter)this.topoEngineNodes_.get(tSTopologyNode2.getOid());
            topologyNodeAdapter.setProperty("Alarm Identity", (Object)string);
            topologyNodeAdapter.setProperty("Alarm Type", (Object)string3);
            topologyNodeAdapter.setProperty("Alarm Severity", (Object)n2);
        }
    }

    private void translateAlarmSummaries(Map map) {
        if (this.out_ != null) {
            long l = System.currentTimeMillis();
            this.out_.println("*** AlarmSummaries from AlarmService: ***");
            this.debuggerOutputTime_ += System.currentTimeMillis() - l;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Identity identity = (Identity)iterator.next();
            String string = identity.toCondensedString();
            TSTopologyNode tSTopologyNode = (TSTopologyNode)this.topoEngineNodes_.get(string);
            if (tSTopologyNode == null) continue;
            AlarmSummary alarmSummary = (AlarmSummary)map.get(identity);
            int n = alarmSummary.getSeverity();
            String string2 = alarmSummary.getAlarmId();
            String string3 = alarmSummary.getAlarmType();
            ((TopologyNodeAdapter)tSTopologyNode).setProperty("Alarm Severity", (Object)new Integer(n));
            ((TopologyNodeAdapter)tSTopologyNode).setProperty("Alarm Identity", (Object)string2);
            ((TopologyNodeAdapter)tSTopologyNode).setProperty("Alarm Type", (Object)string3);
            if (this.out_ == null) continue;
            long l = System.currentTimeMillis();
            this.out_.println("\t Individual AlarmSummary: ");
            this.out_.println("\t\t alarm summary element identity = " + identity);
            this.out_.println("\t\t actual OID into topo. engine node's map = " + string);
            this.out_.println("\t\t alarmSeverity = " + n);
            this.out_.println("\t\t alarmId = " + string2);
            this.out_.println("\t\t alarmType = " + string3);
            this.debuggerOutputTime_ += System.currentTimeMillis() - l;
        }
        this.rollup();
    }

    private void translateAllNodes(Graph graph) {
        if (this.out_ != null) {
            long l = System.currentTimeMillis();
            this.out_.println("GJG_DEBUG: *** DUMP ALL JADE NODES ***");
            this.out_.println();
            this.debuggerOutputTime_ += System.currentTimeMillis() - l;
        }
        Iterator iterator = graph.nodes();
        while (iterator.hasNext()) {
            BasicNode basicNode = (BasicNode)iterator.next();
            this.translateNode(basicNode);
            if (this.out_ == null) continue;
            long l = System.currentTimeMillis();
            this.out_.println();
            long l2 = System.currentTimeMillis();
            this.debuggerOutputTime_ += l2 - l;
        }
        if (this.out_ != null) {
            long l = System.currentTimeMillis();
            this.out_.println("*** END JADE NODE DUMP ***");
            this.out_.println();
            this.debuggerOutputTime_ += System.currentTimeMillis() - l;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void translateComposites() {
        var1_1 = null;
        var2_2 = this.composites_.keySet().iterator();
        while (var2_2.hasNext()) {
            var3_3 = (String)var2_2.next();
            var4_4 = (List)this.composites_.get(var3_3);
            var5_5 = new TSTopologyNode[var4_4.size()];
            var6_6 = 0;
            var7_7 = var4_4.iterator();
            while (var7_7.hasNext()) {
                var8_8 = (String)var7_7.next();
                var9_10 = (TSTopologyNode)this.topoEngineNodes_.get(var8_8);
                var5_5[var6_6++] = var9_10;
            }
            try {
                var1_1 = (TSTopologyNode)this.topoEngineNodes_.get(var3_3);
                this.topoEngine_.addChildren(var1_1, var5_5);
                continue;
            }
            catch (TopologyElementNotFoundException var8_9) {
                if (this.out_ == null) continue;
                var9_11 = System.currentTimeMillis();
                this.out_.println();
                this.out_.println("**********************************************************");
                this.out_.println("***GJG_DEBUG***: problem building composite, skipping! ");
                this.out_.println("parentOidKey = " + var3_3);
                this.out_.println("parentType = " + var1_1.getType());
                this.out_.println("children[] = ");
                var11_12 = 0;
                ** while (var11_12 < var5_5.length)
            }
lbl-1000:
            // 1 sources

            {
                this.out_.println("\t children[" + var7_7 + "] oid = " + var5_5[var11_12].getOid());
                this.out_.println("\t childType = " + var5_5[var11_12].getType());
                ++var11_12;
                continue;
            }
lbl33:
            // 1 sources

            this.out_.println("**********************************************************");
            this.out_.println();
            this.debuggerOutputTime_ += System.currentTimeMillis() - var9_11;
        }
    }

    private void translateEdgeAlarms(AlarmService alarmService) throws RemoteException, IdentityException {
        Iterator iterator = this.allJadeEdges_.iterator();
        while (iterator.hasNext()) {
            String string;
            TopologyEdgeAdapter topologyEdgeAdapter;
            AlarmSummary[] alarmSummaryArray;
            EdgeUserObject edgeUserObject = (EdgeUserObject)iterator.next();
            Identity identity = edgeUserObject.getIdentity();
            if (identity == null || edgeUserObject.status != EdgeUserObject.DEAD || (alarmSummaryArray = alarmService.retrieveAlarmSummaries(new Identity[]{identity}, null, AlarmService.ALL_SEVERITIES, new int[]{0}, 0L, 1L, new int[]{9}, null, true)) == null || alarmSummaryArray.length <= 0 || (topologyEdgeAdapter = RootRealm.retrieveEdge(string = identity.toCondensedString())) == null) continue;
            topologyEdgeAdapter.setProperty("Alarm Identity", alarmSummaryArray[0].getAlarmId());
            topologyEdgeAdapter.setProperty("Alarm Severity", new Integer(alarmSummaryArray[0].getSeverity()));
            topologyEdgeAdapter.setProperty("Alarm Type", alarmSummaryArray[0].getAlarmType());
        }
    }

    private void translateEdges() {
        if (this.out_ != null) {
            long l = System.currentTimeMillis();
            this.out_.println("GJG_DEBUG: *** start EDGES ***");
            this.out_.println();
            this.debuggerOutputTime_ += System.currentTimeMillis() - l;
        }
        Iterator iterator = this.topoEngineNodes_.values().iterator();
        while (iterator.hasNext()) {
            TSTopologyNode tSTopologyNode = (TSTopologyNode)iterator.next();
            List list = (List)tSTopologyNode.getProperty(OUT_EDGE_USER_OBJECTS_LIST_KEY);
            if (list == null) continue;
            Iterator iterator2 = list.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                Object object;
                Object object2;
                if (this.out_ != null) {
                    long l = System.currentTimeMillis();
                    this.out_.println("\t JADE parent MF node OID: " + tSTopologyNode.getOid() + ") output edges: ");
                    this.out_.println("\t\t output edge[" + n++ + "]: ");
                    ++this.edgeUserObjectCount_;
                    this.debuggerOutputTime_ += System.currentTimeMillis() - l;
                }
                EdgeUserObject edgeUserObject = (EdgeUserObject)iterator2.next();
                String string = EDGE_SEMANTIC;
                Identity identity = edgeUserObject.getIdentity();
                if (identity != null) {
                    string = identity.toCondensedString();
                }
                ReferenceForMSE referenceForMSE = edgeUserObject.mse1;
                String string2 = null;
                Identity identity2 = referenceForMSE.getIdentity();
                if (identity2 == null) {
                    if (this.out_ == null) continue;
                    this.out_.println();
                    this.out_.println("*** NULL *** FRU (mse1) Identity in translateEdges()! Skipping edge... OID = " + null);
                    this.out_.println();
                    continue;
                }
                string2 = identity2.toCondensedString();
                TSTopologyNode tSTopologyNode2 = (TSTopologyNode)this.topoEngineNodes_.get(string2);
                if (tSTopologyNode2 == null) {
                    tSTopologyNode2 = this.attemptInlinePortNodeCreation(tSTopologyNode, string2);
                }
                ReferenceForMSE referenceForMSE2 = edgeUserObject.mse2;
                String string3 = null;
                Identity identity3 = referenceForMSE2.getIdentity();
                if (identity3 == null) {
                    if (this.out_ == null) continue;
                    this.out_.println();
                    this.out_.println("*** NULL *** FRU (mse2) Identity in translateEdges()! Skipping edge... OID = " + null);
                    this.out_.println();
                    continue;
                }
                string3 = identity3.toCondensedString();
                TSTopologyNode tSTopologyNode3 = (TSTopologyNode)this.topoEngineNodes_.get(string3);
                if (tSTopologyNode3 == null && (object2 = IdResolver.getId((MF)(object = edgeUserObject.mf2))) != null) {
                    String string4 = object2.toCondensedString();
                    TSTopologyNode tSTopologyNode4 = (TSTopologyNode)this.topoEngineNodes_.get(string4);
                    if (tSTopologyNode4 == null) {
                        if (this.out_ == null) continue;
                        this.out_.println();
                        this.out_.println("*** NULL *** parent in translateEdges()! Skipping edge... OID = " + string4);
                        this.out_.println();
                        continue;
                    }
                    tSTopologyNode3 = this.attemptInlinePortNodeCreation(tSTopologyNode4, string3);
                }
                object = this.deduceHeadNode(tSTopologyNode2, tSTopologyNode3);
                object2 = this.deduceTailNode(tSTopologyNode2, tSTopologyNode3);
                try {
                    if (this.out_ != null) {
                        long l = System.currentTimeMillis();
                        this.out_.println("\t\t\t topoEngine head OID = " + object.getOid());
                        this.out_.println("\t\t\t topoEngine tail OID = " + object2.getOid());
                        this.debuggerOutputTime_ += System.currentTimeMillis() - l;
                    }
                    this.createEdges((TSTopologyNode)object, (TSTopologyNode)object2, string);
                }
                catch (TopologyElementNotFoundException topologyElementNotFoundException) {
                    // empty catch block
                }
            }
        }
        if (this.out_ != null) {
            long l = System.currentTimeMillis();
            this.out_.println();
            this.out_.println("GJG_DEBUG: *** end EDGES ***");
            this.out_.println();
            this.out_.println("TOTAL OUT JADE edge user object count: *** " + this.edgeUserObjectCount_ + " ***");
            this.out_.println();
            this.debuggerOutputTime_ += System.currentTimeMillis() - l;
        }
    }

    private void translateFru(String string, String string2, String string3, FabricId fabricId, String string4) throws TopologyDuplicateElementException, TopologyMalformedNodeException {
        String string5 = null;
        String string6 = RESERVED;
        string5 = string3.equals("com.sun.netstorage.mgmt.component.model.domain.StorageHost") ? "com.sun.netstorage.mgmt.component.model.domain.HBA" : (string3.equals("com.sun.netstorage.mgmt.component.model.domain.Switch") ? "com.sun.netstorage.mgmt.component.model.domain.SwitchPort" : "com.sun.netstorage.mgmt.component.model.domain.NxPort");
        TSTopologyNode tSTopologyNode = this.topoEngine_.addNode(string, string6, string5, null, null, fabricId, null);
        if (string5.equals("com.sun.netstorage.mgmt.component.model.domain.SwitchPort") || string5.equals("com.sun.netstorage.mgmt.component.model.domain.NxPort")) {
            ((TopologyNodeAdapter)tSTopologyNode).setProperty("Port Number", (Object)string4);
        } else if (string5.equals("com.sun.netstorage.mgmt.component.model.domain.HBA")) {
            ((TopologyNodeAdapter)tSTopologyNode).setProperty("Logical Name", (Object)string4);
        }
        ++this.fruCount_;
        this.topoEngineNodes_.put(string, tSTopologyNode);
        ArrayList<String> arrayList = (ArrayList<String>)this.composites_.get(string2);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            this.composites_.put(string2, arrayList);
        }
        arrayList.add(string);
    }

    /*
     * Unable to fully structure code
     */
    private void translateFRUs(TopologyNode var1_1, String var2_2, String var3_3, FabricId var4_4) throws TopologyDuplicateElementException, TopologyMalformedNodeException {
        block5: {
            var5_5 = 0;
            var6_6 = var1_1.getFRUs();
            if (var6_6 == null) break block5;
            var7_7 = var6_6.getRoots();
            if (var7_7 != null) ** GOTO lbl51
            if (this.out_ != null) {
                var8_8 = System.currentTimeMillis();
                this.out_.println("\t\t *** NULL from JADE frus.getRoots()!!!!! *** ...handled it...");
                this.out_.println();
                this.debuggerOutputTime_ += System.currentTimeMillis() - var8_8;
            }
            return;
lbl-1000:
            // 1 sources

            {
                block6: {
                    var8_9 = (DefaultTreeNode)var7_7.next();
                    var9_10 = (ReferenceForMSE)var8_9.getUserObject();
                    var10_11 = var9_10.getType();
                    var11_12 = var9_10.getIdentity().toCondensedString();
                    var12_13 = "Reserved For Future Use! ";
                    if (var10_11 != 11) break block6;
                    if (this.out_ != null) {
                        var13_15 = System.currentTimeMillis();
                        this.out_.println("\t FRU child[" + var5_5++ + "]: ");
                        this.out_.println("\t\t OID = " + var11_12);
                        this.out_.println("\t\t type = " + var10_11);
                        this.debuggerOutputTime_ += System.currentTimeMillis() - var13_15;
                    }
                    var13_14 = var9_10.getKeyValue();
                    this.translateFru(var11_12, var2_2, var3_3, var4_4, var13_14);
                    var14_16 = 0;
                    var15_17 = var8_9.getChildren();
                    if (var15_17 != null) ** GOTO lbl45
                    if (this.out_ == null) continue;
                    var16_18 = System.currentTimeMillis();
                    this.out_.println("\t\t *** NULL from JADE node.getChildren()!!!!! *** ...handled it...");
                    this.out_.println();
                    this.debuggerOutputTime_ += System.currentTimeMillis() - var16_18;
                    continue;
lbl-1000:
                    // 1 sources

                    {
                        var16_19 = (DefaultTreeNode)var15_17.next();
                        var17_20 = (ReferenceForMSE)var16_19.getUserObject();
                        var18_21 = var17_20.getIdentity().toCondensedString();
                        var19_22 = var17_20.getKeyValue();
                        if (this.out_ != null) {
                            var20_23 = System.currentTimeMillis();
                            this.out_.println("\t\t sub-FRU child[" + var14_16++ + "]: ");
                            this.out_.println("\t\t\t OID = " + var18_21);
                            this.debuggerOutputTime_ += System.currentTimeMillis() - var20_23;
                        }
                        this.translateFru(var18_21, var11_12, "com.sun.netstorage.mgmt.component.model.domain.HBA", var4_4, var19_22);
lbl45:
                        // 2 sources

                        ** while (var15_17.hasNext())
                    }
lbl46:
                    // 1 sources

                    continue;
                }
                if (var10_11 != 10) continue;
                var13_14 = var9_10.getKeyValue();
                this.translateFru(var11_12, var2_2, var3_3, var4_4, var13_14);
lbl51:
                // 6 sources

                ** while (var7_7.hasNext())
            }
        }
    }

    private void translateNode(BasicNode basicNode) {
        block18: {
            FabricId fabricId = null;
            Map map = null;
            try {
                Object object;
                DeviceFlavor deviceFlavor;
                Identity identity;
                TopologyNode topologyNode = (TopologyNode)basicNode.getUserObject();
                long l = System.currentTimeMillis();
                MF mF = topologyNode.getMF();
                Properties properties = mF.getProperties();
                if (this.out_ != null) {
                    this.jadePullTotalTime_ += System.currentTimeMillis() - l;
                }
                if ((identity = topologyNode.getIdentity()) == null) {
                    if (this.out_ != null) {
                        this.out_.println();
                        this.out_.println("*** NULL *** Identity from JADE!!! Skipping Node...");
                        this.out_.println();
                    }
                    return;
                }
                String string = identity.toCondensedString();
                if (this.out_ != null) {
                    l = System.currentTimeMillis();
                    this.out_.println("JADE MF [" + this.jadeNodeCount_++ + "]: ");
                    this.out_.println("\t OID = " + string);
                    this.debuggerOutputTime_ += System.currentTimeMillis() - l;
                }
                if ((deviceFlavor = topologyNode.getDeviceFlavor()) == null) {
                    if (this.out_ != null) {
                        this.out_.println();
                        this.out_.println("*** NULL *** DeviceFlavor from JADE!!! Skipping Node... NODE OID = " + string);
                        this.out_.println();
                    }
                    return;
                }
                String string2 = this.mapType(deviceFlavor);
                String string3 = RESERVED;
                map = this.assembleProps(properties);
                if (string2.equals("com.sun.netstorage.mgmt.component.model.domain.Switch")) {
                    String string4;
                    object = topologyNode.getFabric();
                    fabricId = new FabricId("DEFAULT_FABRIC", "Default Root SAN");
                    Identity identity2 = null;
                    if (object != null) {
                        identity2 = object.getIdentity();
                    }
                    if (identity2 != null) {
                        string4 = object.getDisplayName();
                        fabricId = new FabricId(string4, "Default Root SAN");
                        if (this.out_ != null) {
                            l = System.currentTimeMillis();
                            this.out_.println("\t JADE displayName = " + string4);
                            this.debuggerOutputTime_ += System.currentTimeMillis() - l;
                        }
                        fabricId.setIdentity(identity2);
                        this.fabricIds_.put(identity2, fabricId);
                    }
                    if (this.out_ != null) {
                        l = System.currentTimeMillis();
                        this.out_.println("\t fabric IDENTITY = " + identity2);
                        this.debuggerOutputTime_ += System.currentTimeMillis() - l;
                    }
                    if ((string4 = (String)map.get("Logical Name")) != null && topologyNode.isPrincipal()) {
                        fabricId.setLogicalName(string4);
                    }
                    if (this.out_ != null) {
                        l = System.currentTimeMillis();
                        this.out_.println("\t switchLogicalName = " + string4);
                        this.out_.println("\t isPrincipal = " + topologyNode.isPrincipal());
                        this.debuggerOutputTime_ += System.currentTimeMillis() - l;
                    }
                }
                object = this.topoEngine_.addNode(string, string3, string2, map, null, fabricId, null);
                this.topoEngineNodes_.put(string, object);
                this.jadeNodes_.put(string, basicNode);
                if (object.getType().equals("com.sun.netstorage.mgmt.component.model.domain.Switch")) {
                    this.allSwitches_.add(object);
                }
                this.translateFRUs(topologyNode, string, string2, fabricId);
                this.assembleTempEdgeProp(basicNode, (TopologyNodeAdapter)object);
            }
            catch (TopologyDuplicateElementException topologyDuplicateElementException) {
            }
            catch (TopologyMalformedNodeException topologyMalformedNodeException) {
            }
            catch (RemoteException remoteException) {
                if (this.out_ == null) break block18;
                this.out_.println("RemoteException thrown in StoradeAdapter.translateNode()! " + remoteException.getMessage());
            }
        }
    }

    private void translateZone(String[] stringArray, ReferenceForMSE referenceForMSE) {
        if (stringArray.length > 0) {
            FabricTopology[] fabricTopologyArray = this.topoEngine_.getSanTopologyCached().getFabrics();
            int n = 0;
            while (n < fabricTopologyArray.length) {
                String string = null;
                Identity identity = referenceForMSE.getIdentity();
                if (identity == null) {
                    if (this.out_ != null) {
                        this.out_.println();
                        this.out_.println("*** NULL *** FRU Identity in translateZone()! Skipping zone... ");
                        this.out_.println();
                    }
                    return;
                }
                string = identity.toCondensedString();
                TSTopologyNode tSTopologyNode = (TSTopologyNode)this.topoEngineNodes_.get(string);
                if (fabricTopologyArray[n].contains(tSTopologyNode)) {
                    FabricId fabricId = fabricTopologyArray[n].getFabricId();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        long l;
                        try {
                            if (this.out_ != null) {
                                l = System.currentTimeMillis();
                                this.out_.println("\t JADE zone name: " + stringArray[n2]);
                                ++this.zoneCount_;
                                this.debuggerOutputTime_ += System.currentTimeMillis() - l;
                            }
                            this.topoEngine_.addZone(fabricId, stringArray[n2]);
                        }
                        catch (TopologyElementNotFoundException topologyElementNotFoundException) {
                        }
                        catch (TopologyDuplicateElementException topologyDuplicateElementException) {
                            // empty catch block
                        }
                        try {
                            if (this.out_ != null) {
                                l = System.currentTimeMillis();
                                this.out_.println("\t JADE zone member (MSE) OID: " + string);
                                this.out_.println();
                                this.debuggerOutputTime_ += System.currentTimeMillis() - l;
                            }
                            this.topoEngine_.addZoneMember(fabricId, stringArray[n2], tSTopologyNode);
                        }
                        catch (TopologyElementNotFoundException topologyElementNotFoundException) {
                        }
                        catch (TopologyDuplicateElementException topologyDuplicateElementException) {
                            // empty catch block
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
    }

    private void translateZones() {
        long l;
        if (this.out_ != null) {
            l = System.currentTimeMillis();
            this.out_.println("GJG_DEBUG: *** start ZONES ***");
            this.out_.println();
            this.debuggerOutputTime_ += System.currentTimeMillis() - l;
        }
        if (this.endPointsForZones_ != null) {
            int n = 0;
            while (n < this.endPointsForZones_.length) {
                String[] stringArray = this.endPointsForZones_[n].getZones();
                if (stringArray != null && stringArray.length > 0) {
                    ReferenceForMSE referenceForMSE = this.endPointsForZones_[n].getMse();
                    this.translateZone(stringArray, referenceForMSE);
                }
                ++n;
            }
        }
        this.addZoneIdentities();
        if (this.out_ != null) {
            l = System.currentTimeMillis();
            this.out_.println();
            this.out_.println("GJG_DEBUG: *** end ZONES ***");
            this.out_.println();
            this.out_.println("TOTAL JADE zone member count: *** " + this.zoneCount_ + " ***");
            this.out_.println();
            this.debuggerOutputTime_ += System.currentTimeMillis() - l;
        }
    }
}

