/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.services.topology;

import com.sun.netstorage.mgmt.services.topology.FabricId;
import com.sun.netstorage.mgmt.services.topology.FabricTopology;
import com.sun.netstorage.mgmt.services.topology.FabricTopologyImpl;
import com.sun.netstorage.mgmt.services.topology.SanTopology;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyDuplicateElementException;
import com.sun.netstorage.mgmt.services.topology.TopologyEdgeAdapter;
import com.sun.netstorage.mgmt.services.topology.TopologyElementNotFoundException;
import com.sun.netstorage.mgmt.services.topology.TopologyGraph;
import com.sun.netstorage.mgmt.services.topology.TopologyGraphAdapter;
import com.sun.netstorage.mgmt.services.topology.TopologyNodeAdapter;
import diva.graph.modular.Graph;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SanTopologyImpl
implements SanTopology {
    static final String sccs_id = "@(#)SanTopologyImpl.java 1.45  03/07/11 SMI";
    private String sanName_ = null;
    private Map fabrics_ = new HashMap();
    private TopologyGraphAdapter dasTopology_ = null;
    private TopologyNodeAdapter dasRoot_ = null;
    private static long fabricIdCounter_ = 1L;
    private static final String DAS_NAME = "DAS_TOPOLOGY";

    public SanTopologyImpl(String string) {
        this.sanName_ = string;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(DAS_NAME);
        this.dasRoot_ = new TopologyNodeAdapter(null);
        this.dasTopology_ = new TopologyGraphAdapter((Graph)this.dasRoot_, arrayList);
    }

    public synchronized boolean contains(TSTopologyNode tSTopologyNode) {
        if (tSTopologyNode != null) {
            if (this.dasTopology_.contains(tSTopologyNode)) {
                return true;
            }
            Iterator iterator = this.fabrics_.values().iterator();
            while (iterator.hasNext()) {
                FabricTopologyImpl fabricTopologyImpl = (FabricTopologyImpl)iterator.next();
                if (!fabricTopologyImpl.contains(tSTopologyNode)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean contains(String string) {
        return this.fabrics_.containsKey(string);
    }

    protected FabricTopology createFabric() {
        String string = Long.toString(fabricIdCounter_++);
        return this.createFabric(new FabricId(string, this.sanName_));
    }

    public synchronized FabricTopology getFabric(String string) {
        return (FabricTopology)this.fabrics_.get(string);
    }

    public synchronized FabricTopology[] getFabrics() {
        int n = 0;
        int n2 = this.fabrics_.size();
        FabricTopology[] fabricTopologyArray = new FabricTopology[n2];
        Iterator iterator = this.fabrics_.values().iterator();
        while (iterator.hasNext()) {
            fabricTopologyArray[n++] = (FabricTopology)iterator.next();
        }
        return fabricTopologyArray;
    }

    public synchronized String getId() {
        return this.sanName_;
    }

    public synchronized Date lastUpdated() {
        return null;
    }

    protected void removeEdge(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, Object object) throws TopologyElementNotFoundException {
        Iterator iterator = this.fabrics_.values().iterator();
        while (iterator.hasNext()) {
            try {
                FabricTopologyImpl fabricTopologyImpl = (FabricTopologyImpl)iterator.next();
                fabricTopologyImpl.removeEdge(tSTopologyNode, tSTopologyNode2, object);
                return;
            }
            catch (TopologyElementNotFoundException topologyElementNotFoundException) {
                // empty catch block
            }
        }
        throw new TopologyElementNotFoundException("Edge not found within topology.");
    }

    protected void removeFabric(String string) throws TopologyElementNotFoundException {
        if (this.fabrics_.containsKey(string)) {
            this.fabrics_.remove(string);
            return;
        }
        throw new TopologyElementNotFoundException("Fabric with given ID does NOT exist.");
    }

    protected void removeNode(TSTopologyNode tSTopologyNode) throws TopologyElementNotFoundException {
        boolean bl = false;
        if (this.dasTopology_.contains(tSTopologyNode)) {
            this.dasTopology_.removeNode(tSTopologyNode);
            bl = true;
        }
        if (this.fabrics_.size() > 0) {
            Iterator iterator = this.fabrics_.values().iterator();
            while (iterator.hasNext()) {
                FabricTopologyImpl fabricTopologyImpl = (FabricTopologyImpl)iterator.next();
                if (!fabricTopologyImpl.contains(tSTopologyNode)) continue;
                fabricTopologyImpl.removeNode(tSTopologyNode);
                bl = true;
            }
        }
        if (!bl) {
            throw new TopologyElementNotFoundException("Node not found within topology.");
        }
    }

    protected void addZone(String string, String string2) throws TopologyDuplicateElementException, TopologyElementNotFoundException {
        if (!this.contains(string)) {
            throw new TopologyElementNotFoundException("Fabric with given ID does NOT exist.");
        }
        FabricTopologyImpl fabricTopologyImpl = (FabricTopologyImpl)this.getFabric(string);
        fabricTopologyImpl.addZone(string2);
    }

    protected void removeZone(String string, String string2) throws TopologyElementNotFoundException {
        if (!this.contains(string)) {
            throw new TopologyElementNotFoundException("Fabric with given ID does NOT exist.");
        }
        FabricTopologyImpl fabricTopologyImpl = (FabricTopologyImpl)this.getFabric(string);
        fabricTopologyImpl.removeZone(string2);
    }

    protected void addZoneMember(String string, String string2, TSTopologyNode tSTopologyNode) throws TopologyDuplicateElementException, TopologyElementNotFoundException {
        if (!this.contains(string)) {
            throw new TopologyElementNotFoundException("Fabric with given ID does NOT exist.");
        }
        FabricTopologyImpl fabricTopologyImpl = (FabricTopologyImpl)this.getFabric(string);
        fabricTopologyImpl.addZoneMember(string2, tSTopologyNode);
    }

    protected void removeZoneMember(String string, String string2, TSTopologyNode tSTopologyNode) throws TopologyElementNotFoundException {
        if (!this.contains(string)) {
            throw new TopologyElementNotFoundException("Fabric with given ID does NOT exist.");
        }
        FabricTopologyImpl fabricTopologyImpl = (FabricTopologyImpl)this.getFabric(string);
        fabricTopologyImpl.removeZoneMember(string2, tSTopologyNode);
    }

    public String toString() {
        return "SAN name: " + this.sanName_ + ", fabric count: " + this.fabrics_.size() + ", DAS Topology node count: " + this.dasTopology_.getNodeCount();
    }

    protected void addDasEdge(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, String string, Map map) {
        if (!this.dasTopology_.contains(tSTopologyNode)) {
            this.dasTopology_.addNode(tSTopologyNode, this.dasRoot_);
        }
        if (!this.dasTopology_.contains(tSTopologyNode2)) {
            this.dasTopology_.addNode(tSTopologyNode2, this.dasRoot_);
        }
        TopologyEdgeAdapter topologyEdgeAdapter = (TopologyEdgeAdapter)TopologyGraphAdapter.createEdge(string, tSTopologyNode, tSTopologyNode2, map);
        this.dasTopology_.connectEdge(topologyEdgeAdapter, tSTopologyNode, tSTopologyNode2);
    }

    protected TSTopologyNode addDasNode(String string, String string2, String string3, Map map, TSTopologyNode[] tSTopologyNodeArray, TopologyNodeAdapter topologyNodeAdapter) throws TopologyDuplicateElementException {
        if (this.dasTopology_.contains(string.toString(), string2, string3)) {
            throw new TopologyDuplicateElementException("Given node already exists.");
        }
        TopologyNodeAdapter topologyNodeAdapter2 = TopologyGraphAdapter.createNode(string, string2, string3, map, tSTopologyNodeArray, this.dasRoot_, topologyNodeAdapter);
        this.dasTopology_.addNode(topologyNodeAdapter2, this.dasRoot_);
        return topologyNodeAdapter2;
    }

    private boolean areTypesCorrect(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2) {
        return tSTopologyNode.getType().equals("com.sun.netstorage.mgmt.component.model.domain.StorageHost") && tSTopologyNode2.getType().equals("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem");
    }

    protected FabricTopology createFabric(FabricId fabricId) {
        FabricTopologyImpl fabricTopologyImpl = new FabricTopologyImpl(fabricId);
        this.fabrics_.put(fabricId.getFabricName(), fabricTopologyImpl);
        return fabricTopologyImpl;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SanTopology) {
            return this.sanName_.equals(((SanTopologyImpl)object).getId());
        }
        return false;
    }

    public TopologyGraph getAll() {
        Object object;
        HashSet<Object> hashSet = new HashSet<Object>();
        ArrayList<String> arrayList = new ArrayList<String>();
        FabricTopology[] fabricTopologyArray = this.getFabrics();
        int n = 0;
        while (n < fabricTopologyArray.length) {
            object = fabricTopologyArray[n].getPhysicalTopology();
            if (object.getNodeCount() > 0) {
                TSTopologyNode[] tSTopologyNodeArray = object.getNodes();
                int n2 = 0;
                while (n2 < tSTopologyNodeArray.length) {
                    hashSet.add(tSTopologyNodeArray[n2]);
                    ++n2;
                }
                arrayList.add(fabricTopologyArray[n].getFabricId().getFabricName());
            }
            ++n;
        }
        object = this.dasTopology_.getNodes();
        int n3 = 0;
        while (n3 < ((Object)object).length) {
            if (!hashSet.contains(object[n3])) {
                hashSet.add(object[n3]);
            }
            ++n3;
        }
        return SanTopologyImpl.populateGraph(hashSet, arrayList);
    }

    public TopologyGraph getConnectivityGraph(TopologyGraph topologyGraph, TSTopologyNode tSTopologyNode, boolean bl) {
        if (topologyGraph == null) {
            return this.getConnectivityGraph(tSTopologyNode, bl);
        }
        TopologyNodeAdapter topologyNodeAdapter = new TopologyNodeAdapter(null);
        if (tSTopologyNode != null) {
            Set set = new HashSet();
            ArrayList arrayList = new ArrayList();
            set = ((TopologyGraphAdapter)topologyGraph).getConnectivityGraph(tSTopologyNode, bl);
            Set set2 = this.intersect(topologyGraph, set);
            if (set2.size() > 0) {
                return SanTopologyImpl.populateGraph(set2, arrayList);
            }
        }
        return new TopologyGraphAdapter((Graph)topologyNodeAdapter, new ArrayList());
    }

    public synchronized TopologyGraph getConnectivityGraph(TSTopologyNode tSTopologyNode, boolean bl) {
        TopologyNodeAdapter topologyNodeAdapter = new TopologyNodeAdapter(null);
        if (tSTopologyNode != null) {
            HashSet hashSet = new HashSet();
            ArrayList<String> arrayList = new ArrayList<String>();
            FabricTopology[] fabricTopologyArray = this.getFabrics();
            int n = 0;
            while (n < fabricTopologyArray.length) {
                Set set = ((FabricTopologyImpl)fabricTopologyArray[n]).getConnectivityGraph(tSTopologyNode, bl);
                if (set.size() > 0) {
                    hashSet.addAll(set);
                    arrayList.add(fabricTopologyArray[n].getFabricId().getFabricName());
                }
                ++n;
            }
            if (hashSet.size() > 0) {
                return SanTopologyImpl.populateGraph(hashSet, arrayList);
            }
        }
        return new TopologyGraphAdapter((Graph)topologyNodeAdapter, new ArrayList());
    }

    public synchronized int getDasNodeCount() {
        return this.dasTopology_.getNodeCount();
    }

    public synchronized TopologyGraph getDasTopology() {
        return this.dasTopology_;
    }

    public synchronized int getFabricCount() {
        return this.fabrics_.size();
    }

    public TopologyGraph getPathsGraph(TSTopologyNode[] tSTopologyNodeArray, TSTopologyNode[] tSTopologyNodeArray2) throws IllegalArgumentException {
        return this.getPathsGraph(tSTopologyNodeArray, tSTopologyNodeArray2, true);
    }

    public TopologyGraph getPathsGraph(TSTopologyNode[] tSTopologyNodeArray, TSTopologyNode[] tSTopologyNodeArray2, boolean bl) throws IllegalArgumentException {
        TopologyNodeAdapter topologyNodeAdapter = new TopologyNodeAdapter(null);
        HashSet hashSet = new HashSet();
        if (tSTopologyNodeArray != null && tSTopologyNodeArray2 != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 0;
            while (n < tSTopologyNodeArray.length) {
                if (!tSTopologyNodeArray[n].getType().equals("com.sun.netstorage.mgmt.component.model.domain.StorageHost")) {
                    throw new IllegalArgumentException();
                }
                int n2 = 0;
                while (n2 < tSTopologyNodeArray2.length) {
                    if (!tSTopologyNodeArray2[n2].getType().equals("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem")) {
                        throw new IllegalArgumentException();
                    }
                    FabricTopology[] fabricTopologyArray = this.getFabrics();
                    int n3 = 0;
                    while (n3 < fabricTopologyArray.length) {
                        Set set = ((FabricTopologyImpl)fabricTopologyArray[n3]).getPathsGraph(tSTopologyNodeArray[n], tSTopologyNodeArray2[n2], bl);
                        if (set.size() > 0) {
                            hashSet.addAll(set);
                            arrayList.add(fabricTopologyArray[n3].getFabricId().getFabricName());
                        }
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            if (hashSet.size() > 0) {
                return SanTopologyImpl.populateGraph(hashSet, arrayList);
            }
        }
        return new TopologyGraphAdapter((Graph)topologyNodeAdapter, new ArrayList());
    }

    public TopologyGraph getPathsGraph(TopologyGraph topologyGraph, TSTopologyNode[] tSTopologyNodeArray, TSTopologyNode[] tSTopologyNodeArray2) throws IllegalArgumentException {
        return this.getPathsGraph(topologyGraph, tSTopologyNodeArray, tSTopologyNodeArray2, true);
    }

    public TopologyGraph getPathsGraph(TopologyGraph topologyGraph, TSTopologyNode[] tSTopologyNodeArray, TSTopologyNode[] tSTopologyNodeArray2, boolean bl) throws IllegalArgumentException {
        if (topologyGraph == null) {
            return this.getPathsGraph(tSTopologyNodeArray, tSTopologyNodeArray2);
        }
        TopologyNodeAdapter topologyNodeAdapter = new TopologyNodeAdapter(null);
        HashSet hashSet = new HashSet();
        HashSet hashSet2 = new HashSet();
        if (tSTopologyNodeArray != null && tSTopologyNodeArray2 != null) {
            ArrayList arrayList = new ArrayList();
            int n = 0;
            while (n < tSTopologyNodeArray.length) {
                if (!tSTopologyNodeArray[n].getType().equals("com.sun.netstorage.mgmt.component.model.domain.StorageHost")) {
                    throw new IllegalArgumentException();
                }
                int n2 = 0;
                while (n2 < tSTopologyNodeArray2.length) {
                    if (!tSTopologyNodeArray2[n2].getType().equals("com.sun.netstorage.mgmt.component.model.domain.StorageSubSystem")) {
                        throw new IllegalArgumentException();
                    }
                    Set set = new HashSet();
                    set = ((TopologyGraphAdapter)topologyGraph).getPathsGraph(tSTopologyNodeArray[n], tSTopologyNodeArray2[n2], bl);
                    Set set2 = this.intersect(topologyGraph, set);
                    hashSet2.addAll(set2);
                    ++n2;
                }
                ++n;
            }
            if (hashSet2.size() > 0) {
                return SanTopologyImpl.populateGraph(hashSet2, arrayList);
            }
        }
        return new TopologyGraphAdapter((Graph)topologyNodeAdapter, new ArrayList());
    }

    public TopologyGraph getPathsGraph(TopologyGraph topologyGraph, TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2) throws IllegalArgumentException {
        return this.getPathsGraph(topologyGraph, tSTopologyNode, tSTopologyNode2, true);
    }

    public TopologyGraph getPathsGraph(TopologyGraph topologyGraph, TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, boolean bl) throws IllegalArgumentException {
        if (topologyGraph == null) {
            return this.getPathsGraph(tSTopologyNode, tSTopologyNode2);
        }
        TopologyNodeAdapter topologyNodeAdapter = new TopologyNodeAdapter(null);
        if (tSTopologyNode != null && tSTopologyNode2 != null) {
            if (!this.areTypesCorrect(tSTopologyNode, tSTopologyNode2)) {
                throw new IllegalArgumentException();
            }
            Set set = new HashSet();
            ArrayList arrayList = new ArrayList();
            set = ((TopologyGraphAdapter)topologyGraph).getPathsGraph(tSTopologyNode, tSTopologyNode2, bl);
            Set set2 = this.intersect(topologyGraph, set);
            if (set2.size() > 0) {
                return SanTopologyImpl.populateGraph(set2, arrayList);
            }
        }
        return new TopologyGraphAdapter((Graph)topologyNodeAdapter, new ArrayList());
    }

    public TopologyGraph getPathsGraph(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2) throws IllegalArgumentException {
        return this.getPathsGraph(tSTopologyNode, tSTopologyNode2, true);
    }

    public TopologyGraph getPathsGraph(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, boolean bl) throws IllegalArgumentException {
        TopologyNodeAdapter topologyNodeAdapter = new TopologyNodeAdapter(null);
        if (tSTopologyNode != null && tSTopologyNode2 != null) {
            if (!this.areTypesCorrect(tSTopologyNode, tSTopologyNode2)) {
                throw new IllegalArgumentException();
            }
            HashSet hashSet = new HashSet();
            ArrayList<String> arrayList = new ArrayList<String>();
            FabricTopology[] fabricTopologyArray = this.getFabrics();
            int n = 0;
            while (n < fabricTopologyArray.length) {
                Set set = ((FabricTopologyImpl)fabricTopologyArray[n]).getPathsGraph(tSTopologyNode, tSTopologyNode2, bl);
                if (set.size() > 0) {
                    hashSet.addAll(set);
                    arrayList.add(fabricTopologyArray[n].getFabricId().getFabricName());
                }
                ++n;
            }
            if (hashSet.size() > 0) {
                return SanTopologyImpl.populateGraph(hashSet, arrayList);
            }
        }
        return new TopologyGraphAdapter((Graph)topologyNodeAdapter, new ArrayList());
    }

    public int hashCode() {
        return this.getDasNodeCount() + this.getFabricCount();
    }

    private Set intersect(TopologyGraph topologyGraph, Set set) {
        HashSet<TSTopologyNode> hashSet = new HashSet<TSTopologyNode>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            TSTopologyNode tSTopologyNode = (TSTopologyNode)iterator.next();
            if (!topologyGraph.contains(tSTopologyNode)) continue;
            hashSet.add(tSTopologyNode);
        }
        return hashSet;
    }

    protected static TopologyGraphAdapter populateGraph(Set set, List list) {
        TopologyNodeAdapter topologyNodeAdapter = new TopologyNodeAdapter(null);
        TopologyGraphAdapter topologyGraphAdapter = new TopologyGraphAdapter((Graph)topologyNodeAdapter, list);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            TSTopologyNode tSTopologyNode = (TSTopologyNode)iterator.next();
            TopologyNodeAdapter topologyNodeAdapter2 = ((TopologyNodeAdapter)tSTopologyNode).copy(topologyGraphAdapter);
            topologyGraphAdapter.addNode(topologyNodeAdapter2, topologyNodeAdapter);
        }
        return topologyGraphAdapter;
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<san>");
        stringBuffer.append("<name>" + this.sanName_ + "</name>");
        stringBuffer.append("<dasTopology>" + this.dasTopology_.toXML() + "</dasTopology>");
        FabricTopology[] fabricTopologyArray = this.getFabrics();
        int n = 0;
        while (n < fabricTopologyArray.length) {
            stringBuffer.append(fabricTopologyArray[n].toXML());
            ++n;
        }
        stringBuffer.append("</san>");
        return stringBuffer.toString();
    }

    public void toXMLStream(PrintWriter printWriter, boolean bl) {
        if (bl) {
            printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        }
        printWriter.println(this.toXML());
    }
}

