/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.services.topology;

import com.sun.netstorage.mgmt.services.topology.FabricId;
import com.sun.netstorage.mgmt.services.topology.FabricTopology;
import com.sun.netstorage.mgmt.services.topology.SanTopologyImpl;
import com.sun.netstorage.mgmt.services.topology.TSTopologyEdge;
import com.sun.netstorage.mgmt.services.topology.TSTopologyNode;
import com.sun.netstorage.mgmt.services.topology.TopologyDuplicateElementException;
import com.sun.netstorage.mgmt.services.topology.TopologyEdgeAdapter;
import com.sun.netstorage.mgmt.services.topology.TopologyElementNotFoundException;
import com.sun.netstorage.mgmt.services.topology.TopologyGraph;
import com.sun.netstorage.mgmt.services.topology.TopologyGraphAdapter;
import com.sun.netstorage.mgmt.services.topology.TopologyNodeAdapter;
import com.sun.netstorage.mgmt.services.topology.TopologyPredicate;
import com.sun.netstorage.mgmt.services.topology.Zone;
import com.sun.netstorage.mgmt.services.topology.ZoneImpl;
import com.sun.netstorage.mgmt.services.topology.ZoneTopology;
import diva.graph.modular.Graph;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FabricTopologyImpl
implements FabricTopology {
    static final String sccs_id = "@(#)FabricTopologyImpl.java 1.33  03/09/02 SMI";
    private FabricId fabricId_ = null;
    private TopologyGraphAdapter physicalTopology_ = null;
    private ZoneTopology zoneTopology_ = null;
    private TopologyNodeAdapter root_ = null;

    public FabricTopologyImpl(FabricId fabricId) {
        this.fabricId_ = fabricId;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(fabricId.getFabricName());
        this.root_ = new TopologyNodeAdapter(null);
        this.physicalTopology_ = new TopologyGraphAdapter((Graph)this.root_, arrayList);
        this.zoneTopology_ = new ZoneTopology();
    }

    public synchronized boolean contains(TSTopologyNode tSTopologyNode) {
        return this.physicalTopology_.contains(tSTopologyNode);
    }

    public synchronized String getId() {
        return this.fabricId_.getFabricName();
    }

    public synchronized FabricId getFabricId() {
        return this.fabricId_;
    }

    public synchronized TopologyGraph getPhysicalTopology() {
        return this.physicalTopology_;
    }

    public synchronized Zone[] getZones() {
        return this.zoneTopology_.getZones();
    }

    protected void removeEdge(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, Object object) throws TopologyElementNotFoundException {
        if (this.contains(tSTopologyNode)) {
            Iterator iterator = ((TopologyNodeAdapter)tSTopologyNode).outEdges();
            while (iterator.hasNext()) {
                TopologyEdgeAdapter topologyEdgeAdapter = (TopologyEdgeAdapter)iterator.next();
                Object object2 = topologyEdgeAdapter.getSemanticObject();
                TSTopologyNode tSTopologyNode3 = (TSTopologyNode)topologyEdgeAdapter.getTail();
                if (!object2.equals(object) || !tSTopologyNode3.equals(tSTopologyNode2)) continue;
                this.physicalTopology_.disconnectEdge(topologyEdgeAdapter);
                return;
            }
        }
        throw new TopologyElementNotFoundException("Edge not found within topology.");
    }

    protected void removeNode(TSTopologyNode tSTopologyNode) throws TopologyElementNotFoundException {
        if (this.contains(tSTopologyNode)) {
            this.physicalTopology_.removeNode(tSTopologyNode);
            return;
        }
        throw new TopologyElementNotFoundException("Node not found within topology.");
    }

    protected void addZone(String string) throws TopologyDuplicateElementException {
        this.zoneTopology_.addZone(string);
    }

    protected void removeZone(String string) throws TopologyElementNotFoundException {
        this.zoneTopology_.removeZone(string);
    }

    protected void addZoneMember(String string, TSTopologyNode tSTopologyNode) throws TopologyElementNotFoundException, TopologyDuplicateElementException {
        this.zoneTopology_.addZoneMember(string, tSTopologyNode);
    }

    protected void removeZoneMember(String string, TSTopologyNode tSTopologyNode) throws TopologyElementNotFoundException {
        this.zoneTopology_.removeZoneMember(string, tSTopologyNode);
    }

    public String toString() {
        return "Fabric: " + this.fabricId_.getFabricName() + ", Logical Name: " + this.fabricId_.getLogicalName() + ", SAN: " + this.getFabricId().getSanName() + ", node count: " + this.physicalTopology_.getNodeCount() + ", number of zones in fabric: " + this.getZones().length;
    }

    protected void addNode(TSTopologyNode tSTopologyNode) throws TopologyDuplicateElementException {
        if (this.contains(tSTopologyNode)) {
            throw new TopologyDuplicateElementException("Given node already exists.");
        }
        this.physicalTopology_.addNode(tSTopologyNode, this.root_);
    }

    protected void addEdge(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, String string, Map map) {
        if (!this.contains(tSTopologyNode)) {
            this.physicalTopology_.addNode(tSTopologyNode, this.root_);
        }
        if (!this.contains(tSTopologyNode2)) {
            this.physicalTopology_.addNode(tSTopologyNode2, this.root_);
        }
        TopologyEdgeAdapter topologyEdgeAdapter = (TopologyEdgeAdapter)TopologyGraphAdapter.createEdge(string, tSTopologyNode, tSTopologyNode2, map);
        this.physicalTopology_.connectEdge(topologyEdgeAdapter, tSTopologyNode, tSTopologyNode2);
    }

    protected TSTopologyNode addNode(String string, String string2, String string3, Map map, TSTopologyNode[] tSTopologyNodeArray, TopologyNodeAdapter topologyNodeAdapter) throws TopologyDuplicateElementException {
        if (this.physicalTopology_.contains(string, string2, string3)) {
            throw new TopologyDuplicateElementException("Given node already exists.");
        }
        TopologyNodeAdapter topologyNodeAdapter2 = TopologyGraphAdapter.createNode(string, string2, string3, map, tSTopologyNodeArray, this.root_, topologyNodeAdapter);
        this.physicalTopology_.addNode(topologyNodeAdapter2, this.root_);
        return topologyNodeAdapter2;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof FabricTopology) {
            return this.fabricId_.equals(((FabricTopologyImpl)object).getFabricId());
        }
        return false;
    }

    protected Set getConnectivityGraph(TSTopologyNode tSTopologyNode, boolean bl) {
        Set set = new HashSet();
        if (this.contains(tSTopologyNode)) {
            set = this.physicalTopology_.getConnectivityGraph(tSTopologyNode, bl);
        }
        return set;
    }

    public TopologyGraph getLogicalTopology(String string) {
        ArrayList arrayList = new ArrayList();
        TopologyNodeAdapter topologyNodeAdapter = new TopologyNodeAdapter(null);
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        ZoneImpl zoneImpl = this.zoneTopology_.getZone(string);
        if (zoneImpl != null) {
            Object object;
            TSTopologyEdge[] tSTopologyEdgeArray;
            TSTopologyNode[] tSTopologyNodeArray = zoneImpl.getZoneMembers();
            int n = 0;
            while (n < tSTopologyNodeArray.length) {
                hashSet.add(tSTopologyNodeArray[n]);
                if (tSTopologyNodeArray[n].getType().equals("com.sun.netstorage.mgmt.component.model.domain.SwitchPort")) {
                    tSTopologyEdgeArray = tSTopologyNodeArray[n].getOutEdges();
                    int n2 = 0;
                    while (n2 < tSTopologyEdgeArray.length) {
                        object = tSTopologyEdgeArray[n2].getTailNode();
                        hashSet.add(object);
                        ++n2;
                    }
                    object = tSTopologyNodeArray[n].getInEdges();
                    int n3 = 0;
                    while (n3 < ((TSTopologyEdge[])object).length) {
                        TSTopologyNode tSTopologyNode = object[n3].getHeadNode();
                        hashSet.add(tSTopologyNode);
                        ++n3;
                    }
                }
                ++n;
            }
            tSTopologyEdgeArray = hashSet.iterator();
            while (tSTopologyEdgeArray.hasNext()) {
                TSTopologyNode tSTopologyNode = (TSTopologyNode)tSTopologyEdgeArray.next();
                hashSet2.add(tSTopologyNode);
                object = tSTopologyNode.getImmediateParent();
                while (object != null) {
                    hashSet2.add(object);
                    object = object.getImmediateParent();
                }
            }
            if (hashSet2.size() > 0) {
                return SanTopologyImpl.populateGraph(hashSet2, arrayList);
            }
        }
        return new TopologyGraphAdapter((Graph)topologyNodeAdapter, arrayList);
    }

    protected Set getPathsGraph(TSTopologyNode tSTopologyNode, TSTopologyNode tSTopologyNode2, boolean bl) {
        if (!this.contains(tSTopologyNode)) {
            tSTopologyNode = null;
        }
        if (!this.contains(tSTopologyNode2)) {
            tSTopologyNode2 = null;
        }
        return this.physicalTopology_.getPathsGraph(tSTopologyNode, tSTopologyNode2, bl);
    }

    public synchronized TSTopologyNode[] getTopologySubset(TopologyPredicate topologyPredicate) {
        ArrayList<TSTopologyNode> arrayList = new ArrayList<TSTopologyNode>();
        if (topologyPredicate != null) {
            TSTopologyNode[] tSTopologyNodeArray = this.getPhysicalTopology().getNodes();
            int n = 0;
            while (n < tSTopologyNodeArray.length) {
                if (topologyPredicate.execute(tSTopologyNodeArray[n])) {
                    arrayList.add(tSTopologyNodeArray[n]);
                }
                ++n;
            }
        }
        return arrayList.toArray(new TSTopologyNode[arrayList.size()]);
    }

    public synchronized Zone getZone(String string) {
        return this.zoneTopology_.getZone(string);
    }

    public int hashCode() {
        return this.getPhysicalTopology().getNodeCount() + this.getZones().length;
    }

    protected void setLogicalName(String string) {
        this.fabricId_.setLogicalName(string);
    }

    public String toXML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<fabric>");
        stringBuffer.append(this.fabricId_.toXML());
        stringBuffer.append(this.physicalTopology_.toXML());
        stringBuffer.append(this.zoneTopology_.toXML());
        stringBuffer.append("</fabric>");
        return stringBuffer.toString();
    }
}

