/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.service.api;

import com.sun.netstorage.mgmt.esm.logic.service.api.Localization;
import com.sun.netstorage.mgmt.esm.util.l10n.exceptions.LocalizableException;
import java.io.Serializable;

public class ServiceException
extends LocalizableException {
    private static final String SCCS_ID = "@(#)ServiceException.java 1.6   03/04/28 SMI";
    public static final String REGISTRY_NOT_FOUND = "cannot find an RMI registry on {0}:{1}";
    public static final String REGISTRY_UNAVAILABLE = "the RMI registry on {0}:{1} is unavailable because:\n\t{2}";
    public static final String SERVICE_NOT_FOUND = "cannot find the specified service ({0})";
    public static final String INVALID_SERVICE = "the specified service ({0}) implementation ({1}) is invalid";
    private String myServiceName = null;

    public ServiceException(Throwable throwable) {
        super(throwable);
    }

    public ServiceException() {
    }

    public final String getServiceName() {
        return this.myServiceName;
    }

    protected final void setServiceName(String string) {
        this.myServiceName = string;
    }

    public static final class InvalidService
    extends ServiceException {
        private final String myImplName;

        public InvalidService(String string, String string2) {
            this.setServiceName(string);
            this.myImplName = string2;
            this.getSupport().addMessageArg((Serializable)((Object)string));
            this.getSupport().addMessageArg((Serializable)((Object)string2));
            this.getSupport().initMessage(Localization.FMT_INVALID_SERVICE);
        }

        public String getImplName() {
            return this.myImplName;
        }
    }

    public static final class ServiceNotFound
    extends ServiceException {
        public ServiceNotFound(Throwable throwable, String string) {
            super(throwable);
            this.setServiceName(string);
            this.getSupport().addMessageArg((Serializable)((Object)string));
            this.getSupport().initMessage(Localization.FMT_SERVICE_NOT_FOUND);
        }

        public ServiceNotFound(String string) {
            this(null, string);
        }
    }

    public static final class RegistryUnavailable
    extends RegistryException {
        public RegistryUnavailable(Throwable throwable, String string, int n) {
            super(throwable, string, n);
            this.getSupport().addMessageArg((Serializable)((Object)throwable.getMessage()));
            this.getSupport().initMessage(Localization.FMT_REGISTRY_UNAVAILABLE);
        }
    }

    public static final class RegistryNotFound
    extends RegistryException {
        public RegistryNotFound(Throwable throwable, String string, int n) {
            super(throwable, string, n);
            this.getSupport().initMessage(Localization.FMT_REGISTRY_NOT_FOUND);
        }
    }

    public static abstract class RegistryException
    extends ServiceException {
        private final String myHostname;
        private final int myPort;

        public RegistryException(Throwable throwable, String string, int n) {
            super(throwable);
            this.myHostname = string;
            this.myPort = n;
            this.getSupport().addMessageArg((Serializable)((Object)string));
            this.getSupport().addMessageArg((Serializable)new Integer(n));
        }

        public String getHostname() {
            return this.myHostname;
        }

        public int getPort() {
            return this.myPort;
        }
    }
}

