/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.mgmt.esm.logic.identity.api;

import com.sun.jade.apps.persistence.util.db.ConnectionPool;
import com.sun.netstorage.mgmt.esm.logic.identity.api.Identity;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityException;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityPersistenceHelperException;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityResolver;
import com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityType;
import com.sun.netstorage.mgmt.esm.logic.registry.api.RMIRegistryFacility;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IdentityPersistenceHelper {
    private static final String CLASS_NAME = "IdentityPersistenceHelper";
    private static final String PKG_NAME = "com.sun.netstorage.mgmt.esm.logic.identity.api";
    private static final String RES_NAME = "com/sun/netstorage/mgmt/esm/logic/identity/api/Localization";
    private static final String COMP_NAME = "IdentityPersistenceHelper";
    private static final Logger logger = Logger.getLogger("com.sun.netstorage.mgmt.esm.logic.identity.api");
    private static final String ERR_RESOLVER = "id.err.resolver";
    private static final String ERR_DELETE_FAILED = "id.err.db.deleteFailed";
    private static final String ERR_INSERT_FAILED = "id.err.db.insertFailed";
    private static final String ERR_DB = "id.err.db";
    private static final String ERR_DB_LIST = "id.err.db.list";
    private static final String ERR_RESOLVE_DBID = "id.err.resolve.dbid";
    private static final String ERR_DELETE_ALL_FAILED = "id.err.db.deleteAllFailed";
    private static IdentityResolver idResolver;
    static /* synthetic */ Class class$com$sun$netstorage$mgmt$esm$logic$identity$api$IdentityResolver;

    private static IdentityResolver getIdentityResolver() {
        block2: {
            if (idResolver != null) break block2;
            Class clazz = class$com$sun$netstorage$mgmt$esm$logic$identity$api$IdentityResolver == null ? (class$com$sun$netstorage$mgmt$esm$logic$identity$api$IdentityResolver = IdentityPersistenceHelper.class$("com.sun.netstorage.mgmt.esm.logic.identity.api.IdentityResolver")) : class$com$sun$netstorage$mgmt$esm$logic$identity$api$IdentityResolver;
            try {
                idResolver = (IdentityResolver)RMIRegistryFacility.Singleton.get().lookup(clazz.getPackage().getName());
            }
            catch (Exception exception) {
                IdentityPersistenceHelper.log(Level.SEVERE, "IdentityPersistenceHelper", "getIdentityResolver", RES_NAME, ERR_RESOLVER, null, exception);
            }
        }
        return idResolver;
    }

    public static void deleteIdentity(Identity identity, Identity identity2) throws IdentityException, IdentityPersistenceHelperException {
        if (identity != null) {
            try {
                if (IdentityPersistenceHelper.getIdentityResolver().getNumMatchingEntities(identity) == 0) {
                    throw new IdentityException.UnknownIdentity(identity);
                }
            }
            catch (Exception exception) {
                IdentityPersistenceHelper.log(Level.SEVERE, "IdentityPersistenceHelper", "deleteIdentity", RES_NAME, ERR_RESOLVER, null, exception);
                throw new IdentityPersistenceHelperException("Exception while calling resolver to resolve DBID " + identity, exception);
            }
        }
        Connection connection = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            try {
                string = identity2.getType().getName();
                string2 = identity2.getValue();
                string3 = identity != null ? identity.getValue() : string2;
                string4 = "DELETE FROM identity WHERE fkoid = ? AND type = ? and value = ?";
                connection = IdentityPersistenceHelper.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement(string4);
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string2);
                int n = preparedStatement.executeUpdate();
                if (n != 1) {
                    IdentityPersistenceHelper.log(Level.SEVERE, "IdentityPersistenceHelper", "deleteIdentity", RES_NAME, ERR_DELETE_FAILED, new Object[]{string4, string3, string, string2, new Integer(n)});
                    throw new IdentityPersistenceHelperException("Delete failed.  SQL execution result was " + n);
                }
                Object var10_11 = null;
            }
            catch (Exception exception) {
                IdentityPersistenceHelper.log(Level.SEVERE, "IdentityPersistenceHelper", "deleteIdentity", RES_NAME, ERR_DB, new Object[]{string4, string3, string, string2}, exception);
                throw new IdentityPersistenceHelperException("Exception while executing sql.", exception);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            IdentityPersistenceHelper.returnConnection(connection);
            throw throwable;
        }
        IdentityPersistenceHelper.returnConnection(connection);
    }

    public static void deleteIdentities(Identity identity) throws IdentityException, IdentityPersistenceHelperException {
        Identity identity2 = null;
        if (identity != null) {
            try {
                identity2 = IdentityPersistenceHelper.getIdentityResolver().getAlternateIdentifier(identity, IdentityType.DBID);
            }
            catch (Exception exception) {
                IdentityPersistenceHelper.log(Level.SEVERE, "IdentityPersistenceHelper", "deleteIdenties", RES_NAME, ERR_RESOLVE_DBID, new Object[]{identity.getType(), identity.getValue()}, exception);
                throw new IdentityPersistenceHelperException("Exception while calling resolver to resolve DBID " + identity, exception);
            }
        }
        Connection connection = null;
        String string = null;
        String string2 = "DELETE FROM identity WHERE fkoid = ?";
        try {
            try {
                if (identity2 != null) {
                    string = identity2.getValue();
                    connection = IdentityPersistenceHelper.getConnection();
                    PreparedStatement preparedStatement = connection.prepareStatement(string2);
                    preparedStatement.setString(1, string);
                    int n = preparedStatement.executeUpdate();
                    if (n < 1) {
                        IdentityPersistenceHelper.log(Level.SEVERE, "IdentityPersistenceHelper", "deleteIdentities", RES_NAME, ERR_DELETE_ALL_FAILED, new Object[]{string});
                        throw new IdentityPersistenceHelperException("Delete failed.  SQL execution result was " + n);
                    }
                } else {
                    throw new IdentityException.InvalidIdentity(identity);
                }
                Object var8_9 = null;
            }
            catch (Exception exception) {
                IdentityPersistenceHelper.log(Level.SEVERE, "IdentityPersistenceHelper", "deleteIdentities", RES_NAME, ERR_DB_LIST, new Object[]{string2, string}, exception);
                throw new IdentityPersistenceHelperException("Exception while executing sql.", exception);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            IdentityPersistenceHelper.returnConnection(connection);
            throw throwable;
        }
        IdentityPersistenceHelper.returnConnection(connection);
    }

    public static void persistIdentity(Identity identity, Identity identity2) throws IdentityException, IdentityPersistenceHelperException {
        if (identity != null) {
            try {
                if (IdentityPersistenceHelper.getIdentityResolver().getNumMatchingEntities(identity) == 0) {
                    throw new IdentityException.UnknownIdentity(identity);
                }
            }
            catch (Exception exception) {
                IdentityPersistenceHelper.log(Level.SEVERE, "IdentityPersistenceHelper", "persistIdentity", RES_NAME, ERR_RESOLVER, null, exception);
                throw new IdentityPersistenceHelperException("Exception while calling resolver to resolve DBID " + identity, exception);
            }
        }
        Connection connection = null;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        try {
            try {
                string = identity2.getType().getName();
                string2 = identity2.getValue();
                string3 = identity != null ? identity.getValue() : string2;
                string4 = "INSERT INTO identity VALUES ( ?, ?, ?)";
                connection = IdentityPersistenceHelper.getConnection();
                PreparedStatement preparedStatement = connection.prepareStatement(string4);
                preparedStatement.setString(1, string3);
                preparedStatement.setString(2, string);
                preparedStatement.setString(3, string2);
                int n = preparedStatement.executeUpdate();
                if (n != 1) {
                    IdentityPersistenceHelper.log(Level.SEVERE, "IdentityPersistenceHelper", "persistIdentity", RES_NAME, ERR_INSERT_FAILED, new Object[]{string4, string3, string, string2, new Integer(n)});
                    throw new IdentityPersistenceHelperException("Insert failed.  SQL execution result was " + n);
                }
                Object var10_11 = null;
            }
            catch (Exception exception) {
                IdentityPersistenceHelper.log(Level.SEVERE, "IdentityPersistenceHelper", "persistIdentity", RES_NAME, ERR_DB, new Object[]{string4, string3, string, string2}, exception);
                throw new IdentityPersistenceHelperException("Exception while executing sql.", exception);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            IdentityPersistenceHelper.returnConnection(connection);
            throw throwable;
        }
        IdentityPersistenceHelper.returnConnection(connection);
    }

    private static void log(Level level, String string, String string2, String string3, String string4, Object[] objectArray) {
        IdentityPersistenceHelper.log(level, string, string2, string3, string4, objectArray, null);
    }

    private static void log(Level level, String string, String string2, String string3, String string4, Object[] objectArray, Throwable throwable) {
        logger.logrb(level, string, string2, string3, string4, objectArray);
        if (throwable != null) {
            logger.log(level, "", throwable);
        }
    }

    private static Connection getConnection() throws RemoteException, SQLException {
        return ConnectionPool.getConnection();
    }

    private static void returnConnection(Connection connection) {
        ConnectionPool.returnConnection((Connection)connection);
    }

    public static void main(String[] stringArray) throws Exception {
        Identity identity = new Identity("6", IdentityType.DBID);
        Identity identity2 = new Identity("yahoo", IdentityType.HOSTNAME);
        System.out.println("Creating DBID 6");
        IdentityPersistenceHelper.persistIdentity(null, identity);
        System.out.println("Creating hostname identity related to DBID 6");
        IdentityPersistenceHelper.persistIdentity(identity, identity2);
        System.out.println("Deleting hostname identity related to DBID 6");
        IdentityPersistenceHelper.deleteIdentity(identity, identity2);
        System.out.println("Deleting DBID 6 itself");
        IdentityPersistenceHelper.deleteIdentity(null, identity);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

