/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.util.snmp;

import com.sun.jade.util.unittest.UnitTest;

public class SNMPToString_State_Status {
    private static String[] fa_status = new String[]{"Unknown", "Unknown", "Unused", "Ready", "Warning", "Failure", "Not Participating", "Initializing", "Bypass", "OLS"};
    private static String[] fa_state = new String[]{"Unknown", "Unknown", "Online", "Off Line", "Bypassed", "Diagnostics"};
    private static String[] fe_status = new String[]{"Unknown", "Online", "Off Line", "Testing", "Faulty"};
    public static final String sccs_id = "@(#)SNMPToString_State_Status.java\t1.1 11/07/02 SMI";

    private static int parseString(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = 0;
        }
        return n;
    }

    public static String getOperationalStateString(String string) {
        return fa_state[SNMPToString_State_Status.parseString(string)];
    }

    public static String getOperationalStatusString(String string) {
        return fa_status[SNMPToString_State_Status.parseString(string)];
    }

    public static String getOperationalStatusString_FE(String string) {
        return fe_status[SNMPToString_State_Status.parseString(string)];
    }

    public static class Test
    extends UnitTest {
        public void testSNMPStringStateStatus() {
            this.assertEquals(SNMPToString_State_Status.getOperationalStateString("1"), "Unknown");
            this.assertEquals(SNMPToString_State_Status.getOperationalStateString("2"), "Online");
            this.assertEquals(SNMPToString_State_Status.getOperationalStateString("3"), "Off Line");
            this.assertEquals(SNMPToString_State_Status.getOperationalStateString("5"), "Diagnostics");
            this.assertEquals(SNMPToString_State_Status.getOperationalStatusString("1"), "Unknown");
            this.assertEquals(SNMPToString_State_Status.getOperationalStatusString("2"), "Unused");
            this.assertEquals(SNMPToString_State_Status.getOperationalStatusString("3"), "Ready");
            this.assertEquals(SNMPToString_State_Status.getOperationalStatusString("4"), "Warning");
            this.assertEquals(SNMPToString_State_Status.getOperationalStatusString("5"), "Failure");
            this.assertEquals(SNMPToString_State_Status.getOperationalStatusString_FE("1"), "Online");
            this.assertEquals(SNMPToString_State_Status.getOperationalStatusString_FE("2"), "Off Line");
            this.assertEquals(SNMPToString_State_Status.getOperationalStatusString_FE("3"), "Testing");
            this.assertEquals(SNMPToString_State_Status.getOperationalStatusString_FE("4"), "Faulty");
        }
    }
}

