/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.util.snmp;

import com.sun.jade.device.fcswitch.util.snmp.FCFABRIC_ELEMENT_MIBOidTable;
import com.sun.jade.device.fcswitch.util.snmp.Generic_Mibsnmp;
import com.sun.jade.util.unittest.UnitTest;
import java.util.HashMap;
import java.util.Iterator;

public class FE_Mibsnmp
extends Generic_Mibsnmp {
    private String ipno;
    private String wwn;
    private static String[] portCapacity = new String[]{"fcFxPortCapCos", "fcFxPortCapRxDataFieldSizeMin", "fcFxPortCapMedia", "fcFxPortCapBaudRates", "fcFxPortCapRxDataFieldSizeMax", "fcFxPortCapBbCreditMin", "fcFxPortCapHoldTimeMin", "fcFxPortCapHoldTimeMax", "fcFxPortCapBbCreditMax", "fcFxPortCapClass3SeqDeliv", "fcFxPortCapFcphVersionLow", "fcFxPortCapFcphVersionHigh", "fcFxPortCapClass2SeqDeliv", "fcFxPortCapFxPortIndex", "fcFxPortCapStackedConnMode", "fcFxPortCapModuleIndex", "fcFxPortCapIntermix"};
    private static String[] portClass3 = new String[]{"fcFxPortC3OutOctets", "fcFxPortC3InOctets", "fcFxPortC3OutFrames", "fcFxPortC3InFrames", "fcFxPortC3AcctFxPortIndex", "fcFxPortC3AcctModuleIndex", "fcFxPortC3Discards"};
    private static String[] portClass2 = new String[]{"fcFxPortC2FrjtFrames", "fcFxPortC2FbsyFrames", "fcFxPortC2Discards", "fcFxPortC2OutOctets", "fcFxPortC2InOctets", "fcFxPortC2OutFrames", "fcFxPortC2InFrames", "fcFxPortC2AcctFxPortIndex", "fcFxPortC2AcctModuleIndex"};
    private static String[] portClass1 = new String[]{"fcFxPortC1OutFrames", "fcFxPortC1InFrames", "fcFxPortC1ConnTime", "fcFxPortC1FrjtFrames", "fcFxPortC1FbsyFrames", "fcFxPortC1OutConnections", "fcFxPortC1InConnections", "fcFxPortC1Discards", "fcFxPortC1AcctFxPortIndex", "fcFxPortC1OutOctets", "fcFxPortC1InOctets", "fcFxPortC1AcctModuleIndex"};
    private static String[] portStat = new String[]{"fcFxPortDelimiterErrors", "fcFxPortInvalidCrcs", "fcFxPortInvalidTxWords", "fcFxPortPrimSeqProtoErrors", "fcFxPortSigLosses", "fcFxPortOlsOuts", "fcFxPortOlsIns", "fcFxPortSyncLosses", "fcFxPortLinkResetOuts", "fcFxPortLinkFailures", "fcFxPortLinkResetIns", "fcFxPortErrorFxPortIndex", "fcFxPortErrorModuleIndex", "fcFxPortAddressIdErrors"};
    private static String[] portPhysical = new String[]{"fcFxPortPhysOperStatus", "fcFxPortPhysAdminStatus"};
    private static String[] portConfiguration = new String[]{"fcFxPortDistance", "fcFxPortTxType", "fcFxPortMedium", "fcFxPortBaudRate", "fcFxPortHoldTime", "fcFxPortClass3SeqDeliv", "fcFxPortClass2SeqDeliv", "fcFxPortStackedConnMode", "fcFxPortIntermixSupported", "fcFxPortCosSupported", "fcFxPortEdtov", "fcFxPortRatov", "fcFxPortRxBufSize", "fcFxPortBbCredit", "fcFxPortFcphVersionLow", "fcFxPortFcphVersionHigh", "fcFxPortName", "fcFxConfFxPortIndex", "fcFxConfModuleIndex"};
    private static String[] moduleProps = new String[]{"fcFeModuleDescr", "fcFeModuleOperStatus", "fcFeModuleFxPortCapacity"};
    private static String[] groupConfiguration = new String[]{"fcFeModuleCapacity"};
    public static final String sccs_id = "@(#)FE_Mibsnmp.java\t1.11 05/02/03 SMI";

    public FE_Mibsnmp(String string) {
        super(string);
        this.ipno = string;
        this.addOidTable(new FCFABRIC_ELEMENT_MIBOidTable());
    }

    public HashMap getPortStat(int n, int n2) {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, portStat, n + "." + n2);
        return hashMap;
    }

    public HashMap getPortClass3(int n, int n2) {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, portClass3, n + "." + n2);
        return hashMap;
    }

    public HashMap getPortClass2(int n, int n2) {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, portClass2, n + "." + n2);
        return hashMap;
    }

    public HashMap getPortClass1(int n, int n2) {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, portClass1, n + "." + n2);
        return hashMap;
    }

    public HashMap getPortPhysical(int n, int n2) {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, portPhysical, n + "." + n2);
        return hashMap;
    }

    public HashMap getPortCapacity(int n, int n2) {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, portCapacity, n + "." + n2);
        return hashMap;
    }

    public HashMap getPortConfiguration(int n, int n2) {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, portConfiguration, n + "." + n2, "Hex");
        return hashMap;
    }

    public HashMap getModuleProps(int n) {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, moduleProps, "" + n);
        return hashMap;
    }

    public HashMap getGroupConfig() {
        HashMap hashMap = new HashMap();
        this.getProperties(hashMap, groupConfiguration, "0");
        return hashMap;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 3) {
            System.out.println("usage <switch-ip-addresss> <type> [moduleIndex] [fruIndex]");
            System.exit(1);
        }
        FE_Mibsnmp fE_Mibsnmp = new FE_Mibsnmp(stringArray[0]);
        String string = stringArray[1];
        int n = 0;
        int n2 = 0;
        if (stringArray.length > 2) {
            n = Integer.parseInt(stringArray[3]);
            n2 = Integer.parseInt(stringArray[2]);
        }
        HashMap hashMap = null;
        if ("portStat".equals(string)) {
            hashMap = fE_Mibsnmp.getPortStat(n2, n);
        } else if ("portClass1".equals(string)) {
            hashMap = fE_Mibsnmp.getPortClass1(n2, n);
        } else if ("portClass2".equals(string)) {
            hashMap = fE_Mibsnmp.getPortClass2(n2, n);
        } else if ("portClass3".equals(string)) {
            hashMap = fE_Mibsnmp.getPortClass3(n2, n);
        } else if ("portPhysical".equals(string)) {
            hashMap = fE_Mibsnmp.getPortPhysical(n2, n);
        } else if ("portConfiguration".equals(string)) {
            hashMap = fE_Mibsnmp.getPortConfiguration(n2, n);
        } else if ("portCapacity".equals(string)) {
            hashMap = fE_Mibsnmp.getPortCapacity(n2, n);
        } else if ("module".equals(string)) {
            hashMap = fE_Mibsnmp.getModuleProps(n2);
        } else if ("groupConfiguration".equals(string)) {
            hashMap = fE_Mibsnmp.getGroupConfig();
        } else {
            System.out.println("bad type=" + string);
            System.out.println("[portCapacity|portPhysical|groupConfiguration|portStat|portClass1|portClass2|portClass3|portConfiguration|module|all]");
            System.exit(0);
        }
        if (hashMap == null) {
            System.out.println("No data returned");
            System.exit(0);
        }
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = (String)hashMap.get(string2);
            System.out.println("Attribute Name: " + string2 + "\t Attribute Value: " + string3);
        }
    }

    public static class Test
    extends UnitTest {
        public void testFE_MIBNull() {
            FE_Mibsnmp fE_Mibsnmp = new FE_Mibsnmp(null);
            this.assertNotNull(fE_Mibsnmp);
        }

        public void testFE_MIB(String string) {
            FE_Mibsnmp fE_Mibsnmp = new FE_Mibsnmp(string);
            HashMap hashMap = fE_Mibsnmp.getModuleProps(1);
            this.assertEquals((String)hashMap.get("fcFeModuleDescr"), "Brocade Switch");
            this.assertNotNull((String)hashMap.get("fcFeModuleFxPortCapacity"));
        }

        public static void main(String[] stringArray) {
            new Test().testFE_MIB(stringArray[0]);
        }
    }
}

