/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jade.device.fcswitch.fibrealliance.service;

import com.sun.jade.apps.command.CommandExec;
import com.sun.jade.device.fcswitch.ancor.diag.AncorLoopbackTest;
import com.sun.jade.device.fcswitch.ancor.diag.AncorPortStatusTest;
import com.sun.jade.device.fcswitch.ancor.diag.AncorSwitchTest;
import com.sun.jade.device.fcswitch.fibrealliance.diag.brocade.BrocadeTest;
import com.sun.jade.device.fcswitch.fibrealliance.diag.switch2G.Switch2GTest;
import com.sun.jade.device.fcswitch.fibrealliance.io.AncorDeviceReport;
import com.sun.jade.device.fcswitch.fibrealliance.io.BrocadeDeviceReport;
import com.sun.jade.device.fcswitch.fibrealliance.io.GenericInbandSwitchDeviceReport;
import com.sun.jade.device.fcswitch.fibrealliance.io.InrangeDeviceReport;
import com.sun.jade.device.fcswitch.fibrealliance.io.McDataDeviceReport;
import com.sun.jade.device.fcswitch.fibrealliance.io.SwitchDeviceReport;
import com.sun.jade.device.fcswitch.fibrealliance.service.SwitchModelHelper;
import com.sun.jade.device.fcswitch.util.snmp.SwitchWWNsnmp;
import com.sun.jade.logic.mf.AbstractMF;
import com.sun.jade.logic.mf.MFStatus;
import com.sun.jade.logic.wbem.ReportGenerator;
import com.sun.jade.util.locale.LocalizedMessage;
import com.sun.jade.util.locale.LocalizedString;
import com.sun.jade.util.log.Report;
import com.sun.jade.util.unittest.UnitTest;
import java.util.Properties;

public class SwitchMF
extends AbstractMF {
    private String ip;
    private String wwn;
    private String switchType;
    private String wwnSnmp;
    private MFStatus status;
    private Properties props = null;
    private String snmpVendorId;
    private String displaySwitchModel;
    private ReportGenerator reporter = null;
    private ReportGenerator inband_reporter = null;
    private static final String DISPLAY_SWITCH_MODEL = "displaySwitchModel";
    private static final String QLOGIC = "QLogic";
    private static final String BROCADE = "Brocade";
    private static final String MCDATA = "MCDATA";
    private static final String SUN = "Sun";
    private static final String SANBOX_1GB = "SANbox1";
    private static final String SUN_SANBOX_2GB = "Sun SANbox2";
    private static final String SUN_SANBOX_1GB = "Sun SANbox";
    private static final String FIBRE_CHANNEL_SWITCH = "Fibre Channel Switch";
    private static final String CAPTION = "caption";
    private static final String DESCRIPTION = "description";
    private static final String DEFAULT_CAPDESCR = "Fibre Channel Switch";
    private static final String PING = "ping ";
    private static final String QLOGIC_ANCOR_ENTERPRISE_ID = "1663";
    private static final String BROCADE_ENTERPRISE_ID = "1588";
    private static final String MCDATA_ENTERPRISE_ID = "289";
    private static final String INRANGE_ENTERPRISE_ID = "824";
    private static final String SUN_QLOGIC_ANCOR_ENTERPRISE_ID = "42.2.28.3.4.1.1";
    private static final String SANBOX_2GB = "SANbox2";
    private static final String ERROR_STRING = "Error in SwitchMF instantiating appropriate Device report of type :";
    private static final String REPORT_FAILURE = "<report ReturnCode='FAILURE'>";
    private static final int MAX_TRIES = 3;
    private static final long RETRY_TIMEOUT = 60000L;
    private boolean remoteEnabled;
    public static final String sccs_id = "@(#)SwitchMF.java  1.13 09/03/02 SMI";

    public SwitchMF(Properties properties) {
        super(properties);
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        this.props = properties;
        String string6 = properties.getProperty("wwn");
        if (string6 != null && !"".equals(string6.trim())) {
            this.wwn = string6;
        }
        if ((string5 = properties.getProperty("snmpsysDescr")) != null && !"".equals(string5.trim())) {
            this.switchType = string5;
        }
        if ((string4 = properties.getProperty("snmpEnterpriseID")) != null && !"".equals(string4.trim())) {
            this.snmpVendorId = string4;
        }
        if ((string3 = properties.getProperty("wwnSnmp")) != null && !"".equals(string3.trim())) {
            this.wwnSnmp = string3;
        }
        if ((string2 = properties.getProperty("DeviceDisplayModel")) != null && !"".equals(string2.trim())) {
            this.displaySwitchModel = string2;
        }
        if ((string = properties.getProperty("ip")) != null) {
            this.ip = this.resolveIP(properties);
        } else {
            this.ip = properties.getProperty("remoteIP");
            this.remoteEnabled = true;
        }
        this.setDeviceReport(new SwitchReportGenerator());
    }

    private void add2GBSunQlogicSwitch(String string) {
        if (this.displaySwitchModel == null) {
            this.getExtraSwitchProperties(this.props, string);
        }
        this.reporter = new SwitchDeviceReport(this.props);
        if (!this.remoteEnabled) {
            this.addDiagnosticTest(new Switch2GTest());
        }
    }

    protected String getReportError(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(REPORT_FAILURE);
        stringBuffer.append("<exception Reason='Lost Comm'>");
        stringBuffer.append(string);
        stringBuffer.append("</exception>\n");
        stringBuffer.append("</report>\n");
        return stringBuffer.toString();
    }

    private Properties getExtraSwitchProperties(Properties properties, String string) {
        try {
            SwitchModelHelper switchModelHelper = new SwitchModelHelper(string, properties);
            properties = switchModelHelper.getExtraSwitchProperties();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Report.debug.log((Object)illegalArgumentException.toString());
            return properties;
        }
        catch (Exception exception) {
            return properties;
        }
        return properties;
    }

    private static boolean checkEthernetConnection(String string) {
        if (string == null) {
            return false;
        }
        SwitchWWNsnmp switchWWNsnmp = new SwitchWWNsnmp(string);
        String string2 = switchWWNsnmp.getWWNString();
        if (string2 != null) {
            return true;
        }
        try {
            CommandExec commandExec = new CommandExec(PING + string);
            commandExec.exec();
            commandExec.getReturnValue();
            String string3 = commandExec.getStandardOutput();
            string3 = string3.trim();
            String string4 = commandExec.getErrorOutput();
            string4 = string4.trim();
            String string5 = string3 + string4;
            return string5.endsWith("alive");
        }
        catch (Exception exception) {
            return true;
        }
    }

    public String getClassName() {
        return "StorAdeSwitch_UnitaryComputerSystem";
    }

    public String getName() {
        return this.wwn;
    }

    public LocalizedMessage getCaption() {
        return new LocalizedString(this.getProperties().getProperty("logicalName"));
    }

    public LocalizedMessage getDescription() {
        return new LocalizedString("com.sun.jade.device.fcswitch.fibrealliance.service.resource.SwitchModel", this.displaySwitchModel, this.displaySwitchModel == null ? "Fibre Channel Switch" : this.displaySwitchModel);
    }

    public static void main(String[] stringArray) {
        Properties properties = new Properties();
        properties.setProperty("ip", stringArray[0]);
        properties.setProperty("type", "switch");
        properties.setProperty("logicalName", stringArray[0]);
        System.out.println(SwitchMF.checkEthernetConnection(stringArray[0]));
    }

    public static class Test
    extends UnitTest {
        public void testSwitchMF(String string) throws IllegalArgumentException {
            Properties properties = new Properties();
            properties.setProperty("ip", string);
            properties.setProperty("type", "switch");
            properties.setProperty("logicalName", string);
            SwitchMF switchMF = new SwitchMF(properties);
            this.assertCondition(SwitchMF.checkEthernetConnection(string));
            this.assertEquals(switchMF.getClassName(), "StorAdeSwitch_UnitaryComputerSystem");
        }

        public static void main(String[] stringArray) {
            new Test().testSwitchMF(stringArray[0]);
        }
    }

    class SwitchReportGenerator
    implements ReportGenerator {
        SwitchReportGenerator() {
        }

        /*
         * Unable to fully structure code
         */
        public synchronized String generateReport() {
            var1_1 = null;
            var2_2 = 0;
            var3_3 = SwitchMF.access$000(SwitchMF.this).getProperty("search.oob");
            var4_4 = SwitchMF.access$200(SwitchMF.access$100(SwitchMF.this));
            if (var4_4) ** GOTO lbl26
            if (var3_3 == null) {
                var1_1 = this.doGenerateInbandReport();
                if (!var1_1.startsWith("<report ReturnCode='FAILURE'>")) {
                    return var1_1;
                }
                return SwitchMF.this.getReportError("InBand report cannot be got for device " + SwitchMF.access$300(SwitchMF.this));
            }
            Report.trace.log((Object)("Ethernet Connection lost for device " + SwitchMF.access$100(SwitchMF.this)));
            return SwitchMF.this.getReportError("Out Of Band Connection lost to device " + SwitchMF.access$100(SwitchMF.this));
lbl-1000:
            // 1 sources

            {
                try {
                    var1_1 = this.doGenerateReport();
                    if (!var1_1.startsWith("<report ReturnCode='FAILURE'>")) {
                        return var1_1;
                    }
                }
                catch (Exception var5_6) {
                    // empty catch block
                }
                try {
                    this.wait(60000L);
                }
                catch (InterruptedException var5_7) {
                    // empty catch block
                }
                ++var2_2;
lbl26:
                // 2 sources

                ** while (var2_2 < 3)
            }
lbl27:
            // 1 sources

            if (var1_1 == null) {
                return SwitchMF.this.getReportError("Too many tries " + (SwitchMF.access$100(SwitchMF.this) == null ? SwitchMF.access$300(SwitchMF.this) : SwitchMF.access$100(SwitchMF.this)));
            }
            return var1_1;
        }

        public synchronized String doGenerateInbandReport() {
            if (SwitchMF.this.inband_reporter == null) {
                SwitchMF.this.inband_reporter = new GenericInbandSwitchDeviceReport(SwitchMF.this.props);
                SwitchMF.this.updateDeviceConfig();
            }
            if (SwitchMF.this.inband_reporter != null) {
                String string = SwitchMF.this.inband_reporter.generateReport();
                return string;
            }
            return SwitchMF.this.getReportError("Inband Switch reporter falied for: " + SwitchMF.this.wwn);
        }

        public synchronized String doGenerateReport() throws Exception {
            Object object;
            if (SwitchMF.this.reporter == null) {
                Object object2;
                object = null;
                if (SwitchMF.this.wwn == null || SwitchMF.this.switchType == null || SwitchMF.this.snmpVendorId == null || SwitchMF.this.wwnSnmp == null) {
                    object = new SwitchWWNsnmp(SwitchMF.this.ip);
                }
                if (SwitchMF.this.wwn == null || "".equals(SwitchMF.this.wwn.trim())) {
                    SwitchMF.this.wwn = ((SwitchWWNsnmp)object).getWWNString();
                }
                if (SwitchMF.this.switchType == null) {
                    SwitchMF.this.switchType = ((SwitchWWNsnmp)object).getDeviceType();
                }
                if (SwitchMF.this.snmpVendorId == null) {
                    SwitchMF.this.snmpVendorId = ((SwitchWWNsnmp)object).getVendorSNMPId();
                }
                if (SwitchMF.this.wwnSnmp == null) {
                    SwitchMF.this.wwnSnmp = ((SwitchWWNsnmp)object).getWWNSnmp();
                }
                if (SwitchMF.this.switchType != null && SwitchMF.this.snmpVendorId != null && SwitchMF.this.wwnSnmp != null && SwitchMF.this.wwn != null) {
                    SwitchMF.this.props.put("wwn", SwitchMF.this.wwn);
                    SwitchMF.this.props.put("snmpsysDescr", SwitchMF.this.switchType);
                    SwitchMF.this.props.put("snmpEnterpriseID", SwitchMF.this.snmpVendorId);
                    SwitchMF.this.props.put("wwnSnmp", SwitchMF.this.wwnSnmp);
                    if (SwitchMF.QLOGIC_ANCOR_ENTERPRISE_ID.equalsIgnoreCase(SwitchMF.this.snmpVendorId) || SwitchMF.this.snmpVendorId.startsWith(SwitchMF.SUN_QLOGIC_ANCOR_ENTERPRISE_ID)) {
                        if (SwitchMF.this.switchType.startsWith(SwitchMF.QLOGIC) || SwitchMF.this.switchType.startsWith(SwitchMF.SUN_SANBOX_2GB) || SwitchMF.this.switchType.startsWith(SwitchMF.SANBOX_2GB)) {
                            SwitchMF.this.add2GBSunQlogicSwitch("Sun StorEdge network FC 2Gig switch");
                        } else if (SwitchMF.this.switchType.startsWith("Fibre Channel Switch")) {
                            if (SwitchMF.this.displaySwitchModel == null) {
                                SwitchMF.this.getExtraSwitchProperties(SwitchMF.this.props, "Sun StorEdge network FC switch");
                            }
                            object2 = new AncorDeviceReport(SwitchMF.this.props);
                            SwitchMF.this.reporter = (ReportGenerator)object2;
                            SwitchMF.this.wwn = ((AncorDeviceReport)object2).getName();
                            if (!SwitchMF.this.remoteEnabled) {
                                SwitchMF.this.addDiagnosticTest(new AncorLoopbackTest());
                                SwitchMF.this.addDiagnosticTest(new AncorPortStatusTest());
                                SwitchMF.this.addDiagnosticTest(new AncorSwitchTest());
                            }
                        } else if (SwitchMF.this.switchType.startsWith(SwitchMF.SANBOX_1GB) || SwitchMF.this.switchType.startsWith(SwitchMF.SUN_SANBOX_1GB)) {
                            SwitchMF.this.add2GBSunQlogicSwitch("Sun StorEdge network FC switch");
                        } else {
                            SwitchMF.this.add2GBSunQlogicSwitch("Sun StorEdge network FC 2Gig switch");
                        }
                    } else if (SwitchMF.BROCADE_ENTERPRISE_ID.equalsIgnoreCase(SwitchMF.this.snmpVendorId)) {
                        if (SwitchMF.this.displaySwitchModel == null) {
                            SwitchMF.this.getExtraSwitchProperties(SwitchMF.this.props, "Brocade SilkWorm FC Switch");
                        }
                        SwitchMF.this.reporter = new BrocadeDeviceReport(SwitchMF.this.props);
                        if (!SwitchMF.this.remoteEnabled) {
                            SwitchMF.this.addDiagnosticTest(new BrocadeTest());
                        }
                    } else if (SwitchMF.MCDATA_ENTERPRISE_ID.equalsIgnoreCase(SwitchMF.this.snmpVendorId)) {
                        if (SwitchMF.this.displaySwitchModel == null) {
                            SwitchMF.this.getExtraSwitchProperties(SwitchMF.this.props, "McData Enterprise Director FC Switch");
                        }
                        SwitchMF.this.reporter = new McDataDeviceReport(SwitchMF.this.props);
                    } else if (SwitchMF.INRANGE_ENTERPRISE_ID.equalsIgnoreCase(SwitchMF.this.snmpVendorId)) {
                        if (SwitchMF.this.displaySwitchModel == null) {
                            SwitchMF.this.getExtraSwitchProperties(SwitchMF.this.props, "Inrange FC/9000 Switch");
                        }
                        SwitchMF.this.reporter = new InrangeDeviceReport(SwitchMF.this.props);
                    }
                }
                SwitchMF.this.updateDeviceConfig();
                if (SwitchMF.this.displaySwitchModel == null && (object2 = SwitchMF.this.props.getProperty("DeviceDisplayModel")) != null && !"".equals(((String)object2).trim())) {
                    SwitchMF.this.displaySwitchModel = (String)object2;
                }
            }
            if (SwitchMF.this.reporter != null) {
                object = SwitchMF.this.reporter.generateReport();
                if (object == null) {
                    Report.error.log((Object)("Null Report for " + SwitchMF.this.ip));
                    return SwitchMF.this.getReportError("Null Report for " + SwitchMF.this.ip);
                }
                return object;
            }
            return SwitchMF.this.getReportError("Switch reporter is still not set: " + SwitchMF.this.ip);
        }
    }
}

